#! /bin/sh


#  
# Nagmod Installation or Update script
# 
echo " "
echo " "
echo "Nagmod Installation or Update script"
echo ""
echo "Before starting this script be sure that Apache and PHP is running" 
echo ">>> You need root permissions to run this script"
echo ">>> Type any key to continue"
read ANSWER


# Nagmod Version
ver="nagmod_V02.1" 
#nagmod directory
nagdir="/usr/share/nagmod/"
# searching Apache configuration directory
echo "Looking for Apache Server"
if [ -d /etc/httpd/conf.d ]		# be sure the directory conf.d (Fedora) exists
then
   apache_dir="/etc/httpd/conf.d"
   else
       if [ -d /etc/apache2/conf.d ]	# be sure the directory conf.d (ubuntu/Debian) exists
       then      
          apache_dir="/etc/apache2/conf.d"
       else
          echo "Error: Apache not found on this machine; Script aborted"
          exit 1
       fi
fi
echo "done"
echo "Creating working directory and download Nagmod from internet"
# create working directory and download nagmod from internet
if [ ! -d /temporary ]		# create directory /temporary if not exists
then
   mkdir "/temporary"
else
   rm -R  "/temporary"
   mkdir "/temporary"
fi
cd /temporary
wget "http://www.barody.ch/"$ver".tar.gz" 
gzip -d   /temporary/$ver".tar.gz"
tar -xvf /temporary/$ver".tar"
echo "done"

#
# Move Nagmod files from temporary directory to /usr/share/nagmod
#
echo "Create user nagmod and make Nagmod installation"
if [ ! -d /usr/share/nagmod/ ]                      #test if Nagmod update or new installation 
then
   userdel -r  nagmod
   useradd -md $nagdir nagmod                       #Nagmod new Installation
   mv "/temporary/"$ver"/nagmod/config" $nagdir     #first move config directory
fi
rm -R $nagdir"help"
mv "/temporary/"$ver"/nagmod/help"      $nagdir
rm -R $nagdir"fckeditor"
mv "/temporary/"$ver"/nagmod/fckeditor" $nagdir    
rm -R $nagdir"templates"
mv "/temporary/"$ver"/nagmod/templates" $nagdir
rm -R $nagdir"images"
mv "/temporary/"$ver"/nagmod/images"    $nagdir
rm -R $nagdir"install"
mv "/temporary/"$ver"/nagmod/install"   $nagdir
cd "/temporary/"$ver"/nagmod/"
mv *.cfg  $nagdir
mv *.inc  $nagdir
mv *.js   $nagdir
mv *.php  $nagdir         
mv *.css  $nagdir
echo "done"
# copy Nagmod configuration file for Apache (nagmod.conf)
echo "copy Nagmod configuration file for Apache (nagmod.conf)"
cp $nagdir"/install/nagmod.conf" $apache_dir
echo "done"

echo "modify permissions for user nagmod"
chown -R nagmod $nagdir
chgrp -R nagmod $nagdir
chmod -R 777    $nagdir
echo "done"
echo "Delete working directory and files"
#rm -R "/temporary"
echo "done"
# restart Apache server
echo "Restart Apache server"
if [  -f /etc/init.d/httpd ]                       
then
   /etc/init.d/httpd restart
else   
    if [  -f /etc/init.d/apache2 ]                       
       then    
          /etc/init.d/apache2 restart
    else
       echo "Error by restarting Apache server! Please restart manually"
       exit 1
    fi
fi
echo "done"
echo ">>>>> Nagmod installation or update completed without errors <<<<<"
echo "      Start Nagmod from your internet browser with:   "
echo "                 http://this_host/nagmod                  "
exit 0
