<?php


# Page variables
define("OBJECTTYPE", "cgicfg");
define("PAGE_ID", "cgicfg");
define("PAGE_TITLE", "Nagios CGI settings");

require_once("includes/main.inc.php");
include_once("html_wrap/head.inc.php");


$action = isset($action) ? @strtolower($action): "";
$rowcolor = "rowcolor2";
$message = "";
$rows = array();

# Actions before output is send
switch($action) {
	case "save":
		if ($Plugin->SaveConfig("cgicfg", $cfg) != NULL)
			$message = "<font color=\"#FF2222\">Configuration could not been saved.</font>";
		else 
			$message = "<font color=\"#00AA00\">Configuration has been saved.</font>";
}

$cgicfg = $Plugin->GetConfig("cgicfg");

foreach($confobjects[OBJECTTYPE] as $key => $propconf)	{

	$required = "label";
	$values = isset($cgicfg[$key]) ? $cgicfg[$key] : array();
	$count = count($values);

	if (empty($cgicfg[$key])) {
		
		$required = $propconf[2] == TRUE ? "required" : "label";
	}

	# Add an extra entry field when multi values are possible
	if ($propconf[0] == "multistring" || $count == 0) {
	
		$count++;
	}

	# Set the default value if needed and if there is one
	if (isset($values[0]) == FALSE && $propconf[1] != '') {
	
		$values[0] = $propconf[1];
	}

	for($i = 0; $i < $count; $i++)	{
	
		$value = isset($values[$i]) ? $values[$i] : '';
  		$show = NagiosObjPropEdit(OBJECTTYPE, $key, "cfg[$key][$i]", $value);
		$inputname = $key.'['.$i.']';
		
		$rowcolor = ($rowcolor != "dataOdd") ? "dataOdd" : "dataEven";
		
		$infokey=ucfirst(str_replace("_", " ", $key));

		$rows[] = <<<HTML
<tr class="{$rowcolor}">
  <td>$infokey</td>
  <td class="{$required}" with="3">&nbsp;</td>
  <td>
  $show
  </td>
</tr>
HTML;
	}
}

?>
<br>
<div align="center">
<form action="cgicfg.php" method="post">
<table cellpadding="3" border="0">
<tr>
  <td colspan="2" align="left">
  <b><?=$message?>&nbsp;</b>
  </td>
  <td align="right">
  <input type="submit" name="action" value="Save">
  </td>
</tr>
<tr class="data">
  <th colspan="3" class="data">Properties</th>
</tr>
<?=implode("\n", $rows)?>
</table>
</form>
</div>

<?

include_once("html_wrap/tail.inc.php"
);


?>
