<?php

# Page variables
define("PAGE_ID","contactedit");
define("PAGE_TITLE","Command object");
define("OBJECTTYPE","command");
define("OBJECTNAME","Command");

require_once("includes/main.inc.php");

$rowcolor = "";
$errormsg = "";
$cntinh = 0;
$action = (isset($action)) ? @strtolower($action) : "";
$objectid = (isset($objectid)) ? $objectid :  NULL;

# Actions before output is send
switch ($action)	{

	case 'save':
		$name = $saveobject[OBJECTTYPE.'_name'];
		$saveobject['command_line'] = stripslashes(implode(" ", split("\n", preg_replace("/\r/","",$saveobject['command_line']))));

		# If ObjectId is NULL it means it's a new object.
		if ($objectid == "")	{
			
			if ($name == "")	{
			
				$errormsg = "Object has an empty '".strtolower(OBJECTTYPE)."_name'.";
				$object=$saveobject;
				break;
			}
			# Check if record already exists
			elseif ($Plugin->GetObjectByName($name, OBJECTTYPE))	{
			
				$errormsg = "An object named '$name' already exists.";
				$saveobject[OBJECTTYPE."_name"] = "";
				$object=$saveobject;
				break;
			}
		}

		$objectid = $Plugin->SaveObject($objectid, $saveobject, OBJECTTYPE);
		echo "<BODY onLoad='opener.location.reload(); parent.close()'>";
		break;
}

include_once("html_wrap/head2.inc.php");

# If ObjectId is NULL it means it's a new object.
if ($objectid != "") {

	$object = $Plugin->GetObjectById($objectid, OBJECTTYPE);

	$commandname = isset($object[OBJECTTYPE."_name"]) ? $object[OBJECTTYPE."_name"] : $object['name'];
	$objectid = (isset($object['__objectid'])) ? $object['__objectid'] : "";

} elseif (!isset($object))	{

	$object = NULL;
}

$commandname = isset($object[OBJECTTYPE."_name"]) ? $object[OBJECTTYPE."_name"] : $object['name']; 

# If this is a template: get its iheriters
if (!empty($object['name'])) {

	$cntinh = NagiosCountInherited(OBJECTTYPE, $object['name']);
}

# Get information about the parent object if any
if (!empty($object['use'])) {

	$inhobject = $Plugin->GetObjectByName($object['use'],OBJECTTYPE);
	
	foreach($inhobject as $key => $value) {
	
		$object['++'.$key] = $value;
	}
}

# Get a default cfg file if object is new
if (!isset($object))
	if ($object['__cfgfile'] == "") {

		$objects = $Plugin->GetObjects(OBJECTTYPE);
		$firstobject = reset($objects);
		$object['__cfgfile'] = $firstobject['__cfgfile'];
	}


foreach( $confobjects[OBJECTTYPE] as $key => $propconf ) {
	
	$required = 'label';
	$value = isset($object[$key]) ? $object[$key] : "";
	$inhhtml = "";
	
  	$show = NagiosObjPropEdit(OBJECTTYPE, $key, "saveobject[$key]", $value);

	$required = ($propconf[2] == TRUE) ? 'required' : 'label';
        
	$rowcolor = ($rowcolor != "dataOdd") ? "dataOdd" : "dataEven";
	
	$key=ucfirst(str_replace("_", " ", $key));
	
	$rows[$key] = <<<HTML
<tr class="{$rowcolor}">
  <td>$key</td>
  <td class="$required" with="3">&nbsp;</td>
  <td>
  $show
  </td>
  $inhhtml
</tr>
HTML;
}

?>
<div align="center">
<form name="<?=PAGE_ID?>_form" action="<?=$PHP_SELF?>" method="POST">
<input type="hidden" name="objectid" value="<?=$objectid?>">
<input type="hidden" name="saveobject[__type]" value="<?=OBJECTTYPE?>">
<table cellpadding="3" border="0">
<tr>
  <td colspan="3" align="left">&nbsp;
  <?=ErrorMsg($errormsg)?>
  </td>
</tr>
<tr class="data">
  <th colspan="3" class="data">Properties</td>
</tr>
<?
echo implode("\n", $rows);

if ($cntinh > 0) {

	print ObjectInheritance($commandname,OBJECTTYPE, TRUE);
}

/*
$userobjs = NagiosObjectUsage($commandname, OBJECTTYPE);

if ($userobjs != NULL) {

	print ObjectUsage($commandname, OBJECTTYPE, $userobjs, TRUE);
}
*/
?>
<tr>
  <td colspan="3" align="center">
	<hr>
  </td>
</tr>
<tr>
  <td colspan="3" align="center">
 	<input type="submit" name="action" value="Save"> 
	<input type="submit" name="action" value="Cancel" onclick="parent.close('')">
  </td>
</tr>

</table>
</form>
</div>


<?php
include_once("html_wrap/tail2.inc.php");
?>
