<?php

# Page variables
define("PAGE_ID","contactgroupedit");
define("PAGE_TITLE","Contactgroup object");
define("OBJECTTYPE","contactgroup");
define("OBJECTNAME","ContactGroup");

require_once("includes/main.inc.php");

$rowcolor = ""; 
$errormsg = "";
$inhvalue = "";
$cntinh = 0;
$action = (isset($action)) ? @strtolower($action) : "";
$objectid = (isset($objectid)) ? $objectid :  NULL;

# Actions before output is send
$action = strtolower($action);
switch($action) {
	case 'save':
		$saveobject['members'] = @implode(",",$saveobject['members']);

		$name = $saveobject['name'] ? $saveobject['name'] : $saveobject[OBJECTTYPE.'_name'];

		# If ObjectId is NULL it means it's a new object.
		if ($objectid == "")	{

			if ($name == "")	{

				$errormsg = "Object has an empty '".strtolower(OBJECTTYPE)."_name'.";
				$object=$saveobject;
				break;
			}
			# Check if record already exists
			elseif ($Plugin->GetObjectByName($name, OBJECTTYPE))	{

				$errormsg = "An object named '$name' already exists.";
				$saveobject[OBJECTTYPE."_name"] = "";
				$object=$saveobject;
				break;
			}
		}

		$objectid = $Plugin->SaveObject($objectid,$saveobject,OBJECTTYPE);
		echo "<BODY onLoad='opener.location.reload(); parent.close()'>";
		break;
	case 'delete':
		$objectid = $Plugin->DeleteObject($objectid,OBJECTTYPE);
		echo "<BODY onLoad='opener.location.reload(); parent.close()'>";
		break;
}

include_once("html_wrap/head2.inc.php");


if ($objectid != "") {
	
	$object = $Plugin->GetObjectById($objectid, OBJECTTYPE);
	$objectid = (isset($object['__objectid'])) ? $object['__objectid'] : "";

} elseif (!isset($object))	{

	$object = NULL;
}

$contactgroupname = isset($object[OBJECTTYPE."_name"]) ? $object[OBJECTTYPE."_name"] : $object['name']; 

if (!empty($object['name']) && $objectid != "") {

	$cntinh = NagiosCountInherited(OBJECTTYPE, $object['name']);
}

if (!empty($object['use']) && $objectid != "") {

	$inhobject = $Plugin->GetObjectByName($object['use'], OBJECTTYPE);
	
	foreach($inhobject as $key => $value) {
	
		$object['++'.$key] = $value;
	}
}

# Get a default cfg file if object is new
if ($object['__cfgfile'] == "") {

	$objects = $Plugin->GetObjects(OBJECTTYPE);
	$firstobject = reset($objects);
	$object['__cfgfile'] = $firstobject['__cfgfile'];
}

foreach ($confobjects[OBJECTTYPE] as $key => $propconf)	{

	$required = 'label';
	$value = isset($object[$key]) ? $object[$key] : "";
	$inhhtml = "";

	if (isset($object["++".$key]))	{
		
			$inhhtml = "  <td>".$object["++".$key]."</td>\n";
			$reqclass = 'requiredok';
	} else {

		$inhhtml = "  <td>&nbsp;</td>";
		$reqclass = 'required';
	}
  	$show = NagiosObjPropEdit(OBJECTTYPE,$key,"saveobject[$key]",$value);

	if (empty($object['name'])) {

		$required = $propconf[2] == TRUE ? $reqclass : 'label';
	}
        
	$rowcolor = ($rowcolor != "dataOdd") ? "dataOdd" : "dataEven";
	
	$key=ucfirst(str_replace("_", " ", $key));

	$rows[$key] = <<<HTML
<tr class="{$rowcolor}">
  <td>$key</td>
  <td class="$required" with="3">&nbsp;</td>
  <td>
  $show
  </td>
  $inhhtml
</tr>
HTML;
}

?>
<div align="center">
<form method="post">
<input type="hidden" name="objectid" value="<?=$objectid?>">
<input type="hidden" name="saveobject[__cfgfile]" value="<?=$object['__cfgfile']?>">
<input type="hidden" name="saveobject[__type]" value="<?=OBJECTTYPE?>">

<table cellpadding="3" border="0">
<tr>
  <td colspan="4" align="left">
  <?=ErrorMsg($errormsg)?>
  </td>
</tr>
<tr class="data">
  <th colspan="3" class="data">Properties</th>
<?

if (!empty($object['use'])) {

	$parent = $Plugin->GetObjectByName($object['use'],OBJECTTYPE);
	print <<<HTML
  <th class="data">
  Inherits from 
  <a href="contactgroupedit.php?objectid={$parent['use']}"><b>{$parent['name']}</b></a>
  </th>
HTML;
} else	{

	echo "<th class=\"data\">&nbsp;</th>";
}

echo "</tr>";
echo implode("\n", $rows);

if ($cntinh > 0) {
	
	print ObjectInheritance($contactgroupname,OBJECTTYPE, 'edit');
}

$userobjs = NagiosObjectUsage($contactgroupname,OBJECTTYPE);

if ($userobjs != NULL) {

	print ObjectUsage($contactgroupname,OBJECTTYPE,$userobjs, 'edit');
}

?>
<tr>
  <td colspan="4" align="center">
	<hr>
  </td>
</tr>
<tr>
  <td colspan="4" align="center">
   <input type="submit" name="action" value="Save">
   <input type="submit" name="action" value="Cancel" onclick="parent.close('')">
  </td>
</tr>

</table>
</form>
</div>
<?
include_once("html_wrap/tail2.inc.php"
);
?>
