<?php


# Disallow run of this script.
if (basename($_SERVER['PHP_SELF']) == "contactgroups.php") 	{
	print("Direct execution of this script is not allowed.");
	exit;
}


# Includes
require_once("includes/drawlib.inc.php");

# Definitions
define("OBJECTTYPE", "contactgroup");
define("OBJECTNAME", "ContactGroup");
define("PAGE_INFO", "Query made at ".date("H:i:s - d M Y"));

$rowcolor 	= "";
$message 	= "";
$rows 		= array();
$contactgroups 	= array();


# Set Headers Titles and URL Values
$headers = array( 0 => array ( "Title" => "Contact Group", "SortName" => "contactgroup_name"),
		  1 => array ( "Title" => "Name", "SortName" => "name"),
		  2 => array ( "Title" => "Alias", "SortName" => "alias"),
		  3 => array ( "Title" => "Inheritance", "SortName" => ""),
		  4 => array ( "Title" => "Registered", "SortName" => "registered"),
		  );

$page 		= (isset($page)) 	? $page : 1;
$sorttype 	= (isset($sorttype))	? $sorttype : "0";
$sortoption 	= (isset($sortoption)) 	? $sortoption 	: $headers[0]["SortName"];

# Sort Type ($sorttype)
#  - 0 - Ascending
#  - 1 - Reversed

# -------# The script REALLY starts running from here #-------

$objects_count=$Plugin->GetObjectsCount(OBJECTTYPE);

$objects = $Plugin->GetSortedObjectsFromTo($sortoption, $sorttype, 0, $objects_count, OBJECTTYPE);

if (!is_array($objects))	{

	# This message will be displayed in errmsg row in TableHeader
	$message = "No objects found in database.";
	
	OpenTable(7);
	TableHeader($headers, "");
	CloseTable(7);
	include_once("html_wrap/tail.inc.php");
	exit; # If no Records are found, we exit...completly.

}
# we don't need an else, because we exit if there are no records

$i=0;
foreach($objects as $key => $object) {

	$name = isset($object['name']) ? $object['name'] : "";
	$registered = (isset($object['register']) && $object['register'] == 0) ? 'no' : 'yes';
	
	# Is this a inheritable object?
	$cntinh = NagiosCountInherited(OBJECTTYPE, $name);
	$inheritance = "used by $cntinh ".OBJECTTYPE." objects";
		
	if (!empty($object['use']))	{
		
		$inheritance .= ',<br>uses \''.$object['use'].'\' '.OBJECTTYPE.' object';
	}
	
	$contactgroups[$i]["Id"]		= $object["__objectid"];
	$contactgroups[$i]["ContactGroup_Name"] = $object[OBJECTTYPE.'_name'];
	$contactgroups[$i]["Name"]		= $name;
	$contactgroups[$i]["Alias"]		= isset($object['alias']) ? $object['alias'] : "";
	$contactgroups[$i]["Inheritance"]	= $inheritance;
	$contactgroups[$i]["Registered"]	= $registered;


	$i++;
} # foreach

# Get Page information to construct objects to be displayed in the current page, 
# based in DISPLAY_OBJECTS constant var.
$pageinfo=get_objects_from_page(count($contactgroups), $page);

# Construct Table Rows with Selected Host data
$num=$pageinfo["first_object"]+1;

for ($i=$pageinfo["first_object"]; $i<$pageinfo["last_object"]; $i++) {

	$rowcolor = ($rowcolor != "dataOdd") ? "dataOdd" : "dataEven";
	
	$rows[] = <<<HTML
<tr class="{$rowcolor}">
  <td>{$num}</td>
  <td>{$contactgroups[$i]["ContactGroup_Name"]}</td>
  <td>{$contactgroups[$i]["Name"]}</td>
  <td>{$contactgroups[$i]["Alias"]}</td>
  <td>{$contactgroups[$i]["Inheritance"]}</td>
  <td>{$contactgroups[$i]["Registered"]}</td>
  <td>
  <a href="contactgroupedit.php?objectid={$contactgroups[$i]["Id"]}" onclick="nw=window.open('', 'edit_contactgroup_popup', 'resizable=no, scrollbars=1, copyhistory=0, width=700, height=550');nw.opener=self" target="edit_contactgroup_popup">Edit</a>&nbsp;
  <a href="contactgroupview.php?objectid={$contactgroups[$i]["Id"]}" onclick="nw=window.open('', 'view_contactgroup_popup', 'resizable=no, scrollbars=1, copyhistory=0, width=700, height=550');nw.opener=self" target="view_contactgroup_popup">View</a><br>
  <a href="deleteobject.php?objectid={$contactgroups[$i]["Id"]}&objecttype=contactgroup" onclick="nw=window.open('', 'delete_contactgroup_popup', 'resizable=no, scrollbars=1, copyhistory=0, width=430, height=220');nw.opener=self" target="delete_contactgroup_popup">Delete</a>&nbsp;
  </td>
</tr>
HTML;
	$num++;
} # for


# Draw everything
OpenTable(7);
TableHeader($headers, "");
print implode("\n",$rows);
CloseTable(7);

?>
