<?php

# Page variables
define("PAGE_ID","contactgroupedit");
define("PAGE_TITLE","Contactgroup object");
define("OBJECTTYPE","contactgroup");
define("OBJECTNAME","ContactGroup");

require_once("includes/main.inc.php");
include_once("html_wrap/head2.inc.php");

$object = NULL;
$rowcolor = "";
$cntinh = 0;
if (!isset($objectid) ) $objectid = NULL;



$object = $Plugin->GetObjectById($objectid, OBJECTTYPE);

$contactgroupname = isset($object[OBJECTTYPE."_name"]) ? $object[OBJECTTYPE."_name"] : $object['name']; 

if (!empty($object[OBJECTTYPE.'_name'])) {

	$cntinh = NagiosCountInherited(OBJECTTYPE, $object[OBJECTTYPE.'_name']);
}

if (!empty($object['use'])) {

	$inhobject = $Plugin->GetObjectByName($object['use'], OBJECTTYPE);
	
	foreach($inhobject as $key => $value) {
	
		$object['++'.$key] = $value;
	}
}

foreach ($confobjects[OBJECTTYPE] as $key => $propconf)	{

	$required = 'label';
	$value = isset($object[$key]) ? $object[$key] : "";
	$inhhtml = "";
	
	
	if( isset($object["++".$key]) )	{
		
		$inhhtml = "  <td>".$object["++".$key]."</td>\n";
		$reqclass = 'requiredok';
	} else {

		$inhhtml = "  <td>&nbsp;</td>";
		$reqclass = 'required';
	}
	
  	$show = str_replace(",", "<br>", $value);

	if( empty($object[OBJECTTYPE.'_name']) ) {

		$required = $propconf[2] == TRUE ? $reqclass : 'label';
	}
        
	$rowcolor = ($rowcolor != "dataOdd") ? "dataOdd" : "dataEven";
	
	$key=ucfirst(str_replace("_", " ", $key));

	$rows[$key] = <<<HTML
<tr class="{$rowcolor}">
  <td>$key</td>
  <td class="$required" with="3">&nbsp;</td>
  <td>
  $show
  </td>
  $inhhtml
</tr>
HTML;
}

?>
<div align="center">

<table cellpadding="3" border="0">
<tr>
  <td colspan="4" align="left">
  &nbsp;
  </td>
</tr>
<tr class="data">
  <th colspan="3" class="data">Properties</th>
<?

if (!empty($object['use'])) {

	$parent = $Plugin->GetObjectByName($object['use'], OBJECTTYPE);
	print <<<HTML
  <th class="data">
  Inherits from 
  <a href="contactgroupedit.php?objectid={$parent['use']}"><b>{$parent['name']}</b></a>
  </th>
HTML;
} else	{

	echo "<th class=\"data\">&nbsp;</th>";
}

echo "</tr>";
echo implode("\n", $rows);

if ($cntinh > 0) {
	
	print ObjectInheritance($contactgroupname, OBJECTTYPE, 'view');
}

$userobjs = NagiosObjectUsage($contactgroupname, OBJECTTYPE);

if ($userobjs != NULL) {

	print ObjectUsage($contactgroupname, OBJECTTYPE, $userobjs, 'view');
}

?>
<tr>
  <td colspan="4" align="center">
	<hr>
  </td>
</tr>
<tr>
  <td colspan="4" align="center">
   <form method="post">
   <input type="submit" value="Close" onclick="parent.close('')">
   </form>
  </td>
</tr>

</table>
</div>
<?
include_once("html_wrap/tail2.inc.php");
?>
