<?php


# Disallow run of this script.
if (basename($_SERVER['PHP_SELF']) == "contacts.php")  	{
	print("Direct execution of this script is not allowed.");
	exit;
}


# Includes
require_once("includes/drawlib.inc.php");

# Definitions
define("OBJECTTYPE","contact");
define("OBJECTNAME","Contacts");
define("PAGE_INFO", 'Query made at '.date("H:i:s - d M Y"));

# Initialize Variables
$rowcolor = '';
$rows = array();
$errormsg = '';
$message = '';
$contacts = array();

if (!isset($sorttype))	 $sorttype="0";
if (!isset($sortoption)) $sortoption="contact_name";
if (!isset($page)) 	 $page=1;

$sortoption = @strtolower($sortoption);

# Set Headers Titles and URL Values
$headers = array( 0 => array ( "Title" => "Contact Name", "SortName" => "contact_name"),
		  1 => array ( "Title" => "Alias", "SortName" => "alias"),
		  2 => array ( "Title" => "Host Notification Period", "SortName" => "host_notification_period"),
		  3 => array ( "Title" => "Service Notification Period", "SortName" => "service_notification_period"),
		  4 => array ( "Title" => "Inheritance", "SortName" => ""),
		  );

# ######## The script REALLY starts running from here ########


# Get Objects Records Count
$objects_count=$Plugin->GetObjectsCount(OBJECTTYPE);

# Get Sorted Object Records
#
# Host Sort Option ($sortoption):
# - "Name"
# - "Alias"
# - "Address"
# - "Inheritance"
# - "Registered"
#
# Sort Type ($sorttype)
#  - 0 - Ascending
#  - 1 - Reversed
#echo "$sortoption, $sorttype";
$objects = $Plugin->GetSortedObjectsFromTo($sortoption, $sorttype, 0, $objects_count, OBJECTTYPE);
#$objects = $Plugin->GetSortedObjects($sortoption, $sorttype, OBJECTTYPE);
#PrintArray($objects);

if (!is_array($objects))	{

	# This message will be displayed in errmsg row in TableHeader
	$message = "No objects found in database.";
	
	OpenTable(7);
	TableHeader($headers, "");
	CloseTable(7);
	include_once("html_wrap/tail.inc.php");
	exit; # If no Records are found, we exit...completly.

}
# we don't need an else, because we exit if there are no records


$i=0;
# Construct $hostdata and $services Arrays for each object found
foreach($objects as $key => $object) {
	
	$name = $object["contact_name"];
	$registered = (isset($object['register']) && $object['register'] == 0) ? 'no' : 'yes';

	# Is this a inheritable object?
	$cntinh = NagiosCountInherited(OBJECTTYPE, $name);
	$inheritance = "used by $cntinh ".OBJECTTYPE." objects";
	
	if (!empty($object['use']))	{
		
		$inheritance .= ',<br>uses \''.$object['use'].'\' '.OBJECTTYPE.' object';
	}
	
	$contacts[$i]["Id"]				= $object['__objectid'];
	$contacts[$i]["Contact_Name"]			= $name;
	$contacts[$i]["Alias"]				= isset($object['alias']) ? $object['alias'] : '';
	$contacts[$i]["Host_Notification_Period"] 	= $object["host_notification_period"];
	$contacts[$i]["Service_Notification_Period"]	= $object["service_notification_period"];
	$contacts[$i]["Inheritance"]			= $inheritance;

	$i++;
} # foreach


# Get Page information to construct objects to be displayed in the current page, 
# based in DISPLAY_OBJECTS constant var.
$pageinfo=get_objects_from_page(count($contacts), $page);

if (DEBUG == "1") debug_window_msg(print_r($pageinfo));


# Construct Table Rows with Selected Host data
$num=$pageinfo["first_object"]+1;
	
for ($i=$pageinfo["first_object"]; $i<$pageinfo["last_object"]; $i++) {
		
	$rowcolor = ($rowcolor != "dataOdd") ? "dataOdd" : "dataEven";
	
	$rows[] = <<<HTML
<tr class="{$rowcolor}">
  <td>{$num}</td>
  <td>{$contacts[$i]["Contact_Name"]}</td>
  <td>{$contacts[$i]["Alias"]}</td>
  <td>{$contacts[$i]["Host_Notification_Period"]}</td>
  <td>{$contacts[$i]["Service_Notification_Period"]}</td>
  <td>{$contacts[$i]["Inheritance"]}</td>
  <td>
  <a href="contactedit.php?objectid={$contacts[$i]["Id"]}" onclick="nw=window.open('', 'edit_contact_popup', 'resizable=no, scrollbars=1, copyhistory=0, width=700, height=550');nw.opener=self" target="edit_contact_popup">Edit</a>&nbsp;
  <a href="contactview.php?objectid={$contacts[$i]["Id"]}" onclick="nw=window.open('', 'view_contact_popup', 'resizable=no, scrollbars=1, copyhistory=0, width=700, height=550');nw.opener=self" target="view_contact_popup">View</a><br>
  <a href="deleteobject.php?objectid={$contacts[$i]["Id"]}&objecttype=contact" onclick="nw=window.open('', 'delete_contact_popup', 'resizable=no, scrollbars=1, copyhistory=0, width=430, height=220');nw.opener=self" target="delete_contact_popup">Delete</a>&nbsp;
  </td>
</tr>
HTML;
	
	$num++;
} # for


# Draw everything
OpenTable(7);
TableHeader($headers, "");
print implode("\n",$rows);
CloseTable(7);


if (DEBUG == "1") debug_window_msg(print_r($hosts)); # For Debugging


?>
