<?php

# Page variables
define("PAGE_ID","contactview");
define("PAGE_TITLE","Contact object");
define("OBJECTTYPE","contact");
define("OBJECTNAME","Contact");

require_once("includes/main.inc.php");
include_once("html_wrap/head2.inc.php");

$rowcolor = ''; 
$object = NULL;
$cntinh = 0;
if (!isset($objectid) ) $objectid = NULL;


if (!is_array($object)) {

	$object = $Plugin->GetObjectById($objectid, OBJECTTYPE);
}

$contactname = isset($object[OBJECTTYPE."_name"]) ? $object[OBJECTTYPE."_name"] : $object['name']; 

if (!empty($object['name'])) {

	$cntinh = NagiosCountInherited(OBJECTTYPE,$contactname);
}

if (!empty($object['use'])) {

	$inhobject = $Plugin->GetObjectByName($object['use'],OBJECTTYPE);
	
	foreach($inhobject as $key => $value) {
	
		$object['++'.$key] = $value;
	}
}

# Get a default cfg file if object is new
if ($object['__cfgfile'] == "") {

	$objects = $Plugin->GetObjects(OBJECTTYPE);
	$firstobject = reset($objects);
	$object['__cfgfile'] = $firstobject['__cfgfile'];
}

foreach ($confobjects[OBJECTTYPE] as $key => $propconf )	{

	$required = 'label';
	$value = !empty($object[$key]) ? $object[$key] : '';
	$inhhtml = "";
	
	if (isset($object["++".$key]) )	{
		
		$inhhtml = "  <td>".$object["++".$key]."</td>\n";
		$reqclass = 'requiredok';
		
	} else {

		$inhhtml = "  <td>&nbsp;</td>\n";
		$reqclass = 'required';
	}
	
  	$show = str_replace(",", "<br>", $value);

	if (empty($object[$key]) ) {

		$required = $propconf[2] == TRUE ? $reqclass : 'label';
	}

	$rowcolor = ($rowcolor != "dataOdd") ? "dataOdd" : "dataEven";

	$key=ucfirst(str_replace("_", " ", $key));

	$rows[$key] = <<<HTML
<tr class="{$rowcolor}">
  <td>$key</td>
  <td class="$required" with="3">&nbsp;</td>
  <td>
  $show
  </td>
  $inhhtml
</tr>
HTML;
} # foreach


?>
<div align="center">
<table cellpadding="3" border="0">
<tr>
  <td colspan="4" align="left">
  <b>&nbsp;</b>
  </td>
</tr>
<tr class="data">
  <th colspan="3" class="data">Properties</th>
<?
if (!empty($object['use']))	{

	$parent = $Plugin->GetObjectByName($object['use'],OBJECTTYPE);
	
	print <<<HTML
  <th class=\"data\">
  Inherits from 
  <a href="contactedit.php?objectid={$parent['use']}"><b>{$parent['name']}</b></a>
  </th>
HTML;
} else {

    echo "<th class=\"data\">&nbsp;</th>\n";
}

echo "</tr>";
echo implode("\n", $rows);

if ($cntinh > 0) {
	
	print ObjectInheritance($contactname,OBJECTTYPE, 'view');
}

$userobjs = NagiosObjectUsage($object['contact_name'],OBJECTTYPE);

if ($userobjs != NULL) {
	
	print ObjectUsage($object['contact_name'],OBJECTTYPE,$userobjs, 'view');
}

?>
<tr>
  <td colspan="4" align="center">
	<hr>
  </td>
</tr>
<tr>
  <td colspan="4" align="center">
   <form method="post">
   <input type="submit" value="Close" onclick="parent.close('')">
   </form>
  </td>
</tr>
</table>
</div>
<?

include_once("html_wrap/tail2.inc.php");

?>
