<?php

# Page variables
define("PAGE_ID","hosts");
define("PAGE_TITLE","Host object");
define("OBJECTTYPE","host");
define("OBJECTNAME","Host");

require_once("includes/main.inc.php");

$rowcolor = ""; 
$errormsg = "";
$cntinh = 0;
$action = (isset($action)) ? @strtolower($action) : "";
$objectid = (isset($objectid)) ? $objectid :  NULL;

# Actions before output is send
switch($action) {
	case 'save':
		$name = $saveobject['name'] ? $saveobject['name'] : $saveobject[OBJECTTYPE.'_name'];

		# Handle the check_command attributes
		$checkcommand = $saveobject['check_command']['cmd'];
		$param = trim($saveobject['check_command']['param']);
		
		if( !empty($param) ) $checkcommand .= "!".$param;
		
		@settype($saveobject['check_command'], "string");
		$saveobject['check_command'] = $checkcommand;

		$eventhandler = $saveobject['event_handler']['cmd'];
		$param = trim($saveobject['event_handler']['param']);
		
		if( !empty($param) ) $eventhandler .= "!".$param;
		
		@settype($saveobject['event_handler'], "string");
		$saveobject['event_handler'] = $eventhandler;


		$saveobject['notification_options'] = @implode(",", $saveobject['notification_options']);
		$saveobject['stalking_options'] = @implode(",", $saveobject['stalking_options']);
		$saveobject['parents'] = @implode(",", $saveobject['parents']);

		# If ObjectId is NULL it means it's a new object.
		if ($objectid == "")	{
			
			if ($name == "")	{
			
				$errormsg = "Object has an empty '".strtolower(OBJECTTYPE)."_name'.";
				$object=$saveobject;
				break;
			}
			# Check if record already exists
			elseif ($Plugin->GetObjectByName($name, OBJECTTYPE))	{
			
				$errormsg = "An object named '$name' already exists.";
				$saveobject[OBJECTTYPE."_name"] = "";
				$object=$saveobject;
				break;
			}
		}

		$objectid = $Plugin->SaveObject($objectid, $saveobject, OBJECTTYPE);

		echo "<BODY onLoad='opener.location.reload(); parent.close()'>";
		break;
}

include_once("html_wrap/head2.inc.php");

if ($objectid != "") {

	$object = $Plugin->GetObjectById($objectid, OBJECTTYPE);
	$objectid = (isset($object['__objectid'])) ? $object['__objectid'] : "";

} elseif (!isset($object))	{

	$object = NULL;
}

$hostname = isset($object[OBJECTTYPE."_name"]) ? $object[OBJECTTYPE."_name"] : $object['name']; 

# If this is a template: get its iheriters
if (!empty($object['name'])) {

	$cntinh = NagiosCountInherited(OBJECTTYPE, $object['name']);
}

# Get information about the parent object if any
if( !empty($object['use']) ) {

	$inhobject = $Plugin->GetObjectByName($object['use'], OBJECTTYPE);
	
	foreach($inhobject as $key => $value) {
	
		$object['++'.$key] = $value;
	}
}



# Get a default cfg file if object is new
if( $object['__cfgfile'] == "") {
	
	$objects = $Plugin->GetObjects(OBJECTTYPE);
	$firstobject = @reset($objects);
	$object['__cfgfile'] = $firstobject['__cfgfile'];
}

foreach( $confobjects[OBJECTTYPE] as $key => $propconf ) {

	$required = 'label';
	$value = isset($object[$key]) ? $object[$key] : '';
	$inhhtml = "";
	
	if (isset($object["++".$key]))	{
		
		$inhhtml = "  <td>".str_replace(",", ",<br>", $object["++".$key])."</td>\n";
		$reqclass = 'requiredok';
		
	} else {

		$inhhtml = "  <td>&nbsp;</td>\n";
		$reqclass = 'required';
	}
	
	
	$type = 'nagios';
  	$show = NagiosObjPropEdit(OBJECTTYPE, $key, "saveobject[$key]", $value);

	if (empty($object[$key])) {
	
		$required = @$propconf[2] ? $reqclass : 'label';
	}

        $rowcolor = ($rowcolor != "dataOdd") ? "dataOdd" : "dataEven";
	

	$rows[$type][$key] = <<<HTML
<tr class="{$rowcolor}">
  <td>$key</td>
  <td class="{$required}" with="3">&nbsp;</td>
  <td>
  $show
  </td>
  $inhhtml
</tr>
HTML;
}

?>
<div align="center">
<form method="post">
<input type="hidden" name="objectid" value="<?=$objectid?>">
<input type="hidden" name="saveobject[__cfgfile]" value="<?=$object['__cfgfile']?>">
<input type="hidden" name="saveobject[__type]" value="<?=OBJECTTYPE?>">

<table cellpadding="2" border="0">
<tr>
  <td colspan="4" align="left">
  <?=ErrorMsg($errormsg)?>
  </td>
</tr>
<tr class="data">
  <th colspan="3" class="data">Properties</th>
<?

if( !empty($object['use']) ) {

	$parent = $Plugin->GetObjectByName($object['use'], OBJECTTYPE);
	print <<<HTML
  <th class="data">
  Inherits from 
  <a href="hostedit.php?objectid={$parent['__objectid']}" onclick="nw=window.open('', 'edit_template_popup', 'resizable=no, scrollbars=1, copyhistory=0, width=700, height=550');nw.opener=self" target="edit_template_popup"><b>{$parent['name']}</b></a>
  </th>
HTML;
} else {

	echo "<th class=\"data\">&nbsp;</th>\n";
}
?>
</tr>
<?=implode("\n", $rows['nagios'])?>
<?

if ( $cntinh > 0 ) {

	print ObjectInheritance($object['name'], OBJECTTYPE, 'edit');
}

if (!empty($object['name'])) {

	$userobjs = NagiosObjectUsage($hostname, OBJECTTYPE);
	if ( $userobjs != NULL ) {

		print ObjectUsage($hostname, OBJECTTYPE, $userobjs, 'edit');
	}
}

?>
<tr>
  <td colspan="4" align="center">
	<hr>
  </td>
</tr>
<tr>
  <td colspan="4" align="center">
   <input type="submit" name="action" value="Save">
   <input type="submit" name="action" value="Cancel" onclick="parent.close('')">
  </td>
</tr>

</table>
</form>
</div>

<?
include_once("html_wrap/tail2.inc.php");


?>
