<?php

# Disallow run of this script.
if (basename($_SERVER['PHP_SELF']) == "hostextinfo.php") 	{
	print("Direct execution of this script is not allowed.");
	exit;
}


# Includes
require_once("includes/drawlib.inc.php");

# Definitions
define("OBJECTTYPE","hostextinfo");
define("OBJECTNAME","HostExtInfo");
define("PAGE_INFO", 'Query made at '.date("H:i:s - d M Y"));

# Initialize Variables
$rowcolor 	= "";
$message 	= "";
$rows 		= array();
$hostextinfo	= array();


# Set Headers Titles and URL Values
$headers = array( 0 => array ( "Title" => "Name", "SortName" => "host_name"),
		  1 => array ( "Title" => "Notes URL", "SortName" => "notes_url"),
		  2 => array ( "Title" => "Icon", "SortName" => ""),
		  3 => array ( "Title" => "VRML", "SortName" => ""),
		  4 => array ( "Title" => "GD2 Image", "SortName" => ""),
		  5 => array ( "Title" => "Image Alt", "SortName" => "image_alt"),
		  6 => array ( "Title" => "2D Coords", "SortName" => "2d_coords"),
		  7 => array ( "Title" => "3D Coords", "SortName" => "3d_coords"),
		  8 => array ( "Title" => "Registered", "SortName" => "registered")
		  );

$page 		= (isset($page)) 	? $page : 1;
$sorttype 	= (isset($sorttype))	? $sorttype : "0";
$sortoption 	= (isset($sortoption)) 	? $sortoption 	: $headers[0]["SortName"];

# Sort Type ($sorttype)
#  - 0 - Ascending
#  - 1 - Reversed

# -------# The script REALLY starts running from here #-------

$objects_count=$Plugin->GetObjectsCount(OBJECTTYPE);

$objects = $Plugin->GetSortedObjectsFromTo($sortoption, $sorttype, 0, $objects_count, OBJECTTYPE);

if (!is_array($objects))	{

	# This message will be displayed in errmsg row in TableHeader
	$message = "No objects found in database.";
	
	OpenTable(11);
	TableHeader($headers, "");
	CloseTable(11);
	include_once("html_wrap/tail.inc.php");
	exit; # If no Records are found, we exit...completly.

}
# we don't need an else, because we exit if there are no records

$i = 0;
foreach ($objects as $id => $object)	{

	$name = isset($object["host_name"]) ? $object["host_name"] : "";
	$registered = "default";
	
	if (isset($object["register"]))	
		$registered = ($object["register"] == 0) ? "no" : "yes";
	
	$hostextinfo[$i]['Id']		= $object['__objectid'];
	$hostextinfo[$i]['Name']	= $name;
	$hostextinfo[$i]['Notes URL']	= isset($object['notes_url'])	? $object['notes_url']  : "";
	$hostextinfo[$i]['Icon']	= isset($object['icon_image'])	? $object['icon_image']	: "";
	$hostextinfo[$i]['VRML']	= isset($object['vrml_image'])	? $object['vrml_image']	: "";
	$hostextinfo[$i]['GD2 Image']	= isset($object['gd2_image'])	? $object['gd2_image'] : "";
	$hostextinfo[$i]['Image Alt']   = isset($object['image_alt'])	? $object['image_alt']  : "";
	$hostextinfo[$i]['2D Coords']   = isset($object['2d_coords'])	? $object['2d_coords']  : "";
	$hostextinfo[$i]['3D Coords']   = isset($object['3d_coords'])	? $object['3d_coords']  : "";
	$hostextinfo[$i]['Registered']  = $registered;

	$i++;
} # foreach



# Get Page information to construct objects to be displayed in the current page, 
# based in DISPLAY_OBJECTS constant var.
$pageinfo=get_objects_from_page(count($hostextinfo), $page);

# Construct Table Rows with Selected Host data
$num=$pageinfo["first_object"]+1;
	
for ($i=$pageinfo["first_object"]; $i<$pageinfo["last_object"]; $i++) {
		
	$rowcolor = ($rowcolor != "dataOdd") ? "dataOdd" : "dataEven";
	
	$rows[] = <<<HTML
<tr class="{$rowcolor}">
  <td>{$num}</td>
  <td>{$hostextinfo[$i]["Name"]}</td>
  <td>{$hostextinfo[$i]["Notes URL"]}</td>
  <td>{$hostextinfo[$i]["Icon"]}</td>
  <td>{$hostextinfo[$i]["VRML"]}</td>
  <td>{$hostextinfo[$i]["GD2 Image"]}</td>
  <td>{$hostextinfo[$i]["Image Alt"]}</td>
  <td>{$hostextinfo[$i]["2D Coords"]}</td>
  <td>{$hostextinfo[$i]["3D Coords"]}</td>
  <td align="center">{$hostextinfo[$i]["Registered"]}</td>
  <td>
  <a href="hostextinfoedit.php?objectid={$hostextinfo[$i]["Id"]}" onclick="nw=window.open('', 'edit_hostextinfo_popup', 'resizable=no, scrollbars=1, copyhistory=0, width=700, height=450');nw.opener=self" target="edit_hostextinfo_popup">Edit</a>&nbsp;
  <a href="hostextinfoview.php?objectid={$hostextinfo[$i]["Id"]}&action=View" onclick="nw=window.open('', 'view_hostextinfo_popup', 'resizable=no, scrollbars=1, copyhistory=0, width=700, height=450');nw.opener=self" target="view_hostextinfo_popup">View</a><br>
  <a href="deleteobject.php?objectid={$hostextinfo[$i]["Id"]}&objecttype=hostextinfo" onclick="nw=window.open('', 'delete_hostextinfo_popup', 'resizable=no, scrollbars=1, copyhistory=0, width=430, height=220');nw.opener=self" target="delete_hostextinfo_popup">Delete</a>&nbsp;
  </td>
</tr>
HTML;

	$num++;
} # for


# Draw everything
OpenTable(11);
TableHeader($headers, "");
print implode("\n",$rows);
CloseTable(11);

?>
