<?php


# Page variables
define("PAGE_ID","hostgroupedit");
define("PAGE_TITLE","Hostgroup object");
define("OBJECTTYPE","hostgroup");
define("OBJECTNAME", "Hostgroup");

# Includes
require_once("includes/main.inc.php");


$rowcolor = "";
$errormsg = "";
$cntinh = 0;
$action = (isset($action)) ? @strtolower($action) : "";
$objectid = (isset($objectid)) ? $objectid :  NULL;

# Actions before output is send
switch ($action)	{

	case 'save':
		$name = $saveobject['name'] ? $saveobject['name'] : $saveobject[OBJECTTYPE.'_name'];
		
		$saveobject['members'] = @implode(",", $saveobject['members']);
		$saveobject['contact_groups'] =  @implode(",", $saveobject['contact_groups']);

		# If ObjectId is NULL it means it's a new object.
		if ($objectid == "")	{

			if ($name == "")	{

				$errormsg = "Object has an empty '".strtolower(OBJECTTYPE)."_name'.";
				$object=$saveobject;
				break;
			}
			# Check if record already exists
			elseif ($Plugin->GetObjectByName($name, OBJECTTYPE))	{

				$errormsg = "An object named '$name' already exists.";
				$saveobject[OBJECTTYPE."_name"] = "";
				$object=$saveobject;
				break;
			}
		}

		$objectid = $Plugin->SaveObject($objectid, $saveobject, OBJECTTYPE);
		echo "<BODY onLoad='opener.location.reload(); parent.close()'>";
		break;
}

include_once("html_wrap/head2.inc.php");

if ($objectid != "") {

	$object = $Plugin->GetObjectById($objectid, OBJECTTYPE);
	$objectid = (isset($object['__objectid'])) ? $object['__objectid'] : "";

} elseif (!isset($object))	{

	$object = NULL;
}

$hostgroupname = isset($object[OBJECTTYPE."_name"]) ? $object[OBJECTTYPE."_name"] : $object["name"];

# If this is a template: get its iheriters
if (!empty($object['name']))	{

	$cntinh = NagiosCountInherited(OBJECTTYPE, $object['name']);
}

if (!empty($object['use']))	{

	$inhobject = $Plugin->GetObjectByName($object['use'], OBJECTTYPE);
	
	foreach($inhobject as $key => $value)	{
	
		$object['++'.$key] = $value;
	}
}

# Get a default cfg file if object is new
if ($object['__cfgfile'] == "")	{

	$objects = $Plugin->GetObjects(OBJECTTYPE);
	$firstobject = reset($objects);
	$object['__cfgfile'] = $firstobject['__cfgfile'];
	
}

foreach( $confobjects[OBJECTTYPE] as $key => $propconf )	{

	$required = 'label';
	$value = !empty($object[$key]) ? $object[$key] : '';
	$inhhtml = "";

	if (isset($object["++".$key]))	{

		$inhhtml = "  <td>".str_replace(",", ",<br>", $object["++".$key])."</td>\n";
		$reqclass = 'requiredok';

	} else {

		$inhhtml = "  <td>&nbsp;</td>\n";
		$reqclass = 'required';
	}

  	$show = NagiosObjPropEdit(OBJECTTYPE, $key, "saveobject[$key]", $value);

	if (empty($object[$key]))	{

		$required = @$propconf[2] ? $reqclass : 'label';
	}

	$rowcolor = ($rowcolor != "dataOdd") ? "dataOdd" : "dataEven";
	
	$key=ucfirst(str_replace("_", " ", $key));

	$rows[$key] = <<<HTML
<tr class="{$rowcolor}">
  <td>$key</td>
  <td class="$required" with="3">&nbsp;</td>
  <td>
  $show
  </td>
  $inhhtml
</tr>
HTML;
}

?>
<form method="post">
<input type="hidden" name="objectid" value="<?=$objectid?>">
<input type="hidden" name="saveobject[__cfgfile]" value="<?=$object['__cfgfile']?>">
<input type="hidden" name="saveobject[__type]" value="<?=OBJECTTYPE?>">

<div align="center">
<table cellpadding="3" border="0">
<tr>
  <td colspan="4" align="left">
  <?=ErrorMsg($errormsg)?>
  </td>
</tr>
<tr class="data">
  <th colspan="3" class="data">Properties</th>

<? # Display Inheritance Object

	if( !empty($object['use']) ) {
		$parent = $Plugin->GetObjectByName($object['use'], OBJECTTYPE);
		print <<<HTML
  <th class="data">
  Inherits from 
  <a href="hostgroupedit.php?objectid={$parent['__objectid']}" onclick="nw=window.open('', 'edit_template_popup', 'resizable=no, scrollbars=1, copyhistory=0, width=700, height=550');nw.opener=self" target="edit_template_popup"><b>{$parent['name']}</b></a>  
  </th>
HTML;
	
	} else {

		echo "<th class=\"data\">&nbsp;</th>\n";
	}

?>

</tr>
<?=implode("\n", $rows)?>
<?

if ($cntinh > 0) {

	print ObjectInheritance($hostgroupname, OBJECTTYPE, 'view');
}

$userobjs = NagiosObjectUsage($hostgroupname, OBJECTTYPE);

if ($userobjs != NULL) {

	print ObjectUsage($hostgroupname, OBJECTTYPE, $userobjs, 'edit');
}

?>
<tr>
  <td colspan="4" align="center">
    <hr>
  </td>
</tr>
<tr>
  <td colspan="4" align="center">
<?
  if ($action != "view")	{
  	echo '<input type="submit" name="action" value="Save">'; 
	echo '<input type="submit" name="action" value="Cancel" onclick="parent.close(\'\')">';
  }
  else echo '<input type="submit" name="action" value="Close" onclick="parent.close(\'\')">';
?>
  </td>
</tr>
</table>
</div>
</form>

<?php
include_once("html_wrap/tail2.inc.php");

?>
