<?php

# Disallow run of this script.
if (basename($_SERVER['PHP_SELF']) == "hostgroups.php")  	{
	print("Direct execution of this script is not allowed.");
	exit;
}


# Includes
require_once("includes/drawlib.inc.php");

# Page variables
define("OBJECTTYPE", "hostgroup");
define("OBJECTNAME", "Hostgroup");
define("PAGE_INFO", 'Query made at '.date("H:i:s - d M Y"));

$rowcolor = '';
$rows = array();
$errmsg = '';
$message = '';
$hostgroups = array();

if (!isset($sorttype))	 $sorttype="0";
if (!isset($sortoption)) $sortoption="name";
if (!isset($page)) 	 $page=1;

$sortoption = @strtolower($sortoption);

# Set Headers Titles and URL Values
$headers = array( 0 => array ( "Title" => "Hostgroup Name", "SortName" => "hostgroup_name"),
		  1 => array ( "Title" => "Name", "SortName" => "name"),
		  2 => array ( "Title" => "Alias", "SortName" => "alias"),
		  3 => array ( "Title" => "Inheritance", "SortName" => ""),
		  );

# ######## The script REALLY starts running from here ########
# Get Objects Records Count
$objects_count=$Plugin->GetObjectsCount(OBJECTTYPE);

# Get Sorted Object Records
#
# Host Sort Option ($sortoption):
# - "Name"
# - "Alias"
# - "Address"
# - "Inheritance"
# - "Registered"
#
# Sort Type ($sorttype)
#  - 0 - Ascending
#  - 1 - Reversed
#echo "$sortoption, $sorttype";
$objects = $Plugin->GetSortedObjectsFromTo($sortoption, $sorttype, 0, $objects_count, OBJECTTYPE);
#$objects = $Plugin->GetSortedObjects($sortoption, $sorttype, OBJECTTYPE);
#PrintArray($objects);


if (!is_array($objects))	{

	# This message will be displayed in errmsg row in TableHeader
	$message = "No objects found in database.";
	
	OpenTable(6);
	TableHeader($headers, "");
	CloseTable(6);
	include_once("html_wrap/tail.inc.php");
	exit; # If no Records are found, we exit...completly.

}
# we don't need an else, because we exit if there are no records


$i=0;
foreach($objects as $key => $object)	{
	
	$name = isset($object["name"]) ? $object["name"] : "";

	# Is this a inheritable object?
	$cntinh = NagiosCountInherited(OBJECTTYPE,$name);
	$inheritance = "used by $cntinh ".OBJECTTYPE." objects";
		
	if (!empty($object['use']))	{
		
		$inheritance .= ',<br>uses '.$object['use']." ".OBJECTTYPE.' object';
	}
	
	$hostgroups[$i]["Id"]		 = $object["__objectid"];
	$hostgroups[$i]["HostgroupName"] = isset($object[OBJECTTYPE.'_name']) ? $object[OBJECTTYPE.'_name'] : "";
	$hostgroups[$i]["Name"]		 = $name;
	$hostgroups[$i]["Alias"]	 = isset($object["alias"]) ? $object["alias"] : "";
	$hostgroups[$i]["Inheritance"]	 = $inheritance;
	
	$i++;
} # foreach

# Get Page information to construct objects to be displayed in the current page, 
# based in DISPLAY_OBJECTS constant var.
$pageinfo=get_objects_from_page(count($hostgroups), $page);

if (DEBUG == "1") debug_window_msg(print_r($pageinfo));


# Construct Table Rows with Selected Host data
$num=$pageinfo["first_object"]+1;
	
for ($i=$pageinfo["first_object"]; $i<$pageinfo["last_object"]; $i++) {


	$rowcolor = ($rowcolor != "dataOdd") ? "dataOdd" : "dataEven";

	$rows[] = <<<HTML
<tr class="{$rowcolor}">
  <td>{$num}</td>
  <td>{$hostgroups[$i]["HostgroupName"]}</td>
  <td>{$hostgroups[$i]["Name"]}</td>
  <td>{$hostgroups[$i]["Alias"]}</td>
  <td>{$hostgroups[$i]["Inheritance"]}</td>
  <td>
  <a href="hostgroupedit.php?objectid={$hostgroups[$i]["Id"]}" onclick="nw=window.open('', 'edit_hostgroup_popup', 'resizable=no, scrollbars=1, copyhistory=0, width=700, height=550');nw.opener=self" target="edit_hostgroup_popup">Edit</a>&nbsp;
  <a href="hostgroupview.php?objectid={$hostgroups[$i]["Id"]}" onclick="nw=window.open('', 'view_hostgroup_popup', 'resizable=no, scrollbars=1, copyhistory=0, width=700, height=550');nw.opener=self" target="view_hostgroup_popup">View</a><br>
  <a href="deleteobject.php?objectid={$hostgroups[$i]["Id"]}&objecttype=hostgroup" onclick="nw=window.open('', 'delete_hostgroup_popup', 'resizable=no, scrollbars=1, copyhistory=0, width=430, height=220');nw.opener=self" target="delete_hostgroup_popup">Delete</a>&nbsp;</td>
  </td>
  
</tr>
HTML;
	$num++;
} #for


# Draw everything
OpenTable(6);
TableHeader($headers, "");
print implode("\n",$rows);
CloseTable(6);



if (DEBUG == "1") debug_window_msg(print_r($hosts)); # For Debugging

?>
