<?php


# Page variables
define("PAGE_ID","hostgroupview");
define("PAGE_TITLE","Hostgroup object");
define("OBJECTTYPE","hostgroup");
define("OBJECTNAME", "Hostgroup");

# Includes
require_once("includes/main.inc.php");
include_once("html_wrap/head2.inc.php");

$rowcolor = '';
$object = NULL;
$cntinh = 0;
if( !isset($objectid) ) $objectid = NULL;


if (!is_array($object)) {

	$object = $Plugin->GetObjectById($objectid, OBJECTTYPE);
}

$hostgroupname = !empty($object["name"]) ? $object['name'] : ''; 

# If this is a template: get its inheriters
if (!empty($object['name']) )	{

	$cntinh = NagiosCountInherited(OBJECTTYPE, $object['name']);
}

# Get information about the parent object if any
if (!empty($object['use']))	{

	$inhobject = $Plugin->GetObjectByName($object['use'], OBJECTTYPE);
	
	foreach($inhobject as $key => $value)	{
	
		$object['++'.$key] = $value;
	}
}

foreach( $confobjects[OBJECTTYPE] as $key => $propconf )	{

	$required = 'label';
	$value = !empty($object[$key]) ? $object[$key] : '';
	$inhhtml = "";
	
	if (isset($object["++".$key]))	{

		$inhhtml = "  <td>".str_replace(",", ",<br>", $object["++".$key])."</td>\n";
		$reqclass = 'requiredok';
		
	} else {

		$inhhtml = "  <td>&nbsp;</td>\n";
		$reqclass = 'required';
	}
	
  	$show = str_replace(",", "<br>", $value);

	if (empty($object[$key]))	{
	
		$required = @$propconf[2] == TRUE ? $reqclass : 'label';
	}

	$rowcolor = ($rowcolor != "dataOdd") ? "dataOdd" : "dataEven";
	
	$key=ucfirst(str_replace("_", " ", $key));

	$rows[$key] = <<<HTML
<tr class="{$rowcolor}">
  <td width="200">$key</td>
  <td class="$required" with="3">&nbsp;</td>
  <td width="200">
  $show
  </td>
  $inhhtml
</tr>
HTML;
}

?>
<div align="center">

<table cellpadding="3" border="0">
<tr>
  <td colspan="4" align="left">
  <b>&nbsp;</b>
  </td>
</tr>
<tr class="data">
  <th colspan="3" class="data">Properties</th>

<? 

# Display Inheritance Object
if( !empty($object['use']) ) {

	$parent = $Plugin->GetObjectByName($object['use'], OBJECTTYPE);
	print <<<HTML
  <th class="data">
  Inherits from 
  <a href="hostgroupedit.php?objectid={$parent['__objectid']}" onclick="nw=window.open('', 'edit_template_popup', 'resizable=no, scrollbars=1, copyhistory=0, width=700, height=550');nw.opener=self" target="edit_template_popup"><b>{$parent['name']}</b></a>  
  </th>
HTML;
	
} else {

	echo "<th class=\"data\">&nbsp;</th>\n";
}

?>

</tr>
<?=implode("\n", $rows)?>
<?

if ($cntinh > 0) {

	print $Plugin->ObjectInheritance($hostgroupname, OBJECTTYPE, FALSE);
}

$userobjs = NagiosObjectUsage($hostgroupname, OBJECTTYPE);

if ($userobjs != NULL) {

	print ObjectUsage($hostgroupname, OBJECTTYPE, $userobjs, FALSE);
}

?>
<tr>
  <td colspan="4" align="center">
    <hr>
  </td>
</tr>
<tr>
  <td colspan="4" align="center">
	<form method="post">
	<input type="submit" value="Close" onclick="parent.close('')">
	</form>
  </td>
</tr>
</table>
</div>

<?php
include_once("html_wrap/tail2.inc.php");

?>
