<?php

# Disallow run of this script.
if (basename($_SERVER['PHP_SELF']) == "hosts.php") 	{
	print("Direct execution of this script is not allowed.");
	exit;
}


# Includes
require_once("includes/drawlib.inc.php");

# Definitions
define("OBJECTTYPE","host");
define("OBJECTNAME","Hosts");
define("PAGE_INFO", 'Query made at '.date("H:i:s - d M Y"));

# Initialize Variables
$rowcolor 	= "";
$message 	= "";
$rows 		= array();
$hosts		= array();


# Set Headers Titles and URL Values
$headers = array( 0 => array ( "Title" => "Name", "SortName" => "host_name"),
		  1 => array ( "Title" => "Alias", "SortName" => "alias"),
		  2 => array ( "Title" => "IP or FQDN", "SortName" => "address"),
		  3 => array ( "Title" => "Inheritance", "SortName" => ""),
		  4 => array ( "Title" => "Registered", "SortName" => "registered")
		  );

$page 		= (isset($page)) 	? $page : 1;
$sorttype 	= (isset($sorttype))	? $sorttype : "0";
$sortoption 	= (isset($sortoption)) 	? $sortoption 	: $headers[0]["SortName"];

# Sort Type ($sorttype)
#  - 0 - Ascending
#  - 1 - Reversed

# -------# The script REALLY starts running from here #-------

$objects_count=$Plugin->GetObjectsCount(OBJECTTYPE);

$objects = $Plugin->GetSortedObjectsFromTo($sortoption, $sorttype, 0, $objects_count, OBJECTTYPE);

if (!is_array($objects))	{

	# This message will be displayed in errmsg row in TableHeader
	$message = "No objects found in database.";
	
	OpenTable(7);
	TableHeader($headers, "");
	CloseTable(7);
	include_once("html_wrap/tail.inc.php");
	exit; # If no Records are found, we exit...completly.

}
# we don't need an else, because we exit if there are no records

$i = 0;
foreach ($objects as $id => $object)	{

	$name = isset($object[OBJECTTYPE.'_name']) ? $object[OBJECTTYPE.'_name'] : "";
	$registered = (isset($object['register']) && $object['register'] == 0) ? 'no' : 'yes';
	
	# Is this a inheritable object?
	$cntinh = NagiosCountInherited(OBJECTTYPE, $name);
	$inheritance = "used by $cntinh ".OBJECTTYPE." objects";
		
	if (!empty($object['use']))	{
		
		$inheritance .= ',<br>uses \''.$object['use'].'\' '.OBJECTTYPE.' object';
	}
		
	$hosts[$i]['Id']	  = $object['__objectid'];
	$hosts[$i]['Name']	  = $name;
	$hosts[$i]['Alias']	  = isset($object['alias']) ? $object['alias'] : "";
	$hosts[$i]['Address']	  = isset($object['address']) ? $object['address'] : "";
	$hosts[$i]['Inheritance'] = $inheritance;
	$hosts[$i]['Registered']  = $registered;

	$i++;
} # foreach



# Get Page information to construct objects to be displayed in the current page, 
# based in DISPLAY_OBJECTS constant var.
$pageinfo=get_objects_from_page(count($hosts), $page);

# Construct Table Rows with Selected Host data
$num=$pageinfo["first_object"]+1;
	
for ($i=$pageinfo["first_object"]; $i<$pageinfo["last_object"]; $i++) {
		
	$rowcolor = ($rowcolor != "dataOdd") ? "dataOdd" : "dataEven";
	
	$rows[] = <<<HTML
<tr class="{$rowcolor}">
  <td>{$num}</td>
  <td>{$hosts[$i]["Name"]}</td>
  <td>{$hosts[$i]["Alias"]}</td>
  <td>{$hosts[$i]["Address"]}</td>
  <td>{$hosts[$i]["Inheritance"]}</td>
  <td align="center">{$hosts[$i]["Registered"]}</td>
  <td>
  <a href="hostedit.php?objectid={$hosts[$i]["Id"]}" onclick="nw=window.open('', 'edit_host_popup', 'resizable=no, scrollbars=1, copyhistory=0, width=700, height=550');nw.opener=self" target="edit_host_popup">Edit</a>&nbsp;
  <a href="hostview.php?objectid={$hosts[$i]["Id"]}&action=View" onclick="nw=window.open('', 'view_host_popup', 'resizable=no, scrollbars=1, copyhistory=0, width=700, height=550');nw.opener=self" target="view_host_popup">View</a><br>
  <a href="deleteobject.php?objectid={$hosts[$i]["Id"]}&objecttype=host" onclick="nw=window.open('', 'delete_host_popup', 'resizable=no, scrollbars=1, copyhistory=0, width=430, height=220');nw.opener=self" target="delete_host_popup">Delete</a>&nbsp;
  </td>
</tr>
HTML;

	$num++;
} # for


# Draw everything
OpenTable(7);
TableHeader($headers, "");
print implode("\n",$rows);
CloseTable(7);

?>
