<?php

# Page variables
define("PAGE_ID","hostview");
define("PAGE_TITLE","Host object");
define("OBJECTTYPE","host");
define("OBJECTNAME","Host");

# Includes
require_once("includes/main.inc.php");
include_once("html_wrap/head2.inc.php");

$rowcolor = "";
$cntinh = 0;
$objectid = (isset($objectid)) ? $objectid : NULL;

if ($objectid != "") {

	$object = $Plugin->GetObjectbyId($objectid, OBJECTTYPE);
}

$hostname = !empty($object["name"]) ? $object['name'] : ''; 

# If this is a template: get its inheriters
if (!empty($object['name']) ) {

	$cntinh = NagiosCountInherited(OBJECTTYPE, $object['name']);
}

# Get information about the parent object if any
if (!empty($object['use']) ) {

	$inhobject = $Plugin->GetObjectByName($object['use'], OBJECTTYPE);
	
	foreach($inhobject as $key => $value) {
	
		$object['++'.$key] = $value;
	}
}

foreach ($confobjects[OBJECTTYPE] as $key => $propconf )	{

	$required = 'label';
	$value = isset($object[$key]) ? $object[$key] : '';
	$inhhtml = "";


	if (isset($object["++".$key]))	{
		
		$inhhtml = "  <td>".$object["++".$key]."</td>\n";
		$reqclass = 'requiredok';
	} else {
		
		$inhhtml = "  <td>&nbsp;</td>\n";
		$reqclass = 'required';
	}
	
	$show = str_replace(",", "<br>", $value);

	if (empty($object[$key])) {
	
		$required = @$propconf[2] ? $reqclass : 'label';
	}

        $rowcolor = ($rowcolor != "dataOdd") ? "dataOdd" : "dataEven";

	$keyname=ucfirst(str_replace("_", " ", $key));

	$rows[$key] = <<<HTML
<tr class="{$rowcolor}">
  <td width="200">$keyname</td>
  <td class="$required" with="3">&nbsp;</td>
  <td width="200">
  $show
  </td>
  $inhhtml
</tr>
HTML;
}

?>
<div align="center">

<table cellpadding="3" border="0">
<tr>
  <td colspan="4" align="left">&nbsp;</td>
</tr>
<tr class="data">
  <th colspan="3" class="data">Properties</th>
<?

if( !empty($object['use']) ) {

	$parent = $Plugin->GetObjectByName($object['use'], OBJECTTYPE);
	print <<<HTML
  <th class="data">
  Inherits from 
  <a href="hostedit.php?objectid={$parent['__objectid']}" onclick="nw=window.open('', 'edit_template_popup', 'resizable=no, scrollbars=1, copyhistory=0, width=700, height=550');nw.opener=self" target="edit_template_popup"><b>{$parent['name']}</b></a>
  </th>
HTML;
} else {

	echo "<th class=\"data\">&nbsp;</th>\n";
}
?>
</tr>
<?=implode("\n", $rows)?>
<?

if ( $cntinh > 0 ) {

	print $Plugin->ObjectInheritance($hostname, OBJECTTYPE, 'view');
}

if( !empty($hostname) ) {

	$userobjs = NagiosObjectUsage($hostname, OBJECTTYPE);
	if ( $userobjs != NULL ) {

		print ObjectUsage($hostname, OBJECTTYPE, $userobjs, 'view');
	}
}

?>
<tr>
  <td colspan="4" align="center">
    <hr>
  </td>
</tr>
<tr>
  <td colspan="4" align="center">
	<form method="post">
	<input type="submit" value="Close" onclick="parent.close('')">
	</form>
  </td>
</tr>

</table>
</div>

<?php
include_once("html_wrap/tail2.inc.php");


?>
