<?php

define("PAGE_ID","importer");
define("PAGE_TITLE","Import Current Nagios Configurations");

require_once("includes/main.inc.php");
include_once("html_wrap/head.inc.php");


$totalcount = 0;
$rowcolor = "dataOdd";

if (!isset($action)) $action = "";
if (isset($files)) {
	if (!is_array($files)) $files = array();
} else $files = array();

# Try to get the nagios.cfg from previous import
$nagioscfg = $Plugin->GetConfig("nagioscfg");

if (($action == "importobjects") && (isset($files))){

	print "<p>Importing objects:</p>\n";

	foreach( $files as $filename ) {
	
		print "<li> Reading file $filename... ";
		flush();
		$count = $Plugin->ImportObjects($filename);
		if ($count == 0) {
		
			print "no objects found!";
		} elseif ($count == -1 ) {
		
			print "<font color=\"#FF2222\">error reading file.</font>";
		} elseif ($count == -2 ) {
			
			print "<font color=\"#FF2222\">error reading database file.</font>";
		} elseif ($count == -3 ) {
			
			print "<font color=\"#FF2222\">error writting to database file.</font>";
		} else {

			print "<font color=\"#005500\">imported $count objects.</font>";
			$totalcount += $count;
		}
		print "<br>\n";
	}

	print "<p>Read $totalcount objects in total</p>\n";
#	echo "<hr>\n";

} elseif ($action == "importcfg" && count($files) > 0) {

	print "<p>Importing configuration files:</p>\n";

	foreach( $files as $fileid ) {
		$filename = NAGIOS_ETC."/".$NAGIOS_CFGFILES[$fileid];
		print "<li> Processing file : $filename.. ";
		flush();
		if( $result = $Plugin->ImportCfgFile($fileid) ) {
			print "failed : ".$result;
		} else {
			print "ok!";
			$totalcount++;
		}
		flush();
	}

	print "<p>Read $totalcount configuration files.</p>\n";
#	echo "<hr>\n";
}

?>
<br>
<hr>
<b><font color="#ff0000"><u>Developers Note:</u></font></b>The importer has an little issue that it's still beeing resolved.
 For now, you will not be able to import more than one "object configuration file" at a time. I'm still trying to figure this out, 
but i think it's a PHP Bug issue, because with the same code you can import each file without error, and i'm using flock() and fflush() in the loop.<br>
(You can take a look at "importer.php" and function "ImportObjects"@"plugins/serialized.inc". Contact me if you find a solution ").<br>
<b>Conclusion: </b> Import each objects file at a time.
<hr><br>
<table width="100%">
<tr>
<td align="left" valign="top">
<form action="importer.php" method="POST">
<input type="hidden" name="action" value="importcfg">
<input type="hidden" name="panel" value="importer">
<table cellpadding="2" cellspacing="4" border="0">
 <tr class="<?=$rowcolor?>">
   <td colspan="2" align="center">
     Please select the nagios configurations files you want to import:<br>
   </td>
 </tr>
<?
	foreach($NAGIOS_CFGFILES as $key => $filename) {

		$rowcolor = ($rowcolor != "dataOdd") ? "dataOdd" : "dataEven";

		$fullloc = NAGIOS_ETC."/".$filename;
		print <<<HTML
 <tr class="$rowcolor">
   <td align="center">
    <input type="checkbox" name="files[]" value="$key">
   </td>
   <td>$fullloc</td>
 </tr>
HTML;
}
$rowcolor = ($rowcolor != "dataOdd") ? "dataOdd" : "dataEven";

?>
 <tr class="<?=$rowcolor?>">
   <td colspan="2" align="center">
    <input type="submit" value="Import">
   </td>
 </tr>
</table>
</form>

</td>
<?
if ($nagioscfg != NULL && is_array($nagioscfg['cfg_file'])) {

?>
</tr>
<tr>
<td align="left" valign="top">
<form action="importer.php" method="POST">
<input type="hidden" name="action" value="importobjects">

<table cellpadding="2" cellspacing="4" border="0">
 <tr class="<?=$rowcolor?>">
   <td colspan="2" align="center">
     Please select the objects files you want to import:<br>
   </td>
 </tr>
<?
	foreach($nagioscfg['cfg_file'] as $filename) {

		$rowcolor = ($rowcolor != "dataOdd") ? "dataOdd" : "dataEven";

		print <<<HTML
 <tr class="$rowcolor">
   <td align="center">
    <input type="checkbox" name="files[]" value="$filename">
   </td>
   <td>$filename</td>
 </tr>
HTML;
	} # for
?>
<? $rowcolor = ($rowcolor != "dataOdd") ? "dataOdd" : "dataEven"; ?>
<tr class="<?=$rowcolor?>">
   <td colspan="2" align="center">
    <input type="submit" value="Import">
   </td>
 </tr>
</table>
</form>
</td>
<?
} # if

?>
<td align="left" valign="bottom">
 <b><font color="#ff0000"><u>Note:</u></font></b>The importer will not clear your current database configuration.<br>
 You will end up with doubles when importing twice. This behaviour will change in the future.
</td>
</tr>
</table>
<?

include_once("html_wrap/tail.inc.php");

?>
