<?

# This file is a mini-library with functions that construct most type
# of HTML code common to almost every 'object' page.
#
# It includes:
# - Page Handling function:
#
#
#
function get_objects_from_page($total_objects, $page)	{
	
	global $DISPLAY_OBJECTS;	# Objects to be displayed by page

	$output=array();
	# Multiple Page variables
	$first_object = 0;		# Index of first displayed object
	$last_object = 0;		# Index of last displayed object
	$objects_in_page = 0;		# Number of objects shown in current page

	# Calculate total Pages based on total_objects
	$total_pages = abs(ceil($total_objects / $DISPLAY_OBJECTS));
	
	# Because 'count' it's always a grand total, 
	# when we have '0' (zero) pages, we don't really mean that.
	# There is always at least 1 page...the first one! So...
	if ($total_pages == 0) $total_pages = 1;
	if ($page == 0) $page = 1;

	# Calculate first object to appear on the current page
	$first_object = (($page * $DISPLAY_OBJECTS) - $DISPLAY_OBJECTS);
	
	if ($page == $total_pages)	{
		# If displaying last page or if there is only one page.
		$objects_in_page = $DISPLAY_OBJECTS - (($total_pages * $DISPLAY_OBJECTS) - $total_objects);
		$last_object = ((($page * $DISPLAY_OBJECTS) - $DISPLAY_OBJECTS)+$objects_in_page);

	} else {
		# Calculate displayed objects for pages other than last one
		$objects_in_page = $DISPLAY_OBJECTS;
		$last_object = $first_object+$DISPLAY_OBJECTS;
	}

	# Return all values
	$output["first_object"]=$first_object;
	$output["last_object"]=$last_object;
	$output["total_objects"]=$total_objects;
	$output["total_pages"]=$total_pages;
	$output["current_page"]=$page;
	$output["objects_in_page"]=$objects_in_page;
	$output["DISPLAY_OBJECTS"]=$DISPLAY_OBJECTS;

	return($output);
}

# Table Header
function OpenTable($columns = 1, $hidden_values = NULL )	{

	global $errormsg, $message;
	
?>
<div align="center">
<table border="0" cellpadding="2" cellspacing="1" width="100%">
<tr>
  <td colspan="<?=$columns ?>" align="left">
    &nbsp;
    <b>
    <?=ErrorMsg($errormsg)?>
    &nbsp;
    <?=$message?>
    </b>
    &nbsp;
  </td>
</tr>
<tr>
  <td colspan="<?=$columns ?>">
  <? NavigationBar($hidden_values);?>
</td>
</tr>
<?
}


function NavigationBar($hidden_values = NULL)	{

	global $page, $pageinfo, $sorttype, $sortoption;


?>
   <!-- # Start of Navigation Toolbar # -->
   <table border="0" cellpadding="0" cellspacing="0" width="100%"> 
    <tr>
     <!-- # Refresh Button # -->
     <td width="50" align="left">
  	<form action="go.php">
	 <input type="hidden" name="go" value="<?=OBJECTNAME?>">
	 <input type="hidden" name="page" value="<?=$page?>">
	 <input type="hidden" name="sorttype" value="<?=$sorttype?>">
	 <input type="hidden" name="sortoption" value="<?=$sortoption?>">
	 <?
	 if (is_array($hidden_values))	{
	 	for ($i=0; $i<count($hidden_values); $i++)	{

			echo "	 <input type=\"hidden\" name=\"".$hidden_values[$i]["Name"]."\" value=\"".$hidden_values[$i]["Value"]."\">\n";
		}
	 }
	 ?>
	 <input type="submit" value="Refresh"> 
	</form>
     </td>
     <!-- # End Refresh Button # -->

     <!-- # Page Handling # -->
     <td align="center">
      <? draw_page_control($hidden_values);?>
     </td>
     <!-- # End of Page Handling # -->

     <!-- # New Record Button # -->
     <td width="50" align="right">
      <form action="<?=OBJECTTYPE?>edit.php" target="new_<?=OBJECTTYPE?>_popup">
       <input type="hidden" name="objectid" value="">
       <? if (OBJECTTYPE != "command")  {?>
       <input type="submit" value="New" onclick="nw=window.open('', 'new_<?=OBJECTTYPE?>_popup', 'resizable=no, scrollbars=1, copyhistory=0, width=530, height=550');nw.opener=self">
       <? } else {?>
       <input type="submit" value="New" onclick="nw=window.open('', 'new_<?=OBJECTTYPE?>_popup', 'resizable=no, scrollbars=1, copyhistory=0, width=720, height=360');nw.opener=self">
       <? } ?>
      </form>
     </td>
     <!-- # End New Record Button # -->
    </tr>
   </table>
   <!-- # End of Navigation Toolbar # -->
<?
}


function draw_page_control($hidden_values = NULL)	{

	global $pageinfo, $sortoption, $sorttype;

	$page=$pageinfo["current_page"];
	$page_first_object=$pageinfo["first_object"];
	$page_last_object=$pageinfo["last_object"];
	$total_pages=$pageinfo["total_pages"];

	if ($total_pages <= 1)	{
		
		echo "<td>&nbsp;</td>";
		return;
	}

	# Page handling ComboBox
	echo "<form name=\"pageform\" action=\"go.php\">\n";
	echo "<input type=\"hidden\" name=\"go\" value=\"".OBJECTNAME."\">\n";
	echo "<input type=\"hidden\" name=\"sorttype\" value=\"$sorttype\">\n";
	echo "<input type=\"hidden\" name=\"sortoption\" value=\"$sortoption\">\n";
	if (is_array($hidden_values))	{
	 	for ($i=0; $i<count($hidden_values); $i++)	{

			echo "<input type=\"hidden\" name=\"".$hidden_values[$i]["Name"]."\" value=\"".$hidden_values[$i]["Value"]."\">\n";
		}
	}
	echo "Page: ";
	echo "<select name=\"page\" onchange=\"submit()\">\n";
	for ($i=1; $i<($total_pages+1); $i++)	{

		echo "<option value=\"$i\" "; if ($i == $page) echo "selected"; echo ">$i / $total_pages</option>\n";
	}
	echo  "</select>\n";

	# Display a button if browser isn't capable of self submit 
	# the form  based in javascript function.
	if (!strstr($_SERVER["HTTP_USER_AGENT"], "MSIE") &&
	     !strstr($_SERVER["HTTP_USER_AGENT"], "Opera") &&
	     !strstr($_SERVER["HTTP_USER_AGENT"], "Gecko"))	{
	     
		echo "<input type=\"submit\" value=\".\">\n";
	}
	echo "</form>";
}


function TableHeader($headers = array(), $aditional = "")	{

	global $page;

	####################################################################################
	# Variable structure
	#  $headers = array( 0 => array( "Title" => "Name", "SortName" => "host_name"),
	#  		    1 => array( "Title" => "IP or FQDN", "SortName" => "address")
	#		    );
	#
	# Aditional URL string to be included in the full header URL
	#
	# $aditional = "services=all&hosts=none"
	# 
	####################################################################################

	if ($aditional != "")	{
		$aditional=ltrim($aditional, "&"); # Get rid of & if it exists, we will put owerselfs below
		$aditional="&$aditional";
	}
?>
<tr class="data">
<!-- Table Header -->
<th class="data">&nbsp;<a href="go.php?go=<?=OBJECTNAME?>&page=<?=$page?>" class="data">#</a>&nbsp;</th>

<? 
	for ($i=0; $i<count($headers);$i++)	{
		
		if ($headers[$i]["SortName"] != "")	{
?>
  <th class="data">&nbsp;<?=$headers[$i]["Title"]?>
  	<a href="go.php?go=<?=OBJECTNAME?>&page=<?=$page?>&sortoption=<?=$headers[$i]["SortName"]?>&sorttype=0<?=$aditional?>" class="data"><img src="<?=NAGIOS_URL?>/images/up.gif" border="0" alt="up"></a>
  	<a href="go.php?go=<?=OBJECTNAME?>&page=<?=$page?>&sortoption=<?=$headers[$i]["SortName"]?>&sorttype=1<?=$aditional?>" class="data"><img src="<?=NAGIOS_URL?>/images/down.gif" border="0" alt="down"></a>
	&nbsp;
  </th>
<?
		} else {
?>
  <th class="data">&nbsp;<?=$headers[$i]["Title"]?>
	&nbsp;
  </th>
<?

		}
	}
?>
  <th class="data">&nbsp;Action&nbsp;</th>
  <!-- Enf of Table Header -->
 </tr>
 <!-- Objects Records Rows-->

<?
}


# Table Footer
function CloseTable($columns = 1, $hidden_values = NULL)	{
?>

<!-- End of Object Records Rows -->
 <tr>
  <td colspan="<?=$columns ?>">
   <? NavigationBar($hidden_values);?>
  </td>
 </tr>
</table>
<?
}


# To display Page information at the bottom
function show_page_info($info)	{
?>
<hr>
<table width="100%" border="0" cellpadding="0" cellspacing="0">
<tr>
<?
# Display a link to return to Main Page if browser isn't capable of
# displaying frames
	if (!strstr($_SERVER["HTTP_USER_AGENT"], "MSIE") &&
	     !strstr($_SERVER["HTTP_USER_AGENT"], "Opera") &&
	     !strstr($_SERVER["HTTP_USER_AGENT"], "Gecko"))	{
		
		echo "<td align=\"left\"><a href=\"go.php?go=Main\">Main</td>\n";
	     
	}
?>
<td align="right"><font size="-2"><i><?=$info?></i></font></td>
</tr>
</table>
<?
}




?>
