<?php

require_once("includes/config.inc");

# - MAIN - 
define("VERSION", "0.1.5-dev");
define("WEBSITE_URL", trim($website_url, "/"));
define("DEBUG", $debug);
define("REFRESH_PAGES", $page_refresh);
define("OBJECTS_PER_PAGE", $objects_per_page);
define("ERROR_LEVEL", $error_level);
define("SHOW_PAGE_INFO", $show_page_info);
define("TMP_DIR", rtrim($tmp_dir, "/")."/.nawui");

# - NAGIOS -
define("NAGIOS_BIN", rtrim($nagios_bin, "/"));
define("NAGIOS_ETC", rtrim($nagios_etc, "/"));
define("NAGIOS_PLUGINS", rtrim($nagios_plugins, "/"));
define("NAGIOS_WEBROOT", rtrim($nagios_webroot, "/"));
define("NAGIOS_URL", rtrim($nagios_url, "/"));
define("NAGIOS_CGIS", rtrim($nagios_cgis, "/"));

# - NAWUI -
define("NAWUI_ROOT", rtrim($nawui_root, "/"));
define("NAWUI_URL", rtrim($nawui_url, "/"));
define("NAWUI_PLUGIN", NAWUI_ROOT."/plugins/".$nawui_plugin.".inc");
define("NAWUI_CSS", NAWUI_URL."/css/styles.css");

# ------------- COMPATIBILITY -------

# Objects to display per Page
$DISPLAY_OBJECTS = OBJECTS_PER_PAGE;

# ---------- BASIC CHECKS ------------

error_reporting(ERROR_LEVEL);

	
if (!is_dir(NAGIOS_ETC) ) {

	print "<br>Please edit 'nagios_etc' in includes/config.inc to point to your Nagios configuration directory.<br>\n";
	exit();

} elseif (!is_file(NAGIOS_BIN) ) {

	print "<br>Please edit 'nagios_bin' in includes/config.inc to point to your Nagios executable.<br>\n";
	exit();

} elseif (!is_dir(NAGIOS_PLUGINS) ) {

	print "<br>Please edit 'nagios_plugins' in includes/config.inc to point to your Nawui plugins directory.<br>\n";
	exit();

} elseif (!is_dir(NAWUI_ROOT) ) {

	print "<br>Please edit 'nawui_root' in includes/config.inc to point to the Nawui installation directory.<br>\n";
	exit();

} elseif (!is_dir("includes/") ) {

	print "<br>Please edit 'nawui_includes' in includes/config.inc to point to your Nawui includes directory.<br>\n";
	exit();

} elseif (!is_file(NAWUI_PLUGIN) ) {

	print "<br>ERROR: The plugin defined in includes/config.inc was not found. (".NAWUI_PLUGIN.")<br>\n";
	exit();

} elseif( get_cfg_var("register_globals") == 0 ) {

	print   "<br>\n<br>\n<br>\n<br>\n"
		."<center>\n"
		."<b>'register_globals' is OFF.</b>\n"
		."This means you have PHP 4.2 or higher. Nawui was initially made with 4.0.6 and<br>\n"
		."will in the future make sure that your good choice will be respected.<br>\n"
		."For now, set it to 'on' or just sit tight and hope it will be fixed in next release of Nawui ;).<br>\n"
		."</center>\n"
		."<br>\n<br>\n<br>\n<br>\n";
	phpinfo();
	exit();
}

if (REFRESH_PAGES != "0")	{
	define("PAGE_REFRESH", sprintf("<meta http-equiv=\"Refresh\" content=\"%d\">\n", REFRESH_PAGE));
} else	{
	define("PAGE_REFRESH", "\n");
}
		
# Include some 'library' files with various functions
require_once("includes/functions.inc.php");
require_once("includes/nagiosdata.inc.php");
require_once("includes/nagios.inc.php");

# Plugins
require_once(NAWUI_PLUGIN);



# Check if the current user has authorized access to NAWUI,
# based on NAGIOS 'authorized_for_system_commands' configuration in CGI.conf.

#dirname($HTTP_SERVER_VARS["SCRIPT_FILENAME"]);

#$allowed=FALSE;
#$cgicfg = $Plugin->GetConfig("cgicfg");
#PrintArray($HTTP_SERVER_VARS);

$current_user = (isset($HTTP_SERVER_VARS["PHP_AUTH_USER"])) ? strtolower($HTTP_SERVER_VARS["PHP_AUTH_USER"]) : "" ;

/*
if ($current_user != "")	{

   if (is_array($cgicfg))	{

	if (DEBUG == "1") PrintArray($cgicfg);

	$allowed_users=$cgicfg["authorized_for_system_commands"];

	for ($i=0; $i < count($allowed_users); $i++)	{

		$allowed_users[0]=trim($allowed_users[0], " ");
		$current_user=trim($current_user, " ");

		
		# If current PHP_AUTH_USER is in allowed_users group,
		# allow his entrance and exit (break) the loop.
		if ($allowed_users[0] == $current_user)	{
	
			$allowed=TRUE;
			define("NAWUI_ADMIN", $current_user);
			break;
		}
		else $errormsg= "You current user ($current_user) doesn't have authorized access to NAGIOS configuration.\n\n";

	}
	# Free $cgicfg from memory
	reset($cgicfg);

	
	# If not allowed, display an error and exit;
	if (!$allowed)	{

		print $errormsg;
		exit();
	}
   }
} else 	define("NAWUI_ADMIN", "");
#if
*/
# Uncomment the following line to check if this file has no PHP errors.
#echo "\nOk\n\n";



?>
