<?php

# int NagiosCountInherit(array objects [, string objecttype i
#	[, string objectname ]])
#
# This functions counts how many times an object is inherited by another.
# 
# The return value is a number when all parameters are given. If the
# 'objectname' is omitted an array with objects is returned.
#


function NagiosCountInherited_old($objecttype = NULL, $objectname = NULL)	{

	global $Plugin; # Plugin Class

	static $inhobjs = NULL;

	if( $inhobjs == NULL ) {
		$objects = $Plugin->GetObjects($objecttype);
		$inhobjs = array();
		foreach($objects as $object) {
			if( isset($object['use']) )
				@$inhobjs[$object['use']]++;
		}
	}

	if( isset($inhobjs[$objectname]) ) {
		return($inhobjs[$objectname]);
	}

	return($inhobjs);
}

function NagiosCountInherited($objecttype = NULL, $objectname = NULL)	{


	global $Plugin; # Plugin Class

	$objects = $Plugin->GetObjects($objecttype);
	$inherited=0;
	foreach($objects as $object) {
		if ( isset($object['use']))
			if ($object['use'] == $objectname)
				$inherited++;
	}

	return($inherited);
}

function NagiosGetInherited($objecttype = NULL, $objectname = NULL)	{


	global $Plugin; # Plugin Class

	$objects = $Plugin->GetObjects($objecttype);
	$inhobjs = array();
	foreach($objects as $object) {
		if ( isset($object['use']))
			if ($object['use'] == $objectname)
				$inhobjs[]=$object;
	}

	return($inhobjs);
}

#
# array NagiosObjectUsage(array objects, string objectname, mixed ufield)
#
# This function will search objects that use an other object. The ufield
# parameter is the name of the attribute in which we have to check for
# objectname. ufield can be an array of names.
#
# Returns a hash of objects using the object or NULL when none were found.
#
function NagiosObjectUsage($objectname, $type)	{

	
	global $Plugin; # Plugin Class
	global $NAGIOS_OBJUSAGE;

	$objusers = array();

	# Bailout when there is no definition (see nagiosdata.inc)
	if (is_array($NAGIOS_OBJUSAGE[$type]) == FALSE )	{
	
		return(NULL);
		
	}

	foreach ($NAGIOS_OBJUSAGE[$type] as $alien => $fields)	{

		$objects = $Plugin->GetObjects($alien);

		if (is_array($objects))
		foreach($objects as $key => $object)	{
		
			foreach($fields as $field)	{
			
				if (!isset($object[$field])) 
					continue;

				$list_excl = @explode("!", $object[$field]);
				$list_comma = @explode(",", $object[$field]);
				
				if (in_array($objectname, $list_excl))	{
				
					$objusers[$alien][$key] = $object;
					
				} else if (in_array($objectname, $list_comma))	{
				
					$objusers[$alien][$key] = $object;

				}
			}
		}
	}

	if (count($objusers))	{
	
		return($objusers);
		
	} else {
	
		return(NULL);

	}
}

#
# boolean NagiosCompareObject(array obj1, array obj2)
#
# Compares key/values of obj2 with obj1. obj2 should contain lesser pairs than
# obj1. If not they are switched.
#
# Returns TRUE if objects are a like, FALSE otherwise.
#
function NagiosCompareObjects($obj1,$obj2) 
{
	$found = FALSE;

	if( count($obj2) > count($obj1) ) {
		$buffer = $obj1;
		$obj1 = $obj2;
		$obj2 = $buffer;
	}

	foreach($obj2 as $key => $value) {
		if( $obj1[$key] == $value ) {
			$found = TRUE;
		} else {
			$found = FALSE;
		}
	}

	return($found);
}

#
# array NagiosSearchObject(string objecttype, array objects, 
# 		string objectname)
#
# Searches for object with type objectype and name objectname in the hash 
# objects.
#
# Returns a hash containing the object or NULL when not found.
#
function NagiosSearchObject($objecttype, $objectname)	{

	global $Plugin; # Plugin Class

	$objects = $Plugin->GetObjects($objecttype);

	foreach( $objects as $object ) {
		if( is_array($objectname) &&
			NagiosCompareObjects($object,$objectname) ) {
			return($object);	
		} else if( @$object['name'] == $objectname ) {
			return($object);
		} else if( @$object[$objecttype.'_name'] == $objectname ) {
			return($object);
		}
	}

	# We didn't find it
	return(NULL);
}

function NagiosDeleteObject($name, $objecttype, $filename) 
{
	$newconfig = array();
	$gotit = FALSE;

	if( file_exists($filename) == TRUE ) {
		$configlines = file($filename);
	} else {
		ErrorMsg("File $filename couldn't be read. Does it exist?");
		return(NULL);
	}

	foreach($configlines as $line) {
		
		$line = rtrim($line);

		print "$line<br>";

		if( preg_match("/^\s*define\s*$objecttype\s*{/", $line, $m) ) {
			$gotit = TRUE;
		} else if( preg_match("/^\s*}/",$line) && $gotit == TRUE) {
			$gotit = FALSE;
		} else if( $gotit == FALSE ) {
			$newconfig[] = $line;
		}
	}

	# Save the array to the file
	if( $fp = fopen("/tmp/hosts.cfg","w") ) {
		fwrite($fp,implode("\n",$newconfig));
		fclose($fp);
	} 
}

#
# string NagiosObjPropEdit(string type, string property, string name,
#		mixed value [, array objects])
#
# This function generates an edit field when editing an object. Based on the
# type it will generate a text entry, dropdown box, radio options, etc..
# The name parameter will be used in the HTML 'name' attributed of a
# formfield. The value is mostly used in the 'value' part, but can also be a
# CSL or array.
#
# NagiosObjPropEdit uses other functions to do the real job.
#
# Returns HTML code.
#
function NagiosObjPropEdit($type,$property,$name,$value,$objects = NULL)	{

	global $confobjects;

	# Because HostExtInfo & ServiceExtInfo must be written to Nagios CGI.CFG
	# we don't allow the user to make a choice about the config file to be written.
	if (($type == "hostextinfo") && ($property == "__cfgfile")) return("&nbsp;cgi.cfg");
	if (($type == "serviceextinfo") && ($property == "__cfgfile")) return("&nbsp;cgi.cfg");

	$pr = array();
	
	$pr['string'] = '<input type="text" size="40" name="%s" value="%s">';
	$pr['password'] = '<input type="password" size="40" name="%s" value="%s">';
	$pr['number'] = '<input type="text" size="4" name="%s" value="%s">';

	# yesno type should go into a function (FIX ME)
	$pr['yesno'] = <<<HTML
<input type="radio" name="%s" value="1" %s> Yes
<input type="radio" name="%s" value="0" %s> No &nbsp;&nbsp;
<input type="radio" name="%s" value="" %s> default 
HTML;
	$proptype = @$confobjects[$type][$property][0];

	switch($proptype) {
	
		case 'yesno':
			$format = $pr[$proptype];
			if ($value == '')
				 return sprintf($format, $name, '', $name, '', $name, 'checked');
			elseif( $value == 0 )
				return sprintf($format, $name, '', $name, 'checked', $name, '');
			else
				return sprintf($format, $name, 'checked', $name, '', $name, '');
			break;

		case 'iconimage':
			return NagiosDropDownImages($name, $value, 'image');
			break;
			
		case 'vrmlimage':
			return NagiosDropDownImages($name, $value, 'vrml');
			break;
			
		case 'gd2image':
			return NagiosDropDownImages($name, $value, 'gd2');
			break;

		# properties with a previously defined object as value
		case 'timeperiod':
		case 'host':
			return NagiosDropDownObjects($proptype, $name, $value);
			break;
		case 'service':
			return NagiosDropDownObjects($proptype, $name, $value);
			break;
		case 'command':
			return NagiosCheckCommand($name, $value);
			break;

		# properties with a previously defined object as value

		case 'tplhost':
		case 'tplhostgroup':
		case 'tplservice':
		case 'tplcontact':
		case 'tplcontactgroup':
		case 'tpltimeperiod':
		case 'tplhostextinfo':
		case 'tplserviceextinfo':
			return NagiosDropDownTplObjects(substr($proptype,3), 
				$name, $value);
			break;

		# wildcarded properties with a previously defined object as value
		case 'servicewildcard':
			return NagiosDropDownObjectsWithWildcard("service", $name, $value, TRUE);
			break;

		# properties with options
		case 'notsrvcnt':
		case 'nothstcnt':
		case 'notoptshost':
		case 'stalksrvopts':
		case 'stalkopts':
			return NagiosPropOptions($proptype, $name, $value);
			break;
		
		# properties with one option, multi choices
		case 'default_statusmap_layout':
		case 'default_statuswrl_layout':
			return NagiosDropDownValues($proptype, $name, $value);
			break;
		case 'dateformat':
		case 'intercheck':
		case 'interleavefact':
			return NagiosPropOneOption($proptype,$name,$value);
			break;

		# properties with comma seperated list
		case 'hostcommalist':
			return NagiosMultiListObjects('host',$name, $value);
			break;
		case 'commandcommalist':
			return NagiosMultiListObjects('command',$name, $value);
			break;
		case 'contactcommalist':
			return NagiosMultiListObjects('contact', $name, $value);
			break;
		case 'contactgroupcommalist':
			return NagiosMultiListObjects('contactgroup',$name, $value);
			break;


		# properties with comma seperated list and wildcard
		case 'hostgroupwildcardcommalist':
			return NagiosMultiListObjectsWithWildcard('hostgroup',$name, $value, TRUE);
			break;
		case 'hostwildcardcommalist':
			return NagiosMultiListObjectsWithWildcard('host',$name, $value, TRUE);
			break;


		case 'cmdline':
			return NagiosPropCmdline($name,$value);
			break;

		# drop down with cfg_file settings
		case 'cfgfile':
			return NagiosDropDownCfgFile($name,$value);
			break;

		# text and password fields
		case 'password':
			return sprintf($pr['password'], $name, $value);
			break;

		case '-':
			return '&nbsp;';
			break;

		case 'string':
		default:
			return sprintf($pr['string'], $name, str_replace("\'", "'",  $value));
			break;
	}
	
	return($value);
}


#
# string NagiosDropDownImages(string name, string imgselected,
#		string imgtype)
#
# Creates a dropdown list of image files found at NAGIOS_WEBROOT/images/logos
#
# Returns a HTML select statement or a string when there where troubles.
#
function NagiosDropDownImages($name = "", $imgselected = "", $imgtype = "")	{

	global $Plugin; # Plugin Class

	$options = "";
	$option = "     <option value=\"%s\" %s> %s\n";
	$logos_dir = NAGIOS_WEBROOT."/images/logos/";

	if (!file_exists($logos_dir)) return ("No logo images directory found.");

	if ($handle = opendir($logos_dir))	{

		while (false !== ($file = readdir($handle)))	{
	    
			$file_ext =strtolower(substr(basename($file), -4));

			switch (strtolower($imgtype))	{

				case "vrml":
				case "image":
					if ( ($file_ext == ".gif") ||
						($file_ext == ".png") || 
							($file_ext == ".jpg") )	{

						$selected = ($imgselected == $file) ? "selected" : "";
						$options .= sprintf($option, basename($file), $selected, basename($file));
						}
					break;
					
				case "gd2":
					if ($file_ext == ".gd2") 	{

						$selected = ($imgselected == $file) ? "selected" : "";
						$options .= sprintf($option, basename($file), $selected, basename($file));
						}
					break;
				
				default:
					if ($file != ".." && $file != ".")	{
						$selected = ($imgselected == $file) ? "selected" : "";
						$options .= sprintf($option, basename($file), $selected, basename($file));
					}
					
			} # case
		} # while
		closedir($handle); 
	} #if
	
	return <<<HTML
<select name="$name">
     <option value="">
$options
  </select>
HTML;

}


#
# string NagiosDropDownObjects(string objecttype, string name,
#		string selected)
#
# Creates a dropdown list of object with type objecttype.
#
# Returns a HTML select statement or a string when there where troubles.
#
function NagiosDropDownObjects($objecttype,$name,$selected)	{

	return NagiosDropDownObjectsWithWildcard($objecttype,$name,$selected,FALSE);

}


function NagiosDropDownObjectsWithWildcard($objecttype,$name,$selected,$wildcarded)	{

	global $Plugin; # Plugin Class

	$opts = array();
	$option = '   <option value="%s" %s> %s';

	$objects = $Plugin->GetObjects($objecttype);
	if( !is_array($objects) ) {
		return "No '".$objecttype."'-objects available";
	}

	if($wildcarded == TRUE){
	    $sel = ($selected == "*") ? 'selected' : '';
		$opts[] = sprintf($option, "*", $sel, "*");
	}

	foreach($objects as $object) {
		if( isset($object[$objecttype.'_name']) ) {
			$objname = $object[$objecttype.'_name'];
			$sel = ($selected == $objname) ? 'selected' : '';
			$opts[] = sprintf($option, $objname, $sel, $objname);
		}
		else if( isset($object[$objecttype.'_description']) ) {
			$objname = $object[$objecttype.'_description'];
			$sel = ($selected == $objname) ? 'selected' : '';
			$opts[] = sprintf($option, $objname, $sel, $objname);
		}

	}

	sort($opts);
	$options = implode("\n",$opts);

	if( count($opts) != 0 ) {
		return <<<HTML
<select name="$name">
<option value="">
$options
</select>
HTML;
	} else return "No '".$objecttype."'-objects available.";
}

#
# string NagiosCheckCommand(string name, string selected)
#
# Creates a dropdown list of object with type objecttype.
#
# Returns a HTML select statement or a string when there where troubles.
#
function NagiosCheckCommand($name, $value)	{

	global $Plugin; # Plugin Class

	$selected = "";
	$params = "";
	$objecttype = "command";
	$opts = array();
	$option = '   <option value="%s" %s> %s';

	if( !empty($value) ) {
		@list($selected,$params) = split("!", $value, 2);
	}

	$objects = $Plugin->GetObjects($objecttype);
	
	if (!is_array($objects)) {
		return "No '".$objecttype."'-objects available";
	}

	foreach($objects as $object) {
		if( isset($object[$objecttype.'_name']) ) {
			$objname = $object[$objecttype.'_name'];
			$sel = ($selected == $objname) ? 'selected' : '';
			$opts[] = sprintf($option, $objname, $sel, $objname);
		}
	}

	sort($opts);
	$options = implode("\n",$opts);

	if( count($opts) != 0 ) {
		return <<<HTML
<select name="{$name}[cmd]">
<option value="">
$options
</select><br>
Parameters: 
<input type="text" name="{$name}[param]" value="$params" size="30">
HTML;
	} else return "No '".$objecttype."'-objects available.";
}

#
# string NagiosDropDownTplObjects(string objecttype, string name,
#		string selected)
#
# Creates a dropdown list of template object with type objecttype.
#
# Returns a HTML select statement or a string when there where troubles.
#
function NagiosDropDownTplObjects($objecttype,$name,$selected)	{

	global $Plugin; # Plugin Class

	$opts = array();
	$option = '   <option value="%s" %s> %s';

	$objects = $Plugin->GetObjects($objecttype);
	if( !is_array($objects) ) {
		return "No '".$objecttype."'-objects available";
	}

	foreach($objects as $object) {
		if( isset($object['name']) ) {
			$sel = ($selected == $object['name']) ? 'selected' : '';
			$opts[] = sprintf($option, $object['name'], 
				$sel, $object['name']);
		}
	}

	sort($opts);
	$options = implode("\n",$opts);

	if( count($opts) != 0 ) {
		return <<<HTML
<select name="$name">
<option value="">
$options
</select>
HTML;
	} else return "No template '".$objecttype."'-objects available.";
}


#
# string NagiosMultiListObjects(string objecttype, string name,
#		string selected)
#
# Creates a multiple selection list of objects of a certain type.
#
# Returns a HTML select statement or a string when there where troubles.
#

function NagiosMultiListObjects($objecttype,$name,$selected)	{

	return NagiosMultiListObjectsWithWildcard($objecttype, $name, $selected, FALSE);
	
}

function NagiosMultiListObjectsWithWildcard($objecttype,$name,$selected,$wildcarded)	{

	global $Plugin; # Plugin Class

	$selopts = array();
	$selection = explode(",",$selected);
	for($i = 0; $i < count($selection); $i++)
		$selection[$i] = trim($selection[$i]);
	$option = '   <option value="%s" %s> %s';

	$objects = $Plugin->GetObjects($objecttype);
	if( !is_array($objects) ) {
		return "No '".$objecttype."'-objects available";
	}
	
	if($wildcarded == TRUE){
		$sel = (in_array('*',$selection)) 
		                   ? 'selected' : '';	     
		$opts[] = sprintf($option, "*", $sel, "*");
	}

	foreach($objects as $object) {
		if( isset($object[$objecttype.'_name']) ) {
			$objname = $object[$objecttype.'_name'];
			#$sel = ($selected == $objname) ? 'selected' : '';
			$sel = (in_array($objname,$selection)) 
				? 'selected' : '';
			$opts[] = sprintf($option, $objname, $sel, $objname);
		}
	}

	if( (count($selopts) + count($opts)) != 0 ) {

		sort($opts);
		$options = implode("\n",array_merge($selopts,$opts));
		return <<<HTML
<select name="{$name}[]" size="10" multiple>
<option value="">
$options
</select>
HTML;
	} else return "No '".$objecttype."'-objects available.";
}

#
# string NagiosPropOptions(string optiontype, string name,
#		string checked)
#
# Creates a checkbox group of options for an object property.
#
# Returns HTML or nothing when there are no options.
#
function NagiosPropOptions($optiontype,$name,$checked)
{
	global $propoptions;

	$checkbox = '<input type="checkbox" name="%s[]" value="%s" %s> %s';
	$checklist = explode(",",$checked);
	$options = $propoptions[$optiontype];

	foreach($options as $option => $text) {
		$check = in_array($option,$checklist) ? 'checked' : '';
		$chks[] = sprintf($checkbox,$name,$option,$check,$text);
	}

	return implode("<br>\n", $chks);
}


#
# string NagiosPropOneOption(string optiontype, string name,
#		string checked)
#
# Creates a radiobutton group of options for an object property.
#
# Returns HTML or nothing when there are no options.
#
function NagiosPropOneOption($optiontype,$name,$value)
{
	global $propoptions;

	$found = FALSE;
	$radio = '<input type="radio" name="%s" value="%s" %s> %s';
	$input['number'] = 
		'<input type="text" name="%s_number" value="%s" size="5">';
	$options = $propoptions[$optiontype];

	foreach($options as $option => $text) {
		
		$check = '';
		
		if( in_array($value,array_keys($options)) && $found == FALSE && $option == $value ) {
			
			$check = 'checked';
			$found = TRUE;
			
		} else if( preg_match("/:(\w*)input:/",$text,$m) ) {
		
			if($found == TRUE) $value = '';
			
			$in = sprintf($input[$m[1]], $name, $value);
			$text = preg_replace("/:\w*input:/",$in,$text);
			
			if (!in_array($value,array_keys($options)) && $found == FALSE )
			
				$check = 'checked';
		}
		$chks[] = sprintf($radio, $name, $option, $check, $text);
	}

	return implode("<br>\n", $chks);
}


#
# string NagiosDropDownValues(string optiontype, string selected)
#
# Creates a dropdown list with values defined in nagiosdata.inc.
#
# Returns a HTML select statement or a string when there where troubles.
#
function NagiosDropDownValues($optiontype, $name, $selectedvalue)	{

	global $propoptions;
	
	$opts = "";
	
	$htmloption = "   <option value=\"%s\" %s> %s\n";
	$options = $propoptions[$optiontype];

	foreach($options as $value => $text) {
		
		$selected = "";
		if ($selectedvalue == $value)
			$selected = "selected";

		$opts .= sprintf($htmloption, $value, $selected, $text);
	}
	if (count($opts) != 0) {
		return <<<HTML
<select name="$name">
$opts
</select>
HTML;
	} else return "No values found for this field.";
}

#
# string NagiosPropCmdLine(string name, string checked)
#
# Creates a textarea suitable for 'command line' input.
#
# Returns HTML.
#
function NagiosPropCmdline($name, $value)	{


	if (!isset($optiontype)) $optiontype = "";

	$options = isset($propoptions[$optiontype]) ? $propoptions[$optiontype] : "";

	return <<<HTML
<textarea name="$name" wrap="soft" cols="60" rows="5">
$value
</textarea>
<br>(\\n and \\r will be removed to make single line) 
HTML;

}

#
# array NagiosCheckMembership(array objects, string name, 
#		string objecttype, string memberfield)
#
# Finds out where an object is used. For example: of which contactgroups
# is contact 'foobar'.
#
# Returns array of objects in which the object is used or NULL when none.
#
function NagiosCheckMembership($name,$objecttype,$memberfield)
{
	$memobj = NULL;
	
	foreach($objects[$objecttype] as $object) {
		$members = split(",",$object[$memberfield]);
		if( in_array($name, $members) == TRUE ) {
			$memobj[] = $object[$objecttype.'_name'];
		}
	}

	return($memobj);
}

#
# int NagiosUasortObjectName(array ar1, array ar2
#
# Functions used with uasort (see PHP manual)
#
# Returns an integer 1 or -1. 0 should never be returned since an objectname
# is unique.
#
function NagiosUasortObjectName($ar1,$ar2) 
{
	$name1 = '';
	$name2 = '';

	if( isset($ar1[OBJECTTYPE.'_name']) ) {
		$name1 = $ar1[OBJECTTYPE.'_name'];
	} else if ( isset($ar1['name']) ) {
		$name1 = $ar1['name'];
	}

	if( isset($ar2[OBJECTTYPE.'_name']) ) {
		$name2 = $ar2[OBJECTTYPE.'_name'];
	} else if ( isset($ar2['name']) ) {
		$name2 = $ar2['name'];
	}

	if( $name1 < $name2 ) {
		return -1;
	} else if( $name1 > $name2 ) {
		return 1;
	}

	# This can never happen since an objectname is supposed to be unique
	return 0;
}

#
# int NagiosUasortObjectName(array ar1, array ar2
#
# Functions used with uasort (see PHP manual)
#
# Returns an integer 1 or -1. 0 should never be returned since an objectname
# is unique.
#
function NagiosUasortObjectService($ar1,$ar2) 
{
	$name1 = '';
	$name2 = '';

	if( isset($ar1['service_description']) ) {
		$name1 = $ar1['service_description'];
	} else if ( isset($ar1['name']) ) {
		$name1 = $ar1['name'];
	}

	if( isset($ar2['service_description']) ) {
		$name2 = $ar2['service_description'];
	} else if ( isset($ar2['name']) ) {
		$name2 = $ar2['name'];
	}

	if( $name1 < $name2 ) {
		return -1;
	} else if( $name1 > $name2 ) {
		return 1;
	}

	# This can never happen since an objectname is supposed to be unique
	return 0;
}

#
# int NagiosUasortObjectName(array ar1, array ar2
#
# Functions used with uasort (see PHP manual)
#
# Returns an integer 1 or -1. 0 should never be returned since an objectname
# is unique.
#
function NagiosUasortObjectHost($ar1,$ar2) 
{
	$name1 = '';
	$name2 = '';

	if ( isset($ar1['host']) ) $name1 = $ar1['host'];
	if ( isset($ar2['host']) ) $name2 = $ar2['host'];

	if ( $name1 < $name2 ) return -1;
	else if ( $name1 > $name2 ) return 1;

	# This can never happen since an objectname is supposed to be unique
	return 0;
}

#
# string NagiosDropDownCfgFile(string name, string selected)
#
# Creates a dropdown list with filenames as found in the cfg_file
# configuration in nagios.cfg. 
#
# Returns a HTML select statement or a string when there where troubles.
#
function NagiosDropDownCfgFile($name, $selected)	{

	global $Plugin, $OBJECTTYPE; # Plugin Class

	$opts = array();
	$option = '   <option value="%s" %s> %s';

	$nagioscfg = $Plugin->GetConfig("nagioscfg");

	if (!is_array($nagioscfg['cfg_file']))	{

		return "No cfg_file directives found in nagios.cfg";
	}
	
	foreach($nagioscfg['cfg_file'] as $filename) {
		
		$sel = ($selected == $filename) ? "selected" : "";
		if ($sel == "")	{
		
			if (strlen($OBJECTTYPE) > strlen($filename))	{
				$sel = (strpos(strtolower(basename($filename, ".cfg")), strtolower($OBJECTTYPE))) ? "selected" : "";
			} else {
				$sel = (strpos(strtolower($OBJECTTYPE), strtolower(basename($filename, ".cfg")))) ? "selected" : "";
			}
		}
		$opts[] = sprintf($option, $filename, $sel, basename($filename));
	}

	$options = implode("\n",$opts);

	if (count($opts) != 0) {
		return <<<HTML
<select name="$name">
$options
</select>
HTML;
	} else return "No cfg_file directives found in nagios.cfg";
}


?>
