<?php


$NAGIOS_CFGFILES = array(
        'nagioscfg' => 'nagios.cfg',
        'cgicfg' => 'cgi.cfg',
        'resourcecfg' => 'resource.cfg'
        );

# Nagios objecttypes
$NAGIOS_OBJTYPES = array(
	"host", "hostgroup", 
	"hostdependency", "hostescalation", "hostgroupescalation",
	"service", "servicegroup", "servicedependency", "serviceescalation",
	"timeperiod",
	"contact", "contactgroup",
	"command"
	);

# Where and in what fields can an object be used in another object
$NAGIOS_OBJUSAGE = array(
	"host" => array(
		"host" => array("parents"),
		"hostgroup" => array("members"),
		"service" => array("host_name"),
		"hostdependency" => array("host_name", "dependent_host_name"),
		"hostescalation" => array("host_name"),
		"serviceescalation" => array("host_name"),
		),
	"hostgroup" => array(
		"service" => array("hostgroup_name"),
		"hostgroupescalation" => array("hostgroup_name"),
		"serviceescalation" => array("hostgroup_name"),
		),
	"service" => array(
		"servicegroup" => array("members"),
		"servicedependency" => array("service_name", "dependent_service_name"),
		"serviceescalation" => array("service_description"),
		),
	"contact" => array(
		"contactgroup" => array("members"),
		),
	"contactgroup" => array(
		"hostgroup" => array("contact_groups"),
		"service" => array("contact_groups"),
		"serviceescalation" => array("contact_groups"),
		),
	"hostextinfo" => array(
		"host_name" => array("parents"),
		),
	"serviceextinfo" => array(
		"host_name" => array("parents"),
		"service_name" => array("parents"),
		)
);

#
# $confobject = array(
#	'scope'	=> array(
#		'propertyname' => array('inputtype', 'defaultvalue', required)
#	);
$confobjects = array(
 'host' => array(
	'__cfgfile'	=> array('cfgfile', '', TRUE),
	'host_name'	=> array('string', '', TRUE),
	'alias'		=> array('string', '', TRUE),
	'address'	=> array('string', '', TRUE),
	'name'	=> array('string', '', FALSE),
	'register' => array('yesno', '1', FALSE),
	'use' => array('tplhost', '', FALSE),
	'max_check_attempts' => array('number', '', TRUE),
	'notification_interval' => array('number', '', TRUE),
	'notification_period' => array('timeperiod', '', TRUE),
	'notification_options' => array('notoptshost', '', TRUE),
	'notifications_enabled' => array('yesno', '1', FALSE),
	'check_command' => array('command', '', FALSE),
	'checks_enabled' => array('yesno', '', FALSE),
	'event_handler' => array('command', '', FALSE),
	'event_handler_enabled' => array('yesno', '', FALSE),
	'low_flap_threshold' => array('number', '', FALSE),
	'high_flap_threshold' => array('number', '', FALSE),
	'flap_detection_enabled' => array('yesno', '', FALSE),
	'process_perf_data' => array('yesno', '', FALSE),
	'retain_status_information' => array('yesno', '', FALSE),
	'retain_nonstatus_information' => array('yesno', '', FALSE),
	'stalking_options' => array('stalkopts', '', FALSE),
	'parents'	=> array('hostcommalist', '', FALSE),
	),
 'hostgroup' => array(
	'__cfgfile'	=> array('cfgfile', '', TRUE),
 	'hostgroup_name' => array('string', '', TRUE),
	'alias' => array('string', '', 'TRUE'),
	'name' => array('string', '', TRUE),
	'register' => array('yesno', '1', FALSE),
	'use' => array('tplhostgroup', '', FALSE),
	'contact_groups' => array('contactgroupcommalist', '', 'TRUE'),
	'members' => array('hostcommalist', '', TRUE)
 	),
 'service' => array(
	'__cfgfile'	=> array('cfgfile', '', TRUE),
 	'host_name' => array('host', '', TRUE),
 	'service_description' => array('string', '', TRUE),
 	'check_command' => array('command', '', TRUE),
	'name' => array('string', '', TRUE),
	'register' => array('yesno', '1', FALSE),
	'use' => array('tplservice', '', FALSE),
 	'max_check_attempts' => array('number', '', TRUE),
 	'normal_check_interval' => array('number', '', TRUE),
 	'retry_check_interval' => array('number', '', TRUE),
	'active_checks_enabled' => array('yesno', '', FALSE),
	'check_period' => array('timeperiod', '', TRUE),
	'passive_checks_enabled' => array('yesno', '', FALSE),
	'parallelize_check' => array('yesno', '', FALSE),
	'obsess_over_service' => array('yesno', '', FALSE),
	'check_freshness' => array('yesno', '', FALSE),
 	'freshness_threshold' => array('number', '', FALSE),
 	'event_handler' => array('command', '', FALSE),
	'event_handler_enabled' => array('yesno', '', FALSE),
 	'low_flap_threshold' => array('number', '', FALSE),
 	'high_flap_threshold' => array('number', '', FALSE),
 	'flap_detection_enabled' => array('yesno', '', FALSE),
 	'process_perf_data' => array('yesno', '', FALSE),
 	'retain_status_information' => array('yesno', '', FALSE),
 	'retain_nonstatus_information' => array('yesno', '', FALSE),
 	'notification_interval' => array('number', '', TRUE),
	'notification_period' => array('timeperiod', '', TRUE),
	'notification_options' => array('notsrvcnt', '', TRUE),
 	'notifications_enabled' => array('yesno', '', FALSE),
	'contact_groups' => array('contactgroupcommalist', '', TRUE),
	'stalking_options' => array('stalksrvopts', '', FALSE)
	),
 'serviceescalation' => array(
	'__cfgfile'	=> array('cfgfile', '', TRUE),
 	'service_description' => array('servicewildcard', '', TRUE),
 	'host_name' => array('hostwildcardcommalist', '', FALSE),
	'hostgroup_name' => array('hostgroupwildcardcommalist', '', FALSE),
 	'first_notification' => array('number', '', TRUE),
 	'last_notification' => array('number', '', TRUE),
	'contact_groups' => array('contactgroupcommalist', '', TRUE),
 	'notification_interval' => array('number', '', TRUE),
    ),
 'contact' => array(
	'__cfgfile'	=> array('cfgfile', '', TRUE),
	'contact_name'	=> array('string', '', TRUE),
	'alias'		=> array('string', '', TRUE),
	'name'	=> array('string', '', FALSE),
	'register' => array('yesno', '1', FALSE),
	'use' => array('tplcontact', '', FALSE),
	'host_notification_period' => array('timeperiod', '', TRUE),
	'host_notification_options' => array('nothstcnt', '', TRUE),
	'host_notification_commands' => array('commandcommalist', '', FALSE),
	'service_notification_period' => array('timeperiod', '', TRUE),
	'service_notification_options' => array('notsrvcnt', '', TRUE),
	'service_notification_commands' => array('commandcommalist', '', FALSE),
	'email' => array('string', '', FALSE),
	'pager' => array('string', '', FALSE)
 	),
 'contactgroup' => array(
	'__cfgfile'	=> array('cfgfile', '', TRUE),
 	'contactgroup_name' => array('string', '', TRUE),
	'alias' => array('string', '', 'TRUE'),
	'name'	=> array('string', '', FALSE),
	'register' => array('yesno', '1', FALSE),
	'use' => array('tplcontactgroup', '', FALSE),
	'members' => array('contactcommalist', '', TRUE)
 	),
 'timeperiod' => array(
	'__cfgfile'	=> array('cfgfile', '', TRUE),
 	'timeperiod_name' => array('string', '', TRUE),
	'alias' => array('string', '', TRUE),
	'name'	=> array('string', '', FALSE),
	'register' => array('yesno', '1', FALSE),
	'use' => array('tpltimeperiod', '', FALSE),
	'sunday' => array('timerangs', '', FALSE),
	'monday' => array('timerangs', '', FALSE),
	'tuesday' => array('timerangs', '', FALSE),
	'wednesday' => array('timerangs', '', FALSE),
	'thursday' => array('timerangs', '', FALSE),
	'friday' => array('timerangs', '', FALSE),
	'saturday' => array('timerangs', '', FALSE)
 	),
  'command' => array(
	'__cfgfile'	=> array('cfgfile', '', TRUE),
	'command_name' => array('string', '', TRUE),
	'command_line' => array('cmdline', '', TRUE)
  	),
  'hostextinfo' => array(
	'__cfgfile'	=> array('cfgfile', '', TRUE),
  	'host_name' => array('host', '', TRUE),
	'name'	=> array('string', '', FALSE),
	'use' => array('tplhostextinfo', '', FALSE),
	'notes_url' => array('string', '', FALSE),
	'icon_image' => array('iconimage', '', FALSE),
	'vrml_image' => array('vrmlimage', '', FALSE),
	'gd2_image' => array('gd2image', '', FALSE),
	'image_alt' => array('string', '', FALSE),
	'2d_coords' => array('xy', '', FALSE),
	'3d_coords' => array('xyz', '', FALSE),
	'register' => array('yesno', '1', FALSE)
  	),
  'serviceextinfo' => array(
	'__cfgfile'	=> array('cfgfile', '', TRUE),
  	'host_name' => array('host', '', TRUE),
	'service_name' => array('service', '', TRUE),
	'name'	=> array('string', '', FALSE),
	'use' => array('tplserviceextinfo', '', FALSE),
	'notes_url' => array('string', '', FALSE),
	'icon_image' => array('iconimage', '', FALSE),
	'image_alt' => array('string', '', FALSE),
	'register' => array('yesno', '1', FALSE)
  	),
  'nagioscfg' => array(
	'log_file' => array('string', '', TRUE),
	'cfg_file' => array('multistring', '', FALSE),
	'cfg_dir' => array('multistring', '', FALSE),
	'resource_file' => array('multistring', '', FALSE),
	'temp_file' => array('string', '', TRUE),
	'status_file' => array('string', '', TRUE),
	'aggregate_status_updates' => array('yesno', '1', FALSE),
	'status_update_interval' => array('number', '', FALSE),
	'nagios_user' => array('string', '', TRUE),
	'nagios_group' => array('string', '', TRUE),
	'enable_notifications' => array('yesno', '1', FALSE),
	'execute_service_checks' => array('yesno', '1', FALSE),
	'accept_passive_service_checks' => array('yesno', '1', FALSE),
	'enable_event_handlers' => array('yesno', '1', FALSE),
	'log_rotation_method' => array('logrotate', 'n', FALSE),
	'log_archive_path' => array('string', '', FALSE),
	'check_external_commands' => array('yesno', '0', FALSE),
	'command_check_interval' => array('number', '', TRUE),
	'comment_file' => array('string', '', TRUE),
	'downtime_file' => array('string', '', TRUE),
	'command_file' => array('string', '', TRUE),
	'lock_file' => array('string', '', TRUE),
	'retain_state_information' => array('yesno', '0', TRUE),
	'state_retention_file' => array('string', '', TRUE),
	'retention_update_interval' => array('number', '60', TRUE),
	'use_retained_program_state' => array('yesno', '1', TRUE),
	'use_syslog' => array('yesno', '0', TRUE),
	'log_notifications' => array('yesno', '', FALSE),
	'log_service_retries' => array('yesno', '', FALSE),
	'log_host_retries' => array('yesno', '', FALSE),
	'log_event_handlers' => array('yesno', '', FALSE),
	'log_initial_states' => array('yesno', '0', FALSE),
	'log_external_commands' => array('yesno', '1', FALSE),
	'log_passive_service_checks' => array('yesno', '1', FALSE),
	'global_host_event_handler' => array('command', '', FALSE),
	'global_service_event_handler' => array('command', '', FALSE),
	'sleep_time' => array('number', '', TRUE),
	'inter_check_delay_method' => array('intercheck', 's', FALSE),
	'service_interleave_factor' => array('interleavefact', 's', FALSE),
	'max_concurrent_checks' => array('number', '', FALSE),
	'service_reaper_frequency' => array('number', '', TRUE),
	'interval_length' => array('number', '60', FALSE),
	'use_agressive_host_checking' => array('yesno', '0', FALSE),
	'enable_flap_detection' => array('yesno', '0', FALSE),
	'low_service_flap_threshold' => array('number', '', TRUE),
	'high_service_flap_threshold' => array('number', '', TRUE),
	'low_host_flap_threshold' => array('number', '', TRUE),
	'high_host_flap_threshold' => array('number', '', TRUE),
	'soft_state_dependencies' => array('yesno', '0', FALSE),
	'service_check_timeout' => array('number', '', TRUE),
	'host_check_timeout' => array('number', '', TRUE),
	'event_handler_timeout' => array('number', '', TRUE),
	'notification_timeout' => array('number', '', TRUE),
	'ocsp_timeout' => array('number', '', TRUE),
	'perfdata_timeout' => array('number', '', TRUE),
	'obsess_over_services' => array('yesno', '0', FALSE),
	'ocsp_command' => array('command', '', FALSE),
	'process_performance_data' => array('yesno', '0', FALSE),
	'check_for_orphaned_services' => array('yesno', '0', FALSE),
	'check_service_freshness' => array('yesno', '1', FALSE),
	'freshness_check_interval' => array('number', '1', TRUE),
	'admin_email' => array('string', '', TRUE),
	'admin_pager' => array('string', '', FALSE),
	'date_format' => array('dateformat', 'us', FALSE)
	),
  'cgicfg' => array(
	'main_config_file' => array('string', '', TRUE),
	'physical_html_path' => array('string', '', TRUE),
	'url_html_path' => array('string', '', TRUE),
	'default_statusmap_layout' => array('default_statusmap_layout', '5', FALSE),
	'default_statuswrl_layout' => array('default_statuswrl_layout', '4', FALSE),
	'refresh_rate' => array('number', '60', TRUE),
	'show_context_help' => array('yesno', '1', FALSE),
	'process_check_command' => array('string', '', FALSE),
	'' => array('', '', FALSE), 		# Separator row
	'use_authentication' => array('yesno', '1', TRUE),
	'authorized_for_all_host_commands' => array('users', '', FALSE),
	'authorized_for_all_hosts' => array('users', '', FALSE),
	'authorized_for_all_service_commands' => array('users', '', FALSE),
	'authorized_for_all_services' => array('users', '', FALSE),
	'authorized_for_configuration_information' => array('users', '', FALSE),
	'authorized_for_system_commands' => array('users', '', FALSE),
	'authorized_for_system_information' => array('users', '', FALSE),
	'' => array('', '', FALSE), 		# Separator row
	'xcddb_database' => array('string', '', FALSE),
	'xcddb_host' => array('string', '', FALSE),
	'xcddb_password' => array('password', '', FALSE),
	'xcddb_port' => array('string', '', FALSE),
	'xcddb_username' => array('string', '', FALSE),
	'' => array('', '', FALSE), 		# Separator row
	'xdddb_database' => array('string', '', FALSE),
	'xdddb_host' => array('string', '', FALSE),
	'xdddb_password' => array('password', '', FALSE),
	'xdddb_port' => array('string', '', FALSE),
	'xdddb_username' => array('string', '', FALSE),
	'' => array('', '', FALSE), 		# Separator row
	'xeddb_database' => array('string', '', FALSE),
	'xeddb_host' => array('string', '', FALSE),
	'xeddb_password' => array('password', '', FALSE),
	'xeddb_port' => array('string', '', FALSE),
	'xeddb_username' => array('string', '', FALSE),
	'' => array('', '', FALSE), 		# Separator row
	'xsddb_database' => array('string', '', FALSE),
	'xsddb_host' => array('string', '', FALSE),
	'xsddb_password' => array('password', '', FALSE),
	'xsddb_port' => array('string', '', FALSE),
	'xsddb_username' => array('string', '', FALSE)
	),
  'resourcecfg' => array(
#	'$USER%s$' => array('string', '', FALSE),	# %s will be replaced by a number from 1 to 32
	'xcddb_database' => array('string', '', FALSE),
	'xcddb_host' => array('string', '', FALSE),
	'xcddb_password' => array('password', '', FALSE),
	'xcddb_port' => array('string', '', FALSE),
	'xcddb_username' => array('string', '', FALSE),
	'xdddb_database' => array('string', '', FALSE),
	'xdddb_host' => array('string', '', FALSE),
	'xdddb_password' => array('password', '', FALSE),
	'xdddb_port' => array('string', '', FALSE),
	'xdddb_username' => array('string', '', FALSE),
	'xeddb_database' => array('string', '', FALSE),
	'xeddb_host' => array('string', '', FALSE),
	'xeddb_password' => array('password', '', FALSE),
	'xeddb_port' => array('string', '', FALSE),
	'xeddb_username' => array('string', '', FALSE),
	'xsddb_database' => array('string', '', FALSE),
	'xsddb_host' => array('string', '', FALSE),
	'xsddb_password' => array('password', '', FALSE),
	'xsddb_port' => array('string', '', FALSE),
	'xsddb_username' => array('string', '', FALSE)
	),
  'nawuicfg' => array(
	'website_url' => array('string', 'http://', TRUE),
	'nawui_root' => array('string', '/var/www/html/nawui', TRUE),
	'nawui_url' => array('string', '/nawui', TRUE),
	'tmp_dir' => array('string', '/tmp', TRUE),
	'objects_per_page' => array('number', '15', TRUE),
	'page_refresh' => array('number', '0', TRUE),
	'nawui_plugin' => array('string', 'serialized', TRUE),
	'nagios_bin' => array('string', '/usr/bin/nagios', TRUE),
	'nagios_etc' => array('string', '/etc/nagios', TRUE),
	'nagios_plugins' => array('string', '/usr/libexec/nagios/plugins', TRUE),
	'nagios_webroot' => array('string', '/var/www/html/nagios', TRUE),
	'nagios_url' => array('string', '/nagios', TRUE),
	'nagios_cgis' => array('string', '/cgi-bin/nagios', TRUE),
	'debug' => array('yesno', '0', TRUE),
	'error_level' => array('number', '9', TRUE),
	'show_page_info' => array('yesno', '1', TRUE)
	) 
);

$propoptions = array(
 'notoptshost' => array(
	'd' => 'send on a <b>d</b>own state',
	'u' => 'send on an <b>u</b>nreachable state',
	'r' => 'send notifications on <b>r</b>ecoveries (up state)'
	),
 'stalkopts' => array(
 	'o' => 'stalk <b>o</b>n up states',
	'd' => 'stalk on <b>d</b>own states',
	'u' => 'stalk on <b>u</b>nreachable states'
 	),
 'stalksrvopts' => array(
 	'o' => 'stalk on <b>o</b>k states',
	'w' => 'stalk on <b>w</b>arning states',
	'u' => 'stalk on <b>u</b>nknown states',
	'c' => 'stalk on <b>c</b>ritical states'
 	),
 'notsrvcnt' => array(
	'w' => 'notify on <b>w</b>arning service state',
	'u' => 'notify on <b>u</b>nknown service states',
	'c' => 'notify on <b>c</b>ritical service states',
	'r' => 'notify on service <b>r</b>ecoveries (ok state)'
 	),
 'nothstcnt' => array(
 	'd' => 'notify on <b>d</b>own host state',
	'u' => 'notify on <b>u</b>nreachable host states',
	'r' => 'send notifications on <b>r</b>ecoveries (up state)'
	),
 'dateformat' => array(
 	'us' => 'us (MM-DD-YYYY HH:MM:SS)',
	'euro' => 'euro (DD-MM-YYYY HH:MM:SS)',
	'iso8601' => 'iso8601 (YYYY-MM-DD HH:MM:SS)',
	'strict-iso8601' => 'strict-iso8601 (YYYY-MM-DDTHH:MM:SS)'
 	),
 'intercheck' => array(
	's' => 'Use "smart" inter-check delay calculation',
	'n' => "None - don't use any delay between checks",
	'd' => 'Use a "dumb" delay of 1 second between checks',
	'x' => 'interleave factor: :numberinput: seconds'
 	),
 'interleavefact' => array(
	's' => 'Use "smart" interleave factor calculation',
	'x' => 'interleave factor: :numberinput:'
 	),
 'default_statusmap_layout' => array(
	'0' => 'User-defined coordinates',
	'1' => 'Depth layers',
	'2' => 'Collapsed tree',
	'3' => 'Balanced tree',
	'4' => 'Circular',
	'5' => 'Circular (Marked Up)',
	'6' => 'Circular (Balloon)'
 	),
 'default_statuswrl_layout' => array(
	'0' => 'User-defined coordinates',
	'2' => 'Collapsed tree',
	'3' => 'Balanced tree',
	'4' => 'Circular'
	),
 'yesno' => array(
	'0' => 'No',
	'1' => 'Yes',
	)
);

$cfgnagios = array(
  'accept_passive_service_checks' => array('yesno', '1', TRUE),
  'admin_email' => array('string', '', TRUE),
  'admin_pager' => array('string', '', FALSE),
  'aggregate_status_updates' => array('yesno', '1', TRUE),
  'cfg_file' => array('multistring', '', FALSE),
  'check_external_commands' => array('yesno', '1', TRUE),
  'check_for_orphaned_services' => array('yesno', '0', TRUE),
  'check_service_freshness' => array('yesno', '1', TRUE),
  'command_check_interval' => array('number', '', TRUE),
  'command_file' => array('string', '', TRUE),
  'comment_file' => array('string', '', TRUE),
  'date_format' => array('string', '', TRUE),
  'downtime_file' => array('string', '', TRUE),
  'enable_event_handlers' => array('yesno', '1', TRUE),
  'enable_flap_detection' => array('yesno', '1', TRUE),
  'enable_notifications' => array('yesno', '1', TRUE),
  'event_handler_timeout' => array('string', '', TRUE),
  'execute_service_checks' => array('yesno', '1', TRUE),
  'freshness_check_interval' => array('number', '', TRUE),
  'high_host_flap_threshold' => array('number', '', TRUE),
  'high_service_flap_threshold' => array('number', '', TRUE),
  'host_check_timeout' => array('number', '', TRUE),
  'inter_check_delay_method' => array('intercheck', 's', FALSE),
  'interval_length' => array('number', '60', TRUE),
  'lock_file' => array('string', '', TRUE),
  'log_file' => array('string', '', TRUE),
  'log_archive_path' => array('string', '', TRUE),
  'log_event_handlers' => array('yesno', '1', TRUE),
  'log_external_commands' => array('yesno', '1', TRUE),
  'log_host_retries' => array('yesno', '1', TRUE),
  'log_initial_states' => array('yesno', '1', TRUE),
  'log_notifications' => array('yesno', '1', TRUE),
  'log_passive_service_checks' => array('yesno', '1', TRUE),
  'log_rotation_method' => array('logrotate', 'n', FALSE),
  'log_service_retries' => array('yesno', '1', TRUE),
  'low_host_flap_threshold' => array('string', '', TRUE),
  'low_service_flap_threshold' => array('string', '', TRUE),
  'max_concurrent_checks' => array('number', '0', TRUE),
  'nagios_group' => array('string', '', TRUE),
  'nagios_user' => array('string', '', TRUE),
  'notification_timeout' => array('number', '', TRUE),
  'obsess_over_services' => array('yesno', '0', TRUE),
  'ocsp_timeout' => array('number', '', TRUE),
  'perfdata_timeout' => array('number', '', TRUE),
  'process_performance_data' => array('yesno', '1', TRUE),
  'resource_file' => array('multistring', '', FALSE),
  'retain_state_information' => array('yesno', '1', TRUE),
  'retention_update_interval' => array('string', '', TRUE),
  'service_check_timeout' => array('string', '', TRUE),
  'service_interleave_factor' => array('interleavefact', 's', FALSE),
  'service_reaper_frequency' => array('number', '', TRUE),
  'sleep_time' => array('number', '', TRUE),
  'state_retention_file' => array('string', '', TRUE),
  'status_file' => array('string', '', TRUE),
  'status_update_interval' => array('number', '', TRUE),
  'temp_file' => array('string', '', TRUE),
  'use_agressive_host_checking' => array('yesno', '0', TRUE),
  'use_retained_program_state' => array('yesno', '1', TRUE),
  'use_syslog' => array('yesno', '0', TRUE)
);


?>
