<?php

# Page variables
define("OBJECTTYPE",'nagioscfg');
define("PAGE_ID","nagioscfg");
define("PAGE_TITLE","Nagios Configuration settings");

require_once("includes/main.inc.php");
include_once("html_wrap/head.inc.php");


$rowcolor = "rowcolor2";
$action = isset($action) ? @strtolower($action) : "";
$message = "";

# Actions before output is send
switch($action) {
	case "save":

		# Handle the check_command attributes
		$checkcommand = $cfg['ocsp_command'][0]['cmd'];
		$param = trim($cfg['ocsp_command'][0]['param']);
		
		if (!empty($param)) $checkcommand .= "!".$param;
		
		@settype($cfg['ocsp_command'][0], "string");
		$cfg['ocsp_command'][0] = $checkcommand;

		$checkcommand = $cfg['global_host_event_handler'][0]['cmd'];
		$param = trim($cfg['global_host_event_handler'][0]['param']);
		
		if (!empty($param)) $checkcommand .= "!".$param;
		
		@settype($cfg['global_host_event_handler'][0],"string");
		$cfg['global_host_event_handler'][0] = $checkcommand;

		$checkcommand = $cfg['global_service_event_handler'][0]['cmd'];
		$param = trim($cfg['global_service_event_handler'][0]['param']);
		
		if (!empty($param)) $checkcommand .= "!".$param;

		@settype($cfg['global_service_event_handler'][0],"string");
		$cfg['global_service_event_handler'][0] = $checkcommand;

		if ($Plugin->SaveConfig("nagioscfg", $cfg) != NULL)
			$message = "<font color=\"#FF2222\">Configuration could not been saved.</font>";
		else $message = "<font color=\"#00AA00\">Configuration has been saved.</font>";

}

$nagioscfg = $Plugin->GetConfig("nagioscfg");

foreach ($confobjects[OBJECTTYPE] as $key => $propconf) {

	$required = "label";
	$values = isset($nagioscfg[$key]) ? $nagioscfg[$key] : array();
	$count = count($values);
	
	if (empty($nagioscfg[$key])) {
		$required = $propconf[2] == TRUE ? "required" : "label";
	}

	# Add an extra entry field when multi values are possible.
	if ($propconf[0] == "multistring" || $count == 0) {
		
		$count++;
	}

	# Set the default value if needed and if there is one.
	if (isset($values[0]) == FALSE && $propconf[1] != "") {
		
		$values[0] = $propconf[1];
	}

	for ($i = 0; $i < $count; $i++) {
	
		$value = isset($values[$i]) ? $values[$i] : "";
  		
		$show = NagiosObjPropEdit(OBJECTTYPE, $key, "cfg[$key][$i]", $value);
		$rowcolor = ($rowcolor != "dataOdd") ? "dataOdd" : "dataEven";

		$info_key=ucfirst(str_replace("_", " ", $key));

		$rows[] = <<<HTML
<tr class="{$rowcolor}">
  <td>$info_key</td>
  <td class="$required" with="3">&nbsp;</td>
  <td>
  $show
  </td>
</tr>
HTML;
	}
}

?>
<br>
<div align="center">
<form action="nagioscfg.php" method="post">
<table cellpadding="3" border="0" class="data">
<tr>
  <td colspan="2" align="left">
  <b>&nbsp;<?=$message?>&nbsp;</b>
  </td>
  <td colspan="1" align="right">
  <input type="submit" name="action" value="Save">
  </td>
</tr>
<tr class="data">
  <th colspan="3" class="data">Properties</th>
</tr>
<?=implode("\n", $rows)?>
</table>
</form>
</div>
<?



include_once("html_wrap/tail.inc.php");

?>
