<?php

# Page variables
define("OBJECTTYPE",'nawuicfg');
define("PAGE_ID","nawuicfg");
define("PAGE_TITLE","NaWui Configuration settings");

require_once("includes/main.inc.php");
include_once("html_wrap/head.inc.php");


$rowcolor = "rowcolor2";
$action = isset($action) ? @strtolower($action): "";
$message = "";
$rows = array();

# Actions before output is send
switch($action) {
	case "save":

		$result = SaveNawuiConfig($cfg);
		if ($result === TRUE)
			$message = "<font color=\"#00AA00\">Configuration has been saved.</font>";
	  	else
			$message = "<font color=\"#FF2222\">$result</font>";

}

$nawuicfg = LoadNawuiConfig();

foreach ($confobjects[OBJECTTYPE] as $key => $propconf) {

	$values = isset($nawuicfg[$key]) ? $nawuicfg[$key] : array();
	$count = count($values);
	$required = "label";

	if (empty($nawuicfg[$key])) {
	
		$required = $propconf[2] == TRUE ? 'required' : 'label';
	}

	# Add an extra entry field when multi values are possible
	if ($propconf[0] == 'multistring' || $count == 0) {

		$count++;
	}

	# Set the default value if needed and if there is one
	if (isset($values[0]) == FALSE && $propconf[1] != '') {

		$values[0] = $propconf[1];
	}

	for ($i = 0; $i < $count; $i++) {
	
		$value = isset($values[$i]) ? $values[$i] : '';
  		
		$show = NagiosObjPropEdit(OBJECTTYPE, $key, "cfg[$key][$i]",$value);
		
		$rowcolor = ($rowcolor != "dataOdd") ? "dataOdd" : "dataEven";

		$key=ucfirst(str_replace("_", " ", $key));

		$rows[] = <<<HTML
<tr class="{$rowcolor}">
  <td>$key</td>
  <td class="$required" with="3">&nbsp;</td>
  <td>
  $show
  </td>
</tr>
HTML;
	}
}

?>
<br>
<div align="center">
<form action="<?=$PHP_SELF?>" method="post">
<table cellpadding="3" border="0" class="data">
<tr>
  <td colspan="2" align="left">
  <b><?=$message?>&nbsp;</b>
  </td>
  <td colspan="1" align="right">
  <input type="submit" name="action" value="Save">
  </td>
</tr>
<tr class="data">
  <th colspan="3" class="data">Properties</th>
</tr>
<?=implode("\n", $rows)?>
</table>
</form>
</div>
<?



include_once("html_wrap/tail.inc.php");

?>
