<?php

define("PAGE_ID","onlinecfgs");
define("PAGE_TITLE","Online Nagios Configurations*");

require_once("includes/main.inc.php");
include_once("html_wrap/head.inc.php");

$action = (isset($action)) ? @strtolower($action) : "";
$config_file = (isset($config_file)) ? $config_file : "";
$data = "";
$errormsg = "<br>";


function WriteConfigFile($content)	{


	global $config_file, $errormsg;
		
	$content = str_replace("\\\"", "\"", $content);

	if (is_writable($config_file)) {

		if (!$handle = fopen($config_file, 'w')) {
			
			$errormsg = "<div align=\"center\"><font color=\"#FF2222\">Cannot open file.</font></div>\n";
		
		} elseif (!fwrite($handle, $content)) {
			
			$errormsg = "<div align=\"center\"><font color=\"#FF2222\">Cannot write to file.</font></div>\n";
		
		} else {
		
			$errormsg = "<div align=\"center\"><font color=\"#009900\">Modifications were was successfuly saved.</font></div>\n";
			fclose($handle);
		}
	} else 	$errormsg = "<div align=\"center\"><font color=\"#FF2222\">Configuration file is not writable.</font></div>\n";
}



switch ($action)	{

	case "save":
		if ($config_file != "")
			WriteConfigFile($file_textarea);
		# Don't break, read the file again.
	
	case "edit":
	case "view":
		if (isset($config_file))
			if ($config_file != "")
				if (is_readable($config_file))
					$data=implode("", file($config_file));
				else
					$errormsg = "<div align=\"center\"><font color=\"#009900\">Cannot open file to read.</font></div>\n";
		break;
}

# Get configuration files
$nagioscfg = $Plugin->GetConfig("nagioscfg");

?>
<?=$errormsg?>
<div align="center">
<form name="config_file_form" action="<?=$PHP_SELF?>" method="POST">
<table border="0" width="750">
<tr class="dataOdd">
<td>
<font size="-2" color="#FF2222"><b>NOTE: </b></font><font size="-2">
You are editing configuration files loaded by the current running Nagios process. This means that every<br>
configuration file MAY be overwritten in the next export, this only depends from the ability of the chosen plugin to <br>
preserve this modifications or not.
</font>
</td>
</tr>
<tr class="dataEven">
<td width="50%" align="left">&nbsp;Configuration file:&nbsp;
<select name="config_file">
<option value="">
<option value="<?=NAGIOS_ETC."/nagios.cfg"?>" <?=($config_file == NAGIOS_ETC."/nagios.cfg") ? "selected" : ""?>>nagios.cfg
<option value="<?=NAGIOS_ETC."/cgi.cfg"?>" <?=($config_file == NAGIOS_ETC."/cgi.cfg") ? "selected" : ""?>>cgi.cfg
<option value="<?=$nagioscfg["resource_file"][0]?>" <?=($config_file == $nagioscfg["resource_file"][0]) ? "selected" : ""?>><?=basename($nagioscfg["resource_file"][0])?>
<?

foreach($nagioscfg["cfg_file"] as $filename)	{

	$selected = ($filename == $config_file) ? "selected" : "";
	echo "<option value=\"$filename\" $selected>".basename($filename)."\n";

}
?>
</select>
<input type="submit" name="action" value="View">
<?
if ($action != "view" && $action != "") 
	echo "<input type=\"submit\" name=\"action\" value=\"Save\">";
else
	echo "<input type=\"submit\" name=\"action\" value=\"Edit\">"; 
?>
</td>
</tr>
<tr class="dataOdd">
<td>
<textarea <?=($action == "view") ? "readonly" : ""?> name="file_textarea" rows="25" cols="80">
<?=$data?>
</textarea>
</td>
</tr>
</table>
</form>
</div>
<br>
<?

include_once("html_wrap/tail.inc.php");
?>
