<?php

# Page variables
define("OBJECTTYPE",'resourcecfg');
define("PAGE_ID","resourcecfg");
define("PAGE_TITLE","Nagios Configuration settings");

require_once("includes/main.inc.php");
include_once("html_wrap/head.inc.php");


$rowcolor = "rowcolor2";
$action = isset($action) ? @strtolower($action) : "";
$message = "";

# Actions before output is send
switch($action) {
	case "save":

		#if ($Plugin->SaveResourceConfig($resource_filename) != NULL)
		if ($Plugin->SaveConfig("resourcecfg", $cfg) != NULL)
			$message = "<font color=\"#FF2222\">Configuration could not been saved.</font>";
		else $message = "<font color=\"#00AA00\">Configuration has been saved.</font>";

}


$nagioscfg = $Plugin->GetConfig("nagioscfg");
$resource_filename = $nagioscfg["resource_file"][0];
$nagioscfg = NULL;
#$resourcecfg = $Plugin->GetConfig($resource_filename);
$resourcecfg = $Plugin->GetConfig("resourcecfg");

# Count the $USER_$ key values there is in $resourcecfg,
# and create some kind of dynamic array keys in $confobjects.
# ex: $USER1$, $USER2$, $USER3$, etc... till 32.
ksort($resourcecfg);
$userX=0;
foreach ($resourcecfg as $key => $v)	{

	if (strstr($key, '$USER'))	{

		$userX++;
		if ($v != "")
			$confobjects[OBJECTTYPE]['$USER'.$userX.'$'] = array('string', '', FALSE);
	}
}
# Create a last $USER_$ entry field if the user wants to add new values,
# but ONLY if the values are less than 32. 
# (This is the limit imposed by Nagios for this kind of field.)
if ($userX < 32)	{
	$userX++;
	$confobjects[OBJECTTYPE]['$USER'.$userX.'$'] = array('string', '', FALSE);
} 

# Because the dynamic arary created previously was appended to the existing one ($confobjects)
# we will reverse it in order to display the $USER_$ fields first and the rest next.
ksort($confobjects[OBJECTTYPE]);

#$USER%s$' => array('string', '', FALSE),	# %s will be replaced by a number from 1 to 32

foreach ($confobjects[OBJECTTYPE] as $key => $propconf) {

	$required = "label";
	$values = isset($resourcecfg[$key]) ? $resourcecfg[$key] : array();
	$count = count($values);
	
	
	if (empty($resourcecfg[$key])) {
		$required = $propconf[2] == TRUE ? "required" : "label";
	}

	# Add an extra entry field when multi values are possible.
	if ($propconf[0] == "multistring" || $count == 0) {
		
		$count++;
	}#elseif (strstr($key, '$USER')) $count++;

	# Set the default value if needed and if there is one.
	if (isset($values[0]) == FALSE && $propconf[1] != "") {
		
		$values[0] = $propconf[1];
	}
	
	for ($i = 0; $i < $count; $i++) {
	
		$value = isset($values[$i]) ? $values[$i] : "";
  	
		$show = NagiosObjPropEdit(OBJECTTYPE, $key, "cfg[$key][$i]", $value);
		$rowcolor = ($rowcolor != "dataOdd") ? "dataOdd" : "dataEven";

		$info_key=ucfirst(str_replace("_", " ", $key));

		$rows[] = <<<HTML
<tr class="{$rowcolor}">
  <td>$info_key</td>
  <td class="$required" with="3">&nbsp;</td>
  <td>
  $show
  </td>
</tr>
HTML;
	}
}

?>
<br>
<div align="center">
<form action="<?=$PHP_SELF?>" method="POST">
<input type="hidden" name="resource_filename" value="<?=$resoure_filename?>">
<table cellpadding="3" border="0" class="data">
<tr>
  <td colspan="2" align="left">
  <b>&nbsp;<?=$message?>&nbsp;</b>
  </td>
  <td colspan="1" align="right">
  <input type="submit" name="action" value="Save">
  </td>
</tr>
<tr class="data">
  <th colspan="3" class="data">Properties</th>
</tr>
<?=implode("\n", $rows)?>
</table>
</form>
</div>
<?



include_once("html_wrap/tail.inc.php");

?>
