<?php

# Disallow run of this script.
if (basename($_SERVER['PHP_SELF']) == "serviceescalations.php")	{
	print("Direct execution of this script is not allowed.");
	exit;
}


# Includes
require_once("includes/drawlib.inc.php");

# Definitions
define("OBJECTTYPE","serviceescalation");
define("OBJECTNAME","ServiceEscalation");
define("PAGE_INFO", 'Query made at '.date("H:i:s - d M Y"));

$rowcolor = '';
$rows = array();
$errormsg = '';
$message = '';
$serviceescalation = array();

if (!isset($sorttype))	 $sorttype="0";
if (!isset($sortoption)) $sortoption="service_description";
if (!isset($page)) 	 $page=1;

$sortoption = @strtolower($sortoption);

# Set Headers Titles and URL Values
$headers = array( 0 => array ( "Title" => "Service Description", "SortName" => "service_description"),
		  1 => array ( "Title" => "Hostname", "SortName" => "host_name"),
		  2 => array ( "Title" => "Hostgroup Name", "SortName" => "hostgroup_name"),
		  3 => array ( "Title" => "Contactgroups", "SortName" => "contact_groups"),
		  );

# ######## The script REALLY starts running from here ########


# Get Objects Records Count
$objects_count=$Plugin->GetObjectsCount(OBJECTTYPE);

# Get Sorted Object Records
# Sort Type ($sorttype)
#  - 0 - Ascending
#  - 1 - Reversed
$objects = $Plugin->GetSortedObjectsFromTo($sortoption, $sorttype, 0, $objects_count, OBJECTTYPE);
#PrintArray($objects);

if (!is_array($objects))	{

	# This message will be displayed in errmsg row in TableHeader
	$message = "No objects found in database.";
	
	OpenTable(6);
	TableHeader($headers, "");
	CloseTable(6);
	include_once("html_wrap/tail.inc.php");
	exit; # If no Records are found, we exit...completly.

}

$i=0;
#PrintArray($objects);
$serviceescalations=NULL;
foreach($objects as $key => $object)	{


	if (isset($object["__objectid"]))	{
		$serviceescalations[$i]["Id"]			= $object["__objectid"];
		$serviceescalations[$i]["Service_Description"]  = (!empty($object['service_description'])) ? $object['service_description'] : "";
		$serviceescalations[$i]["Host_Name"]		= (!empty($object['host_name'])) ? $object['host_name'] : "-";
		$serviceescalations[$i]["Hostgroup_Name"]	= (!empty($object['hostgroup_name'])) ? $object['hostgroup_name'] : "";
		$serviceescalations[$i]["Contact_groups"]	= (!empty($object['contact_groups'])) ? $object['contact_groups'] : "";

		$i++;
	}
} # foreach

# Get Page information to construct objects to be displayed in the current page, 
# based in DISPLAY_OBJECTS constant var.
$pageinfo=get_objects_from_page(count($serviceescalations), $page);

if (DEBUG == "1") debug_window_msg(print_r($pageinfo));


# Construct Table Rows with Selected Host data
$num=$pageinfo["first_object"]+1;
	
for ($i=$pageinfo["first_object"]; $i<$pageinfo["last_object"]; $i++) {

	$rowcolor = ($rowcolor != "dataOdd") ? "dataOdd" : "dataEven";
	
	$rows[] = <<<HTML
<tr class="{$rowcolor}">
  <td>{$num}</td>
  <td>{$serviceescalations[$i]["Service_Description"]}</td>
  <td>{$serviceescalations[$i]["Host_Name"]}</td>
  <td>{$serviceescalations[$i]["Hostgroup_Name"]}</td>
  <td>{$serviceescalations[$i]["Contact_groups"]}</td>
  <td>
   <a href="serviceescalationedit.php?objectid={$serviceescalations[$i]["Id"]}" onclick="nw=window.open('', 'edit_serviceescalation_popup', 'resizable=no, scrollbars=1, copyhistory=0, width=700, height=550');nw.opener=self" target="edit_serviceescalation_popup">Edit</a>
   <a href="serviceescalationview.php?objectid={$serviceescalations[$i]["Id"]}" onclick="nw=window.open('', 'view_serviceescalation_popup', 'resizable=no, scrollbars=1,, copyhistory=0, width=700, height=550');nw.opener=self" target="view_serviceescalation_popup">View</a><br>
   <a href="deleteobject.php?objectid={$serviceescalations[$i]["Id"]}&objecttype=serviceescalation" onclick="nw=window.open('', 'delete_serviceescalation_popup', 'resizable=no, scrollbars=1, copyhistory=0, width=430, height=220');nw.opener=self" target="delete_serviceescalation_popup">Delete</a>
</td>
</tr>
HTML;
	$num++;
} # for

# Draw everything
OpenTable(6);
TableHeader($headers, "");
print implode("\n",$rows);
CloseTable(6);


if (DEBUG == "1") debug_window_msg(print_r($hosts)); # For Debugging

?>
