<?php

# Disallow run of this script.
if (basename($_SERVER['PHP_SELF']) == "serviceextinfo.php") 	{
	print("Direct execution of this script is not allowed.");
	exit;
}


# Includes
require_once("includes/drawlib.inc.php");

# Definitions
define("OBJECTTYPE","serviceextinfo");
define("OBJECTNAME","ServiceExtInfo");
define("PAGE_INFO", 'Query made at '.date("H:i:s - d M Y"));

# Initialize Variables
$rowcolor 	= "";
$message 	= "";
$rows 		= array();
$serviceextinfo	= array();


# Set Headers Titles and URL Values
$headers = array( 0 => array ( "Title" => "Host Name", "SortName" => "host_name"),
		  1 => array ( "Title" => "Service Name", "SortName" => "service_name"),
		  2 => array ( "Title" => "Name", "SortName" => "name"),
		  3 => array ( "Title" => "Notes URL", "SortName" => "notes_url"),
		  4 => array ( "Title" => "Icon", "SortName" => ""),
		  5 => array ( "Title" => "Image Alt", "SortName" => "image_alt"),
		  6 => array ( "Title" => "Registered", "SortName" => "registered")
		  );

$page 		= (isset($page)) 	? $page : 1;
$sorttype 	= (isset($sorttype))	? $sorttype : "0";
$sortoption 	= (isset($sortoption)) 	? $sortoption 	: $headers[0]["SortName"];

# Sort Type ($sorttype)
#  - 0 - Ascending
#  - 1 - Reversed

# -------# The script REALLY starts running from here #-------

$objects_count=$Plugin->GetObjectsCount(OBJECTTYPE);

$objects = $Plugin->GetSortedObjectsFromTo($sortoption, $sorttype, 0, $objects_count, OBJECTTYPE);

if (!is_array($objects))	{

	# This message will be displayed in errmsg row in TableHeader
	$message = "No objects found in database.";
	
	OpenTable(9);
	TableHeader($headers, "");
	CloseTable(9);
	include_once("html_wrap/tail.inc.php");
	exit; # If no Records are found, we exit...completly.

}
# we don't need an else, because we exit if there are no records

$i = 0;
foreach ($objects as $id => $object)	{

	$name = isset($object["host_name"]) ? $object["host_name"] : "";
	$registered = "default";
	
	if (isset($object["register"]))	
		$registered = ($object["register"] == 0) ? "no" : "yes";
	
	$serviceextinfo[$i]['Id']		= $object['__objectid'];
	$serviceextinfo[$i]['Host Name']	= $name;
	$serviceextinfo[$i]['Service Name']= isset($object['service_name'])? $object['service_name'] : "";
	$serviceextinfo[$i]['Name']	= isset($object['name'])	? $object['name']  	  : "";
	$serviceextinfo[$i]['Notes URL']	= isset($object['notes_url'])	? $object['notes_url']	  : "";
	$serviceextinfo[$i]['Icon']	= isset($object['icon_image'])	? $object['icon_image']	  : "";
	$serviceextinfo[$i]['Image Alt']   = isset($object['image_alt'])	? $object['image_alt']    : "";
	$serviceextinfo[$i]['Registered']  = $registered;

	$i++;
} # foreach



# Get Page information to construct objects to be displayed in the current page, 
# based in DISPLAY_OBJECTS constant var.
$pageinfo=get_objects_from_page(count($serviceextinfo), $page);

# Construct Table Rows with Selected data
$num=$pageinfo["first_object"]+1;
	
for ($i=$pageinfo["first_object"]; $i<$pageinfo["last_object"]; $i++) {
		
	$rowcolor = ($rowcolor != "dataOdd") ? "dataOdd" : "dataEven";
	
	$rows[] = <<<HTML
<tr class="{$rowcolor}">
  <td>{$num}</td>
  <td>{$serviceextinfo[$i]["Host Name"]}</td>
  <td>{$serviceextinfo[$i]["Service Name"]}</td>
  <td>{$serviceextinfo[$i]["Name"]}</td>
  <td>{$serviceextinfo[$i]["Notes URL"]}</td>
  <td>{$serviceextinfo[$i]["Icon"]}</td>
  <td>{$serviceextinfo[$i]["Image Alt"]}</td>
  <td align="center">{$serviceextinfo[$i]["Registered"]}</td>
  <td>
  <a href="serviceextinfoedit.php?objectid={$serviceextinfo[$i]["Id"]}" onclick="nw=window.open('', 'edit_serviceextinfo_popup', 'resizable=no, scrollbars=1, copyhistory=0, width=700, height=450');nw.opener=self" target="edit_serviceextinfo_popup">Edit</a>&nbsp;
  <a href="serviceextinfoview.php?objectid={$serviceextinfo[$i]["Id"]}&action=View" onclick="nw=window.open('', 'view_serviceextinfo_popup', 'resizable=no, scrollbars=1, copyhistory=0, width=700, height=450');nw.opener=self" target="view_serviceextinfo_popup">View</a><br>
  <a href="deleteobject.php?objectid={$serviceextinfo[$i]["Id"]}&objecttype=serviceextinfo" onclick="nw=window.open('', 'delete_serviceextinfo_popup', 'resizable=no, scrollbars=1, copyhistory=0, width=430, height=220');nw.opener=self" target="delete_serviceextinfo_popup">Delete</a>&nbsp;
  </td>
</tr>
HTML;

	$num++;
} # for


# Draw everything
OpenTable(9);
TableHeader($headers, "");
print implode("\n",$rows);
CloseTable(9);

?>
