<?php

# Page variables
define("PAGE_ID","serviceextinfoedit");
define("PAGE_TITLE","Extended Service Info Object");
define("OBJECTTYPE","serviceextinfo");
define("OBJECTNAME","SericeExtInfo");

require_once("includes/main.inc.php");

$rowcolor = ""; 
$errormsg = "";
$cntinh	  = 0;
$action   = (isset($action))	? @strtolower($action)	: "";
$objectid = (isset($objectid))	? $objectid 		: NULL;

# Actions before output is send
switch ($action)	{
	
	case 'save':
	
		$servicename = $saveobject['service_name'] ? $saveobject['service_name'] : "";
		$hostname = $saveobject['host_name'] ? $saveobject['host_name'] : "";

		# If ObjectId is NULL it means it's a new object.
		if ($objectid == "")	{
			
			if ($hostname == "")	{
			
				$errormsg = "Object has an empty 'Host Name'.";
				$object=$saveobject;
				break;
			}
			if ($servicename == "")	{
			
				$errormsg = "Object has an empty 'Service Name'.";
				$object=$saveobject;
				break;
			}
/*
			# - FIX ME -
			# Still need to make some kind of check service_name/host_name 
			# with database to disallow duplicate entries for the same Host/Service.
			#
			$saved_object = $Plugin->GetObjectByIndexName($hostname, OBJECTTYPE, "host_name");
			$saved_object = $Plugin->GetObjectByIndexName($hostname, OBJECTTYPE, "service_name");
			echo "New: $hostname = $servicename<br>";
			echo "Saved: ".$saved_object['host_name'][0]." = ".$saved_object['service_name'][0];
			PrintArray($saved_object);
			# Check if record already exists
			if ( $saved_hostname == $hostname && $saved_servicename == $servicename)	{
*/			
			# Check if record already exists
			if ( $Plugin->GetObjectByIndexName($hostname, OBJECTTYPE))	{
				$errormsg = "'$servicename' 'Service Name' has already been defined for '$hostname' 'Host Name'.";
				$saveobject["service_name"] = "";
				$object=$saveobject;
				break;
			}
		}

		$objectid = $Plugin->SaveObject($objectid, $saveobject, OBJECTTYPE);

		echo "<BODY onLoad='opener.location.reload(); parent.close()'>";
		break;
}

include_once("html_wrap/head2.inc.php");

if ($objectid != "") {

	$object = $Plugin->GetObjectById($objectid, OBJECTTYPE);
	$objectid = (isset($object['__objectid'])) ? $object['__objectid'] : "";

} elseif (!isset($object))	{

	$object = NULL;
}

$serviceextinfoname = isset($object["service_name"]) ? $object["service_name"] : $object['name']; 


# If this is a template: get its iheriters
if (!empty($object['host_name'])) {

	$cntinh = NagiosCountInherited(OBJECTTYPE, $object['host_name']);
}

# Get information about the parent object if any
if( !empty($object['use']) ) {

	$inhobject = $Plugin->GetObjectByName($object['use'], OBJECTTYPE);
	
	foreach($inhobject as $key => $value) {
	
		$object['++'.$key] = $value;
	}
}

# Get a default cfg file if object is new
if ($object['__cfgfile'] == "") {
	
	$object['__cfgfile'] = NAGIOS_ETC."/cgi.cfg";
}

foreach ($confobjects[OBJECTTYPE] as $key => $propconf)	{

	$required = 'label';
	$value = isset($object[$key]) ? $object[$key] : '';
	$inhhtml = "";
	
	if (isset($object["++".$key]))	{
		
		$inhhtml = "  <td>".str_replace(",", ",<br>", $object["++".$key])."</td>\n";
		$reqclass = 'requiredok';
		
	} else {

		$inhhtml = "  <td>&nbsp;</td>\n";
		$reqclass = 'required';
	}
	
	
  	$show = NagiosObjPropEdit(OBJECTTYPE, $key, "saveobject[$key]", $value);

	if (empty($object[$key])) {
	
		$required = @$propconf[2] ? $reqclass : 'label';
	}

        $rowcolor = ($rowcolor != "dataOdd") ? "dataOdd" : "dataEven";
	
	$keyname=ucfirst(str_replace("_", " ", $key));

	$rows[$key] = <<<HTML
<tr class="{$rowcolor}">
  <td>$keyname</td>
  <td class="{$required}" with="3">&nbsp;</td>
  <td>
  $show
  </td>
  $inhhtml
</tr>
HTML;
}

?>
<div align="center">
<form name="<?=PAGE_ID?>_form" action="<?=$PHP_SELF?>" method="POST">
<input type="hidden" name="objectid" value="<?=$objectid?>">
<input type="hidden" name="saveobject[__cfgfile]" value="<?=$object['__cfgfile']?>">
<input type="hidden" name="saveobject[__type]" value="<?=OBJECTTYPE?>">

<table cellpadding="2" border="0">
<tr>
  <td colspan="4" align="left">
  <?=ErrorMsg($errormsg)?>
  </td>
</tr>
<tr class="data">
  <th colspan="3" class="data">Properties</th>
<?

if( !empty($object['use']) ) {

	$parent = $Plugin->GetObjectByName($object['use'], OBJECTTYPE);
	print <<<HTML
  <th class="data">
  Inherits from 
  <a href="serviceextinfoedit.php?objectid={$parent['__objectid']}" onclick="nw=window.open('', 'edit_serviceextinfo_template_popup', 'resizable=no, scrollbars=1, copyhistory=0, width=700, height=450');nw.opener=self" target="edit_serviceextinfo_template_popup"><b>{$parent['name']}</b></a>
  </th>
HTML;
} else {

	echo "<th class=\"data\">&nbsp;</th>\n";
}
?>
</tr>
<?=implode("\n", $rows)?>
<?


if ( $cntinh > 0 ) {

	print ObjectInheritance($object['name'], OBJECTTYPE, 'edit');
}

if (!empty($object["host_name"])) {

	$userobjs = NagiosObjectUsage($serviceextinfoname, OBJECTTYPE);
	if ( $userobjs != NULL ) {

		print ObjectUsage($serviceextinfoname, OBJECTTYPE, $userobjs, "edit");
	}
}

?>
<tr>
  <td colspan="4" align="center">
   <hr>
  </td>
</tr>
<tr>
  <td colspan="4" align="center">
   <input type="submit" name="action" value="Save">
   <input type="submit" name="action" value="Cancel" onclick="parent.close('')">
  </td>
</tr>

</table>
</form>
</div>

<?
include_once("html_wrap/tail2.inc.php");


?>
