<?php

# Page variables
define("PAGE_ID","serviceextinfoview");
define("PAGE_TITLE","Extended Host Info Object");
define("OBJECTTYPE","serviceextinfo");
define("OBJECTNAME","HostExtInfo");

require_once("includes/main.inc.php");

$rowcolor = ""; 
$action   = (isset($action))	? @strtolower($action)	: "";
$objectid = (isset($objectid))	? $objectid 		: NULL;

include_once("html_wrap/head2.inc.php");

if ($objectid != "") {

	$object = $Plugin->GetObjectById($objectid, OBJECTTYPE);
	$objectid = (isset($object['__objectid'])) ? $object['__objectid'] : "";

}

$serviceextinfoname = isset($object["service_name"]) ? $object["service_name"] : $object['name']; 


# If this is a template: get its iheriters
if (!empty($object['host_name'])) {

	$cntinh = NagiosCountInherited(OBJECTTYPE, $object['host_name']);
}

# Get information about the parent object if any
if( !empty($object['use']) ) {

	$inhobject = $Plugin->GetObjectByName($object['use'], OBJECTTYPE);
	
	foreach($inhobject as $key => $value) {
	
		$object['++'.$key] = $value;
	}
}


foreach ($confobjects[OBJECTTYPE] as $key => $propconf)	{

	$required = 'label';
	$value = isset($object[$key]) ? $object[$key] : '';
	$inhhtml = "";
	
	if (isset($object["++".$key]))	{
		
		$inhhtml = "  <td>".str_replace(",", ",<br>", $object["++".$key])."</td>\n";
		$reqclass = 'requiredok';
		
	} else {

		$inhhtml = "  <td>&nbsp;</td>\n";
		$reqclass = 'required';
	}
	
	
	$show = str_replace(",", "<br>", $value);

	if (empty($object[$key])) {
	
		$required = @$propconf[2] ? $reqclass : 'label';
	}

        $rowcolor = ($rowcolor != "dataOdd") ? "dataOdd" : "dataEven";
	
	$keyname=ucfirst(str_replace("_", " ", $key));

	$rows[$key] = <<<HTML
<tr class="{$rowcolor}">
  <td>$keyname</td>
  <td class="{$required}" with="3">&nbsp;</td>
  <td>
  $show
  </td>
  $inhhtml
</tr>
HTML;
}

?>
<div align="center">

<table cellpadding="2" border="0">
<tr>
  <td colspan="4" align="left">&nbsp;</td>
</tr>
<tr class="data">
  <th colspan="3" class="data">Properties</th>
<?

if( !empty($object['use']) ) {

	$parent = $Plugin->GetObjectByName($object['use'], OBJECTTYPE);
	print <<<HTML
  <th class="data">
  Inherits from 
  <a href="serviceextinfoedit.php?objectid={$parent['__objectid']}" onclick="nw=window.open('', 'edit_serviceextinfo_template_popup', 'resizable=no, scrollbars=1, copyhistory=0, width=700, height=450');nw.opener=self" target="edit_serviceextinfo_template_popup"><b>{$parent['name']}</b></a>
  </th>
HTML;
} else {

	echo "<th class=\"data\">&nbsp;</th>\n";
}
?>
</tr>
<?=implode("\n", $rows)?>
<?


if ( $cntinh > 0 ) {

	print ObjectInheritance($object['name'], OBJECTTYPE, 'edit');
}

if (!empty($object["host_name"])) {

	$userobjs = NagiosObjectUsage($serviceextinfoname, OBJECTTYPE);
	if ( $userobjs != NULL ) {

		print ObjectUsage($serviceextinfoname, OBJECTTYPE, $userobjs, "edit");
	}
}

?>
<tr>
  <td colspan="4" align="center">
   <hr>
  </td>
</tr>
<tr>
  <td colspan="4" align="center">
   <form method="post">
   <input type="submit" name="action" value="Close" onclick="parent.close('')">
  </td>
</tr>

</table>
</div>

<?
include_once("html_wrap/tail2.inc.php");


?>
