<?php

# Disallow run of this script.
if (basename($_SERVER['PHP_SELF']) == "services.php")  	{
	print("Direct execution of this script is not allowed.");
	exit;
}


# Includes
require_once("includes/drawlib.inc.php");

# Definitions
define("OBJECTTYPE","service");
define("OBJECTNAME","Service");
define("PAGE_INFO", 'Query made at '.date("H:i:s - d M Y"));

# Initialize Variables
$rowcolor = '';
$rows = array();
$errormsg = '';
$message = '';
$services = array();

# Set Headers Titles and URL Values
$headers = array( 0 => array ( "Title" => "Service Description", "SortName" => "service_description"),
		  1 => array ( "Title" => "Hostname", "SortName" => "host_name"),
		  2 => array ( "Title" => "Inheritance", "SortName" => ""),
		  3 => array ( "Title" => "Registered", "SortName" => "registered")
		  );


if (!isset($sorttype))	 $sorttype="0";
#if (!isset($sortoption)) $sortoption=$headers[0]["Title"]["SortName"];
if (!isset($sortoption)) $sortoption="service_description";
if (!isset($page)) 	 $page=1;

$sortoption = @strtolower($sortoption);


# - Services Only Variables -
$hostdata=array();
$services=array(); # Items for the Services ComboBox
$hosts=array(); # Items for the Hosts ComboBox

if (!isset($selectedservice)) $selectedservice="ALL";
if ($selectedservice == "")  $selectedservice=substr($query, strpos($query, "selectedservice="));

# Ensure that $selectedhost has a value from this point forward
if (!isset($selectedhost)) $selectedhost="ALL";

if ($selectedhost == "") $selectedhost=substr($query, strpos($query, "selectedhost="));
# -


# ######## The script REALLY starts running from here ########


# Get Objects Records Count
$objects_count=$Plugin->GetObjectsCount(OBJECTTYPE);

# Sort Type ($sorttype)
#  - 0 - Ascending
#  - 1 - Reversed
#echo "$sortoption, $sorttype";
$objects = $Plugin->GetSortedObjectsFromTo($sortoption, $sorttype, 0, $objects_count, OBJECTTYPE);
#$objects = $Plugin->GetSortedObjects($sortoption, $sorttype, OBJECTTYPE);
#PrintArray($objects);

if (!is_array($objects))	{

	# This message will be displayed in errmsg row in TableHeader
	$message = "No objects found in database.";
	
	OpenTable(7);
	TableHeader($headers, "");
	CloseTable(7);
	include_once("html_wrap/tail.inc.php");
	exit; # If no Records are found, we exit...completly.

}
# we don't need an else, because we exit if there are no records

	
$i=0;
# Construct $hostdata and $services Arrays for each object found
foreach ($objects as $key => $object)	{
	
	$name = (!empty($object[OBJECTTYPE.'_description'])) ? $object[OBJECTTYPE.'_description'] : '';
	$host = (!empty($object['host_name'])) ? $object['host_name'] : '';
			
	$registered = (isset($object['register']) && $object['register'] == 0) ? 'no' : 'yes';

	# Is this a inheritable object?
	$cntinh = NagiosCountInherited(OBJECTTYPE, $name);
	$inheritance = "used by $cntinh ".OBJECTTYPE." objects";
	
	if (!empty($object['use']))	{
		
		$inheritance .= ',<br>uses \''.$object['use'].'\' '.OBJECTTYPE.' object';
	}

#	if( !empty($object['name']) ) {
#		$cntinh = NagiosCountInherited(OBJECTTYPE,$name);
#		if( $cntinh != 0 ) $inheritance = 'used by '.$cntinh.' objects';
#	} 

	$servicesdata[$i]["Id"] = $object["__objectid"];
	$servicesdata[$i]["Name"] = $name;
	$servicesdata[$i]["Host"] = $host;
	$servicesdata[$i]["Inheritance"] = $inheritance;
	$servicesdata[$i]["Registered"] = $registered;

	# Construct ComboBox Array of UNIQUE services
	if ((!in_array($name, $services)) && (strpos($name,"TEMPLATE") === FALSE) && ($services != "")) $services[]=$name;
		
	if ((!in_array($host, $hosts)) && ($host != "")) $hosts[]=$host;
        $i++;
} # foreach

# Sort ComboBox services array
sort($services);
# Sort ComboBox hosts array
sort($hosts);

?>
<!-- Start of Services & Hosts Form -->
<br>
<div align="center">
<form name="filterform" action="go.php">
<input type="hidden" name="go" value="Services">
<table width="100%">
<tr>
<td align="left" width="40%">
<!-- Start of Services ComboBox -->
Services:&nbsp; 
<select name="selectedservice" onchange="submit()">
<option value="ALL" <? if ($selectedservice == "ALL") echo "selected"; ?> >All Services</option>
<option value="TEMPLATES" <? if ($selectedservice == "TEMPLATES") echo "selected"; ?> >Only Templates</option>
<option value="ALL">----------------</option>
<?
for ($i=0; $i<count($services); $i++) {

	if ($selectedservice == $services[$i])	{
	
		echo "<option value=\"$services[$i]\" selected>$services[$i]</option>\n\r";
	} else {

		echo "<option value=\"$services[$i]\">$services[$i]</option>\n\r";
	}
}
?>
</select>
</td>
<td align="center">
<input type="submit" value="Filter">
</td>
<td align="right" width="40%">
<!-- Start of Services ComboBox -->
Hostnames:&nbsp; 
<?
echo "<select name=\"selectedhost\" onchange=\"submit()\">\n\r";
echo "<option value=\"ALL\" "; if ($selectedhost == "ALL") echo "selected"; echo ">All Hosts</option>\n\r";
echo "<option value=\"ALL\">----------------</option>\n\r";
for ($i=0; $i<count($hosts); $i++) {
	if ($selectedhost == $hosts[$i])	{
		echo "<option value=\"$hosts[$i]\" selected>$hosts[$i]</option>\n\r";
	} else {
		echo "<option value=\"$hosts[$i]\">$hosts[$i]</option>\n\r";
	}
}
?>
</select>
</td>
</tr>
</table>
</form>
</div>
<!-- End of Services & Hosts Form -->

<hr>
<?

# Include only user selected service
$SelectedHostData=array();
for ($i=0; $i<count($servicesdata); $i++)	{
	
		# Select ALL Objects
		if ($selectedservice == "ALL") {
		
			$SelectedHostData[]=$servicesdata[$i];
		
		# Select only objects of the Selected Service
		} elseif ($selectedservice == $servicesdata[$i]["Name"]) {
		
			$SelectedHostData[]=$servicesdata[$i];
		
		} elseif ($selectedservice == "TEMPLATES") 	{
		
			# Select only TEMPLATE, objects, that is, with "TEMPLATE" word in the name
			if (strpos($servicesdata[$i]["Name"], "TEMPLATE") !== FALSE)
				$SelectedHostData[]=$servicesdata[$i];
		}
}
$servicesdata=$SelectedHostData;
$SelectedHostData=array();

# Include only user selected host
for ($i=0; $i<count($servicesdata); $i++)	{
		
		# Select ALL Objects
		if ($selectedhost == "ALL") {
			$SelectedHostData[]=$servicesdata[$i];
		# Select only objects of the Selected Service
		} elseif ($selectedhost == $servicesdata[$i]["Host"]) {
			$SelectedHostData[]=$servicesdata[$i];
		}
}
reset($servicesdata);
/*
if (($selectedservice != "") && ($selectedservice != "ALL") && ($selectedservice != "TEMPLATES"))	{

	$SelectedHostData = asortbyindex($SelectedHostData, "Host");

} elseif ($selectedservice == "TEMPLATES")	{

	$SelectedHostData = asortbyindex($SelectedHostData, "Name");
}
*/

# Get Page information to construct objects to be displayed in the current page, 
# based in DISPLAY_OBJECTS constant var.
$pageinfo=get_objects_from_page(count($SelectedHostData), $page);

if (DEBUG == "1") debug_window_msg(print_r($pageinfo));

# Construct Table Rows with Selected Host data
$num=$pageinfo["first_object"]+1;
#PrintArray($SelectedHostData);
for ($i=$pageinfo["first_object"]; $i<$pageinfo["last_object"]; $i++) {
		
	$rowcolor = ($rowcolor != "dataOdd") ? "dataOdd" : "dataEven";
	
	$rows[]=<<<HTML
<tr class="{$rowcolor}">
  <td>{$num}</a></td>
  <td>{$SelectedHostData[$i]["Name"]}</td>
  <td>{$SelectedHostData[$i]["Host"]}</td>
  <td>{$SelectedHostData[$i]["Inheritance"]}</td>
  <td align="center">{$SelectedHostData[$i]["Registered"]}</td>
  <td>
  <a href="serviceedit.php?objectid={$SelectedHostData[$i]['Id']}" onclick="nw=window.open('', 'edit_service_popup', 'resizable=no, scrollbars=1, copyhistory=0, width=700, height=550');nw.opener=self" target="edit_service_popup">Edit</a>&nbsp;
  <a href="serviceview.php?objectid={$SelectedHostData[$i]['Id']}" onclick="nw=window.open('', 'view_service_popup', 'resizable=no, scrollbars=1, copyhistory=0, width=700, height=550');nw.opener=self" target="view_service_popup">View</a><br>
  <a href="deleteobject.php?objectid={$SelectedHostData[$i]['Id']}&objecttype=service" onclick="nw=window.open('', 'delete_service_popup', 'resizable=no, scrollbars=1, copyhistory=0, width=430, height=220');nw.opener=self" target="delete_service_popup">Delete</a>&nbsp;
  </td>
</tr>
HTML;
	$num++;
} # for

$hidden_values = array( 0 => array ( "Name" => "selectedservice", "Value" => "$selectedservice"),
			1 => array ( "Name" => "selectedhost", "Value" => "$selectedhost")
		  );

# Draw everything
OpenTable(7, $hidden_values);
TableHeader($headers, "selectedservice=".$selectedservice."&selectedhost=".$selectedhost);
print implode("\n",$rows);
CloseTable(7, $hidden_values);


if (DEBUG == "1") debug_window_msg(print_r($hosts)); # For Debugging


?>
