<?php

# Page variables
define("PAGE_ID","serviceview");
define("PAGE_TITLE","Service object");
define("OBJECTTYPE","service");
define("OBJECTNAME","Service");

require_once("includes/main.inc.php");

$rowcolor = "";
$object = NULL;
$cntinh = 0;
$objectid = (isset($objectid))	? $objectid : NULL;

include_once("html_wrap/head2.inc.php");

if ($objectid != "") {

	$object = $Plugin->GetObjectById($objectid, OBJECTTYPE);
}

$servicename = !empty($object["name"]) ? $object['name'] : ''; 

# If this is a template: get its iheriters
if (!empty($object['name'])) {

	$cntinh = NagiosCountInherited(OBJECTTYPE,$object['name']);
}

# Get information about the parent object if any
if (!empty($object['use'])) {

	$inhobject = $Plugin->GetObjectByName($object['use'],OBJECTTYPE);
	
	foreach($inhobject as $key => $value) {
	
		$object['++'.$key] = $value;
	}
}

foreach ($confobjects[OBJECTTYPE] as $key => $propconf) {

	$required = 'label';
	$value = !empty($object[$key]) ? $object[$key] : '';
	$inhhtml = "";
	
	if( isset($object["++".$key]) ) {
		
		$inhhtml = "  <td>".$object["++".$key]."</td>";
		$reqclass = 'requiredok';
		
	} else {

		$inhhtml = "  <td>&nbsp;</td>";
		$reqclass = 'required';
	}

	if (is_array($value))
		$show = str_replace(",", ", <br>", implode(",", $value) );
	else
		$show = str_replace(",", ", <br>", $value);

	if (empty($object[$key])) {
	
		$required = $propconf[2] == TRUE ? $reqclass : 'label';
	}

        $rowcolor = ($rowcolor != "dataOdd") ? "dataOdd" : "dataEven";

	$key=ucfirst(str_replace("_", " ", $key));

	$rows[$key] = <<<HTML
<tr class="{$rowcolor}">
  <td>$key</td>
  <td class="$required" width="3">&nbsp;</td>
  <td>
  $show
  </td>
  $inhhtml
</tr>
HTML;
}

?>
<div align="center">
<form method="post">
<input type="hidden" name="objectid" value="<?=$object['__objectid']?>">
<table cellpadding="3" border="0">
<tr>
  <td colspan="4" align="left">
  &nbsp;
  </td>
</tr>
<tr class="data">
  <th colspan="3" class="data">Properties</th>
<?

if( !empty($object['use']) ) {

	$parent = $Plugin->GetObjectByName($object['use'],OBJECTTYPE);
  	print <<<HTML
  <th class="data">
  Inherits from 
  <a href="serviceedit.php?objectid={$parent['__objectid']}" onclick="nw=window.open('', 'edit_template_popup', 'resizable=no, scrollbars=1, copyhistory=0, width=700, height=550');nw.opener=self" class="data" target="edit_template_popup"><b>{$parent['name']}</b></a>
  </th>
HTML;
	}
else {
	echo "<th class=\"data\">&nbsp;</th>";
}

echo "</tr>";
echo implode("\n", $rows);

if ( $cntinh > 0  && !empty($servicename) ) {
	
	echo "<td>";
	print ObjectInheritance($servicename, OBJECTTYPE, FALSE);
}

?>
<tr>
  <td colspan="4" align="center">
	<hr>
  </td>
</tr>
<tr>
  <td colspan="4" align="center">
   <input type="submit" name="action" value="Save">
   <input type="submit" name="action" value="Cancel" onclick="parent.close('')">
  </td>
</tr>
</table>
</div>
</form>

<?

include_once("html_wrap/tail2.inc.php");


?>
