<?php

# Page variables
define("OBJECTTYPE",'nawuicfg');
define("PAGE_ID","nawuicfg");
define("PAGE_TITLE","NaWui Configuration settings");

# Include some 'library' files with various functions
require_once("includes/functions.inc.php");
require_once("includes/nagiosdata.inc.php");
require_once("includes/nagios.inc.php");

$rowcolor = "rowcolor2";
$action = isset($action) ? @strtolower($action): "";
$message = "";
$rows = array();

# Actions before output is send
switch($action) {
	case "setup":

		$result = SaveNawuiConfig($cfg);
		if ($result === TRUE)	{
		
			header("Location: ".$cfg["website_url"][0].$cfg["nawui_url"][0]);
			exit;
		
		} else $message = "<font color=\"#FF2222\">$result</font>";

}


# Display HTML Header
?>
<html>
<head>
<link rel="stylesheet" type="text/css" href="css/styles.css">
<title><?=PAGE_TITLE?></title>
</head>
<body bgcolor="#ffffff">
<br>
<div align="center" class="pageTitle"><?=PAGE_TITLE?></div>
<?



$nawuicfg = LoadNawuiConfig();

foreach ($confobjects[OBJECTTYPE] as $key => $propconf) {

	$values = isset($nawuicfg[$key]) ? $nawuicfg[$key] : array();
	$count = count($values);
	$required = "label";

	if (empty($nawuicfg[$key])) {
	
		$required = $propconf[2] == TRUE ? 'required' : 'label';
	}

	# Add an extra entry field when multi values are possible
	if ($propconf[0] == 'multistring' || $count == 0) {

		$count++;
	}

	# Set the default value if needed and if there is one
	if (isset($cfg))	{
		
		$values[0] = $cfg[$key][0];
	} elseif (isset($values[0]) == FALSE && $propconf[1] != '') {

		$values[0] = $propconf[1];
	}

	for ($i = 0; $i < $count; $i++) {
	
		$value = isset($values[$i]) ? $values[$i] : '';
  		
		$show = NagiosObjPropEdit(OBJECTTYPE, $key, "cfg[$key][$i]",$value);
		
		$rowcolor = ($rowcolor != "dataOdd") ? "dataOdd" : "dataEven";

		$key=ucfirst(str_replace("_", " ", $key));

		$rows[] = <<<HTML
<tr class="{$rowcolor}">
  <td>$key</td>
  <td class="$required" with="3">&nbsp;</td>
  <td>
  $show
  </td>
</tr>
HTML;
	}
}

?>
<br>
<div align="center">
<form action="<?=$PHP_SELF?>" method="POST">
<table cellpadding="3" border="0" class="data">
<tr>
  <td colspan="3" align="left">
  <b><?=$message?>&nbsp;</b>
  </td>
</tr>
<tr class="data">
  <th colspan="3" class="data">Properties</th>
</tr>
<?=implode("\n", $rows)?>
<tr>
  <td colspan="3" align="center">
  <input type="submit" name="action" value="Setup">
  </td>
</tr>
</table>
</form>
</div>
</body>
</html>
