<?php


# Disallow run of this script.
if (basename($_SERVER['PHP_SELF']) == "timeperiods.php")  	{
	print("Direct execution of this script is not allowed.");
	exit;
}


# Includes
require_once("includes/drawlib.inc.php");

# Definitions
define("OBJECTTYPE","timeperiod");
define("OBJECTNAME","TimePeriod");
define("PAGE_INFO", 'Query made at '.date("H:i:s - d M Y"));

$rowcolor 	= "";
$message 	= "";
$rows 		= array();
$timeperiods	= array();

# Set Headers Titles and URL Values
$headers = array( 0 => array ( "Title" => "Timeperiod Name", "SortName" => "timeperiod_name"),
		  1 => array ( "Title" => "Name", "SortName" => "name"),
		  2 => array ( "Title" => "Alias", "SortName" => "alias"),
		  3 => array ( "Title" => "Inheritance", "SortName" => ""),
		  );

$page 		= (isset($page)) 	? $page 	: 1;
$sorttype 	= (isset($sorttype))	? $sorttype 	: "0";
$sortoption 	= (isset($sortoption)) 	? $sortoption 	: $headers[0]["SortName"];

# Sort Type ($sorttype)
#  - 0 - Ascending
#  - 1 - Reversed

# -------# The script REALLY starts running from here #-------

$objects_count=$Plugin->GetObjectsCount(OBJECTTYPE);

$objects = $Plugin->GetSortedObjectsFromTo($sortoption, $sorttype, 0, $objects_count, OBJECTTYPE);

if (!is_array($objects))	{

	# This message will be displayed in errmsg row in TableHeader
	$message = "No objects found in database.";
	
	OpenTable(6);
	TableHeader($headers, "");
	CloseTable(6);
	include_once("html_wrap/tail.inc.php");
	exit; # If no Records are found, we exit...completly.

}
# we don't need an else, because we exit if there are no records


$i=0;
foreach($objects as $key => $object) {

	$name =	empty($object['name']) ? $object[OBJECTTYPE.'_name'] : "";

	# Is this a inheritable object?
	$cntinh = NagiosCountInherited(OBJECTTYPE, $name);
		
	$inheritance = 'used by '.$cntinh.' objects';
	if (!empty($object['use']))	{

		$inheritance .= ',<br>uses \''.$object['use'].'\' '.OBJECTTYPE.' object';
			
	}
	$timeperiod[$i]["Id"]		   = $object['__objectid'];
	$timeperiod[$i]["Timeperiod_Name"] = $object['timeperiod_name'];
	$timeperiod[$i]["Name"]		   = $name;
	$timeperiod[$i]["Alias"]	   = isset($object['alias']) ? $object['alias'] : "" ;
	$timeperiod[$i]["Inheritance"]	   = $inheritance;

	$i++;
} # foreach

# Get Page information to construct objects to be displayed in the current page, 
# based in DISPLAY_OBJECTS constant var.
$pageinfo=get_objects_from_page(count($timeperiod), $page);


# Construct Table Rows with Selected Host data
$num=$pageinfo["first_object"]+1;
	
for ($i=$pageinfo["first_object"]; $i<$pageinfo["last_object"]; $i++) {

	$rowcolor = ($rowcolor != "dataOdd") ? "dataOdd" : "dataEven";
		 
	$rows[] = <<<HTML
<tr class="{$rowcolor}">
  <td>{$num}</td>
  <td>{$timeperiod[$i]["Timeperiod_Name"]}</td>
  <td>{$timeperiod[$i]["Name"]}</td>
  <td>{$timeperiod[$i]["Alias"]}</td>
  <td>{$timeperiod[$i]["Inheritance"]}</td>
  <td>
  <a href="timeperiodedit.php?objectid={$timeperiod[$i]["Id"]}" onclick="nw=window.open('', 'edit_timeperiod_popup', 'resizable=no, scrollbars=1, copyhistory=0, width=700, height=550');nw.opener=self" target="edit_timeperiod_popup">Edit</a>&nbsp;
  <a href="timeperiodview.php?objectid={$timeperiod[$i]["Id"]}" onclick="nw=window.open('', 'view_timeperiod_popup', 'resizable=no, scrollbars=1, copyhistory=0, width=700, height=550');nw.opener=self" target="view_timeperiod_popup">View</a><br>
  <a href="deleteobject.php?objectid={$timeperiod[$i]["Id"]}&objecttype=timeperiod" onclick="nw=window.open('', 'delete_timeperiod_popup', 'resizable=no, scrollbars=1, copyhistory=0, width=430, height=220');nw.opener=self" target="delete_timeperiod_popup">Delete</a>&nbsp;
  </td>
</tr>
HTML;
	$num++;
} # for


# Draw everything
OpenTable(6);
TableHeader($headers, "");
print implode("\n",$rows);
CloseTable(6);


?>
