<?php


# Page variables
define("OBJECTTYPE","verify");
define("PAGE_ID","verify");
define("PAGE_TITLE","Verify Configurations & Objects");

require_once("includes/main.inc.php");
include_once("html_wrap/head.inc.php");

$error 		= array();
$warnings 	= "";
$errors 	= "";
$Ok 		= "";
$errormsg 	= "";
$rawV 		= (isset($rawV)) ? $rawV :  "";	# Raw Verify
$rawA 		= (isset($rawA)) ? $rawA :  "";	# Raw Analyze
$action 	= (isset($action))? $action : "";


?>
<br>
<div align="center">
<table cellpadding="2" cellspacing="4" border="0">
<tr class="dataOdd">
  <td align="center">
  <form action="verify.php" method="POST">
  <input type="submit" value="Verify">
  <input type="hidden" name="action" value="verify"><br>
  <input type="checkbox" name="rawV" value="1" <? if ($rawV == "1") echo "checked";?>> show raw output
</form>
  </td>
  <td>
      &nbsp;This will verify all configurations and objects to ensure that there<br>
      &nbsp;are no serious errors before the last modifications can be put online.<br>
      &nbsp;
  </td>
</tr>
</table>
</div>
<br>
<div align="center">
<table cellpadding="2" cellspacing="4" border="0">
<tr class="dataOdd">
  <td align="center">
  <form action="verify.php" method="POST">
  <input type="submit" value="Analyze">
  <input type="hidden" name="action" value="analyze"><br>
  <input type="checkbox" name="rawA" value="1" <? if ($rawA == "1") echo "checked";?>> show raw output
</form>
  </td>
  <td>
      &nbsp;Requests Nagios to show projected and/or recommended service<br>
      &nbsp;check scheduling information based on the current data in the<br>
      &nbsp;configuration files. 
      &nbsp;
  </td>
</tr>
</table>
</div>

<?


if ($action == "verify" || $action == "analyze")	{

	# ---- echo "<p>Writing temporary configuration files:</p>\n";
	
	# Export objects files to temporary directory before we can verify them
	if (@!mkdir(TMP_DIR, 0700)) $errormsg = "Problem: cannot create temporary directory.";

	if ($errormsg = $Plugin->tmpNagiosWriteObjects(TMP_DIR)) print "Problem: ".$errormsg;
	# ----	
	# Export configuration files to temporary directory before we can verify them

	if ($errormsg = $Plugin->tmpNagiosWriteConfigs(TMP_DIR)) print $errormsg;
	# ----
	
	# ---- echo "<br>Done writing configurations and objects...<br>";
	# ---- echo "<p>Verifing configuration files and objects:</p>\n";

	$tempfile = TMP_DIR."/nawui-output.".rand(0, 100);

	if ($action == "verify")	{
		
		# Execute nagios with the verify parameter to analyze configurations
		$cmd = NAGIOS_BIN." -v ".TMP_DIR."/nagios.cfg 2>&1 > $tempfile";
	
	} elseif ($action == "analyze")	{
		
		# Execute nagios with the projected/recommended parameter to analyze configurations
		$cmd = NAGIOS_BIN." -s ".TMP_DIR."/nagios.cfg 2>&1 > $tempfile";
	}
	
	if (DEBUG == "1") echo "Exec: $cmd\n";
	
	exec($cmd);

	# Get processed nagios output
	$output = file($tempfile);

	# Delete temporary files
	if (DEBUG == 1) print "<br>Deleting configuration files:<br>";
	if (!unlink($tempfile)) 	{
		$errormsg = "Cannot delete temporary file '$tempfile'.";
		print $errormsg;
	}
	if ($errormsg = $Plugin->tmpNagiosDeleteObjects(TMP_DIR)) print $errormsg;
	if ($errormsg = $Plugin->tmpNagiosDeleteConfigs(TMP_DIR)) print $errormsg;



	# --- Process NAGIOS output ---
	for ($i=0; $i<count($output);$i++)	{
		$line=strtolower(trim($output[$i], ""));
		if (substr($line, 0, 14) == "total warnings")	{
			$warnings=trim(substr($line, strpos($line, ":")+1), " ");
			$warnings=trim($warnings, "\n");

		} elseif (substr($line, 0, 12) == "total errors")	{
			$errors=trim(substr($line, strpos($line, ":")+1), " ");;
			$errors=trim($errors, "\n");

		} elseif (substr($line, 0, 16) == "things look okay")	{
			$Ok = $line;

		} elseif (substr($line, 0, 5) == "error")	{
			$error[] = $line;
		}
	}

	if ($action == "verify")	{
		
		echo "<hr><br>";
		# Open Table
		echo "<div align=\"center\">\n";
		echo "<table border=\"0\" cellpadding=\"2\" cellspacing=\"2\">\n";

		# if there's a fatal error and processing of configuration files stops, 
		# only write this below:
		if (isset($error[0])) 	{
			echo "<tr class=\"StatusCritical\">\n";
			echo "<td>\n";
			echo "<font color=\"FFFFFF\"><b>ERROR</b></font><br>\n";
			echo "</td>\n";
			echo "</tr>\n";
			for ($i=0; $i<count($error); $i++)	{
				echo "<tr class=\"StatusCritical\">\n";
				echo "<td>\n";
				echo "<font color=\"FFFFFF\">$error[$i]</font>\n";
				echo "</td>\n";
				echo "</tr>\n";
			}
			if (strstr($error[0], "token"))	{
				echo "<tr class=\"dataEven\">\n";
				echo "<td>\n";
				echo "<b>TIP: </b>You have probably specified both a 'cfg_dir' and at least a 'cfg_file' in <a href=\"nagioscfg.php\">nagios.cfg</a>. \n";
				echo "</td>\n";
				echo "</tr>\n";
			}
		} else {
			echo "<tr>\n";
			echo "<th colspan=\"2\" class=\"data\">Pre-flight check\n";
			echo "</th>\n";
			
			# Warning Message
			if ($warnings != "0")
				$warningclass="StatusWarning";
			else 
				$warningclass="";
				
			echo "<tr class=\"dataOdd\">\n";
			echo "<td class=\"$warningclass\">";
			echo "Warnings:";
			echo "</td>\n";
			echo "<td class=\"$warningclass\">";
			echo "$warnings";
			echo "</td>\n";
			echo "</tr>\n";
	
			# Error Message
			if ($errors != "0")
				$criticalclass="StatusCritical";
			else 
				$criticalclass="dataOdd";
	
			echo "<td class=\"$criticalclass\">";
			echo "Errors:";
			echo "</td>\n";
			echo "<td class=\"$criticalclass\">";
			if ($errors != "0")
				echo "<font color=\"FFFFFF\">$errors</font>";
			else 
				echo "$errors";
	
			echo "</td>\n";
			echo "</tr>\n";
	
			# OK Message
			if ($Ok != "")	{
	
				echo "<tr class=\"dataEven\">\n";
				echo "<td>";
				echo "Message:";
				echo "</td>\n";
				echo "<td>";
				echo "$Ok";
				echo "</td>\n";
				echo "</tr>\n";
			}
		}
		# Close Table
		echo "</table>\n";
		echo "</div>\n";
	
	} elseif ($action == "analyze") 	{
		echo "<hr><br>\n";
		echo "<div align=\"center\">\n";
		echo "<table>\n";
		$information = FALSE;
		for ($i=0; $i<count($output)-1; $i++)	{

			$output[$i]=trim($output[$i], " ");
			if (strstr($output[$i], "SERVICE SCHEDULING INFORMATION"))
				$information = TRUE;
		
			if ($information)	{
				echo "<tr>\n";
				echo "<td>&nbsp;";
				echo $output[$i];
				echo "&nbsp;</td>\n";
				echo "</tr>\n";
			}
		}
		echo "</table>\n";
		echo "</div>";
		echo "<br>";
	}
	if ($rawV == "1" || $rawA == "1") 	{
		echo "<hr><br>\n";
		echo "<b>Raw output:</b><br><br>";
		echo "<table>\n";
		for ($i=0; $i<count($output)-1; $i++)	{

			$output[$i]=trim($output[$i], " ");
		
			echo "<tr>\n";
			echo "<td>&nbsp;";
			echo $output[$i];
			echo "&nbsp;</td>\n";
			echo "</tr>\n";
		}
		echo "</table>\n";
		echo "<br>";
	}

} #if




include_once("html_wrap/tail.inc.php");

?>
