#! /bin/sh

echo
echo "This script attempts to recompile the libjrrd.so JNI library on your system"
echo "A patch to make this JNI compatible with rrdtool 1.2 has already been applied"

echo

scriptRoot=`echo $0 | sed -e 's,[\\/][^\\/]*$,,'`
cd $scriptRoot
scriptRoot=`pwd`

rrd_cmd="/usr/bin/rrdtool"

tmp_dir="$scriptRoot/tmp"

mkdir -p $tmp_dir

cd $tmp_dir

jar -xf $scriptRoot/lib/rrdjtool.jar

cd  $tmp_dir/native

if [ ! -f /usr/include/rrd.h ]; then
	echo "WARNING, /usr/include/rrd.h not present"
	echo "You probably need to install the rrd-devel package on your system"
	echo "Or edit Makefile.linux to use the correct location"
fi

if [ "`which make`" == "" ]; then
	echo "'make' was not found, please make sure 'make' is installed on this system"
	exit
fi

echo
make -f Makefile.linux
echo

if [ "$(uname -m)" == "x86_64" ]; then
	dest="$scriptRoot/lib64"
else
        dest="$scriptRoot/lib"
fi

if [ -f libjrrd.so ]; then 
	cp -f libjrrd.so $dest/
	cd $scriptRoot
	rm -Rf $tmp_dir
	echo "libjrrd.so has been compied to $dest"
else
	echo
	echo "ERROR: The JNI did not compile on your system."
	echo "The jar has been unpacked to: $tmp_dir"
	echo "You may need to edit native/Makefile.linux"
	echo "See http://www.dnseurope.net/opensource/rrdjtool/ for more info" 
fi

echo
