#! /bin/sh

echo

scriptRoot=`echo $0 | sed -e 's,[\\/][^\\/]*$,,'`

perf2rrd_root="/var/services/perf2rrd"
recomp=0
daemontool=1


while getopts d:ct opt
do
	case "$opt" in
		d)      perf2rrd_root="$OPTARG";;
		c)      recomp=1;;
		t)      daemontool=0;;
		*)      exit 2;
esac
done




echo "This script will perform a basic install of perf2rrd"

echo "Using $perf2rrd_root as perf2rrd_root"

mkdir -p $perf2rrd_root

if [ $recomp -eq 1 ]; then
	echo "Recompiling libjrrd.so"
	$scriptRoot/compile_rrdjtool.sh
fi


echo "Copying Files..."

cp -f $scriptRoot/*.class $perf2rrd_root
cp -f $scriptRoot/run $perf2rrd_root
cp -f $scriptRoot/set_paths $perf2rrd_root
cp -fr $scriptRoot/lib* $perf2rrd_root
cp -fr $scriptRoot/log $perf2rrd_root

chmod ug+x $scriptRoot/run
chmod ug+x $scriptRoot/set_paths
chmod ug+x $scriptRoot/log/run

if [ -d /service ] && [ $daemontool -eq 1 ]; then
	echo "Creating Daemontools Link"
	ln -s $perf2rrd_root /service/
fi

echo "Done"

echo
echo "-----------------------------------------------------"


echo "Quick start..."

echo

echo "copy:"

echo

echo "define command {"
echo "	command_name perf2rrd"
echo "	command_line $perf2rrd_root/run -o"
echo "}"

echo

echo "Into your Nagios objects configuration."

echo

echo "In Nagios Main Config, set these variables"

echo

echo "service_perfdata_file=/var/log/nagios/perfdata.pipe"
echo "service_perfdata_file_template=[SERVICEPERFDATA]\\t\$TIMET\$\\t\$HOSTNAME\$\\t\$SERVICEDESC\$\\t\$SERVICEEXECUTIONTIME\$\\t\$SERVICELATENCY\$\\t\$SERVICEOUTPUT\$\\t\$SERVICEPERFDATA\$"
echo "service_perfdata_file_mode=a"
echo "service_perfdata_file_processing_command=perf2rrd"
echo "service_perfdata_file_processing_interval=10"

echo
