-- phpMyAdmin SQL Dump
-- version 2.6.4
-- http://www.phpmyadmin.net
-- 
-- Host: localhost
-- Generation Time: Apr 06, 2006 at 01:25 PM
-- Server version: 4.1.14
-- PHP Version: 5.0.5
-- 
-- Database: `nagiosweb-dist`
-- 

-- --------------------------------------------------------

-- 
-- Table structure for table `command`
-- 

CREATE TABLE `command` (
  `command_id` int(11) NOT NULL auto_increment,
  `command_name` text NOT NULL,
  `command_line` text NOT NULL,
  `help_text` text NOT NULL,
  PRIMARY KEY  (`command_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=53 ;

-- 
-- Dumping data for table `command`
-- 

INSERT INTO `command` VALUES (1, 'check_ping', '$USER1$/check_ping -H $HOSTADDRESS$ -w $ARG1$ -c $ARG2$ -p 4', 'This check looks for 2 things. Response Time and Number of dropped packets.\r\n\r\nARG1 is for Warning, ARG2 is for Critical\r\n\r\nThe following example gives a Warning when the Response Time is longer than 500ms or 50% packet loss and gives a Critical when the Response Time is longer than 1000ms or 75% packet loss.\r\n\r\n''500,50%'':''1000,75%''\r\n\r\nThe single quotes are required to delimit the % sign.');
INSERT INTO `command` VALUES (2, 'check_ftp', '$USER1$/check_ftp -H $HOSTADDRESS$', 'This check looks scans port 21 on the host to see if it is accepting connections.');
INSERT INTO `command` VALUES (3, 'check-host-alive', '$USER1$/check_ping -H $HOSTADDRESS$ -w 3000.0,80% -c 5000.0,100% -p 3', 'There are no Arguments for this check, it is intented for a host only.');

-- --------------------------------------------------------

-- 
-- Table structure for table `contactgroup_members`
-- 

CREATE TABLE `contactgroup_members` (
  `contactgroup_id` int(11) NOT NULL default '0',
  `contact_id` int(11) NOT NULL default '0',
  `alert` varchar(10) NOT NULL default '',
  PRIMARY KEY  (`contactgroup_id`,`contact_id`,`alert`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `contactgroup_members`
-- 

INSERT INTO `contactgroup_members` VALUES (4, 1, 'email');
INSERT INTO `contactgroup_members` VALUES (4, 1, 'pager');

-- --------------------------------------------------------

-- 
-- Table structure for table `contactgroups`
-- 

CREATE TABLE `contactgroups` (
  `contactgroup_id` int(11) NOT NULL auto_increment,
  `contactgroup_name` text NOT NULL,
  `alias` text NOT NULL,
  PRIMARY KEY  (`contactgroup_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=5 ;

-- 
-- Dumping data for table `contactgroups`
-- 

INSERT INTO `contactgroups` VALUES (4, 'Support Staff', '');

-- --------------------------------------------------------

-- 
-- Table structure for table `contacts`
-- 

CREATE TABLE `contacts` (
  `contact_id` int(11) NOT NULL auto_increment,
  `contact_name` text NOT NULL,
  `alias` text NOT NULL,
  `service_notification_period` text NOT NULL,
  `host_notification_period` text NOT NULL,
  `service_notification_options` text NOT NULL,
  `host_notification_options` text NOT NULL,
  `service_notification_command_email` int(11) NOT NULL default '0',
  `host_notification_command_email` int(11) NOT NULL default '0',
  `service_notification_command_pager` int(11) NOT NULL default '0',
  `host_notification_command_pager` int(11) NOT NULL default '0',
  `email` text NOT NULL,
  `pager` text NOT NULL,
  PRIMARY KEY  (`contact_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=2 ;

-- 
-- Dumping data for table `contacts`
-- 

INSERT INTO `contacts` VALUES (1, 'John Support', 'jsupport', '1', '1', 'OK, Warn, Unkn, Crit', 'Down, Recovery', 3, 6, 0, 0, 'jsupport@yourdomain.com', '555-1212');

-- --------------------------------------------------------

-- 
-- Table structure for table `downtime`
-- 

CREATE TABLE `downtime` (
  `downtime_id` int(11) NOT NULL auto_increment,
  `days` text NOT NULL,
  `host_name` text NOT NULL,
  `starttime` time NOT NULL default '00:00:00',
  `duration` int(11) NOT NULL default '0',
  `fd` text NOT NULL,
  `name` text NOT NULL,
  `comments` text NOT NULL,
  `host_id` int(11) NOT NULL default '0',
  PRIMARY KEY  (`downtime_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=2 ;

-- 
-- Dumping data for table `downtime`
-- 

INSERT INTO `downtime` VALUES (1, 'Sun, Sat', 'Host 1', '23:00:00', 1800, 'Dynamic', 'Nagios Downtime Scheduler', 'Scheduled reboot of server.', 1);

-- --------------------------------------------------------

-- 
-- Table structure for table `host_contactgroups`
-- 

CREATE TABLE `host_contactgroups` (
  `host_id` int(11) NOT NULL default '0',
  `contactgroup_id` int(11) NOT NULL default '0',
  UNIQUE KEY `host_id` (`host_id`,`contactgroup_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `host_contactgroups`
-- 

INSERT INTO `host_contactgroups` VALUES (1, 4);
INSERT INTO `host_contactgroups` VALUES (2, 4);

-- --------------------------------------------------------

-- 
-- Table structure for table `host_parents`
-- 

CREATE TABLE `host_parents` (
  `host_id` int(11) NOT NULL default '0',
  `parent_host_id` int(11) NOT NULL default '0',
  PRIMARY KEY  (`host_id`,`parent_host_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `host_parents`
-- 

INSERT INTO `host_parents` VALUES (1, 2);

-- --------------------------------------------------------

-- 
-- Table structure for table `hostdependency`
-- 

CREATE TABLE `hostdependency` (
  `hostdependency_id` int(11) NOT NULL auto_increment,
  `dependent_host_name` text NOT NULL,
  `host_id` int(11) NOT NULL default '0',
  `host_name` text NOT NULL,
  `dependent_host_id` int(11) NOT NULL default '0',
  `notification_failure_criteria` int(11) NOT NULL default '0',
  PRIMARY KEY  (`hostdependency_id`),
  UNIQUE KEY `host_id` (`host_id`,`dependent_host_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- 
-- Dumping data for table `hostdependency`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `hostgroup_contactgroups`
-- 

CREATE TABLE `hostgroup_contactgroups` (
  `hostgroup_id` int(11) NOT NULL default '0',
  `contactgroup_id` int(11) NOT NULL default '0',
  UNIQUE KEY `hostgroup_id` (`hostgroup_id`,`contactgroup_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `hostgroup_contactgroups`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `hostgroup_members`
-- 

CREATE TABLE `hostgroup_members` (
  `hostgroup_id` int(11) NOT NULL default '0',
  `host_id` int(11) NOT NULL default '0',
  PRIMARY KEY  (`hostgroup_id`,`host_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `hostgroup_members`
-- 

INSERT INTO `hostgroup_members` VALUES (3, 1);
INSERT INTO `hostgroup_members` VALUES (4, 2);
INSERT INTO `hostgroup_members` VALUES (5, 1);
INSERT INTO `hostgroup_members` VALUES (5, 2);

-- --------------------------------------------------------

-- 
-- Table structure for table `hostgroups`
-- 

CREATE TABLE `hostgroups` (
  `hostgroup_id` int(11) NOT NULL auto_increment,
  `hostgroup_name` text NOT NULL,
  `alias` text NOT NULL,
  PRIMARY KEY  (`hostgroup_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=6 ;

-- 
-- Dumping data for table `hostgroups`
-- 

INSERT INTO `hostgroups` VALUES (1, 'Host 1', 'Host 1');
INSERT INTO `hostgroups` VALUES (3, 'Host 1', 'Host 1');
INSERT INTO `hostgroups` VALUES (4, 'Router', 'Core Router');
INSERT INTO `hostgroups` VALUES (5, '24x7 Ping', '');

-- --------------------------------------------------------

-- 
-- Table structure for table `hosts`
-- 

CREATE TABLE `hosts` (
  `host_id` int(11) NOT NULL auto_increment,
  `hostgroup_id` int(11) NOT NULL default '0',
  `host_name` text NOT NULL,
  `alias` text NOT NULL,
  `address` text NOT NULL,
  `max_check_attempts` int(11) NOT NULL default '1',
  `notification_period` text NOT NULL,
  `check_command` text NOT NULL,
  `notification_options` text NOT NULL,
  `checks_enabled` text NOT NULL,
  `event_handler_enabled` text NOT NULL,
  `low_flap_threshold` text NOT NULL,
  `high_flap_threshold` text NOT NULL,
  `flap_detection_enabled` text NOT NULL,
  `event_handler` text NOT NULL,
  `process_perf_data` text NOT NULL,
  `retain_status_information` text NOT NULL,
  `retain_nonstatus_information` text NOT NULL,
  `notifications_enabled` text NOT NULL,
  `notification_interval` text NOT NULL,
  `stalking_options` text NOT NULL,
  `check_command_args` text NOT NULL,
  `parent` text NOT NULL,
  PRIMARY KEY  (`host_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=3 ;

-- 
-- Dumping data for table `hosts`
-- 

INSERT INTO `hosts` VALUES (1, 3, 'Host 1', 'Host 1', 'host1.yourdomain.com', 3, '1', '3', 'Down, Recovery', 'Yes', 'No', '', '', 'No', '', 'No', 'Yes', 'Yes', 'Yes', '30', '', '', '');
INSERT INTO `hosts` VALUES (2, 4, 'Router', 'Core Router', 'router.yourdomain.com', 3, '1', '3', 'Down, Recovery', 'Yes', 'No', '', '', 'No', '', 'No', 'Yes', 'Yes', 'Yes', '30', '', '', '');

-- --------------------------------------------------------

-- 
-- Table structure for table `notify`
-- 

CREATE TABLE `notify` (
  `command_id` int(11) NOT NULL auto_increment,
  `command_name` text NOT NULL,
  `command_line` text NOT NULL,
  PRIMARY KEY  (`command_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=18 ;

-- 
-- Dumping data for table `notify`
-- 

INSERT INTO `notify` VALUES (3, 'notify-by-email', '/usr/bin/printf "%b" "***** Nagios  *****\\n\\nNotification Type: $NOTIFICATIONTYPE$\\n\\nService: $SERVICEDESC$\\nHost: $HOSTALIAS$\\nAddress: $HOSTADDRESS$\\nState: $SERVICESTATE$\\n\\nDate/Time: $DATETIME$\\nDuration: $SERVICEDURATION$\\n\\nAdditional Info:\\n\\n$SERVICEOUTPUT$\\n\\n$SERVICEACKAUTHOR$-$SERVICEACKCOMMENT$\\n\\nhttp://nagios.guidehome.com/nagios/cgi-bin/extinfo.cgi?type=2&host=$HOSTNAME$&service=$SERVICEDESC$\\n\\n" | /usr/bin/mail -s "** $NOTIFICATIONTYPE$ alert - $HOSTALIAS$/$SERVICEDESC$ is $SERVICESTATE$ **" $CONTACTEMAIL$ ');
INSERT INTO `notify` VALUES (6, 'host-notify-by-email', ' /usr/bin/printf "%b" "***** Nagios  *****\\n\\nNotification Type: $NOTIFICATIONTYPE$\\nHost: $HOSTNAME$\\nState: $HOSTSTATE$\\nAddress: $HOSTADDRESS$\\nInfo: $HOSTOUTPUT$\\n\\nDate/Time: $DATETIME$\\nDuration: $HOSTDURATION$\\n\\n$HOSTACKAUTHOR$-$HOSTACKCOMMENT$" | /usr/bin/mail -s "Host $HOSTSTATE$ alert for $HOSTNAME$!" $CONTACTEMAIL$');

-- --------------------------------------------------------

-- 
-- Table structure for table `service_contactgroups`
-- 

CREATE TABLE `service_contactgroups` (
  `service_id` int(11) NOT NULL default '0',
  `contactgroup_id` int(11) NOT NULL default '0',
  PRIMARY KEY  (`service_id`,`contactgroup_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `service_contactgroups`
-- 

INSERT INTO `service_contactgroups` VALUES (1, 4);

-- --------------------------------------------------------

-- 
-- Table structure for table `servicedependency`
-- 

CREATE TABLE `servicedependency` (
  `servicedependency_id` int(11) NOT NULL auto_increment,
  `dependent_host_name` text NOT NULL,
  `dependent_host_id` int(11) NOT NULL default '0',
  `dependent_service_description` varchar(100) NOT NULL default '',
  `host_name` text NOT NULL,
  `host_id` int(11) NOT NULL default '0',
  `service_description` varchar(100) NOT NULL default '',
  `execution_failure_criteria` text NOT NULL,
  `notification_failure_criteria` text NOT NULL,
  `inherits_parent` varchar(10) NOT NULL default '',
  PRIMARY KEY  (`servicedependency_id`),
  UNIQUE KEY `dependent_host_id` (`dependent_host_id`,`dependent_service_description`,`host_id`,`service_description`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=45 ;

-- 
-- Dumping data for table `servicedependency`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `servicegroup_members`
-- 

CREATE TABLE `servicegroup_members` (
  `servicegroup_id` int(11) NOT NULL default '0',
  `service_id` int(11) NOT NULL default '0',
  PRIMARY KEY  (`servicegroup_id`,`service_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `servicegroup_members`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `servicegroups`
-- 

CREATE TABLE `servicegroups` (
  `servicegroup_id` int(11) NOT NULL auto_increment,
  `servicegroup_name` text NOT NULL,
  `alias` text NOT NULL,
  PRIMARY KEY  (`servicegroup_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- 
-- Dumping data for table `servicegroups`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `services`
-- 

CREATE TABLE `services` (
  `service_id` int(11) NOT NULL auto_increment,
  `host_id` int(11) NOT NULL default '0',
  `hostgroup_id` int(11) NOT NULL default '0',
  `service_description` varchar(100) NOT NULL default '',
  `active_checks_enabled` text NOT NULL,
  `parallelize_check` text NOT NULL,
  `obsess_over_service` text NOT NULL,
  `check_freshness` text NOT NULL,
  `notifications_enabled` text NOT NULL,
  `event_handler_enabled` text NOT NULL,
  `flap_detection_enabled` text NOT NULL,
  `process_perf_data` text NOT NULL,
  `retain_status_information` text NOT NULL,
  `is_volatile` text NOT NULL,
  `register` text NOT NULL,
  `check_period` text NOT NULL,
  `notification_period` text NOT NULL,
  `notification_interval` text NOT NULL,
  `normal_check_interval` text NOT NULL,
  `retry_check_interval` text NOT NULL,
  `max_check_attempts` text NOT NULL,
  `notification_options` text NOT NULL,
  `check_command` text NOT NULL,
  `command_args` text NOT NULL,
  `freshness_threshold` text NOT NULL,
  `low_flap_threshold` text NOT NULL,
  `high_flap_threshold` text NOT NULL,
  `event_handler` text NOT NULL,
  `stalking_options` text NOT NULL,
  `passive_checks_enabled` text NOT NULL,
  PRIMARY KEY  (`service_id`),
  UNIQUE KEY `service_id` (`service_id`,`service_description`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=2 ;

-- 
-- Dumping data for table `services`
-- 

INSERT INTO `services` VALUES (1, 0, 5, '24x7 Ping', 'Yes', 'Yes', 'No', 'No', 'Yes', 'No', 'No', 'No', 'Yes', 'No', '', '1', '1', '30', '5', '5', '2', 'OK, Crit', '1', '''500,50%'':''1000,75%''', '', '', '', '', '', 'Yes');

-- --------------------------------------------------------

-- 
-- Table structure for table `timeperiods`
-- 

CREATE TABLE `timeperiods` (
  `timeperiod_id` int(11) NOT NULL auto_increment,
  `timeperiod_name` text NOT NULL,
  `alias` text NOT NULL,
  `sunday` text NOT NULL,
  `monday` text NOT NULL,
  `tuesday` text NOT NULL,
  `wednesday` text NOT NULL,
  `thursday` text NOT NULL,
  `friday` text NOT NULL,
  `saturday` text NOT NULL,
  PRIMARY KEY  (`timeperiod_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=21 ;

-- 
-- Dumping data for table `timeperiods`
-- 

INSERT INTO `timeperiods` VALUES (1, '24x7', '24x7 All the Time', '00:00-23:59', '00:00-23:59', '00:00-23:59', '00:00-23:59', '00:00-23:59', '00:00-23:59', '00:00-23:59');
