<?php 

include("dbconfig.php");

// Open/Create files
$hostfile=fopen($etcprefix . '/hosts.cfg','w+');
fwrite ($hostfile,"# This file generated by create php script, Josh\n");
$hostextfile=fopen($etcprefix . '/hostextinfo.cfg','w+');
fwrite ($hostextfile,"# This file generated by create php script, Josh\n");
$servicefile=fopen($etcprefix . '/services.cfg','w+');
fwrite ($servicefile,"# This file generated by create php script, Josh\n");
$hostgroupfile=fopen($etcprefix . '/hostgroups.cfg','w+');
fwrite ($hostgroupfile,"# This file generated by create php script, Josh\n");
$contactgroupfile=fopen($etcprefix . '/contactgroups.cfg','w+');
fwrite ($contactgroupfile,"# This file generated by create php script, Josh\n");
$contactsfile=fopen($etcprefix . '/contacts.cfg','w+');
fwrite ($contactsfile,"# This file generated by create php script, Josh\n");
$dependfile=fopen($etcprefix . '/dependencies.cfg','w+');
fwrite ($dependfile,"# This file generated by create php script, Josh\n");
$commandfile=fopen($etcprefix . '/checkcommands.cfg','w+');
fwrite ($commandfile,"# This file generated by create php script, Josh\n");
$timefile=fopen($etcprefix . '/timeperiods.cfg','w+');
fwrite ($timefile,"# This file generated by create php script, Josh\n");
$downfile=fopen($etcprefix . '/downtimeschedhst.cfg','w+');
$servicegroupfile=fopen($etcprefix . '/servicegroups.cfg','w+');
fwrite ($servicegroupfile,"# This file generated by create php script, Josh\n");

// Initialize counts
$hostcount = '0';
$hostgroupcount = '0';
$servicecount = '0';
$contactcount = '0';
$contactgroupcount = '0';
$servicedepcount = '0';
$hostdepcount = '0';
$commandcount = '0';
$timecount = '0';
$servicegroupcount = '0';

function write_attribute($attribute, $file) {
	global $$attribute;
	$value = $$attribute;
	if ($value<>'' OR $value=='0') {
		fwrite ($file, sprintf("\t%s\t\t%s\n", $attribute, str_replace(" ", "_", trim($value))));
	}
} // End Function

function not_options($attribute, $file) {
	global $$attribute;
	$value = $$attribute;
	$value=str_replace("Down", "d", $value);
	$value=str_replace('Up', 'u', $value);
	$value=str_replace('Recovery', 'r', $value);
	if ($value<>'') {
		fwrite ($file, sprintf("\t%s	%s\n", $attribute, str_replace(" ", "", trim($value))));
	}
} // End Function

function srv_not_options($attribute, $file) {
	global $$attribute;
	$value = $$attribute;
	$value=str_replace("OK", "r", $value);
	$value=str_replace('Warn', 'w', $value);
	$value=str_replace('Unkn', 'u', $value);
	$value=str_replace('Crit', 'c', $value);
	if ($value<>'') {
		fwrite ($file, sprintf("\t%s	%s\n", $attribute, str_replace(" ", "", trim($value))));
	}
} // End Function

function contact_srv_not_options($attribute, $file) {
	global $$attribute;
	$value = $$attribute;
	$value=str_replace("OK", "r", $value);
	$value=str_replace('Warn', 'w', $value);
	$value=str_replace('Unkn', 'u', $value);
	$value=str_replace('Crit', 'c', $value);
	if ($value<>'') {
		fwrite ($file, sprintf("\t%s	%s\n", $attribute, str_replace(" ", "", trim($value))));
	}
} // End Function

function srv_stalk_options($attribute, $file) {
	global $$attribute;
	$value = $$attribute;
	$value=str_replace("OK", "o", $value);
	$value=str_replace('Warn', 'w', $value);
	$value=str_replace('Unkn', 'u', $value);
	$value=str_replace('Crit', 'c', $value);
	if ($value<>'') {
		fwrite ($file, sprintf("\t%s	%s\n", $attribute, str_replace(" ", "", trim($value))));
	}
} // End Function

function stalk_options($attribute, $file) {
	global $$attribute;
	$value = $$attribute;
	$value=str_replace("Down", "d", $value);
	$value=str_replace('Up', 'o', $value);
	$value=str_replace('Unreachable', 'u', $value);
	if ($value<>'') {
		fwrite ($file, sprintf("\t%s	%s\n", $attribute, str_replace(" ", "", trim($value))));
	}
} // End Function

// Clean up Tables, put queries here to clean up DB before writing files
$hostcleanup=mysql_query("DELETE FROM hosts WHERE host_name='' AND alias='' AND address=''");
$hostgroupcleanup=mysql_query("DELETE FROM hostgroups WHERE hostgroup_name='' AND alias=''");


// Create hosts.cfg file
$hostresult = mysql_query("SELECT * FROM hosts ORDER BY host_name");
while ($myrow=mysql_fetch_array($hostresult)) {
	$hostcount++;

	// Localize Host variables
	$columns = mysql_num_fields($hostresult);
	for ($i = 0; $i < $columns; $i++) {
		$tempname = mysql_field_name($hostresult, $i);
		if ($myrow[$tempname]=='Yes') {
			$$tempname = '1';
		} elseif ($myrow[$tempname]=='No') {
			$$tempname = '0';
		} else {
			$$tempname = $myrow[$tempname];
		}
	}

	// Write host definition
	fwrite ($hostfile, "\ndefine host{\n");
	write_attribute ("host_name", $hostfile);
	write_attribute ("alias", $hostfile);
	write_attribute ("address", $hostfile);
	$parents='';
	$parentq=mysql_query("SELECT hosts.host_name FROM hosts, host_parents WHERE host_parents.host_id='$host_id' AND host_parents.parent_host_id=hosts.host_id");
	if (mysql_num_rows($parentq)>0) {
		while($myparent=mysql_fetch_array($parentq)) {
			$parents=sprintf('%s,%s', $myparent["host_name"], $parents);
		}
		write_attribute ("parents", $hostfile);
	}
	$check_commandq=mysql_query("SELECT command_name FROM command WHERE command_id='$check_command'");
	if (mysql_num_rows($check_commandq)>0) {
		$check_command=mysql_result($check_commandq, 0);
		write_attribute ("check_command", $hostfile);
	}
	write_attribute ("checks_enabled", $hostfile);
	$event_handlerq=mysql_query("SELECT command_name FROM command WHERE command_id='$event_handler'");
	if (mysql_num_rows($event_handlerq)>0) {
		$event_handler=mysql_result($event_handlerq, 0);
		write_attribute ("event_handler", $hostfile);
	}
	write_attribute ("event_handler_enabled", $hostfile);
	write_attribute ("max_check_attempts", $hostfile);
	write_attribute ("low_flap_threshold", $hostfile);
	write_attribute ("high_flap_threshold", $hostfile);
	write_attribute ("flap_detection_enabled", $hostfile);
	write_attribute ("process_perf_data", $hostfile);
	write_attribute ("retain_status_information", $hostfile);
	write_attribute ("retain_nonstatus_information", $hostfile);
	write_attribute ("notification_interval", $hostfile);
	$notq=mysql_query("SELECT timeperiod_name FROM timeperiods WHERE timeperiod_id='$notification_period'");
	if (mysql_num_rows($notq)>0) {
		$notification_period=mysql_result($notq, 0);
		write_attribute ("notification_period", $hostfile);
	}
	not_options ("notification_options", $hostfile);
	write_attribute ("notifications_enabled", $hostfile);
	$contact_groups='';
	$contact_groupsq=mysql_query("SELECT DISTINCT contactgroups.contactgroup_name FROM contactgroups, host_contactgroups WHERE contactgroups.contactgroup_id=host_contactgroups.contactgroup_id AND host_contactgroups.host_id='$host_id'");
	while($mygroup=mysql_fetch_array($contact_groupsq)) {
		$contact_groups=sprintf('%s,%s', $mygroup["contactgroup_name"], $contact_groups);
	}
	write_attribute ("contact_groups", $hostfile);
	stalk_options ("stalking_options", $hostfile);
	fwrite ($hostfile, "\n}\n\n");
	// Done writing Host Definition

	// Write Extended Definition
	fwrite ($hostextfile, "define hostextinfo{\n");
	write_attribute ("host_name", $hostextfile);
	$notes_url = sprintf("\tnotes_url http://nagios.guidehome.com/chart/serverinfo.php?hostname=%s\n", $host_name);
	fwrite ($hostextfile, $notes_url);
	fwrite ($hostextfile, "}\n\n");
	// Done Writing Host Extended Info definition
}
// Done writing Host Specific Files

// Write Services
$servicequery=mysql_query("SELECT * FROM services ORDER BY service_description");
//$servicequery=mysql_query("SELECT services.*, hosts.host_name, hostgroups.hostgroup_name FROM services, hosts, hostgroups WHERE services.host_id=hosts.host_id OR services.hostgroup_id=hostgroups.hostgroup_id");
while ($myservice=mysql_fetch_array($servicequery)) {
	$servicecount++;
	// Localize Service variables
	$columns = mysql_num_fields($servicequery);
	for ($i = 0; $i < $columns; $i++) {
		$tempname = mysql_field_name($servicequery, $i);
		if ($myservice[$tempname]=='Yes') {
			$$tempname = '1';
		} elseif ($myservice[$tempname]=='No') {
			$$tempname = '0';
		} else {
			$$tempname = $myservice[$tempname];
		}
	}

	fwrite ($servicefile, "\ndefine service{\n");
	if ($hostgroup_id=='0') {
		$hostq=mysql_query("SELECT host_name FROM hosts WHERE host_id='$host_id'");
		$host_name=mysql_result($hostq, 0);
		write_attribute ("host_name", $servicefile);
	} else {
		$hostq=mysql_query("SELECT hostgroup_name FROM hostgroups WHERE hostgroup_id='$hostgroup_id'");
		//		echo $hostgroup_id."<br>";
		$hostgroup_name=mysql_result($hostq, 0);
		write_attribute ("hostgroup_name", $servicefile);
	}
	write_attribute ("service_description", $servicefile);
	write_attribute ("is_volatile", $servicefile);
	$command_args_new='';
	$check_commandq=mysql_query("SELECT command_name FROM command WHERE command_id='$check_command'");
	if (mysql_num_rows($check_commandq)>0) {
		$check_command=mysql_result($check_commandq, 0);
		$command_args_array=explode(":",$command_args);
		foreach($command_args_array as $commandarray) {
			if ($commandarray<>'') {
				$command_args_new=sprintf('%s!%s', $command_args_new, $commandarray);
			}
		}
		$check_command=$check_command . $command_args_new;
		//		write_attribute ("check_command", $servicefile);
		fwrite($servicefile, "\tcheck_command\t\t" . $check_command . "\n");
	}
	write_attribute ("max_check_attempts", $servicefile);
	write_attribute ("normal_check_interval", $servicefile);
	write_attribute ("retry_check_interval", $servicefile);
	write_attribute ("active_checks_enabled", $servicefile);
	write_attribute ("passive_checks_enabled", $servicefile);
	$notq=mysql_query("SELECT timeperiod_name FROM timeperiods WHERE timeperiod_id='$check_period'");
	if (mysql_num_rows($notq)>0) {
		$check_period=mysql_result($notq, 0);
		write_attribute ("check_period", $servicefile);
	}
	write_attribute ("parallelize_check", $servicefile);
	write_attribute ("obsess_over_service", $servicefile);
	write_attribute ("check_freshness", $servicefile);
	write_attribute ("freshness_threshold", $servicefile);
	$event_handlerq=mysql_query("SELECT command_name FROM command WHERE command_id='$event_handler'");
	if (mysql_num_rows($event_handlerq)>0) {
		$event_handler=mysql_result($event_handlerq, 0);
		write_attribute ("event_handler", $servicefile);
	}
	write_attribute ("event_handler_enabled", $servicefile);
	write_attribute ("low_flap_threshold", $servicefile);
	write_attribute ("high_flap_threshold", $servicefile);
	write_attribute ("flap_detection_enabled", $servicefile);
	write_attribute ("process_perf_data", $servicefile);
	write_attribute ("retain_status_information", $servicefile);
	write_attribute ("retain_nonstatus_information", $servicefile);
	write_attribute ("notification_interval", $servicefile);
	$notq=mysql_query("SELECT timeperiod_name FROM timeperiods WHERE timeperiod_id='$notification_period'");
	if (mysql_num_rows($notq)>0) {
		$notification_period=mysql_result($notq, 0);
		write_attribute ("notification_period", $servicefile);
	}
	srv_not_options ("notification_options", $servicefile);
	write_attribute ("notifications_enabled", $servicefile);
	$contact_groups='';
	$contact_groupsq=mysql_query("SELECT contactgroups.contactgroup_name FROM contactgroups, service_contactgroups WHERE service_contactgroups.service_id='$service_id' AND contactgroups.contactgroup_id=service_contactgroups.contactgroup_id");
	while($mygroup=mysql_fetch_array($contact_groupsq)) {
		$contact_groups=sprintf('%s,%s', $mygroup["contactgroup_name"], $contact_groups);
	}
	write_attribute ("contact_groups", $servicefile);
	srv_stalk_options ("stalking_options", $servicefile);
	fwrite ($servicefile, "}\n\n");
}
// Done writing Services


// Write Host Group Files
$hgquery=mysql_query("SELECT * FROM hostgroups WHERE alias='' ORDER BY hostgroup_name");
while ($myhg=mysql_fetch_array($hgquery)) {
	$hostgroupcount++;
	// Localize Host Group variables
	$columns = mysql_num_fields($hgquery);
	for ($i = 0; $i < $columns; $i++) {
		$tempname = mysql_field_name($hgquery, $i);
		if ($myhg[$tempname]=='Yes') {
			$$tempname = '1';
		} elseif ($myhg[$tempname]=='No') {
			$$tempname = '0';
		} else {
			$$tempname = $myhg[$tempname];
		}
	}
	fwrite ($hostgroupfile, "\ndefine hostgroup{\n");
	write_attribute ("hostgroup_name", $hostgroupfile);
	$alias=$hostgroup_name;
	write_attribute ("alias", $hostgroupfile);
	$members='';
	$membersq=mysql_query("SELECT DISTINCT hosts.host_name FROM hosts, hostgroup_members WHERE hostgroup_members.hostgroup_id='$hostgroup_id' AND hosts.host_id=hostgroup_members.host_id");
	while($myhost=mysql_fetch_array($membersq)) {
		$members=sprintf('%s,%s', $members, $myhost["host_name"]);
	}
	if (stristr(substr($members, 0, 1),",")) {
		$members=substr($members, 1);
	}

	write_attribute ("members", $hostgroupfile);
	fwrite ($hostgroupfile, "}\n\n");
	// Done Writing Host Groups
}
// Done writing Host Group Specifics

// Write Service Groups
$sgquery=mysql_query("SELECT * FROM servicegroups ORDER BY servicegroup_name");
while ($mysg=mysql_fetch_array($sgquery)) {
	extract($mysg);
	echo $servicegroupid;
	$servicegroupcount++;
	// Localize Host Group variables
	//	$columns = mysql_num_fields($hgquery);
	//	for ($i = 0; $i < $columns; $i++) {
	//		$tempname = mysql_field_name($hgquery, $i);
	//		if ($myhg[$tempname]=='Yes') {
	//			$$tempname = '1';
	//		} elseif ($myhg[$tempname]=='No') {
	//			$$tempname = '0';
	//		} else {
	//			$$tempname = $myhg[$tempname];
	//		}
	//	}
	fwrite ($servicegroupfile, "\ndefine servicegroup{\n");
	write_attribute ("servicegroup_name", $servicegroupfile);
	$alias=$servicegroup_name;
	write_attribute ("alias", $servicegroupfile);
	$members='';
	$membersq=mysql_query("SELECT services.* FROM services, servicegroup_members WHERE servicegroup_members.servicegroup_id='$servicegroup_id' AND services.service_id=servicegroup_members.service_id");
	while($myhost=mysql_fetch_array($membersq)) {
		extract($myhost);
		if ($hostgroup_id=='0'){
			// We're dealing with a service assigned to a single host
			$members=sprintf('%s,%s', $members, mysql_result(mysql_query("SELECT host_name FROM hosts WHERE host_id='$host_id'"), 0));
			$members=sprintf('%s,%s', $members, $myhost["service_description"]);
		} else {
			// We're dealing with a service assigned to a hostgroup and we need to break it out.
			$hgquery=mysql_query("SELECT host_id FROM hostgroup_members WHERE hostgroup_id='$hostgroup_id'");
			while($myhg=mysql_fetch_array($hgquery)){
				$host_id=$myhg["host_id"];
				$members=sprintf('%s,%s', $members, mysql_result(mysql_query("SELECT host_name FROM hosts WHERE host_id='$host_id'"), 0));
				$members=sprintf('%s,%s', $members, $myhost["service_description"]);
			}
		}
		//		$members=sprintf('%s,%s', $members, $myhost["service_description"]);
	}
	if (stristr(substr($members, 0, 1),",")) {
		$members=substr($members, 1);
	}

	write_attribute ("members", $servicegroupfile);
	fwrite ($servicegroupfile, "}\n\n");
	// Done Writing Service Groups
}
// Done writing Service Groups

// Write contacts file
$contactq=mysql_query("SELECT * FROM contacts ORDER BY contact_name");
while($mycontact=mysql_fetch_array($contactq)) {
	$contactcount++;
	// Localize Service variables
	$columns = mysql_num_fields($contactq);
	for ($i = 0; $i < $columns; $i++) {
		$tempname = mysql_field_name($contactq, $i);
		if ($mycontact[$tempname]=='Yes') {
			$$tempname = '1';
		} elseif ($mycontact[$tempname]=='No') {
			$$tempname = '0';
		} else {
			$$tempname = $mycontact[$tempname];
		}
	}

	$contactmethods=array('pager', 'email');
	$host_notification_period_query=$host_notification_period;
	$service_notification_period_query=$service_notification_period;
	foreach ($contactmethods as $contactm) {
		if ($$contactm<>'') {
			fwrite ($contactsfile, "\ndefine contact{\n");
			fwrite ($contactsfile, "\tcontact_name		".str_replace(" ", "_", trim($contact_name)). "-" . $contactm."\n");
			write_attribute ("alias", $contactsfile);
			$notq=mysql_query("SELECT timeperiod_name FROM timeperiods WHERE timeperiod_id='$host_notification_period_query'");
			if (mysql_num_rows($notq)>0) {
				$host_notification_period=mysql_result($notq, 0);
				write_attribute ("host_notification_period", $contactsfile);
			}
			$notq=mysql_query("SELECT timeperiod_name FROM timeperiods WHERE timeperiod_id='$service_notification_period_query'");
			if (mysql_num_rows($notq)>0) {
				$service_notification_period=mysql_result($notq, 0);
				write_attribute ("service_notification_period", $contactsfile);
			}
			not_options("host_notification_options", $contactsfile);
			contact_srv_not_options("service_notification_options", $contactsfile);
			$host_notification_commands="host_notification_command_" . $contactm;
			$check_commandq=sprintf("SELECT command_name FROM notify WHERE command_id='%s'", $$host_notification_commands);
			$check_commandq=mysql_query($check_commandq);
			if (mysql_num_rows($check_commandq)>0) {
				$host_notification_commands=mysql_result($check_commandq, 0);
				write_attribute ("host_notification_commands", $contactsfile);
			}
			$service_notification_commands="service_notification_command_" . $contactm;
			$check_commandq=sprintf("SELECT command_name FROM notify WHERE command_id='%s'", $$service_notification_commands);
			$check_commandq=mysql_query($check_commandq);
			if (mysql_num_rows($check_commandq)>0) {
				$service_notification_commands=mysql_result($check_commandq, 0);
				write_attribute ("service_notification_commands", $contactsfile);
			}
			write_attribute ("email", $contactsfile);
			write_attribute ("pager", $contactsfile);
			fwrite ($contactsfile, "}\n\n");
		}
	}
}
// Done writing Contacts

// Writing Contact Groups
$contactgroupq=mysql_query("SELECT * FROM contactgroups ORDER BY contactgroup_name");
while ($mycg=mysql_fetch_array($contactgroupq)) {
	$contactgroupcount++;

	// Localize Contact Group variables
	$columns = mysql_num_fields($contactgroupq);
	for ($i = 0; $i < $columns; $i++) {
		$tempname = mysql_field_name($contactgroupq, $i);
		if ($mycg[$tempname]=='Yes') {
			$$tempname = '1';
		} elseif ($mycg[$tempname]=='No') {
			$$tempname = '0';
		} else {
			$$tempname = $mycg[$tempname];
		}
	}

	fwrite ($contactgroupfile, "\ndefine contactgroup{\n");
	write_attribute ("contactgroup_name", $contactgroupfile);
	if ($alias=='') {
		$alias = $contactgroup_name;
	}
	write_attribute ("alias", $contactgroupfile);
	$members='';
	$membersq=mysql_query("SELECT contacts.contact_name, contactgroup_members.alert FROM contacts, contactgroup_members WHERE contactgroup_members.contactgroup_id='$contactgroup_id' AND contacts.contact_id=contactgroup_members.contact_id");
	while($mycg=mysql_fetch_array($membersq)) {
		$members=sprintf('%s-%s,%s', $mycg["contact_name"], $mycg["alert"], $members);
	}
	write_attribute ("members", $contactgroupfile);
	fwrite ($contactgroupfile, "}\n\n");
}
// Done writing Contact Groups

// Writing service dependencies
$depquery=mysql_query("SELECT * FROM servicedependency");
while ($mydep=mysql_fetch_array($depquery)) {
	$servicedepcount++;
	// Localize Service variables
	$columns = mysql_num_fields($depquery);
	for ($i = 0; $i < $columns; $i++) {
		$tempname = mysql_field_name($depquery, $i);
		if ($mydep[$tempname]=='Yes') {
			$$tempname = '1';
		} elseif ($mydep[$tempname]=='No') {
			$$tempname = '0';
		} else {
			$$tempname = $mydep[$tempname];
		}
	}

	fwrite ($dependfile, "\ndefine servicedependency{\n");
	write_attribute ("dependent_host_name", $dependfile);
	write_attribute ("dependent_service_description", $dependfile);
	write_attribute ("host_name", $dependfile);
	write_attribute ("service_description", $dependfile);
	write_attribute ("inherits_parent", $dependfile);
	srv_not_options ("execution_failure_criteria", $dependfile);
	srv_not_options ("notification_failure_criteria", $dependfile);

	fwrite ($dependfile, "}\n\n");
}
// Done writing service dependencies


// Writing host dependencies
$depquery=mysql_query("SELECT * FROM hostdependency");
while ($mydep=mysql_fetch_array($depquery)) {
	$hostdepcount++;
	// Localize host variables
	$columns = mysql_num_fields($depquery);
	for ($i = 0; $i < $columns; $i++) {
		$tempname = mysql_field_name($depquery, $i);
		if ($mydep[$tempname]=='Yes') {
			$$tempname = '1';
		} elseif ($mydep[$tempname]=='No') {
			$$tempname = '0';
		} else {
			$$tempname = $mydep[$tempname];
		}
	}
	$dependent_host_nameq=mysql_query("SELECT host_name FROM hosts WHERE host_id='$dependent_host_id'");
	$dependent_host_name=mysql_result($dependent_host_nameq, 0);
	$host_nameq=mysql_query("SELECT host_name FROM hosts WHERE host_id='$host_id'");
	$host_name=mysql_result($host_nameq, 0);

	fwrite ($dependfile, "\ndefine hostdependency{\n");
	write_attribute ("dependent_host_name", $dependfile);
	write_attribute ("host_name", $dependfile);
	write_attribute ("inherits_parent", $dependfile);

	// Hard coded for now
	fwrite ($dependfile, "\tnotification_failure_criteria	d,u\n");
	fwrite ($dependfile, "\texecution_failure_criteria	d,u\n");

	fwrite ($dependfile, "}\n\n");
}
// Done writing host dependencies


// Write check command file
$commandquery=mysql_query("SELECT * FROM command");
while($mycommand=mysql_fetch_array($commandquery)) {
	$commandcount++;
	// Localize command variables
	$columns = mysql_num_fields($commandquery);
	for ($i = 0; $i < $columns; $i++) {
		$tempname = mysql_field_name($commandquery, $i);
		if ($mycommand[$tempname]=='Yes') {
			$$tempname = '1';
		} elseif ($mycommand[$tempname]=='No') {
			$$tempname = '0';
		} else {
			$$tempname = $mycommand[$tempname];
		}
	}

	fwrite ($commandfile, "\ndefine command{\n");
	write_attribute ("command_name", $commandfile);
	fwrite ($commandfile, "\tcommand_line	". $command_line);
	fwrite ($commandfile, "\n}\n\n");
}
// Done writing check command file

// Write notify commands
$commandquery=mysql_query("SELECT * FROM notify");
while($mycommand=mysql_fetch_array($commandquery)) {
	$commandcount++;
	// Localize command variables
	$columns = mysql_num_fields($commandquery);
	for ($i = 0; $i < $columns; $i++) {
		$tempname = mysql_field_name($commandquery, $i);
		if ($mycommand[$tempname]=='Yes') {
			$$tempname = '1';
		} elseif ($mycommand[$tempname]=='No') {
			$$tempname = '0';
		} else {
			$$tempname = $mycommand[$tempname];
		}
	}

	fwrite ($commandfile, "\ndefine command{\n");
	write_attribute ("command_name", $commandfile);
	fwrite ($commandfile, "\tcommand_line	". $command_line . "\n");
	fwrite ($commandfile, "}\n\n");
}
// done writing notify commands

// Writing timeperiods
$timequery=mysql_query("SELECT * FROM timeperiods ORDER BY timeperiod_name");
while ($mytime=mysql_fetch_array($timequery)) {
	$timecount++;
	// Localize time variables
	$columns = mysql_num_fields($timequery);
	for ($i = 0; $i < $columns; $i++) {
		$tempname = mysql_field_name($timequery, $i);
		if ($mytime[$tempname]=='Yes') {
			$$tempname = '1';
		} elseif ($mytime[$tempname]=='No') {
			$$tempname = '0';
		} else {
			$$tempname = $mytime[$tempname];
		}
	}

	fwrite ($timefile, "\ndefine timeperiod{\n");
	write_attribute ("timeperiod_name", $timefile);
	write_attribute ("alias", $timefile);
	write_attribute ("sunday", $timefile);
	write_attribute ("monday", $timefile);
	write_attribute ("tuesday", $timefile);
	write_attribute ("wednesday", $timefile);
	write_attribute ("thursday", $timefile);
	write_attribute ("friday", $timefile);
	write_attribute ("saturday", $timefile);
	fwrite ($timefile, "\n}\n\n");
}
// Done writing timeperiods

// Write Scheduled Downtime
$downquery=mysql_query("SELECT * FROM downtime ORDER BY host_name");
while ($downtime=mysql_fetch_array($downquery)) {
	$daysarray=array('Sun' => '0', 'Mon' => '0', 'Tues' => '0', 'Wed' => '0', 'Thur' => '0', 'Fri' => '0', 'Sat' => '0');
	$daylist=str_replace(",", " ", $downtime["days"]);
	foreach($daysarray as $day => $value) {
		if (stristr($daylist, $day)) {
			$daysarray[$day] = '1';
		}
	}
	$output='';
	foreach ($daysarray as $value) {
		$output=sprintf('%s%s:', $output, $value);
	}

	$output=substr($output, 0, -1);

	$output=sprintf('%s,%s,%s,%s', $output, $downtime["host_name"], $downtime["starttime"], $downtime["duration"]);
	if ($downtime["fd"] == "Dynamic") {
		$output = $output . ",0";
	} else {
		$output = $output . ",1";
	}
	$output=sprintf("%s,%s,%s,%s\n", $output, $downtime["duration"], $downtime["name"], $downtime["comments"]);

	fwrite ($downfile, $output);
}
// done writing Scheduled Downtime

fclose($hostfile);
fclose($hostextfile);
fclose($servicefile);
fclose($hostgroupfile);
fclose($contactgroupfile);
fclose($contactsfile);
fclose($dependfile);

echo "Done writing Configuration Files\n<br>";
printf ("%s Hosts Defined<br>", $hostcount);
printf ("%s HostGroups Defined<br>", $hostgroupcount);
printf ("%s Services Defined<br>", $servicecount);
printf ("%s ServiceGroups Defined<br>", $servicegroupcount);
printf ("%s Contacts Defined<br>", $contactcount);
printf ("%s Contact Groups Defined<br>", $contactgroupcount);
printf ("%s Service Dependencies Defined<br>", $servicedepcount);
printf ("%s Host Dependencies Defined<br>", $hostdepcount);
printf ("%s Commands Defined<br>", $commandcount);
printf ("%s Time Periods Defined<br>", $timecount);
echo "Done Writing Config Files";
?>
