#!/usr/bin/perl
# Based on:  check_mem.pl Copyright (C) 2009 
# Igor Nikitin <igor.nikitin@btinternet.com>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty
# of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# you should have received a copy of the GNU General Public License
# along with this program (or with Nagios);  if not, write to the
# Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA

# Tell Perl what we need to use
use strict;
use Getopt::Std;
use Db::Documentum qw (:all);
use Db::Documentum::Tools qw (:all);
use vars qw($opt_T $opt_D $opt_U $opt_P);

# Predefined exit codes for Nagios
my %exit_codes   = ('UNKNOWN' ,-1,
		 'OK'      , 0,
		 'WARNING' , 1,
		 'CRITICAL', 2,);

# Get the options
if ($#ARGV le 0)
{
  &usage;
}
else
{
  getopts('T:U:D:P:');
}

# logon or die
my $SESSION_ID = dm_Connect($opt_D,$opt_U,$opt_P);
unless ($SESSION_ID) {
   print  "No session ID obtained. Documentum Error was: " .  dm_LastError("","3","all") . "\n";
  exit $exit_codes{'CRITICAL'};
} 
my $DQL = "select count(*) as cnt from dm_sysobject where r_object_type ='" . $opt_T . "'";

# do duery
my $col_id = dmAPIGet("query,$SESSION_ID,$DQL");

# if query successful
my $cnt;
if ($col_id) {
   # loop thorugh collection  
   while (dmAPIExec("next,$SESSION_ID,$col_id")) {
   $cnt = dmAPIGet("get,$SESSION_ID,$col_id,cnt");
   }
   dmAPIExec("close,$SESSION_ID,$col_id");
}
# if no collection, error
else {
   print "Documentum Error was: " . dm_LastError($SESSION_ID,"3","all") . "\n";
   exit $exit_codes{'UNKNOWN'};
}

dmAPIExec("disconnect,$SESSION_ID");


print "Number of objects - $cnt |number=$cnt\n";
exit $exit_codes{'OK'};

# Show usage
sub usage()
{
  print "\ncheck_docbase_objects.pl v0.1 - Nagios Plugin\n\n";
  print "usage:\n";
  print "  check_docbase_objects.pl -D<docbase> -U<user> -P<password>  -T<r_object_type>\n\n";
  print "options:\n";
  print " -U USER name\n";
  print " -P password\n";
  print " -D docbase\n";
  print " -T object type\n";
  print "This program is licensed under the terms of the\n";
  print "GNU General Public License (check source code for details)\n";
  exit $exit_codes{'UNKNOWN'};
}

