#! /bin/sh 
#
# Usage: ./check_docbase_projection --help
#
# Description: 
#	Used to verify docbase projection via Nagios
#
# Output:
#	Outputs Critical Error if there is no projected Content Servers.
#
# Examples: 
#	./check_docbase_projection.sh -t 10.1.1.1 -p 1489 -d mydocbase
#

# Paths to commands used in this script.  These
# may have to be modified to match your system setup.
. ~nagios/.bash_profile

PATH=""

ECHO="/bin/echo"
SED="/bin/sed"
DMQDTOOL="/usr/local/groundwork/documentum/product/5.3/bin/dmqdocbroker"
GREP="/bin/grep"
DF="/bin/df"
DIFF="/bin/diff"
TAIL="/bin/tail"
CAT="/bin/cat"
RM="/bin/rm"
WC="/bin/wc"

PROGNAME=`/bin/basename $0`
PROGPATH=`echo $0 | /bin/sed -e 's,[\\/][^\\/][^\\/]*$,,'`
REVISION=`echo '$Revision: 0.1 $' | /bin/sed -e 's/[^0-9.]//g'`

. /usr/local/groundwork/nagios/libexec/utils.sh

print_usage() {
    echo "Usage: $PROGNAME -t <docbroker_host> -p <docbroker_port> -d <docbase_name>"
    echo "Usage: $PROGNAME --help"
    echo "Usage: $PROGNAME --version"
}

print_help() {
    print_revision $PROGNAME $REVISION
    echo ""
    print_usage
    echo ""
    echo "Check Docbase Projection"
    echo ""
    support
}

# Make sure the correct number of command line
# arguments have been supplied

if [ $# -lt 3 ]; then
    print_usage
    exit $STATE_UNKNOWN
fi

# Grab the command line arguments

exitstatus=$STATE_WARNING #default
while test -n "$1"; do
    case "$1" in
        --help)
            print_help
            exit $STATE_OK
            ;;
        -h)
            print_help
            exit $STATE_OK
            ;;
        --version)
            print_revision $PROGNAME $VERSION
            exit $STATE_OK
            ;;
        -V)
            print_revision $PROGNAME $VERSION
            exit $STATE_OK
            ;;
        -t)
	    HOSTNAME=$2;
            shift;
            ;;
        -p)
	    PORT=$2;
            shift;
            ;;
        -d)
	    DOCBASE=$2;
            shift;
            ;;
        *)
            echo "Unknown argument: $1"
            print_usage
            exit $STATE_UNKNOWN
            ;;
    esac
    shift
done

RESULT="`$DMQDTOOL -t $HOSTNAME -p $PORT -c getservermap $DOCBASE`" 

if [ $? == 0 ] ; then
    CHECK_IS_OPEN="$ECHO $RESULT | $GREP 'server status' | $GREP 'Open'"
    if [ $? == 0 ] ; then
       $ECHO "Docbase $DOCBASE is projected on server $HOSTNAME \n"
       exit $STATE_OK
    fi
fi


$ECHO "Docbase $DOCBASE is not projected on server $HOSTNAME \n"
exit $STATE_CRITICAL

