<?php
# $Id: serviceedit.php,v 1.13 2002/06/21 10:27:38 kemuri Exp $

/*
 * Copyright (c) 2002 Ypsilon.Net AG, Germany
 *
 * This file is part of Nagat.
 * 
 * Nagat is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * Nagat is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Nagat; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

# Page variables
define("PAGE_ID","serviceedit");
define("PAGE_TITLE","Service object");
define("OBJECTTYPE","service");

require_once("local.inc");

$action = isset($action) ? strtolower($action) : '';
$message = '';
$object = NULL;
$cntinh = 0;

# Actions before output is send
switch($action) {
	case 'save':
		$saveobject['notification_options'] = 
			@implode(",",$saveobject['notification_options']);
		$saveobject['stalking_options'] = 
			@implode(",",$saveobject['stalking_options']);

		# Handle the check_command attributes
		$checkcommand = $saveobject['check_command']['cmd'];
		$param = trim($saveobject['check_command']['param']);
		if( !empty($param) ) $checkcommand .= "!".$param;
		@settype($saveobject['check_command'],"string");
		$saveobject['check_command'] = $checkcommand;

		$eventhandler = $saveobject['event_handler']['cmd'];
		$param = trim($saveobject['event_handler']['param']);
		if( !empty($param) ) $eventhandler .= "!".$param;
		@settype($saveobject['event_handler'],"string");
		$saveobject['event_handler'] = $eventhandler;

		$objectid = PluginSaveObject($objectid,$saveobject,OBJECTTYPE);
		header("Location: services.php");
		exit();
		break;

	case 'delete':
		$objectid = PluginDeleteObject($objectid,OBJECTTYPE);
		header("Location: services.php");
		break;
}

include_once(NGT_LIB."head.inc");

if( is_array($object) == FALSE) {
	$object = PluginGetObject($objectid,OBJECTTYPE);
}

$servicename = !empty($object["name"]) ? $object['name'] : ''; 

# If this is a template: get its iheriters
if( !empty($object['name']) ) {
	$cntinh = NagiosCountInherited(OBJECTTYPE,$object['name']);
}

# Get information about the parent object if any
if( !empty($object['use']) ) {
	$inhobject = PluginGetObjectByName($object['use'],OBJECTTYPE);
	foreach($inhobject as $key => $value) {
		$object['++'.$key] = $value;
	}
}

# Get a default cfg file if object is new
if( $object['__cfgfile'] == "") {
  $objects = PluginGetObjects(OBJECTTYPE);
  $firstobject = reset($objects);
  $object['__cfgfile'] = $firstobject['__cfgfile'];
}

foreach( $confobjects[OBJECTTYPE] as $key => $propconf ) {

	$required = 'label';
	$value = !empty($object[$key]) ? $object[$key] : '';
	$inhhtml = "";
	
	if( isset($object["++".$key]) ) {
	   $inhhtml = "  <td>".$object["++".$key]."</td>";
           $reqclass = 'requiredok';
	} else {
	   $reqclass = 'required';
	}
	
  	$show = NagiosObjPropEdit(OBJECTTYPE,$key,"saveobject[$key]",$value);

	if( empty($object['name']) ) {
		$required = $propconf[2] == TRUE ? $reqclass : 'label';
	}

	$rows[$key] = <<<HTML
<tr>
  <td class="label">$key</td>
  <td class="$required" width="3">&nbsp;</td>
  <td class="value">
  $show
  </td>
  $inhhtml
</tr>
HTML;
}

?>
<form method="post">
<input type="hidden" name="objectid" value="<?=$object['__objectid']?>">

<table cellpadding="3" border="0">
<tr>
  <td colspan="3" align="left">
  <b><?=$message?>&nbsp;</b>
  </td>
</tr>
<tr>
  <td colspan="3" align="right">
  <input type="submit" name="action" value="Save">
  <input type="submit" name="action" value="Delete">
  </td>
</tr>
<tr class="rowsep">
  <td colspan="3">Properties</td>
<?php
if( !empty($object['use']) ) {
	$parent = PluginGetObjectByName($object['use'],OBJECTTYPE);
  	print <<<HTML
  <td>
  Inherits from 
  <a href="serviceedit.php?objectid={$parent['__objectid']}"><b>{$parent['name']}</b></a>
  </td>
HTML;
}
?>
</tr>
<?=implode("\n", $rows)?>
<?

if ( $cntinh > 0  && !empty($servicename) ) {
	print ObjectInheritance($servicename, OBJECTTYPE);
}

?>
</table>
</form>

<?php
include_once(NGT_LIB."tail.inc");
?>
