#!/bin/bash
# symon_nagios version 0.5 (rrd)

# Fabio Pardi on Sept 2014

# This plugin checks the rrd files created by symon and reads CPU and RAM values

# Consideration: we run symux on the same host on which icinga runs. Thus the checks are local.

#we need:

# files location. Is where the RRD files are eg: /var/www/html/symon/rrds/
# host to check: hostname of the machine. eg: firewall_01
#warning and critical thresholds (threated as the same for CPU and RAM)

exit_code=0

#############################################
#############################################
print_help() {
        echo ""
        echo "Usage: $PROGNAME --help"
    	echo "Usage: $PROGNAME -f file location -H hostname_to_check "
        echo ""
        echo "Plugin to check symon's output"
    	echo ""
    	echo "PARAMETERS:"
    	echo "-f file location -> is where the rrd file is "
    	echo " -w and -c [integer] to give warning and critical thresholds"
    	echo "Common syntax of the target_host is: name integer integer"
        echo ""
}
##############################################
##############################################

#parameters check
while test -n "$1"; do
   case "$1" in
        --help)
            print_help
            exit 2
            ;;
        -w)
            warning=$2
            shift
            ;;
        -c)
            critical=$2
            shift
            ;;

        -f)
            file_location=$2
            shift
            ;;
        *)
            echo "Unknown argument: $1"
            print_help
            exit 2
            ;;
    esac
    shift
done 


if [ -z $file_location ] ;then
    	echo "Files location is missing!"
    	echo "Please use -f files_location. The folder in which symux host folder is"
    	exit 2
fi

if [ -z $critical ] ;then
        echo "Critital threshold missing!"
        echo "Please use -c [Integer]"
        exit 2
fi

if [ -z $warning ] ;then
        echo "Warning threshold missing!"
        echo "Please use -w [Integer]"
        exit 2
fi

if [ $warning -ge $critical ] ; then
	    echo "Warning threshold must be greather than critical!"
	    exit 2
fi
	


check_recent(){
#checks that the files are recent
	recent_files=`find  $file_location/ -mmin -2 -type f | grep 'cpu\|mem' | wc -l`
	all_files=`ls $file_location/ |  grep 'cpu\|mem' | wc -l`
	if [ ! $recent_files -eq $all_files ]
		then
		#we cannot proceed because files are not recent.
		echo "No recent files to check"
		exit 3
	fi
}

check_recent

#If we are here, the files are recent and we can use them

average_cpu(){
#calculates the average usage of CPUs
total_load=0
count=0

for cpus in $file_location/cpu* 
	do
		idle=`rrdtool info $cpus | grep "idle].last" | awk '{print $3}' | sed 's,",,g'`
        	result=$(echo "100-$idle" | bc)
#		echo result is $result
        	total_load=$(echo "$total_load+$result"|bc)
        	let count++
#		echo count is $count and total load is $total_load

done
        cpu_avg=$(echo "($total_load/$count)"|bc)
#	echo cpu avg is $cpu_avg
        if [[ "$cpu_avg" -gt "$critical" ]]
        then
                echo "CPU load is Critical: average is $cpu_avg" 
                exit_code=2
                else if [[ "$cpu_avg" -ge "$warning" ]]
                then
                        echo "CPU is Warning: average is $cpu_avg%" 
                        exit_code=1
                fi
        fi
}

average_cpu

#This function checks the RAM
check_mem(){
	active_mem=`rrdtool info $file_location/mem.rrd | grep "active].last" | awk '{print $3}' | sed 's,",,g'`
	avail_mem=`rrdtool info $file_location/mem.rrd | grep "real_total].last" | awk '{print $3}' | sed 's,",,g'`
	#echo active memory is $active_mem and total is $avail_mem

        percentage_active=$(echo "(100*$active_mem/$avail_mem)"|bc)

	if [ "$percentage_active" -gt "$critical" ]
	then
        	echo "Active RAM Critical: $percentage_active%" 
        	exit_code=2
		else if [[ "$percentage_active" -gt "$warning" ]]
        	then

	        	echo "Active RAM Warning: $percentage_active%" 
			if [[  $exit_code -lt 2 ]]
			then
        	        	exit_code=1
        		fi
        	fi
	fi
}


check_mem

if [ $exit_code -gt 0 ]
then
	exit $exit_code
else
       	echo "OK - CPU $cpu_avg% and RAM $percentage_active%"
	exit 0
fi
echo "Dunno what i m doing here"
exit 3
