#!/usr/bin/awk -f

BEGIN {
	print "[global]"
	print "options_rescan_at_startup=0"
	print "options_discover_retries=2"
	print "options_operating_system_check=0"
	print "options_confirm_delete=1"
	print "options_reverse_dns=0"
	print "options_save_changes_on_exit=1"
	print "options_use_ip_for_label=0"
	print "options_only_display_hostname=0"
	print "options_move_stuff_live=1"
	print "options_probe_ports=0"
	print "options_map=1"
	print "options_os_scan_ports="
	print "options_os_scan_tcp_scan=Connect Scan"
	print "options_os_scan_timing=Normal"
	print "options_os_scan_fastscan=0"
	print "options_os_scan_udp_scan=0"
	print "options_os_scan_identd_scan=0"
	print "options_os_scan_rpc_scan=0"
	print "options_os_scan_osscan=0"
	print "options_os_scan_dont_ping=1"
	print "options_os_scan_scan_specified_ports=0"
	print "options_use_ip_for_merged_ports=0"
	print "width=757"
	print "height=633"
	print ""
	print "[viewspace0]"
	print "name=nag2che ViewSpace"
	print "agent_ip=127.0.0.1"
	print "usessl=0"
	objnum = 0
}

/host_name/ {
	print "page_object_"objnum"_ip=127.1.0." objnum
	print "page_object_"objnum"_name=" $2
}

/2d_coords/ {
	x=y=$2
	gsub(/\,.*/,"",x)
	gsub(/.*\,/,"",y)
	print "page_object_"objnum"_x=" x
	print "page_object_"objnum"_y=" y
	print "page_object_"objnum"_icon_file_name=unknown.xpm"
	objnum++
}


#
# Convert Nagios config from ..
#
#define hostextinfo{
#        host_name       7670
#        notes_url
#        icon_image      cook/switch.png
#        icon_image_alt  7670
#        vrml_image      cook/switch.png
#        statusmap_image cook/switch.gd2
#        2d_coords       100,350
#        3d_coords       100.0,50.0,75.0
#        }
#
# to cheops-ng config ...
#
#page_object_0_ip=192.168.5.5
#page_object_0_name=
#page_object_0_x=212
#page_object_0_y=317
#page_object_0_icon_file_name=unknown.xpm
#
