<?php
/* EMC CLARiiON CONFIG WIZARD */

/* Required include */
include_once(dirname(__FILE__).'/../configwizardhelper.inc.php');

/* Run the initialization function */

/* for all function names, prepend function name with the wizard's name */
/* Example: function emcclariion_configwizard_init() */
emcclariion_configwizard_init();

function emcclariion_configwizard_init(){
	
	/* Name / ID for config wizard */
	$name = 'emcclariion';
	
	/* Relevant info for wizard */
	$args = array(
		CONFIGWIZARD_NAME 			=> $name,
		CONFIGWIZARD_TYPE 			=> CONFIGWIZARD_TYPE_MONITORING,
		CONFIGWIZARD_DESCRIPTION 	=> 'Monitor an EMC CLARiiON SAN.',
		CONFIGWIZARD_DISPLAYTITLE 	=> 'EMC CLARiiON',
		CONFIGWIZARD_FUNCTION 		=> 'emcclariion_configwizard_func',
		CONFIGWIZARD_PREVIEWIMAGE 	=> 'emc1.png',
		CONFIGWIZARD_VERSION 		=> '2013-03-09',
		CONFIGWIZARD_DATE 			=> '2013-03-09',
		CONFIGWIZARD_AUTHOR 		=> 'Troy Lea aka Box293',
		);
	/* Register wizard with XI */
	register_configwizard($name,$args);
	}

/* This function is automatically called by the XI wizard framework when the wizard is run */
function emcclariion_configwizard_func($mode = '',$inargs = null,&$outargs,&$result){

	/* Define the wizard name */
	$wizard_name = 'emcclariion';

	/* Initialize return code and output */
	$result = 0;
	$output = '';
	
	/* Initialize output args - pass back the same data we got -> used by XI framework, don't change */
	$outargs[CONFIGWIZARD_PASSBACK_DATA] = $inargs;

	/* The wizard will advanced depending on which mode/stage it's in. */
	/* wizard functions with the following pattern: <show stage html> -> <validate stage> -> <show next stage html> */
	/* CONFIGWIZARD_MODE_GETSTAGE1HTML */
	/* CONFIGWIZARD_MODE_VALIDATESTAGE1DATA */
	/* CONFIGWIZARD_MODE_GETSTAGE2HTML */
	/* CONFIGWIZARD_MODE_VALIDATESTAGE2DATA */
	/* CONFIGWIZARD_MODE_GETSTAGE3OPTS */
	/* CONFIGWIZARD_MODE_GETSTAGE3HTML */
	/* CONFIGWIZARD_MODE_VALIDATESTAGE3DATA */
	/* CONFIGWIZARD_MODE_GETSTAGE4OPTS */
	/* CONFIGWIZARD_MODE_GETFINALSTAGEHTML */
	/* CONFIGWIZARD_MODE_GETOBJECTS */
	
	/* Main Wizard Stage switch */
	switch ($mode) {
		case CONFIGWIZARD_MODE_GETSTAGE1HTML:
			
			/* Getting a list of existing hosts to display in the wizard */
			$host = grab_array_var($inargs,'host','');
			
			/* This defines $back variable, used for determining if the Back button */
			/* was clicked when the user was on CONFIGWIZARD_MODE_GETSTAGE2HTML */
			$back = htmlentities(grab_array_var($_POST,'backButton',false),ENT_QUOTES); 
			
			/* This defines $nextstep variable, used for determining if the user did not */
			/* provide correct information when the user was on CONFIGWIZARD_MODE_GETSTAGE1HTML */
			$nextstep = htmlentities(grab_array_var($_POST,'nextstep',false),ENT_QUOTES); 
			
			/* The following THREE lines can be enabled for debugging purposes */
			//print_r('<br />post CONFIGWIZARD_MODE_GETSTAGE1HTML<br />'); 
			//print_r($_POST); 
			//print_r('<br /><br />'); 
			
			/* The following THREE lines can be enabled for debugging purposes */
			//print_r('<br />session CONFIGWIZARD_MODE_GETSTAGE1HTML<br />'); 
			//print_r($_SESSION); 
			//print_r('<br /><br />'); 
			
			/* The following THREE lines can be enabled for debugging purposes */
			//print_r('<br />session[emcclariion] CONFIGWIZARD_MODE_GETSTAGE1HTML<br />'); 
			//print_r($_SESSION[$wizard_name]); 
			//print_r('<br /><br />'); 
			
			/* Determine if this is the first wizard run */
			if ($nextstep == '') {
				/* Clear the session array to be sure it is blank */
				unset($_SESSION[$wizard_name]); 
				}
			
			/* Check to see if we are coming back from CONFIGWIZARD_MODE_GETSTAGE2HTML */
			if ($back == 'Back') {
				/* User pressed Back button on CONFIGWIZARD_MODE_GETSTAGE2HTML */
				/* The following line can be enabled for debugging purposes */
				//print_r('<br />User pressed Back button on CONFIGWIZARD_MODE_GETSTAGE2HTML<br />'); 
				
				/* Back was clicked when user was on CONFIGWIZARD_MODE_GETSTAGE2HTML so we need to define some variables */
				
				$tab_selected = $_SESSION[$wizard_name]['tab_selected'];
				//print_r('<br />tab_selected<br />'); 
				//print_r($tab_selected); 
				//print_r('<br /><br />'); 	
					
				/* There are different values based on which tab was selected */
				switch($tab_selected){
					case 'emcclariion-new':
						$sanname = $_SESSION[$wizard_name]['sanname'];
						$spaaddress = $_SESSION[$wizard_name]['spaaddress'];
						$spbaddress = $_SESSION[$wizard_name]['spbaddress'];
						$spahostname = '';
						$spbhostname = '';
						break; /* End case 'emcclariion-new': */
					
					case 'emcclariion-existing':
						$spahostname = $_SESSION[$wizard_name]['spahostname'];
						$spbhostname = $_SESSION[$wizard_name]['spbhostname'];
						$sanname = '';
						$spaaddress = '';
						$spbaddress = '';
						break; /* End case 'emcclariion-existing': */
					} /* End switch($tab_selected){ */
				
				$spaselect = $_SESSION[$wizard_name]['spaselect'];
				$spbselect = $_SESSION[$wizard_name]['spbselect'];
				$monitoring_username = $_SESSION[$wizard_name]['monitoring_username'];
				$monitoring_password = $_SESSION[$wizard_name]['monitoring_password'];
				
				if ($spaselect == 'on') {
					$spaselectsetting = 'checked';
					}
				else {
					$spaselectsetting = '';
					}
				if ($spbselect == 'on') {
					$spbselectsetting = 'checked';
					}
				else {
					$spbselectsetting = '';
					}
				} /* End if ($back == 'Back') { */
			
			else {
				/* Fresh Wizard Run */
				/* OR */
				/* Continuing from CONFIGWIZARD_MODE_VALIDATESTAGE1DATA due to user error */
				
				$tab_selected_test = htmlentities(grab_array_var($_POST,'emcclariion-tab-selected',false),ENT_QUOTES);
				//print_r('<br />tab_selected_test<br />'); 
				//print_r($tab_selected); 
				//print_r('<br /><br />'); 	
				
				if ($tab_selected_test == '') {
					/* Fresh Wizard Run */
					/* The following line can be enabled for debugging purposes */
					//print_r('<br />First Time The Wizard has been run <br />');
					
					/* Define the session array to hold data from different stages */
					$_SESSION[$wizard_name] = array(); 
					
					/* The following variables need to be defined to prevent coding errors */
					$sanname = '';
					$spaaddress = '';
					$spbaddress = '';
					$spaselect = '';
					$spbselect = '';
					$monitoring_username = '';
					$monitoring_password = '';
					$spaselectsetting = '';
					$spbselectsetting = '';
					$spahostname = '';
					$spbhostname = '';
					$tab_selected = 'emcclariion-new';
					} /* End if (!isset($_SESSION[$wizard_name]['tab_selected'])) { */
				else {
					/* Continuing from CONFIGWIZARD_MODE_VALIDATESTAGE1DATA due to user error */
					/* The following line can be enabled for debugging purposes */
					//print_r('<br />Continuing from CONFIGWIZARD_MODE_VALIDATESTAGE1DATA due to user error<br />'); 
					
					/* The following THREE lines can be enabled for debugging purposes */
					//print_r('<br />session[emcclariion] CONFIGWIZARD_MODE_VALIDATESTAGE1DATA<br />'); 
					//print_r($_SESSION[$wizard_name]); 
					//print_r('<br /><br />'); 
					
					/* Grab user data already provided from CONFIGWIZARD_MODE_GETSTAGE1HTML */
					
					$tab_selected = grab_array_var($inargs,'emcclariion-tab-selected','');
					//print_r('<br />tab_selected<br />'); 
					//print_r($tab_selected); 
					//print_r('<br /><br />'); 	
						
					/* There are different values based on which tab was selected */
					switch($tab_selected){
						case 'emcclariion-new':
							$sanname = grab_array_var($inargs,'sanname','');
							$spaaddress = grab_array_var($inargs,'spaaddress','');
							$spbaddress = grab_array_var($inargs,'spbaddress','');
							$spahostname = '';
							$spbhostname = '';
							break; /* End case 'emcclariion-new': */
						
						case 'emcclariion-existing':
							$spahostname = grab_array_var($inargs,'spahostname','');
							$spbhostname = grab_array_var($inargs,'spbhostname','');
							$sanname = '';
							$spaaddress = '';
							$spbaddress = '';
							break; /* End case 'emcclariion-existing': */
						} /* End switch($tab_selected){ */
					
					$spaselect = grab_array_var($inargs,'spaselect','');
					$spbselect = grab_array_var($inargs,'spbselect','');
					$monitoring_username = grab_array_var($inargs,'monitoring_username','');
					$monitoring_password = grab_array_var($inargs,'monitoring_password','');
					
					if ($spaselect == 'on') {
						$spaselectsetting = 'checked';
						}
					else {
						$spaselectsetting = '';
						}

					if ($spbselect == 'on') {
						$spbselectsetting = 'checked';
						}
					else {
						$spbselectsetting = '';
						}
				
					} /* End else { Continuing from CONFIGWIZARD_MODE_VALIDATESTAGE1DATA due to user error */
				}	/* End else { */
			
			/* Now we are creating the HTML for CONFIGWIZARD_MODE_GETSTAGE1HTML */ 
			$output = '
				<!-- This is how you link an external Cascading Style Sheets file -->
				<link href="../includes/configwizards/'.$wizard_name.'/'.$wizard_name.'.css" rel="stylesheet" type="text/css" />
				<!-- This is how you link an external Javascript/jQuery file -->
				<script type="text/javascript" src="../includes/configwizards/'.$wizard_name.'/'.$wizard_name.'.js"></script>

				<!-- This div sets the width -->
				<div style="width: 500px;">
				
				<div class="sectionTitle">Overview, Requirements, Installation and License</div>
				
				<p><div>
				<input type="button" class="emcclariion-button01" onclick="return emcclariion_toggleMe(\'para1\')" value="Overview">
				</div>
				<div id="para1" style="display:none">
				<br>
				This Wizard allows you to monitor an EMC CLARiiON SAN.<br><br>

				You can monitor the following components of the SAN:
				<ul class="a">
					<li><b>Storage Processors (SP)</b></li>
						<ul class="b"><li>Status of each SP</li></ul>
					<li><b>Storage Processor Information</b></li>
						<ul class="b"><li>Gets information on the SP (SP ID, Agent Revision, FLARE Revision, PROM Revision, Model/Type, Memory and Serial Number</li></ul>
					<li><b>Storage Processors Busy Percentage</b></li>
						<ul class="b"><li>SP Busy Percentage with performance data for graphing purposes</li></ul>
					<li><b>Disks</b></li>
						<ul class="b"><li>Status of the Physical Disks attached in all the Disk Array Enclosures (DAE\'s)</li></ul>
					<li><b>Cache</b></li>
						<ul class="b"><li>Status of the Read and Write Cache</li></ul>
					<li><b>Faults</b></li>
						<ul class="b"><li>Report any Faults on the SAN</li></ul>
					<li><b>Percentage Dirty Pages in Cache</b></li>
						<ul class="b"><li>Percentage Dirty Pages in Cache with Performance Data for graphing purposes</li></ul>
					<li><b>Port State</b></li>
						<ul class="b"></b><li>Status of the Ports on an SP</li></ul>
					<li><b>HBA State</b></li>
						<ul class="b"><li>Status of a client\'s host bust adapter (HBA) connection</li></ul>
					<li><b>LUNs</b></li>
						<ul class="b"><li>Check the status of a specific LUN and reports State, ID, Name, Size, Free Space, RAID Group Type and Percentage Rebuilt</li></ul>
					<li><b>RAID Groups</b></li>
						<ul class="b"><li>Checks the status of a specific RAID Group and reports the State, ID, RAID Group Type, Logical Size, Free Space, Percentage Defragmentation Complete, Percentage Expansion Complete</li></ul>
				</ul> 
				</div>
						
				<div>
				<input type="button" class="emcclariion-button01" onclick="return emcclariion_toggleMe(\'para2\')" value="Requirements">
				</div>
				<div id="para2" style="display:none">
				<br>
				There are a couple of components used that make all of this work.<br>
				<ul class="a">
					<li><b>The Nagios plugin check_emc_clariion.pl</b></li>
						<ul class="b"><li>The plugin is installed with this configuration wizard</li></ul>
						<ul class="b"><li>This uses an EMC app called naviseccli to communicate with the SAN</li></ul>
						<ul class="b"><li>More information about this plugin can be found <a href="http://exchange.nagios.org/directory/Plugins/Hardware/Storage-Systems/SAN-and-NAS/EMC-Clarion/check_emc_clariion-2Epl-maintained-by-Box293/details" target="_blank"><b>here</b></a></li></ul>
					<li><b>EMC Linux Navisphere Server Software</b></li>
						<ul class="b"><li>This is the software that communicates with the SAN</li></ul>
						<ul class="b"><li>You will need to <b>download</b> this from the EMC Powerlink website (see steps under Installation)</li></ul>
					<li><b>Enable SNMP on the SAN SPs</b></li>
						<ul class="b"><li>Follow the steps under Installation to do this</li></ul>
						<ul class="b"><li>You are not able to change the SNMP community string of the SAN, thats just the way it is</li></ul>
					<li><b>Create a Monitoring Account on the SAN</b></li>
						<ul class="b"><li>This is a read only account required for secure communication</li></ul>
						<ul class="b"><li>Follow the steps under Installation to do this</li></ul>
				</ul> 
				</div>

				<div>
				<input type="button" class="emcclariion-button01" onclick="return emcclariion_toggleMe(\'para3\')" value="Installation">
				</div>
				<div id="para3" style="display:none">
				
				<div>
				<input type="button" class="emcclariion-button02" onclick="return emcclariion_toggleMe(\'para4\')" value="Download EMC Linux Navisphere Server Software">
				</div>
				<div id="para4" style="display:none">
				<ul class="a">
					<li>Go here <a href="http://powerlink.emc.com" target="_blank"><b>http://powerlink.emc.com</b></a></li>
						<ul class="b"><li>Access to the Powerlink website requires you to have an account with EMC</li></ul>		
						<ul class="b"><li>Usually this is provided as part of your support contract with EMC</li></ul>
					<li>Once logged in navigate your way to:</li>
						<ul class="b"><li>Support > Software Downloads and Licensing > Downloads J-O > <b>Navisphere Server Software</b></li></ul>
					<li>Find the section <i>Linux Navisphere Server Software</i></li>
					<li>You need to download <b>Navisphere Host Agent/CLI (Linux)</b></li>
						<ul class="b"><li>For example: NaviCLI-Linux-64-x86-en_US-7.31.33.0.41-1.x86_64.rpm</li></ul>
						<ul class="b"><li>NOTE: There is a 32-bit and 64-bit version, the example above is the 64-bit version</li></ul>
				</ul> 
				If you can\'t find this download or section then you need to contact EMC as your account will only have access to downloads that your account is registered for.<br><br>
				</div>

				<div>
				<input type="button" class="emcclariion-button02" onclick="return emcclariion_toggleMe(\'para6\')" value="WinSCP Steps">
				</div>
				<div id="para6" style="display:none">
				<ul class="a">
					<li>We\'ll use <a href="http://winscp.net/eng/download.php" target="_blank"><b>WinSCP</b></a> to transfer the extracted file to <b>/tmp</b> on your Nagios XI host</li><li>Open <b>WinSCP</b></li>
						<ul class="b"><li>Hostname:	<i>IP address of your Nagios XI server</i></li></ul>
						<ul class="b"><li>Username:	<b>root</b></li></ul>
						<ul class="b"><li>Password:	Your root Password <i>(nagiosxi by default)</i></li></ul>
					<li><b>Click</b> the <b>Login</b> button</li>
					<li><b>Click</b> in the <b>right</b> pane</li>
					<li><b>Click</b> the <b>Open directory/bookmark</b> icon <i>[Remote > Goto > Open directory/bookmark]</i></li>
						<ul class="b"><li>In the remote directory type in <b>/tmp</b></li></ul>
						<ul class="b"><li>Click <b>OK</b></li></ul>
					<li>In the <b>left</b> pane browse to the location you downloaded <b>NaviCLI-Linux-64-x86-en_US-7.31.33.0.41-1.x86_64.rpm to</b></li>
					<li><b>Drag</b> the file <b>NaviCLI-Linux-64-x86-en_US-7.31.33.0.41-1.x86_64.rpm</b> from the <b>left</b> pane to the <b>right</b> pane</li>
						<ul class="b"><li><b>Click</b> the <b>Copy</b> button</li></ul>
						<ul class="b"><li><i>Wait for the file to copy</i></li></ul>
					<li>You can now <b>close</b> WinSCP
				</ul> 
				</div>
				
				<div>
				<input type="button" class="emcclariion-button02" onclick="return emcclariion_toggleMe(\'Uninstall-Navisphere\')" value="Un-install Existing EMC Linux Navisphere Server Software">
				</div>
				<div id="Uninstall-Navisphere" style="display:none">
				<br>
				This step is ONLY required if you have an older version of Navisphere installed.<br>
				<ul class="a">
					<li>Access the <i>Console</i> of your <b>Nagios XI</b> server or use <i>Putty</i> to connect to it remotely<br></li>
						<ul class="b"><li>Username:	<b>root</b></li></ul>
						<ul class="b"><li>Password:	Your root Password <i>(nagiosxi by default)</i></li></ul>
				</ul>
				To identify if you have an existing version:
				<ul class="a">
					<li>Type <b>rpm -qa | grep -i \'navi*\'</b> and press <b>Enter</b></li>
					<li>If you have an existing version it will return something like:</li>
						<ul class="b"><li>naviagentcli-6.24.6.0.32-1</li></ul>
					<li>To un-install this version</li>
					<li>Type <b>yum remove naviagentcli-6.24.6.0.32-1</b> and press <b>Enter</b></li>
					<li><i>Wait while it is un-installed</i></li>
					<li>You can leave your Console / Putty session active as you\'ll need it in the installation steps</li>
				</ul>
				</div>
				
				<div>
				<input type="button" class="emcclariion-button02" onclick="return emcclariion_toggleMe(\'para7\')" value="Install EMC Linux Navisphere Server Software">
				</div>
				<div id="para7" style="display:none">
				<ul class="a">
					<li>Access the <i>Console</i> of your <b>Nagios XI</b> server or use <i>Putty</i> to connect to it remotely<br></li>
						<ul class="b"><li>Username:	<b>root</b></li></ul>
						<ul class="b"><li>Password:	Your root Password <i>(nagiosxi by default)</i></li></ul>
					<li>Type <b>cd /tmp</b> and press <b>Enter</b></li>
					<li>Type <b>yum install NaviCLI-Linux-64-x86-en_US-7.31.33.0.41-1.x86_64.rpm</b> and press <b>Enter</b></li>
					<li><i>This will install the software and any required dependancies</i></li>
					<li><i>Wait for the installation to complete</i></li>
					<ul class="b">
						<li><b>NOTE:</b> Sometimes yum checks the rpm packages for signatures and won\'t install the rpm package if it isn\'t signed. To override this functionality:</li>
						<li>Type <b>yum install --nogpgcheck NaviCLI-Linux-64-x86-en_US-7.31.33.0.41-1.x86_64.rpm</b> and press <b>Enter</b></li>
					</ul>
					<li>Now we\'ve installed the Navisphere Host Agent/CLI we can delete the installer</li>
					<li>Type <b>rm -f NaviCLI-Linux-64-x86-en_US-7.31.33.0.41-1.x86_64.rpm</b> and press <b>Enter</b></li>
					<li>You can now exit your Console / Putty session</li>
				</ul>
				</div>

				<div>
				<input type="button" class="emcclariion-button02" onclick="return emcclariion_toggleMe(\'para8\')" value="Enable SNMP on the EMC SAN">
				</div>
				<div id="para8" style="display:none">
				<ul class="a">
					<li>This is done using the Navisphere web console</li>
					<li>Open a web browser to one of the SANs SP IP Address</li>
					<li>Login as an administrator</li>
					<li>Expand the tree of your SAN and <b>select</b> one of the <b>SPs</b></li>
					<li><b>Right</b> click the <b>SP</b> and select <b>Properties</b></li>
						<ul class="b"><li><b>Click</b> the <b>Network</b> tab</li></ul>
						<ul class="b"><li><b>Tick</b> the box <b>Enable/Disable processing of SNMP MIB read requests</b></li></ul>
						<ul class="b"><li>Click <b>Apply</b> and then <b>OK</b></li></ul>
					<li><b>Repeat</b> this step for each <b>SP</b> in your SAN</b></li>
					<li>You can leave Navisphere open as we will use it with the next step</li>
				</ul> 
				</div>

				<div>
				<input type="button" class="emcclariion-button02" onclick="return emcclariion_toggleMe(\'para9\')" value="Create a Monitoring Account">
				</div>
				<div id="para9" style="display:none">
				<ul class="a">
					<li>Continuing with your Navisphere web console session</li>
					<li><b>Click</b> the pull down menu <b>Tools</b> and select <b>Security > User Management...</b></li>
						<ul class="b"><li><b>Click</b> the <b>Add</b> button</li></ul>
						<ul class="b"><li>Username: <b>readonly</b></li></ul>
						<ul class="b"><li>Role: <b>monitor</b></li></ul>
						<ul class="b"><li>Global/Local: <b>global</b></li></ul>
						<ul class="b"><li>Password: <i>type a <b>strong</b> password</i></li></ul>
						<ul class="b"><li>Click <b>OK</b></li></ul>
						<ul class="b"><li>Click <b>Yes</b> to add the new user</li></ul>
						<ul class="b"><li>Click <b>OK</b> and then <b>OK</b> again</li></ul>
					<li>You can leave Navisphere open, you may need to refer to it when running the Wizard</li>
				</ul> 
				This completes all the steps required for the configuration wizard to work.<br><br>
				
				You can now run through the wizard to start monitoring your EMC SAN.<br><br>
				</div>
				
				</div>

				
				<div>
				<input type="button" class="emcclariion-button01" onclick="return emcclariion_toggleMe(\'para50\')" value="Work In Progress">
				</div>
				<div id="para50" style="display:none">
					<br>
					For the next revision of this wizard I will be updating the port state check. I plan to do the following:
					<ul class="a">
						<li>Query the SAN to get a list of all ports active on each SP</li>
						<li>Allow you to select all, one or many ports</li>
						<li>This requires updating the check_emc_clariion.pl script</li>
					</ul> 
					Stay tuned ...
					<br>
					<br>
				</div>
				
				
				<div>
				<input type="button" class="emcclariion-button01" onclick="return emcclariion_toggleMe(\'para60\')" value="Discount Offer">
				</div>
				<div id="para60" style="display:none">
					<br>
					Get a <b>10%</b> discount on your Nagios XI license when purchased through <a href="http://www.nagios.com/nagiosxi10?ref=box293" target="_blank"><b>this link</b></a>.
					<br>
					<br>
				</div>
				
				<div>
					<input type="button" class="emcclariion-button01" onclick="return emcclariion_toggleMe(\'Project-Hours\')" value="Project Hours">
				</div>
				<div id="Project-Hours" style="display:none">
					<br>
					Approximately 85 hours has been spent on this project. 
					<br>
					<br>
					In addition to this, approximately 30 hours has been spent on the check_emc_clariion.pl plugin.
					<br>
					<br>
				</div> <!-- End Project-Hours -->

				<div class="statusinfo-spacer5"> </div>
				
				<div>
					<input type="button" class="emcclariion-button01" onclick="return emcclariion_toggleMe(\'My-Projects\')" value="My Projects">
				</div>
				<div id="My-Projects" style="display:none">
					<br>
					I have created a handful of projects for Nagios XI for various reasons. Some of them are very useful indeed so I suggest you check them out, you can view them all here via <a href="http://exchange.nagios.org/directory/Owner/Box293/1" target="_blank">this link</a>.
					<br>
					<br>
				</div> <!-- End My-Projects -->
				
				<div>
				<input type="button" class="emcclariion-button01" onclick="return emcclariion_toggleMe(\'para10\')" value="License">
				</div>
				<div id="para10" style="display:none">
				<h3 style="text-align: center;">GNU GENERAL PUBLIC LICENSE</h3>
				<p style="text-align: center;">Version 3, 29 June 2007</p>

				<p>Copyright &copy; 2007 Free Software Foundation, Inc.
				 &lt;<a href="http://fsf.org/">http://fsf.org/</a>&gt;</p><p>
				 Everyone is permitted to copy and distribute verbatim copies
				 of this license document, but changing it is not allowed.</p>

				<h3><a name="preamble"></a>Preamble</h3>

				<p>The GNU General Public License is a free, copyleft license for
				software and other kinds of works.</p>

				<p>The licenses for most software and other practical works are designed
				to take away your freedom to share and change the works.  By contrast,
				the GNU General Public License is intended to guarantee your freedom to
				share and change all versions of a program--to make sure it remains free
				software for all its users.  We, the Free Software Foundation, use the
				GNU General Public License for most of our software; it applies also to
				any other work released this way by its authors.  You can apply it to
				your programs, too.</p>

				<p>When we speak of free software, we are referring to freedom, not
				price.  Our General Public Licenses are designed to make sure that you
				have the freedom to distribute copies of free software (and charge for
				them if you wish), that you receive source code or can get it if you
				want it, that you can change the software or use pieces of it in new
				free programs, and that you know you can do these things.</p>

				<p>To protect your rights, we need to prevent others from denying you
				these rights or asking you to surrender the rights.  Therefore, you have
				certain responsibilities if you distribute copies of the software, or if
				you modify it: responsibilities to respect the freedom of others.</p>

				<p>For example, if you distribute copies of such a program, whether
				gratis or for a fee, you must pass on to the recipients the same
				freedoms that you received.  You must make sure that they, too, receive
				or can get the source code.  And you must show them these terms so they
				know their rights.</p>

				<p>Developers that use the GNU GPL protect your rights with two steps:
				(1) assert copyright on the software, and (2) offer you this License
				giving you legal permission to copy, distribute and/or modify it.</p>

				<p>For the developers\' and authors\' protection, the GPL clearly explains
				that there is no warranty for this free software.  For both users\' and
				authors\' sake, the GPL requires that modified versions be marked as
				changed, so that their problems will not be attributed erroneously to
				authors of previous versions.</p>

				<p>Some devices are designed to deny users access to install or run
				modified versions of the software inside them, although the manufacturer
				can do so.  This is fundamentally incompatible with the aim of
				protecting users\' freedom to change the software.  The systematic
				pattern of such abuse occurs in the area of products for individuals to
				use, which is precisely where it is most unacceptable.  Therefore, we
				have designed this version of the GPL to prohibit the practice for those
				products.  If such problems arise substantially in other domains, we
				stand ready to extend this provision to those domains in future versions
				of the GPL, as needed to protect the freedom of users.</p>

				<p>Finally, every program is threatened constantly by software patents.
				States should not allow patents to restrict development and use of
				software on general-purpose computers, but in those that do, we wish to
				avoid the special danger that patents applied to a free program could
				make it effectively proprietary.  To prevent this, the GPL assures that
				patents cannot be used to render the program non-free.</p>

				<p>The precise terms and conditions for copying, distribution and
				modification follow.</p>

				<h3><a name="terms"></a>TERMS AND CONDITIONS</h3>

				<h4><a name="section0"></a>0. Definitions.</h4>

				<p>&ldquo;This License&rdquo; refers to version 3 of the GNU General Public License.</p>

				<p>&ldquo;Copyright&rdquo; also means copyright-like laws that apply to other kinds of
				works, such as semiconductor masks.</p>
				 
				<p>&ldquo;The Program&rdquo; refers to any copyrightable work licensed under this
				License.  Each licensee is addressed as &ldquo;you&rdquo;.  &ldquo;Licensees&rdquo; and
				&ldquo;recipients&rdquo; may be individuals or organizations.</p>

				<p>To &ldquo;modify&rdquo; a work means to copy from or adapt all or part of the work
				in a fashion requiring copyright permission, other than the making of an
				exact copy.  The resulting work is called a &ldquo;modified version&rdquo; of the
				earlier work or a work &ldquo;based on&rdquo; the earlier work.</p>

				<p>A &ldquo;covered work&rdquo; means either the unmodified Program or a work based
				on the Program.</p>

				<p>To &ldquo;propagate&rdquo; a work means to do anything with it that, without
				permission, would make you directly or secondarily liable for
				infringement under applicable copyright law, except executing it on a
				computer or modifying a private copy.  Propagation includes copying,
				distribution (with or without modification), making available to the
				public, and in some countries other activities as well.</p>

				<p>To &ldquo;convey&rdquo; a work means any kind of propagation that enables other
				parties to make or receive copies.  Mere interaction with a user through
				a computer network, with no transfer of a copy, is not conveying.</p>

				<p>An interactive user interface displays &ldquo;Appropriate Legal Notices&rdquo;
				to the extent that it includes a convenient and prominently visible
				feature that (1) displays an appropriate copyright notice, and (2)
				tells the user that there is no warranty for the work (except to the
				extent that warranties are provided), that licensees may convey the
				work under this License, and how to view a copy of this License.  If
				the interface presents a list of user commands or options, such as a
				menu, a prominent item in the list meets this criterion.</p>

				<h4><a name="section1"></a>1. Source Code.</h4>

				<p>The &ldquo;source code&rdquo; for a work means the preferred form of the work
				for making modifications to it.  &ldquo;Object code&rdquo; means any non-source
				form of a work.</p>

				<p>A &ldquo;Standard Interface&rdquo; means an interface that either is an official
				standard defined by a recognized standards body, or, in the case of
				interfaces specified for a particular programming language, one that
				is widely used among developers working in that language.</p>

				<p>The &ldquo;System Libraries&rdquo; of an executable work include anything, other
				than the work as a whole, that (a) is included in the normal form of
				packaging a Major Component, but which is not part of that Major
				Component, and (b) serves only to enable use of the work with that
				Major Component, or to implement a Standard Interface for which an
				implementation is available to the public in source code form.  A
				&ldquo;Major Component&rdquo;, in this context, means a major essential component
				(kernel, window system, and so on) of the specific operating system
				(if any) on which the executable work runs, or a compiler used to
				produce the work, or an object code interpreter used to run it.</p>

				<p>The &ldquo;Corresponding Source&rdquo; for a work in object code form means all
				the source code needed to generate, install, and (for an executable
				work) run the object code and to modify the work, including scripts to
				control those activities.  However, it does not include the work\'s
				System Libraries, or general-purpose tools or generally available free
				programs which are used unmodified in performing those activities but
				which are not part of the work.  For example, Corresponding Source
				includes interface definition files associated with source files for
				the work, and the source code for shared libraries and dynamically
				linked subprograms that the work is specifically designed to require,
				such as by intimate data communication or control flow between those
				subprograms and other parts of the work.</p>

				<p>The Corresponding Source need not include anything that users
				can regenerate automatically from other parts of the Corresponding
				Source.</p>

				<p>The Corresponding Source for a work in source code form is that
				same work.</p>

				<h4><a name="section2"></a>2. Basic Permissions.</h4>

				<p>All rights granted under this License are granted for the term of
				copyright on the Program, and are irrevocable provided the stated
				conditions are met.  This License explicitly affirms your unlimited
				permission to run the unmodified Program.  The output from running a
				covered work is covered by this License only if the output, given its
				content, constitutes a covered work.  This License acknowledges your
				rights of fair use or other equivalent, as provided by copyright law.</p>

				<p>You may make, run and propagate covered works that you do not
				convey, without conditions so long as your license otherwise remains
				in force.  You may convey covered works to others for the sole purpose
				of having them make modifications exclusively for you, or provide you
				with facilities for running those works, provided that you comply with
				the terms of this License in conveying all material for which you do
				not control copyright.  Those thus making or running the covered works
				for you must do so exclusively on your behalf, under your direction
				and control, on terms that prohibit them from making any copies of
				your copyrighted material outside their relationship with you.</p>

				<p>Conveying under any other circumstances is permitted solely under
				the conditions stated below.  Sublicensing is not allowed; section 10
				makes it unnecessary.</p>

				<h4><a name="section3"></a>3. Protecting Users\' Legal Rights From Anti-Circumvention Law.</h4>

				<p>No covered work shall be deemed part of an effective technological
				measure under any applicable law fulfilling obligations under article
				11 of the WIPO copyright treaty adopted on 20 December 1996, or
				similar laws prohibiting or restricting circumvention of such
				measures.</p>

				<p>When you convey a covered work, you waive any legal power to forbid
				circumvention of technological measures to the extent such circumvention
				is effected by exercising rights under this License with respect to
				the covered work, and you disclaim any intention to limit operation or
				modification of the work as a means of enforcing, against the work\'s
				users, your or third parties\' legal rights to forbid circumvention of
				technological measures.</p>

				<h4><a name="section4"></a>4. Conveying Verbatim Copies.</h4>

				<p>You may convey verbatim copies of the Program\'s source code as you
				receive it, in any medium, provided that you conspicuously and
				appropriately publish on each copy an appropriate copyright notice;
				keep intact all notices stating that this License and any
				non-permissive terms added in accord with section 7 apply to the code;
				keep intact all notices of the absence of any warranty; and give all
				recipients a copy of this License along with the Program.</p>

				<p>You may charge any price or no price for each copy that you convey,
				and you may offer support or warranty protection for a fee.</p>

				<h4><a name="section5"></a>5. Conveying Modified Source Versions.</h4>

				<p>You may convey a work based on the Program, or the modifications to
				produce it from the Program, in the form of source code under the
				terms of section 4, provided that you also meet all of these conditions:</p>

				<ul>
				<li>a) The work must carry prominent notices stating that you modified
					it, and giving a relevant date.</li>

				<li>b) The work must carry prominent notices stating that it is
					released under this License and any conditions added under section
					7.  This requirement modifies the requirement in section 4 to
					&ldquo;keep intact all notices&rdquo;.</li>

				<li>c) You must license the entire work, as a whole, under this
					License to anyone who comes into possession of a copy.  This
					License will therefore apply, along with any applicable section 7
					additional terms, to the whole of the work, and all its parts,
					regardless of how they are packaged.  This License gives no
					permission to license the work in any other way, but it does not
					invalidate such permission if you have separately received it.</li>

				<li>d) If the work has interactive user interfaces, each must display
					Appropriate Legal Notices; however, if the Program has interactive
					interfaces that do not display Appropriate Legal Notices, your
					work need not make them do so.</li>
				</ul>

				<p>A compilation of a covered work with other separate and independent
				works, which are not by their nature extensions of the covered work,
				and which are not combined with it such as to form a larger program,
				in or on a volume of a storage or distribution medium, is called an
				&ldquo;aggregate&rdquo; if the compilation and its resulting copyright are not
				used to limit the access or legal rights of the compilation\'s users
				beyond what the individual works permit.  Inclusion of a covered work
				in an aggregate does not cause this License to apply to the other
				parts of the aggregate.</p>

				<h4><a name="section6"></a>6. Conveying Non-Source Forms.</h4>

				<p>You may convey a covered work in object code form under the terms
				of sections 4 and 5, provided that you also convey the
				machine-readable Corresponding Source under the terms of this License,
				in one of these ways:</p>

				<ul>
				<li>a) Convey the object code in, or embodied in, a physical product
					(including a physical distribution medium), accompanied by the
					Corresponding Source fixed on a durable physical medium
					customarily used for software interchange.</li>

				<li>b) Convey the object code in, or embodied in, a physical product
					(including a physical distribution medium), accompanied by a
					written offer, valid for at least three years and valid for as
					long as you offer spare parts or customer support for that product
					model, to give anyone who possesses the object code either (1) a
					copy of the Corresponding Source for all the software in the
					product that is covered by this License, on a durable physical
					medium customarily used for software interchange, for a price no
					more than your reasonable cost of physically performing this
					conveying of source, or (2) access to copy the
					Corresponding Source from a network server at no charge.</li>

				<li>c) Convey individual copies of the object code with a copy of the
					written offer to provide the Corresponding Source.  This
					alternative is allowed only occasionally and noncommercially, and
					only if you received the object code with such an offer, in accord
					with subsection 6b.</li>

				<li>d) Convey the object code by offering access from a designated
					place (gratis or for a charge), and offer equivalent access to the
					Corresponding Source in the same way through the same place at no
					further charge.  You need not require recipients to copy the
					Corresponding Source along with the object code.  If the place to
					copy the object code is a network server, the Corresponding Source
					may be on a different server (operated by you or a third party)
					that supports equivalent copying facilities, provided you maintain
					clear directions next to the object code saying where to find the
					Corresponding Source.  Regardless of what server hosts the
					Corresponding Source, you remain obligated to ensure that it is
					available for as long as needed to satisfy these requirements.</li>

				<li>e) Convey the object code using peer-to-peer transmission, provided
					you inform other peers where the object code and Corresponding
					Source of the work are being offered to the general public at no
					charge under subsection 6d.</li>
				</ul>

				<p>A separable portion of the object code, whose source code is excluded
				from the Corresponding Source as a System Library, need not be
				included in conveying the object code work.</p>

				<p>A &ldquo;User Product&rdquo; is either (1) a &ldquo;consumer product&rdquo;, which means any
				tangible personal property which is normally used for personal, family,
				or household purposes, or (2) anything designed or sold for incorporation
				into a dwelling.  In determining whether a product is a consumer product,
				doubtful cases shall be resolved in favor of coverage.  For a particular
				product received by a particular user, &ldquo;normally used&rdquo; refers to a
				typical or common use of that class of product, regardless of the status
				of the particular user or of the way in which the particular user
				actually uses, or expects or is expected to use, the product.  A product
				is a consumer product regardless of whether the product has substantial
				commercial, industrial or non-consumer uses, unless such uses represent
				the only significant mode of use of the product.</p>

				<p>&ldquo;Installation Information&rdquo; for a User Product means any methods,
				procedures, authorization keys, or other information required to install
				and execute modified versions of a covered work in that User Product from
				a modified version of its Corresponding Source.  The information must
				suffice to ensure that the continued functioning of the modified object
				code is in no case prevented or interfered with solely because
				modification has been made.</p>

				<p>If you convey an object code work under this section in, or with, or
				specifically for use in, a User Product, and the conveying occurs as
				part of a transaction in which the right of possession and use of the
				User Product is transferred to the recipient in perpetuity or for a
				fixed term (regardless of how the transaction is characterized), the
				Corresponding Source conveyed under this section must be accompanied
				by the Installation Information.  But this requirement does not apply
				if neither you nor any third party retains the ability to install
				modified object code on the User Product (for example, the work has
				been installed in ROM).</p>

				<p>The requirement to provide Installation Information does not include a
				requirement to continue to provide support service, warranty, or updates
				for a work that has been modified or installed by the recipient, or for
				the User Product in which it has been modified or installed.  Access to a
				network may be denied when the modification itself materially and
				adversely affects the operation of the network or violates the rules and
				protocols for communication across the network.</p>

				<p>Corresponding Source conveyed, and Installation Information provided,
				in accord with this section must be in a format that is publicly
				documented (and with an implementation available to the public in
				source code form), and must require no special password or key for
				unpacking, reading or copying.</p>

				<h4><a name="section7"></a>7. Additional Terms.</h4>

				<p>&ldquo;Additional permissions&rdquo; are terms that supplement the terms of this
				License by making exceptions from one or more of its conditions.
				Additional permissions that are applicable to the entire Program shall
				be treated as though they were included in this License, to the extent
				that they are valid under applicable law.  If additional permissions
				apply only to part of the Program, that part may be used separately
				under those permissions, but the entire Program remains governed by
				this License without regard to the additional permissions.</p>

				<p>When you convey a copy of a covered work, you may at your option
				remove any additional permissions from that copy, or from any part of
				it.  (Additional permissions may be written to require their own
				removal in certain cases when you modify the work.)  You may place
				additional permissions on material, added by you to a covered work,
				for which you have or can give appropriate copyright permission.</p>

				<p>Notwithstanding any other provision of this License, for material you
				add to a covered work, you may (if authorized by the copyright holders of
				that material) supplement the terms of this License with terms:</p>

				<ul>
				<li>a) Disclaiming warranty or limiting liability differently from the
					terms of sections 15 and 16 of this License; or</li>

				<li>b) Requiring preservation of specified reasonable legal notices or
					author attributions in that material or in the Appropriate Legal
					Notices displayed by works containing it; or</li>

				<li>c) Prohibiting misrepresentation of the origin of that material, or
					requiring that modified versions of such material be marked in
					reasonable ways as different from the original version; or</li>

				<li>d) Limiting the use for publicity purposes of names of licensors or
					authors of the material; or</li>

				<li>e) Declining to grant rights under trademark law for use of some
					trade names, trademarks, or service marks; or</li>

				<li>f) Requiring indemnification of licensors and authors of that
					material by anyone who conveys the material (or modified versions of
					it) with contractual assumptions of liability to the recipient, for
					any liability that these contractual assumptions directly impose on
					those licensors and authors.</li>
				</ul>

				<p>All other non-permissive additional terms are considered &ldquo;further
				restrictions&rdquo; within the meaning of section 10.  If the Program as you
				received it, or any part of it, contains a notice stating that it is
				governed by this License along with a term that is a further
				restriction, you may remove that term.  If a license document contains
				a further restriction but permits relicensing or conveying under this
				License, you may add to a covered work material governed by the terms
				of that license document, provided that the further restriction does
				not survive such relicensing or conveying.</p>

				<p>If you add terms to a covered work in accord with this section, you
				must place, in the relevant source files, a statement of the
				additional terms that apply to those files, or a notice indicating
				where to find the applicable terms.</p>

				<p>Additional terms, permissive or non-permissive, may be stated in the
				form of a separately written license, or stated as exceptions;
				the above requirements apply either way.</p>

				<h4><a name="section8"></a>8. Termination.</h4>

				<p>You may not propagate or modify a covered work except as expressly
				provided under this License.  Any attempt otherwise to propagate or
				modify it is void, and will automatically terminate your rights under
				this License (including any patent licenses granted under the third
				paragraph of section 11).</p>

				<p>However, if you cease all violation of this License, then your
				license from a particular copyright holder is reinstated (a)
				provisionally, unless and until the copyright holder explicitly and
				finally terminates your license, and (b) permanently, if the copyright
				holder fails to notify you of the violation by some reasonable means
				prior to 60 days after the cessation.</p>

				<p>Moreover, your license from a particular copyright holder is
				reinstated permanently if the copyright holder notifies you of the
				violation by some reasonable means, this is the first time you have
				received notice of violation of this License (for any work) from that
				copyright holder, and you cure the violation prior to 30 days after
				your receipt of the notice.</p>

				<p>Termination of your rights under this section does not terminate the
				licenses of parties who have received copies or rights from you under
				this License.  If your rights have been terminated and not permanently
				reinstated, you do not qualify to receive new licenses for the same
				material under section 10.</p>

				<h4><a name="section9"></a>9. Acceptance Not Required for Having Copies.</h4>

				<p>You are not required to accept this License in order to receive or
				run a copy of the Program.  Ancillary propagation of a covered work
				occurring solely as a consequence of using peer-to-peer transmission
				to receive a copy likewise does not require acceptance.  However,
				nothing other than this License grants you permission to propagate or
				modify any covered work.  These actions infringe copyright if you do
				not accept this License.  Therefore, by modifying or propagating a
				covered work, you indicate your acceptance of this License to do so.</p>

				<h4><a name="section10"></a>10. Automatic Licensing of Downstream Recipients.</h4>

				<p>Each time you convey a covered work, the recipient automatically
				receives a license from the original licensors, to run, modify and
				propagate that work, subject to this License.  You are not responsible
				for enforcing compliance by third parties with this License.</p>

				<p>An &ldquo;entity transaction&rdquo; is a transaction transferring control of an
				organization, or substantially all assets of one, or subdividing an
				organization, or merging organizations.  If propagation of a covered
				work results from an entity transaction, each party to that
				transaction who receives a copy of the work also receives whatever
				licenses to the work the party\'s predecessor in interest had or could
				give under the previous paragraph, plus a right to possession of the
				Corresponding Source of the work from the predecessor in interest, if
				the predecessor has it or can get it with reasonable efforts.</p>

				<p>You may not impose any further restrictions on the exercise of the
				rights granted or affirmed under this License.  For example, you may
				not impose a license fee, royalty, or other charge for exercise of
				rights granted under this License, and you may not initiate litigation
				(including a cross-claim or counterclaim in a lawsuit) alleging that
				any patent claim is infringed by making, using, selling, offering for
				sale, or importing the Program or any portion of it.</p>

				<h4><a name="section11"></a>11. Patents.</h4>

				<p>A &ldquo;contributor&rdquo; is a copyright holder who authorizes use under this
				License of the Program or a work on which the Program is based.  The
				work thus licensed is called the contributor\'s &ldquo;contributor version&rdquo;.</p>

				<p>A contributor\'s &ldquo;essential patent claims&rdquo; are all patent claims
				owned or controlled by the contributor, whether already acquired or
				hereafter acquired, that would be infringed by some manner, permitted
				by this License, of making, using, or selling its contributor version,
				but do not include claims that would be infringed only as a
				consequence of further modification of the contributor version.  For
				purposes of this definition, &ldquo;control&rdquo; includes the right to grant
				patent sublicenses in a manner consistent with the requirements of
				this License.</p>

				<p>Each contributor grants you a non-exclusive, worldwide, royalty-free
				patent license under the contributor\'s essential patent claims, to
				make, use, sell, offer for sale, import and otherwise run, modify and
				propagate the contents of its contributor version.</p>

				<p>In the following three paragraphs, a &ldquo;patent license&rdquo; is any express
				agreement or commitment, however denominated, not to enforce a patent
				(such as an express permission to practice a patent or covenant not to
				sue for patent infringement).  To &ldquo;grant&rdquo; such a patent license to a
				party means to make such an agreement or commitment not to enforce a
				patent against the party.</p>

				<p>If you convey a covered work, knowingly relying on a patent license,
				and the Corresponding Source of the work is not available for anyone
				to copy, free of charge and under the terms of this License, through a
				publicly available network server or other readily accessible means,
				then you must either (1) cause the Corresponding Source to be so
				available, or (2) arrange to deprive yourself of the benefit of the
				patent license for this particular work, or (3) arrange, in a manner
				consistent with the requirements of this License, to extend the patent
				license to downstream recipients.  &ldquo;Knowingly relying&rdquo; means you have
				actual knowledge that, but for the patent license, your conveying the
				covered work in a country, or your recipient\'s use of the covered work
				in a country, would infringe one or more identifiable patents in that
				country that you have reason to believe are valid.</p>
				  
				<p>If, pursuant to or in connection with a single transaction or
				arrangement, you convey, or propagate by procuring conveyance of, a
				covered work, and grant a patent license to some of the parties
				receiving the covered work authorizing them to use, propagate, modify
				or convey a specific copy of the covered work, then the patent license
				you grant is automatically extended to all recipients of the covered
				work and works based on it.</p>

				<p>A patent license is &ldquo;discriminatory&rdquo; if it does not include within
				the scope of its coverage, prohibits the exercise of, or is
				conditioned on the non-exercise of one or more of the rights that are
				specifically granted under this License.  You may not convey a covered
				work if you are a party to an arrangement with a third party that is
				in the business of distributing software, under which you make payment
				to the third party based on the extent of your activity of conveying
				the work, and under which the third party grants, to any of the
				parties who would receive the covered work from you, a discriminatory
				patent license (a) in connection with copies of the covered work
				conveyed by you (or copies made from those copies), or (b) primarily
				for and in connection with specific products or compilations that
				contain the covered work, unless you entered into that arrangement,
				or that patent license was granted, prior to 28 March 2007.</p>

				<p>Nothing in this License shall be construed as excluding or limiting
				any implied license or other defenses to infringement that may
				otherwise be available to you under applicable patent law.</p>

				<h4><a name="section12"></a>12. No Surrender of Others\' Freedom.</h4>

				<p>If conditions are imposed on you (whether by court order, agreement or
				otherwise) that contradict the conditions of this License, they do not
				excuse you from the conditions of this License.  If you cannot convey a
				covered work so as to satisfy simultaneously your obligations under this
				License and any other pertinent obligations, then as a consequence you may
				not convey it at all.  For example, if you agree to terms that obligate you
				to collect a royalty for further conveying from those to whom you convey
				the Program, the only way you could satisfy both those terms and this
				License would be to refrain entirely from conveying the Program.</p>

				<h4><a name="section13"></a>13. Use with the GNU Affero General Public License.</h4>

				<p>Notwithstanding any other provision of this License, you have
				permission to link or combine any covered work with a work licensed
				under version 3 of the GNU Affero General Public License into a single
				combined work, and to convey the resulting work.  The terms of this
				License will continue to apply to the part which is the covered work,
				but the special requirements of the GNU Affero General Public License,
				section 13, concerning interaction through a network will apply to the
				combination as such.</p>

				<h4><a name="section14"></a>14. Revised Versions of this License.</h4>

				<p>The Free Software Foundation may publish revised and/or new versions of
				the GNU General Public License from time to time.  Such new versions will
				be similar in spirit to the present version, but may differ in detail to
				address new problems or concerns.</p>

				<p>Each version is given a distinguishing version number.  If the
				Program specifies that a certain numbered version of the GNU General
				Public License &ldquo;or any later version&rdquo; applies to it, you have the
				option of following the terms and conditions either of that numbered
				version or of any later version published by the Free Software
				Foundation.  If the Program does not specify a version number of the
				GNU General Public License, you may choose any version ever published
				by the Free Software Foundation.</p>

				<p>If the Program specifies that a proxy can decide which future
				versions of the GNU General Public License can be used, that proxy\'s
				public statement of acceptance of a version permanently authorizes you
				to choose that version for the Program.</p>

				<p>Later license versions may give you additional or different
				permissions.  However, no additional obligations are imposed on any
				author or copyright holder as a result of your choosing to follow a
				later version.</p>

				<h4><a name="section15"></a>15. Disclaimer of Warranty.</h4>

				<p>THERE IS NO WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY
				APPLICABLE LAW.  EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT
				HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM &ldquo;AS IS&rdquo; WITHOUT WARRANTY
				OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO,
				THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
				PURPOSE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM
				IS WITH YOU.  SHOULD THE PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF
				ALL NECESSARY SERVICING, REPAIR OR CORRECTION.</p>

				<h4><a name="section16"></a>16. Limitation of Liability.</h4>

				<p>IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
				WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MODIFIES AND/OR CONVEYS
				THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES, INCLUDING ANY
				GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE
				USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF
				DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD
				PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER PROGRAMS),
				EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF
				SUCH DAMAGES.</p>

				<h4><a name="section17"></a>17. Interpretation of Sections 15 and 16.</h4>

				<p>If the disclaimer of warranty and limitation of liability provided
				above cannot be given local legal effect according to their terms,
				reviewing courts shall apply local law that most closely approximates
				an absolute waiver of all civil liability in connection with the
				Program, unless a warranty or assumption of liability accompanies a
				copy of the Program in return for a fee.</p>

				<p>END OF TERMS AND CONDITIONS</p>
				<br>
				</div>
				</p>

				
				<div class="sectionTitle">EMC CLARiiON Details</div>
				
				
				
				<div id="emcclariion-containter-san-selection">
				
					The EMC CLARiiON has two SPs for redundancy (A and B). Each SP has it\'s own IP Address.<br><br>
				
					<div id="menubar">
						<input type="button"'; if ($tab_selected == 'emcclariion-new') {$output .=' class="emcclariion-menuheading2"';} else {$output .=' class="emcclariion-menuheading1"';} $output .=' id="id-emcclariion-new" onclick="emcclariion_ToggleMenu(\'emcclariion-new\')" value="New EMC CLARiiON">
						<input type="button"'; if ($tab_selected == 'emcclariion-existing') {$output .=' class="emcclariion-menuheading2"';} else {$output .=' class="emcclariion-menuheading1"';} $output .=' id="id-emcclariion-existing" onclick="emcclariion_ToggleMenu(\'emcclariion-existing\')" value="Existing EMC CLARiiON">
					</div>
					
					<input type="hidden" id="id-emcclariion-tab-selected" name="emcclariion-tab-selected" value="'.$tab_selected.'">
					
					<div id="emcclariion-new" name="emcclariion-new" class="emcclariion-togglediv"'; if ($tab_selected != 'emcclariion-new') {$output .=' style="display:none"';} $output .='> <!-- New EMC SAN -->
						<br>
						
						Select the SPs that you wish to monitor and provide their relevant IP Addresses or FQDN. Each SP you select to monitor will have a host object created.<br><br>
						
						Please provide a name for the SAN. The name you type will be appeneded with the SP being monitored. For example:
						<ul class="a">
							<li>If you typed <b>san01</b> each SP host object will be called:</li>
								<ul class="b"><li>san01 SPA</li></ul>
								<ul class="b"><li>san01 SPB</li></ul>
							<li>If you typed <b>SAN Over There</b> each SP host object will be called:</li>
								<ul class="b"><li>SAN Over There SPA</li></ul>
								<ul class="b"><li>SAN Over There SPB</li></ul>
						</ul>
						
						
						<br>
						Name and FQDN are cAse SeNSAtive!<br><br>
						<table>
						<tr>
						<td valign="middle"><label>Name:</label></td>
						<td><input type="text" size="40" name="sanname" id="sanname" value="'.$sanname.'" class="textfield" /></td>
						</tr>
						</table>
						<table>
						<tr>
						<td valign="middle"><label>SPA</label></td>
						<td><input type="checkbox" class="checkbox" name="spaselect" onclick="emcclariionTestCheckbox(\'spaselect\')" '.$spaselectsetting.'>
						<td valign="middle"><label>IP Address or FQDN:</label></td>
						<td><input type="text" size="40" name="spaaddress" id="spaaddress" value="'.$spaaddress.'" class="textfield" /></td>
						</tr>
						<tr>
						<td valign="middle"><label>SPB</label></td>
						<td><input type="checkbox" class="checkbox" name="spbselect" '.$spbselectsetting.'></td>
						<td valign="middle"><label>IP Address or FQDN:</label></td>
						<td><input type="text" size="40" name="spbaddress" id="spbaddress" value="'.$spbaddress.'" class="textfield" /></td>
						</tr>
						</table>
					</div> <!-- End emcclariion-new -->
				
				
					<div id="emcclariion-existing" name="emcclariion-existing" class="emcclariion-togglediv"'; if ($tab_selected != 'emcclariion-existing') {$output .=' style="display:none"';} $output .='> <!-- Exisitng EMC SAN -->
						<br>
						Select the existing SAN SPs.<br><br>
						
						<table>
						<tr>
						<td valign="middle"><label>SPA</label></td>
						<td><input type="checkbox" class="checkbox" name="spaselect" '.$spaselectsetting.'>
						<td valign="middle"><label>IP Address or FQDN:</label></td>
						<td>
							<select name="spahostname" id="spahostname" onChange="emcclariion_get_existing_host_address()">
								<option value=""></option>
								';
								$args = array(
									'is_active' => 1,
									'orderby' => 'host_name:a',
									);
								$xmlhosts = get_xml_host_objects($args);
								foreach($xmlhosts->host as $h){
									$hname = strval($h->host_name);
									$hdesc = $hname;
									$halias = strval($h->alias);
									if($halias != $hname && $halias != '')
										$hdesc .= ' ('.$halias.')';
									$output .= '<option value="'.$hname.'" '.is_selected($spaaddress,$hname).' '; if ($spahostname == $hname) {$output .= 'selected';} $output .='>'.$hdesc.'</option>';
									}
									
								$output.='
							</select>
						</td>
						</tr>
						<tr>
						<td valign="middle"><label>SPB</label></td>
						<td><input type="checkbox" class="checkbox" name="spbselect" '.$spbselectsetting.'></td>
						<td valign="middle"><label>IP Address or FQDN:</label></td>
						<td>
							<select name="spbhostname" id="spbhostname" onChange="emcclariion_get_existing_host_address()">
								<option value=""></option>
								';
								$args = array(
									'is_active' => 1,
									'orderby' => 'host_name:a',
									);
								$xmlhosts = get_xml_host_objects($args);
								foreach($xmlhosts->host as $h){
									$hname = strval($h->host_name);
									$hdesc = $hname;
									$halias = strval($h->alias);
									if($halias != $hname && $halias != '')
										$hdesc .=' ('.$halias.')';
									$output .= '<option value="'.$hname.'" '.is_selected($spbaddress,$hname).' '; if ($spbhostname == $hname) {$output .= 'selected';} $output .='>'.$hdesc.'</option>';
									}
									
								$output.='
							</select>
						</td>
						</tr>
						</table>
						<div id="emcclariion_get_existing_host_address_result">
							<!-- Host Address results will go here -->
						</div>
						
					</div> <!-- End emcclariion-existing -->
					';
				if ($spaselectsetting == 'checked' or $spbselectsetting == 'checked') {
					$output .= '
						<script type="text/javascript">
							$(document).ready(function() {
								emcclariion_get_existing_host_address();
								}); 
						</script>
						';
					}
				$output.='
				</div> <!-- End emcclariion-containter-san-selection -->
				
				<div class="emcclariion-spacer45"> </div>
				
				<div class="sectionTitle">Monitoring Account</div>
				<p>
				This is the read only account required for secure communication<br>
				
				<table>
				<tr>
				<td valign="middle" style="width: 80px;"><label>Username:</label></td>
				<td><input type="text" size="40" name="monitoring_username" id="monitoring_username" value="'.$monitoring_username.'" class="textfield" /></td>
				</tr>
				<tr>
				<td valign="middle" style="width: 80px;"><label>Password:</label></td>
				<td><input type="password" size="40" name="monitoring_password" id="monitoring_password" value="'.$monitoring_password.'" class="textfield" /></td>
				</tr>
				</table>
				</p>

				
				<br>
				
				<input type="button" id="id-emcclariion_test_account" onclick="emcclariion_test_account()" value="Test Monitoring Account">
				
				<br><br>
				
				<div id="emcclariion_test_account_result"> 
					<!-- Test results will go here -->
				</div>
				
				<br>
				
				</div> <!-- This is the end of the div for width -->
			';
			/* The quote and semicolon ends HTML for CONFIGWIZARD_MODE_GETSTAGE1HTML */ 
			/* $output will be passed back to XI framework and rendered to browser */
			/* The next line ends CONFIGWIZARD_MODE_GETSTAGE1HTML */
			break;

			
		/* Form validation for CONFIGWIZARD_MODE_GETSTAGE1HTML */
		case CONFIGWIZARD_MODE_VALIDATESTAGE1DATA:		
			/* The following THREE lines can be enabled for debugging purposes */
			//print_r('<br />post CONFIGWIZARD_MODE_VALIDATESTAGE1DATA<br />'); 
			//print_r($_POST); 
			//print_r('<br /><br />'); 
			
			/* This defines $back variable, used for determining if the Back button */
			/* was clicked when the user was on CONFIGWIZARD_MODE_GETSTAGE2HTML */
			$back = htmlentities(grab_array_var($_POST,'backButton',false),ENT_QUOTES); 	
			
			/* If the user came back from CONFIGWIZARD_MODE_GETSTAGE3HTML then we don't need to revalidate and check for errors */
			if ($back) break;	
			
			/* Get variables that were passed to us AND check for errors before proceeding to CONFIGWIZARD_MODE_GETSTAGE2HTML */
				/* NOTE: grab_array_var is an XI wrapper function to fetch values 'if they exist' */
				/* USAGE: grab_array_var($array, $variable, $defaultValue) */
			
			/* Set the error count to 0 */
			$errors = 0;
			/* Create the error messages array */
			$errmsg = array();
			
			$tab_selected = grab_array_var($inargs,'emcclariion-tab-selected','');
			$spaselect = grab_array_var($inargs,'spaselect','');
			$spbselect = grab_array_var($inargs,'spbselect','');
			
			//print_r('<br>spaselect: '.$spaselect.'<br>');
			//print_r('<br>spbselect: '.$spbselect.'<br>');
			
			/* There are different values based on which tab was selected */
			switch($tab_selected){
				case 'emcclariion-new':
					$sanname = grab_array_var($inargs,'sanname','');
					$spaaddress = grab_array_var($inargs,'spaaddress','');
					$spbaddress = grab_array_var($inargs,'spbaddress','');
					
					if (have_value($sanname) == false) {
						$errmsg[$errors++] = 'A Name for the SAN has not been supplied.';
						}
					else if (preg_match('/[^0-9a-zA-Z\ \.\:\_\-\[\]]/',$sanname)) {
						$errmsg[$errors++] = 'The SAN Name $sanname contains invalid characters.';
						}
					
					if (have_value($spaselect) == true) {
						if (have_value($spaaddress) == false) {
							$errmsg[$errors++] = 'No address specified for SPA.';
							}
						else if (!valid_ip($spaaddress)) {
							$errmsg[$errors++] = 'Invalid IP address for SPA.';
							}
						}
					
					if (have_value($spbselect) == true) {
						if (have_value($spbaddress) == false) {
							$errmsg[$errors++] = 'No address specified for SPB.';
							}
						else if (!valid_ip($spbaddress)) {
							$errmsg[$errors++] = 'Invalid IP address for SPB.';
							}
						}
					break; /* End case 'emcclariion-new': */
				
				case 'emcclariion-existing':
					$spahostname = grab_array_var($inargs,'spahostname','');
					$spbhostname = grab_array_var($inargs,'spbhostname','');
					
					if (have_value($spaselect) == true) {
						if (have_value($spahostname) == false) {
							$errmsg[$errors++] = 'No existing host selected for SPA.';
							}
						}
					if (have_value($spbselect) == true) {
						if (have_value($spbhostname) == false) {
							$errmsg[$errors++] = 'No existing host selected for SPB.';
							}
						}
					break; /* End case 'emcclariion-existing': */
				} /* End switch($tab_selected){ */
			
			$monitoring_username = grab_array_var($inargs,'monitoring_username','');
			$monitoring_password = grab_array_var($inargs,'monitoring_password','');
			
			if ($spaselect == '') {
				if ($spbselect == '') {
					$errmsg[$errors++] = 'You need to select SPA, SPB or both.';
					}
				}
			
			if ($monitoring_username == '') {
				$errmsg[$errors++] = 'The Monitoring Username for the SAN has not been supplied.';
				}
			else if (preg_match('/[^0-9a-zA-Z\ \.\:\_\-\[\]]/',$monitoring_username)) {
				$errmsg[$errors++] = 'The Monitoring Username $monitoring_username contains invalid characters.';
				}

			if ($monitoring_password == '') {
				$errmsg[$errors++] = 'The Monitoring Password for the SAN has not been supplied.';
				}
			else if (preg_match('/[^0-9a-zA-Z\ \.\:\_\-\[\]]/',$monitoring_password)) {
				$errmsg[$errors++] = 'The Monitoring Password contains invalid characters.';
				}
			
			/* Check to see if the $errors array contains errors */
			if ($errors>0){
				$outargs[CONFIGWIZARD_ERROR_MESSAGES] = $errmsg;
				$result = 1;
				}
			
			/* The next line ends CONFIGWIZARD_MODE_VALIDATESTAGE1DATA */
			break;

			
		case CONFIGWIZARD_MODE_GETSTAGE2HTML:
			/* This defines $back variable, used for determining if the Back button */
			/* was clicked when the user was on CONFIGWIZARD_MODE_GETSTAGE3HTML */
			$back = htmlentities(grab_array_var($_POST,'backButton',false),ENT_QUOTES); 		
			
			/* The following THREE lines can be enabled for debugging purposes */
			//print_r('<br />post CONFIGWIZARD_MODE_GETSTAGE2HTML<br />'); 
			//print_r($_POST); 
			//print_r('<br /><br />'); 

			/* The following THREE lines can be enabled for debugging purposes */
			//print_r('<br />session CONFIGWIZARD_MODE_GETSTAGE2HTML<br />'); 
			//print_r($_SESSION); 
			//print_r('<br /><br />'); 
			
			/* The following THREE lines can be enabled for debugging purposes */
			//print_r('<br />session[emcclariion] CONFIGWIZARD_MODE_GETSTAGE2HTML<br />'); 
			//print_r($_SESSION[$wizard_name]); 
			//print_r('<br /><br />'); 
			
			/* Check to see if we are coming back from CONFIGWIZARD_MODE_GETSTAGE3HTML */
			if ($back == 'Back') {
				/* User pressed Back button on CONFIGWIZARD_MODE_GETSTAGE3HTML */
				/* The following line can be enabled for debugging purposes */
				//print_r('<br />User pressed Back button on CONFIGWIZARD_MODE_GETSTAGE3HTML<br />'); 
				
				/* Back was clicked when user was on CONFIGWIZARD_MODE_GETSTAGE3HTML so we need to define some variables */
				$tab_selected = $_SESSION[$wizard_name]['tab_selected'];
				$spaselect = $_SESSION[$wizard_name]['spaselect'];
				$spbselect = $_SESSION[$wizard_name]['spbselect'];
				$monitoring_username = $_SESSION[$wizard_name]['monitoring_username'];
				$monitoring_password = $_SESSION[$wizard_name]['monitoring_password'];
				
				/* There are different values based on which tab was selected */
				switch($tab_selected){
					case 'emcclariion-new':
						$sanname = $_SESSION[$wizard_name]['sanname'];
						$spaaddress = $_SESSION[$wizard_name]['spaaddress'];
						$spbaddress = $_SESSION[$wizard_name]['spbaddress'];
						break; /* End case 'emcclariion-new': */
					
					case 'emcclariion-existing':
						$spahostname = $_SESSION[$wizard_name]['spahostname'];
						$spbhostname = $_SESSION[$wizard_name]['spbhostname'];
						break; /* End case 'emcclariion-existing': */
					} /* End switch($tab_selected){ */
				
				if ($_SESSION[$wizard_name]['spa_monitoring_spa'] == 'on') {
						$spa_monitoring_spa_setting = 'checked';
						}
					else {
						$spa_monitoring_spa_setting = '';
						}
				
					if ($_SESSION[$wizard_name]['spa_monitoring_spb'] == 'on') {
						$spa_monitoring_spb_setting = 'checked';
						}
					else {
						$spa_monitoring_spb_setting = '';
						}
						
					if ($_SESSION[$wizard_name]['spb_monitoring_spa'] == 'on') {
						$spb_monitoring_spa_setting = 'checked';
						}
					else {
						$spb_monitoring_spa_setting = '';
						}
					
					if ($_SESSION[$wizard_name]['spb_monitoring_spb'] == 'on') {
						$spb_monitoring_spb_setting = 'checked';
						}
					else {
						$spb_monitoring_spb_setting = '';
						}
				
					if ($_SESSION[$wizard_name]['spa_monitoring_information'] == 'on') {
						$spa_monitoring_information_setting = 'checked';
						}
					else {
						$spa_monitoring_information_setting = '';
						}
				
					if ($_SESSION[$wizard_name]['spb_monitoring_information'] == 'on') {
						$spb_monitoring_information_setting = 'checked';
						}
					else {
						$spb_monitoring_information_setting = '';
						}
				
					if ($_SESSION[$wizard_name]['spa_monitoring_sp_busy_select'] == 'on') {
						$spa_monitoring_sp_busy_setting = 'checked';
						}
					else {
						$spa_monitoring_sp_busy_setting = '';
						}
				
					if ($_SESSION[$wizard_name]['spa_monitoring_sp_busy_warn_select'] == 'on') {
						$spa_monitoring_sp_busy_warn_setting = 'checked';
						}
					else {
						$spa_monitoring_sp_busy_warn_setting = '';
						}
				
					if ($_SESSION[$wizard_name]['spa_monitoring_sp_busy_warn_value'] != '') {
						$spa_monitoring_sp_busy_warn_value_setting = $_SESSION[$wizard_name]['spa_monitoring_sp_busy_warn_value'];
						}
					else {
						$spa_monitoring_sp_busy_warn_value_setting = '';
						}
						
					if ($_SESSION[$wizard_name]['spa_monitoring_sp_busy_crit_select'] == 'on') {
						$spa_monitoring_sp_busy_crit_setting = 'checked';
						}
					else {
						$spa_monitoring_sp_busy_crit_setting = '';
						}
				
					if ($_SESSION[$wizard_name]['spa_monitoring_sp_busy_crit_value'] != '') {
						$spa_monitoring_sp_busy_crit_value_setting = $_SESSION[$wizard_name]['spa_monitoring_sp_busy_crit_value'];
						}
					else {
						$spa_monitoring_sp_busy_crit_value_setting = '';
						}
				
					if ($_SESSION[$wizard_name]['spb_monitoring_sp_busy_select'] == 'on') {
						$spb_monitoring_sp_busy_setting = 'checked';
						}
					else {
						$spb_monitoring_sp_busy_setting = '';
						}
				
					if ($_SESSION[$wizard_name]['spb_monitoring_sp_busy_warn_select'] == 'on') {
						$spb_monitoring_sp_busy_warn_setting = 'checked';
						}
					else {
						$spb_monitoring_sp_busy_warn_setting = '';
						}
				
					if ($_SESSION[$wizard_name]['spb_monitoring_sp_busy_warn_value'] != '') {
						$spb_monitoring_sp_busy_warn_value_setting = $_SESSION[$wizard_name]['spb_monitoring_sp_busy_warn_value'];
						}
					else {
						$spb_monitoring_sp_busy_warn_value_setting = '';
						}
						
					if ($_SESSION[$wizard_name]['spb_monitoring_sp_busy_crit_select'] == 'on') {
						$spb_monitoring_sp_busy_crit_setting = 'checked';
						}
					else {
						$spb_monitoring_sp_busy_crit_setting = '';
						}
				
					if ($_SESSION[$wizard_name]['spb_monitoring_sp_busy_crit_value'] != '') {
						$spb_monitoring_sp_busy_crit_value_setting = $_SESSION[$wizard_name]['spb_monitoring_sp_busy_crit_value'];
						}
					else {
						$spb_monitoring_sp_busy_crit_value_setting = '';
						}
				
					if ($_SESSION[$wizard_name]['spa_monitoring_disks'] == 'on') {
						$spa_monitoring_disks_setting = 'checked';
						}
					else {
						$spa_monitoring_disks_setting = '';
						}
				
					if ($_SESSION[$wizard_name]['spb_monitoring_disks'] == 'on') {
						$spb_monitoring_disks_setting = 'checked';
						}
					else {
						$spb_monitoring_disks_setting = '';
						}
				
					if ($_SESSION[$wizard_name]['spa_monitoring_cache'] == 'on') {
						$spa_monitoring_cache_setting = 'checked';
						}
					else {
						$spa_monitoring_cache_setting = '';
						}
				
					if ($_SESSION[$wizard_name]['spb_monitoring_cache'] == 'on') {
						$spb_monitoring_cache_setting = 'checked';
						}
					else {
						$spb_monitoring_cache_setting = '';
						}
					
					if ($_SESSION[$wizard_name]['spa_monitoring_faults'] == 'on') {
						$spa_monitoring_faults_setting = 'checked';
						}
					else {
						$spa_monitoring_faults_setting = '';
						}
				
					if ($_SESSION[$wizard_name]['spb_monitoring_faults'] == 'on') {
						$spb_monitoring_faults_setting = 'checked';
						}
					else {
						$spb_monitoring_faults_setting = '';
						}
				
					if ($_SESSION[$wizard_name]['spa_monitoring_pdp'] == 'on') {
						$spa_monitoring_pdp_setting = 'checked';
						}
					else {
						$spa_monitoring_pdp_setting = '';
						}
				
					if ($_SESSION[$wizard_name]['spb_monitoring_pdp'] == 'on') {
						$spb_monitoring_pdp_setting = 'checked';
						}
					else {
						$spb_monitoring_pdp_setting = '';
						}
				
					if ($_SESSION[$wizard_name]['spa_monitoring_portstate_spa'] == 'on') {
						$spa_monitoring_portstate_spa_setting = 'checked';
						}
					else {
						$spa_monitoring_portstate_spa_setting = '';
						}
					
					if ($_SESSION[$wizard_name]['spa_monitoring_portstate_spb'] == 'on') {
						$spa_monitoring_portstate_spb_setting = 'checked';
						}
					else {
						$spa_monitoring_portstate_spb_setting = '';
						}
				
					if ($_SESSION[$wizard_name]['spb_monitoring_portstate_spa'] == 'on') {
						$spb_monitoring_portstate_spa_setting = 'checked';
						}
					else {
						$spb_monitoring_portstate_spa_setting = '';
						}
				
					if ($_SESSION[$wizard_name]['spb_monitoring_portstate_spb'] == 'on') {
						$spb_monitoring_portstate_spb_setting = 'checked';
						}
					else {
						$spb_monitoring_portstate_spb_setting = '';
						}
				
				$serviceargs = $_SESSION[$wizard_name]['serviceargs'];
				
				/* The following THREE lines can be enabled for debugging purposes */
				//print_r('<br />serviceargs<br />'); 
				//print_r($serviceargs); 
				//print_r('<br /><br />'); 
	
				for($w = 0; $w < 9; $w++) {
					if (isset($serviceargs['client_select'][$w])) {
						$serviceargs['client_select']['setting'][$w] = 'checked';
						}
					else {
						$serviceargs['client_select']['setting'][$w] = '';
						}
					
					if ($serviceargs['client_name'][$w] != '') {
						$serviceargs['client_name']['setting'][$w] = $serviceargs['client_name'][$w];
						}
					else {
						$serviceargs['client_name']['setting'][$w] = '';
						}
						
					if (isset($serviceargs['client_select_spa'][$w])) {
						$serviceargs['client_select_spa']['setting'][$w] = 'checked';
						}
					else {
						$serviceargs['client_select_spa']['setting'][$w] = '';
						}
			
					if (isset($serviceargs['client_select_spb'][$w])) {
						$serviceargs['client_select_spb']['setting'][$w] = 'checked';
						}
					else {
						$serviceargs['client_select_spb']['setting'][$w] = '';
						}
						
					if ($serviceargs['client_number_paths'][$w] != '') {
						$serviceargs['client_number_paths']['setting'][$w] = $serviceargs['client_number_paths'][$w];
						}
					else {
						$serviceargs['client_number_paths']['setting'][$w] = '';		
						}
					} /* End for($w = 0; $w < 9; $w++){ */
				$luns_counter = $_SESSION[$wizard_name]['luns_counter'];
				$raid_groups_counter = $_SESSION[$wizard_name]['raid_groups_counter'];
				} /* End if ($back == 'Back') { */
			else {
				/* Continuing from CONFIGWIZARD_MODE_GETSTAGE1HTML */
				/* OR */
				/* Continuing from CONFIGWIZARD_MODE_VALIDATESTAGE2DATA due to user error */
				
				if (isset($_POST['monitoring_username'])) {
					/* Continuing from CONFIGWIZARD_MODE_GETSTAGE1HTML */
					/* The following line can be enabled for debugging purposes */
					//print_r('<br />Continuing from CONFIGWIZARD_MODE_VALIDATESTAGE1DATA<br />'); 
					
					/* Grab array variables from CONFIGWIZARD_MODE_GETSTAGE1HTML AND save these to the session variable array for later use */
					
					$tab_selected = grab_array_var($inargs,'emcclariion-tab-selected','');
					$spaselect = grab_array_var($inargs,'spaselect','');
					$spbselect = grab_array_var($inargs,'spbselect','');
					$_SESSION[$wizard_name]['tab_selected'] = $tab_selected; 
					$_SESSION[$wizard_name]['spaselect'] = $spaselect; 
					$_SESSION[$wizard_name]['spbselect'] = $spbselect; 
					
					/* There are different values based on which tab was selected */
					switch($tab_selected){
						case 'emcclariion-new':
							$sanname = grab_array_var($inargs,'sanname','');
							$spaaddress = grab_array_var($inargs,'spaaddress','');
							$spbaddress = grab_array_var($inargs,'spbaddress','');
							$_SESSION[$wizard_name]['sanname'] = $sanname; 
							$_SESSION[$wizard_name]['spaaddress'] = $spaaddress; 
							$_SESSION[$wizard_name]['spbaddress'] = $spbaddress; 
							break; /* End case 'emcclariion-new': */
						
						case 'emcclariion-existing':
							$spahostname = grab_array_var($inargs,'spahostname','');
							$spbhostname = grab_array_var($inargs,'spbhostname','');
							$_SESSION[$wizard_name]['spahostname'] = $spahostname; 
							$_SESSION[$wizard_name]['spbhostname'] = $spbhostname; 
							break; /* End case 'emcclariion-existing': */
						} /* End switch($tab_selected){ */
					
					$monitoring_username = grab_array_var($inargs,'monitoring_username','');
					$monitoring_password = grab_array_var($inargs,'monitoring_password','');
					$_SESSION[$wizard_name]['monitoring_username'] = $monitoring_username; 
					$_SESSION[$wizard_name]['monitoring_password'] = $monitoring_password; 
					
					/* The following variables need to be defined to prevent coding errors */
					$spa_monitoring_spa_setting = '';
					$spa_monitoring_spb_setting = '';
					$spb_monitoring_spa_setting = '';
					$spb_monitoring_spb_setting = '';
					$spa_monitoring_information_setting = '';
					$spb_monitoring_information_setting = '';
					$spa_monitoring_sp_busy_setting = '';
					$spa_monitoring_sp_busy_warn_setting = '';
					$spa_monitoring_sp_busy_warn_value_setting = '';
					$spa_monitoring_sp_busy_crit_setting = '';
					$spa_monitoring_sp_busy_crit_value_setting = '';
					$spb_monitoring_sp_busy_setting = '';
					$spb_monitoring_sp_busy_warn_setting = '';
					$spb_monitoring_sp_busy_warn_value_setting = '';
					$spb_monitoring_sp_busy_crit_setting = '';
					$spb_monitoring_sp_busy_crit_value_setting = '';
					$spa_monitoring_disks_setting = '';
					$spb_monitoring_disks_setting = '';
					$spa_monitoring_cache_setting = '';
					$spb_monitoring_cache_setting = '';
					$spa_monitoring_faults_setting = '';
					$spb_monitoring_faults_setting = '';
					$spa_monitoring_pdp_setting = '';
					$spb_monitoring_pdp_setting = '';
					$spa_monitoring_portstate_spa_setting = '';
					$spa_monitoring_portstate_spb_setting = '';
					$spb_monitoring_portstate_spa_setting = '';
					$spb_monitoring_portstate_spb_setting = '';
					$luns_counter = '';
					$raid_groups_counter = '';
					
					$serviceargs = '';
					for($w = 0; $w < 9; $w++){
						$serviceargs['client_select']['setting'][$w] = '';
						$serviceargs['client_name']['setting'][$w] = '';
						$serviceargs['client_select_spa']['setting'][$w] = '';
						$serviceargs['client_select_spb']['setting'][$w] = '';
						$serviceargs['client_number_paths']['setting'][$w] = '';		
						} /* End for($w = 0; $w < 9; $w++){ */
					
					} /* End if (isset($_POST['monitoring_username'])) { */
				else {
					/* Continuing from CONFIGWIZARD_MODE_VALIDATESTAGE2DATA due to user error */
					/* The following line can be enabled for debugging purposes */
					//print_r('<br />Continuing from CONFIGWIZARD_MODE_VALIDATESTAGE2DATA due to user error<br />'); 
					
					$tab_selected = $_SESSION[$wizard_name]['tab_selected'];
					$spaselect = $_SESSION[$wizard_name]['spaselect'];
					$spbselect = $_SESSION[$wizard_name]['spbselect'];
					$monitoring_username = $_SESSION[$wizard_name]['monitoring_username'];
					$monitoring_password = $_SESSION[$wizard_name]['monitoring_password'];
						
					/* There are different values based on which tab was selected */
					switch($tab_selected){
						case 'emcclariion-new':
							$sanname = $_SESSION[$wizard_name]['sanname'];
							$spaaddress = $_SESSION[$wizard_name]['spaaddress'];
							$spbaddress = $_SESSION[$wizard_name]['spbaddress'];
							break; /* End case 'emcclariion-new': */
						
						case 'emcclariion-existing':
							$spahostname = $_SESSION[$wizard_name]['spahostname'];
							$spbhostname = $_SESSION[$wizard_name]['spbhostname'];
							break; /* End case 'emcclariion-existing': */
						} /* End switch($tab_selected){ */
						
					/* Grab user data already provided from CONFIGWIZARD_MODE_GETSTAGE2HTML */
					if (grab_array_var($inargs,'spa_monitoring_spa') == 'on') {
						$spa_monitoring_spa_setting = 'checked';
						}
					else {
						$spa_monitoring_spa_setting = '';
						}
				
					if (grab_array_var($inargs,'spa_monitoring_spb') == 'on') {
						$spa_monitoring_spb_setting = 'checked';
						}
					else {
						$spa_monitoring_spb_setting = '';
						}
				
					if (grab_array_var($inargs,'spb_monitoring_spa') == 'on') {
						$spb_monitoring_spa_setting = 'checked';
						}
					else {
						$spb_monitoring_spa_setting = '';
						}
				
					if (grab_array_var($inargs,'spb_monitoring_spb') == 'on') {
						$spb_monitoring_spb_setting = 'checked';
						}
					else {
						$spb_monitoring_spb_setting = '';
						}
				
					if (grab_array_var($inargs,'spa_monitoring_information') == 'on') {
						$spa_monitoring_information_setting = 'checked';
						}
					else {
						$spa_monitoring_information_setting = '';
						}
				
					if (grab_array_var($inargs,'spb_monitoring_information') == 'on') {
						$spb_monitoring_information_setting = 'checked';
						}
					else {
						$spb_monitoring_information_setting = '';
						}
					
					if (grab_array_var($inargs,'spa_monitoring_sp_busy_select') == 'on') {
						$spa_monitoring_sp_busy_setting = 'checked';
						}
					else {
						$spa_monitoring_sp_busy_setting = '';
						}
				
					if (grab_array_var($inargs,'spa_monitoring_sp_busy_warn_select') == 'on') {
						$spa_monitoring_sp_busy_warn_setting = 'checked';
						}
					else {
						$spa_monitoring_sp_busy_warn_setting = '';
						}
				
					if (grab_array_var($inargs,'spa_monitoring_sp_busy_warn_value') != '') {
						$spa_monitoring_sp_busy_warn_value_setting = grab_array_var($inargs,'spa_monitoring_sp_busy_warn_value','');
						}
					else {
						$spa_monitoring_sp_busy_warn_value_setting = '';
						}
						
					if (grab_array_var($inargs,'spa_monitoring_sp_busy_crit_select') == 'on') {
						$spa_monitoring_sp_busy_crit_setting = 'checked';
						}
					else {
						$spa_monitoring_sp_busy_crit_setting = '';
						}
				
					if (grab_array_var($inargs,'spa_monitoring_sp_busy_crit_value') != '') {
						$spa_monitoring_sp_busy_crit_value_setting = grab_array_var($inargs,'spa_monitoring_sp_busy_crit_value','');
						}
					else {
						$spa_monitoring_sp_busy_crit_value_setting = '';
						}
				
					if (grab_array_var($inargs,'spb_monitoring_sp_busy_select') == 'on') {
						$spb_monitoring_sp_busy_setting = 'checked';
						}
					else {
						$spb_monitoring_sp_busy_setting = '';
						}
				
					if (grab_array_var($inargs,'spb_monitoring_sp_busy_warn_select') == 'on') {
						$spb_monitoring_sp_busy_warn_setting = 'checked';
						}
					else {
						$spb_monitoring_sp_busy_warn_setting = '';
						}
				
					if (grab_array_var($inargs,'spb_monitoring_sp_busy_warn_value') != '') {
						$spb_monitoring_sp_busy_warn_value_setting = grab_array_var($inargs,'spb_monitoring_sp_busy_warn_value','');
						}
					else {
						$spb_monitoring_sp_busy_warn_value_setting = '';
						}
						
					if (grab_array_var($inargs,'spb_monitoring_sp_busy_crit_select') == 'on') {
						$spb_monitoring_sp_busy_crit_setting = 'checked';
						}
					else {
						$spb_monitoring_sp_busy_crit_setting = '';
						}
				
					if (grab_array_var($inargs,'spb_monitoring_sp_busy_crit_value') != '') {
						$spb_monitoring_sp_busy_crit_value_setting = grab_array_var($inargs,'spb_monitoring_sp_busy_crit_value','');
						}
					else {
						$spb_monitoring_sp_busy_crit_value_setting = '';
						}
				
					if (grab_array_var($inargs,'spa_monitoring_disks') == 'on') {
						$spa_monitoring_disks_setting = 'checked';
						}
					else {
						$spa_monitoring_disks_setting = '';
						}
				
					if (grab_array_var($inargs,'spb_monitoring_disks') == 'on') {
						$spb_monitoring_disks_setting = 'checked';
						}
					else {
						$spb_monitoring_disks_setting = '';
						}
				
					if (grab_array_var($inargs,'spa_monitoring_cache') == 'on') {
						$spa_monitoring_cache_setting = 'checked';
						}
					else {
						$spa_monitoring_cache_setting = '';
						}
				
					if (grab_array_var($inargs,'spb_monitoring_cache') == 'on') {
						$spb_monitoring_cache_setting = 'checked';
						}
					else {
						$spb_monitoring_cache_setting = '';
						}
					
					if (grab_array_var($inargs,'spa_monitoring_faults') == 'on') {
						$spa_monitoring_faults_setting = 'checked';
						}
					else {
						$spa_monitoring_faults_setting = '';
						}
				
					if (grab_array_var($inargs,'spb_monitoring_faults') == 'on') {
						$spb_monitoring_faults_setting = 'checked';
						}
					else {
						$spb_monitoring_faults_setting = '';
						}
				
					if (grab_array_var($inargs,'spa_monitoring_pdp') == 'on') {
						$spa_monitoring_pdp_setting = 'checked';
						}
					else {
						$spa_monitoring_pdp_setting = '';
						}
				
					if (grab_array_var($inargs,'spb_monitoring_pdp') == 'on') {
						$spb_monitoring_pdp_setting = 'checked';
						}
					else {
						$spb_monitoring_pdp_setting = '';
						}
				
					if (grab_array_var($inargs,'spa_monitoring_portstate_spa') == 'on') {
						$spa_monitoring_portstate_spa_setting = 'checked';
						}
					else {
						$spa_monitoring_portstate_spa_setting = '';
						}
					
					if (grab_array_var($inargs,'spa_monitoring_portstate_spb') == 'on') {
						$spa_monitoring_portstate_spb_setting = 'checked';
						}
					else {
						$spa_monitoring_portstate_spb_setting = '';
						}
				
					if (grab_array_var($inargs,'spb_monitoring_portstate_spa') == 'on') {
						$spb_monitoring_portstate_spa_setting = 'checked';
						}
					else {
						$spb_monitoring_portstate_spa_setting = '';
						}
				
					if (grab_array_var($inargs,'spb_monitoring_portstate_spb') == 'on') {
						$spb_monitoring_portstate_spb_setting = 'checked';
						}
					else {
						$spb_monitoring_portstate_spb_setting = '';
						}
					
					$serviceargs = grab_array_var($inargs,'serviceargs');
					
					/* The following three lines can be enabled for debugging purposes */
					//print_r('<br />serviceargs<br />'); 
					//print_r($serviceargs); 
					//print_r('<br /><br />'); 
		
					for($w = 0; $w < 9; $w++){
						if (isset($serviceargs['client_select'][$w])) {
							$serviceargs['client_select']['setting'][$w] = 'checked';
							}
						else {
							$serviceargs['client_select']['setting'][$w] = '';
							}
						
						if ($serviceargs['client_name'][$w] != '') {
							$serviceargs['client_name']['setting'][$w] = $serviceargs['client_name'][$w];
							}
						else {
							$serviceargs['client_name']['setting'][$w] = '';
							}
							
						if (isset($serviceargs['client_select_spa'][$w])) {
							$serviceargs['client_select_spa']['setting'][$w] = 'checked';
							}
						else {
							$serviceargs['client_select_spa']['setting'][$w] = '';
							}
				
						if (isset($serviceargs['client_select_spb'][$w])) {
							$serviceargs['client_select_spb']['setting'][$w] = 'checked';
							}
						else {
							$serviceargs['client_select_spb']['setting'][$w] = '';
							}
							
						if ($serviceargs['client_number_paths'][$w] != '') {
							$serviceargs['client_number_paths']['setting'][$w] = $serviceargs['client_number_paths'][$w];
							}
						else {
							$serviceargs['client_number_paths']['setting'][$w] = '';		
							}
						} /* End for($w = 0; $w < 9; $w++){ */
					
					$luns_counter = grab_array_var($inargs,'emcclariion-luns-counter','');
					$raid_groups_counter = grab_array_var($inargs,'emcclariion-raid-groups-counter','');
					} /* End else { Continuing from CONFIGWIZARD_MODE_VALIDATESTAGE2DATA due to user error */
				} /* End else { Continuing from CONFIGWIZARD_MODE_GETSTAGE1HTML OR Continuing from CONFIGWIZARD_MODE_VALIDATESTAGE2DATA due to user error */
			
			
			/* These hidden inputs are used by the JavaScript to gather SAN information */
			$hidden_inputs ='
				<input type="hidden" id="id-emcclariion-monitoring-username" value="'.$monitoring_username.'">
				<input type="hidden" id="id-emcclariion-monitoring-password" value="'.$monitoring_password.'">
				<input type="hidden" id="id-emcclariion-spa-select" value="'.$spaselect.'">
				<input type="hidden" id="id-emcclariion-spb-select" value="'.$spbselect.'">
				';
			
			/* There are different values based on which tab was selected */
			switch($tab_selected){
				case 'emcclariion-new':
					$hidden_inputs .='
						<input type="hidden" id="id-emcclariion-spa-address" value="'.$spaaddress.'">
						<input type="hidden" id="id-emcclariion-spb-address" value="'.$spbaddress.'">
						';
					break; /* End case 'emcclariion-new': */
				
				case 'emcclariion-existing':
					// Get the SPA host address
					if ($spahostname != '') {
						$emcclariion_backendargs['cmd'] = 'gethosts';
						$emcclariion_backendargs['is_active'] = 1;
						$emcclariion_backendargs['host_name'] = $spahostname;

						//returns an XML object, this is NOT an array. 
						$emcclariion_hosts_xml = get_xml_host_objects($emcclariion_backendargs);

						foreach($emcclariion_hosts_xml->host as $host) {
							$spaaddress = "$host->address";
							}
						}
					else {
						$spaaddress = '';
						}
					
					// Get the SPB host address
					if ($spbhostname != '') {
						$emcclariion_backendargs['cmd'] = 'gethosts';
						$emcclariion_backendargs['is_active'] = 1;
						$emcclariion_backendargs['host_name'] = $spbhostname;

						//returns an XML object, this is NOT an array. 
						$emcclariion_hosts_xml = get_xml_host_objects($emcclariion_backendargs);

						foreach($emcclariion_hosts_xml->host as $host) {
							$spbaddress = "$host->address";
							}
						}
					else {
						$spbaddress = '';
						}
					
					$hidden_inputs .='
						<input type="hidden" id="id-emcclariion-spa-address" value="'.$spaaddress.'">
						<input type="hidden" id="id-emcclariion-spb-address" value="'.$spbaddress.'">
						';
					break; /* End case 'emcclariion-existing': */
				} /* End switch($tab_selected){ */
			/* End of hidden inputs are used by the JavaScript to gather SAN information */	
			
			
			/* Now we are creating the HTML for CONFIGWIZARD_MODE_GETSTAGE2HTML */ 
			$output = '				
			<!-- This is how you link an external Cascading Style Sheets file -->
			<link href="../includes/configwizards/'.$wizard_name.'/'.$wizard_name.'.css" rel="stylesheet" type="text/css" />
			<!-- This is how you link an external Javascript/jQuery file -->
			<script type="text/javascript" src="../includes/configwizards/'.$wizard_name.'/'.$wizard_name.'.js"></script>
			
			'.$hidden_inputs.'
			
			<div style="width: 500px;"> <!-- This div sets the width -->
			
			<div class="sectionTitle">EMC CLARiiON Details</div>
			You have selected to monitor:<br><br>
			
			<table>
			<tr>
			';
			if ($spaselect==true){
				$output.='
					<td><b>SPA:</b></td>
					';
				if ($tab_selected == 'emcclariion-new'){
					$output.='
						</tr>
						<tr><td style="width: 150px"><label>IP Address or FQDN:</label></td><td><label>'.$spaaddress.'</label></td></tr>
						<tr><td><label>Name:</label></td><td><label>'.$sanname.' SPA</label></td></tr>
						';
					}
				else {
					$output.='
						<td><label>Existing EMC CLARiiON:</label></td><td><b>'.$spahostname.'</b></td></tr>
						';
					}
				}
			if ($spbselect==true){
				if ($spaselect==true){
					$output.='
						<tr></tr><tr>
						';
					}
				$output.='
					<td><b>SPB:</b></td>
					';
				if ($tab_selected == 'emcclariion-new'){
					$output.='
						</tr>
						<tr><td style="width: 150px"><label>IP Address or FQDN:</label></td><td><label>'.$spbaddress.'</label></td></tr>
						<tr><td><label>Name:</label></td><td><label>'.$sanname.' SPB</label></td></tr>
						';
					}
				else {
					$output.='
						<td><label>Existing EMC CLARiiON:</label></td><td><b>'.$spbhostname.'</b></td></tr>
						';
					}
				}
			$output.='	
			</table>
			
			<br>
			Now you need to select what you want each SP to monitor.<br><br>
			
			Whatever options you select to monitor, you should monitor them on SPA <b>AND</b> SPB.<br><br>
			This allows for reduncancy of your checks. For example:
			<ul class="a">
				<li>You are monitoring the disks via SPA but not via SPB</li>
				<li>You lose connectivity to SPA</li>
				<li>At this point you will have no idea what the disk status is until you resolve your connectivity issue</li>
				<li>If you were also monitoring SPB then you will still know what the disk status is</li>
				<li>Think of it as redundant monitoring</li>
			</ul>
			
			
			<div class="sectionTitle">Storage Processors</div>
			This will check the overall status of an SP.<br><br>
			Please select which SP(s) you would like to monitor:<br><br>
			
			<table>
			<tr>
			<td rowspan="4" style="text-align: center; width: 80px">Monitoring<br>via</td>
			';
			if ($spaselect==true){
				$output.='
				<td rowspan="2" style="text-align: center; width: 20px">SPA:</td>
				<td><input type="checkbox" class="checkbox" name="spa_monitoring_spa" '.$spa_monitoring_spa_setting.'></td>
				<td>SPA Status</td>
				</tr>
				<tr>
				<td><input type="checkbox" class="checkbox" name="spa_monitoring_spb" '.$spa_monitoring_spb_setting.'></td>
				<td>SPB Status</td>
				</tr>
				';
				}
			if ($spbselect==true){
				if ($spaselect==true){
					$output.='<tr>';
				}
				$output.='
				<td rowspan="2" style="text-align: center; width: 20px">SPB:</td>
				<td><input type="checkbox" class="checkbox" name="spb_monitoring_spa" '.$spb_monitoring_spa_setting.'></td>
				<td>SPA Status</td>
				</tr>
				<tr>
				<td><input type="checkbox" class="checkbox" name="spb_monitoring_spb" '.$spb_monitoring_spb_setting.'></td>
				<td>SPB Status</td>
				</tr>
				';
				}
			$output.='	
			</table>
			
			
			<div class="sectionTitle">Storage Processors Information</div>
			Gathers the following information:<br>
			
			<table>
				<tr>			
					<td style="width: 180px">
						<ul class="a">
							<li>SP ID</li>
							<li>Agent Revision</li>
							<li>FLARE Revision</li>
							<li>PROM Revision</li>
							<li>Model/Type</li>
							<li>Memory</li>
							<li>Serial Number</li>
						</ul>
					</td>	
					<td>
						<table>
						<tr>
						<td rowspan="2" style="text-align: center; width: 80px">Monitoring<br>via</td>
						';
						if ($spaselect==true){
							$output.='
							<td>SPA:</td>
							<td><input type="checkbox" class="checkbox" name="spa_monitoring_information" '.$spa_monitoring_information_setting.'></td>
							</tr>
							';
							}
						if ($spbselect==true){
							if ($spaselect==true){
								$output.='<tr>';
							}
							$output.='
							<td>SPB:</td>
							<td><input type="checkbox" class="checkbox" name="spb_monitoring_information" '.$spb_monitoring_information_setting.'></td>
							</tr>
							';
							}
						$output.='	
						</table>
					</td>	
				</tr>
			</table>
			
			
			<div class="sectionTitle">Storage Processors Percentage Busy</div>
			This will report how busy a storage processor is using the Controller Busy Tick values taken from the SAN.<br><br>
			
			This will generate performance data for graphing purposes.<br><br>
			
			Please select which SP(s) you would like to monitor:<br><br>
			
			Warning and/or critical values are optional however critical must be a larger value than warning. For example warn at 50% and critical at 80%.<br><br>
			
			<table>
			<tr>
			<td rowspan="4" style="text-align: center; width: 80px">Monitoring<br>via</td>
			';
			if ($spaselect==true){
				$output.='
				<td><input type="checkbox" class="checkbox" name="spa_monitoring_sp_busy_select" '.$spa_monitoring_sp_busy_setting.'></td>
				<td>:SPA</td>
				<td align="right" style="width: 40px"><input type="checkbox" class="checkbox" name="spa_monitoring_sp_busy_warn_select" '.$spa_monitoring_sp_busy_warn_setting.'></td>
				<td><label>Warning:</label></td>
				<td><input type="text" size="5" name="spa_monitoring_sp_busy_warn_value" value="'.$spa_monitoring_sp_busy_warn_value_setting.'" class="textfield"></td>
				<td align="right" style="width: 50px"><input type="checkbox" class="checkbox" name="spa_monitoring_sp_busy_crit_select" '.$spa_monitoring_sp_busy_crit_setting.'></td>
				<td><label>Critical:</label></td>
				<td><input type="text" size="5" name="spa_monitoring_sp_busy_crit_value" value="'.$spa_monitoring_sp_busy_crit_value_setting.'" class="textfield"></td>
				</tr>
				';
				}
			if ($spbselect==true){
				if ($spaselect==true){
					$output.='<tr>';
				}
				$output.='
				<td><input type="checkbox" class="checkbox" name="spb_monitoring_sp_busy_select" '.$spb_monitoring_sp_busy_setting.'></td>
				<td>:SPB</td>
				<td align="right" style="width: 40px"><input type="checkbox" class="checkbox" name="spb_monitoring_sp_busy_warn_select" '.$spb_monitoring_sp_busy_warn_setting.'></td>
				<td><label>Warning:</label></td>
				<td><input type="text" size="5" name="spb_monitoring_sp_busy_warn_value" value="'.$spb_monitoring_sp_busy_warn_value_setting.'" class="textfield"></td>
				<td align="right" style="width: 50px"><input type="checkbox" class="checkbox" name="spb_monitoring_sp_busy_crit_select" '.$spb_monitoring_sp_busy_crit_setting.'></td>
				<td><label>Critical:</label></td>
				<td><input type="text" size="5" name="spb_monitoring_sp_busy_crit_value" value="'.$spb_monitoring_sp_busy_crit_value_setting.'" class="textfield"></td>
				</tr>
				';
				}
			$output.='	
			</table>
			
			
			<div class="sectionTitle">Disks</div>
			This will check the status of the Physical Disks attached in all the DAE\'s.<br><br>
				
			<table>
			<tr>
			<td rowspan="2" style="text-align: center; width: 80px">Monitoring<br>via</td>
			';
			if ($spaselect==true){
				$output.='
				<td>SPA:</td>
				<td><input type="checkbox" class="checkbox" name="spa_monitoring_disks" '.$spa_monitoring_disks_setting.'></td>
				</tr>
				';
				}
			if ($spbselect==true){
				if ($spaselect==true){
					$output.='<tr>';
				}
				$output.='
				<td>SPB:</td>
				<td><input type="checkbox" class="checkbox" name="spb_monitoring_disks" '.$spb_monitoring_disks_setting.'></td>
				</tr>
				';
				}
			$output.='	
			</table>
			

			<div class="sectionTitle">Cache</div>
			This will check the status of the Read and Write Cache.<br><br>
				
			<table>
			<tr>
			<td rowspan="2" style="text-align: center; width: 80px">Monitoring<br>via</td>
			';
			if ($spaselect==true){
				$output.='
				<td>SPA:</td>
				<td><input type="checkbox" class="checkbox" name="spa_monitoring_cache" '.$spa_monitoring_cache_setting.'></td>
				</tr>
				';
				}
			if ($spbselect==true){
				if ($spaselect==true){
					$output.='<tr>';
				}
				$output.='
				<td>SPB:</td>
				<td><input type="checkbox" class="checkbox" name="spb_monitoring_cache" '.$spb_monitoring_cache_setting.'></td>
				</tr>
				';
				}
			$output.='	
			</table>


			<div class="sectionTitle">Faults</div>
			This will Report any Faults on the SAN.<br><br>
				
			<table>
			<tr>
			<td rowspan="2" style="text-align: center; width: 80px">Monitoring<br>via</td>
			';
			if ($spaselect==true){
				$output.='
				<td>SPA:</td>
				<td><input type="checkbox" class="checkbox" name="spa_monitoring_faults" '.$spa_monitoring_faults_setting.'></td>
				</tr>
				';
				}
			if ($spbselect==true){
				if ($spaselect==true){
					$output.='<tr>';
				}
				$output.='
				<td>SPB:</td>
				<td><input type="checkbox" class="checkbox" name="spb_monitoring_faults" '.$spb_monitoring_faults_setting.'></td>
				</tr>
				';
				}
			$output.='	
			</table>
			
			
			<div class="sectionTitle">Percentage Dirty Pages In Cache</div>
			Returns the percentage of dirty pages currently in cache, that is, pages that have been modified in the SP\'s write cache, but that have not yet been written to disk.<br><br>
			
			A high percentage of dirty pages means the cache is handling many write requests.<br><br>
			
			This will generate performance data for graphing purposes.<br><br>
			
			<table>
			<tr>
			<td rowspan="4" style="text-align: center; width: 80px">Monitoring<br>via</td>
			';
			if ($spaselect==true){
				$output.='
				<td>SPA:</td>
				<td><input type="checkbox" class="checkbox" name="spa_monitoring_pdp" '.$spa_monitoring_pdp_setting.'></td>
				</tr>
				';
				}
			if ($spbselect==true){
				if ($spaselect==true){
					$output.='<tr>';
				}
				$output.='
				<td>SPB:</td>
				<td><input type="checkbox" class="checkbox" name="spb_monitoring_pdp" '.$spb_monitoring_pdp_setting.'></td>
				</tr>
				';
				}
			$output.='	
			</table>

			
			<div class="sectionTitle">Port State</div>
			This will check the status of ALL the Ports on an SP.<br><br>
				
			<table>
			<tr>
			<td rowspan="4" style="text-align: center; width: 80px">Monitoring<br>via</td>
			';
			if ($spaselect==true){
				$output.='
				<td rowspan="2" style="text-align: center; width: 20px">SPA:</td>
				<td><input type="checkbox" class="checkbox" name="spa_monitoring_portstate_spa" '.$spa_monitoring_portstate_spa_setting.'></td>
				<td>SPA Status</td>
				</tr>
				<tr>
				<td><input type="checkbox" class="checkbox" name="spa_monitoring_portstate_spb" '.$spa_monitoring_portstate_spb_setting.'></td>
				<td>SPB Status</td>
				</tr>
				';
				}
			if ($spbselect==true){
				if ($spaselect==true){
					$output.='<tr>';
				}
				$output.='
				<td rowspan="2" style="text-align: center; width: 20px">SPB:</td>
				<td><input type="checkbox" class="checkbox" name="spb_monitoring_portstate_spa" '.$spb_monitoring_portstate_spa_setting.'></td>
				<td>SPA Status</td>
				</tr>
				</tr>
				<td><input type="checkbox" class="checkbox" name="spb_monitoring_portstate_spb" '.$spb_monitoring_portstate_spb_setting.'></td>
				<td>SPB Status</td>
				</tr>
				';
				}
			$output.='	
			</table>


			<div class="sectionTitle">Client Host Bus Adapter State</div>
			This will check the status of a Client\'s HBA connection(s).<br><br>
			
			This requires two bits of information.<br>
				
			<ul class="a">
			<b>Client Name</b>
			<li>A client is defined as a host connected to the SAN (like an ESX host)</li>
			<li>Technically it\'s called a <b>Host</b> under Navisphere but I am using the term client to avoid the confusing phrase <i>Host Host Bus Adapder State</i></li>
			<li>We need to know the <b>hostname</b> that this client is registered as</li>
			<li>For example <i>server14</i> or <i>esx33.domain.local</i></li>
			<li>This is NOT the IP Address, an IP Address will <b>NOT</b> work</li>
			<li>Use Navisphere to look under the Hosts section of the SAN to find the client name (hostname)</li>
			</ul>
			
			<ul class="a">
			<b>Number of Paths</b>
			<li>The client has one or more HBAs that it connects to the SAN with</li>
			<li>Each connection to the SAN is a <b>path</b></li>
			<li>Depending on your SAN Fabric / HBA topology depends on how many paths you have</li>
			<li>Basic formula is "number of HBAs" x "number of SPs" = "number of paths"</li>
			</ul>
			
			<div style="width: 500px">
				<div style="width: 50px; float: left; font-weight: bold; text-align: center">
					Select
				</div>
				<div style="width: 450px; float: right; font-weight: bold; text-align: center">
					Define Client Parameters
				</div>
				<br><br>
			';
			
			for($x = 0; $x < 9; $x++){
				if ($x & 1)
					$output.='<table>';
				else 
					$output.='<table bgcolor="#EEEEEE">'; 
				$output.='
				<tr>
				<td rowspan="2" style="vertical-align: middle; text-align: center; width: 50px"><label>'.$x.'</label><br><input type="checkbox" class="checkbox" name="serviceargs[client_select]['.$x.']" '.$serviceargs['client_select']['setting'][$x].'></td>
				<td style="width: 120px"><label>Client Name:</label></td>
				<td style="width: 190px"><input type="text" size="25" name="serviceargs[client_name]['.$x.']" value="'.$serviceargs['client_name']['setting'][$x].'" class="textfield"></td>
				<td rowspan="2" style="width: 80px; text-align: center"><label>Monitoring<br>via</label></td>
				<td rowspan="2" style="width: 60px">
				';
				if ($spaselect == true){
					$output.='
					<label>SPA:</label><input type="checkbox" class="checkbox" name="serviceargs[client_select_spa]['.$x.']" '.$serviceargs['client_select_spa']['setting'][$x].'>
					';
					}
				if ($spbselect == true){
					$output.='
					<label>SPB:</label><input type="checkbox" class="checkbox" name="serviceargs[client_select_spb]['.$x.']" '.$serviceargs['client_select_spb']['setting'][$x].'>
					';
					}
				$output.='	
				</td>
				</tr>
				<tr>
				<td style="width: 120px"><label>Number of Paths:</label></td>
				';
				$output.='<td><select name="serviceargs[client_number_paths]['.$x.']">';
				$output.='<option value="'.$serviceargs['client_number_paths']['setting'][$x].'">'.$serviceargs['client_number_paths']['setting'][$x].'</option>';
				for($y = 1; $y <= 8; $y++){
					$output.='<option value="'.$y.'">'.$y.'</option>';
					}
				$output.='</select></td>';
				$output.='
				</tr>
				</table>
				';
			}			
			$output.='
			</div>
			
			
			<div class="sectionTitle">LUNs</div>
			Check the status of a specific LUN and reports State, ID, Name, Size, Free Space, RAID Group Type and Percentage Rebuilt.<br><br>
			
			Warning and/or critical values are optional however critical must be a smaller value than warning. For example warn when free space is 60% of LUN and critical when free space is 10% of LUN.<br><br>
			
			This will generate performance data for graphing purposes.<br><br>

			Click the "Get LUNs" button to populate the screen with a list of the LUNs on the EMC CLARiiON. The more LUNs there are on the CLARiiON, the longer it will take for the results to display below. <b>NOTE:</b> the monitoring username and password must be correctly entered on the previous step.<br><br>
			
			<input type="button" id="id-emcclariion_get_luns" onclick="emcclariion_get_luns()" value="Get LUNs">
			
			<br><br>
			
			
			<div id="emcclariion_lun_results"> 
				<!-- LUN results will go here -->
				';
				if ($luns_counter != '') {
					$output.='
						<div style="width: 500px">
							<div style="width: 50px; float: left; font-weight: bold; text-align: center">
								Select
							</div>
							<div style="width: 450px; float: right; font-weight: bold; text-align: center">
								Define LUN Parameters
							</div>
							<br><br>
						';
				
					for ($l = 0; $l < $luns_counter; $l++) {
						if ($l & 1) {
							$output.='
								<table class="emcclariion_luns" style="width: 494px">
								';
							}
						else {
							$output .= '
								<table class="emcclariion_luns" style="background-color: #EEEEEE; width: 494px">
								';
							}	
						$output .= '
									<tr>
										<td rowspan="2" style="vertical-align: middle; text-align: center; width: 46px">'.$l.'<br><input type="checkbox" class="checkbox" name="serviceargs[lun_select]['.$l.']" '; if (isset($serviceargs['lun_select'][$l])) { if ($serviceargs['lun_select'][$l] == 'on') {$output .= 'checked';} } $output .= '></td>
										<td><label>ID:</label></td>
										<td>'.$serviceargs['lun_id'][$l].'</td>
										<input type="hidden" name="serviceargs[lun_id]['.$l.']" value="'.$serviceargs['lun_id'][$l].'">
										<td><label>Type:</label></td>
										<td>'.$serviceargs['lun_type'][$l].'</td>
										<input type="hidden" name="serviceargs[lun_type]['.$l.']" value="'.$serviceargs['lun_type'][$l].'">
										<td><label>Size:</label></td>
										<td>'.$serviceargs['lun_size'][$l].'</td>
										<input type="hidden" name="serviceargs[lun_size]['.$l.']" value="'.$serviceargs['lun_size'][$l].'">
										<td rowspan="2" style="width: 80px; text-align: center"><label>Monitoring<br>via</label></td>
										<td rowspan="2" style="width: 60px">
							';
						if ($spaselect == true){
							$output .= '
											<label>SPA:</label><input type="checkbox" class="checkbox" name="serviceargs[lun_select_spa]['.$l.']" '; if (isset($serviceargs['lun_select_spa'][$l])) { if ($serviceargs['lun_select_spa'][$l] == 'on') {$output .= 'checked';} } $output .= '>
							';
							}
						if ($spbselect == true){
							$output .= '
											<label>SPB:</label><input type="checkbox" class="checkbox" name="serviceargs[lun_select_spb]['.$l.']" '; if (isset($serviceargs['lun_select_spb'][$l])) { if ($serviceargs['lun_select_spb'][$l] == 'on') {$output .= 'checked';} } $output .= '>
							';
							}
						$output.='	
										</td>
									</tr>
									<tr>
										<td><label>Name:</label></td>
										<td colspan="5"><input type="text" size="35" name="serviceargs[lun_name]['.$l.']" value="'.$serviceargs['lun_name'][$l].'" class="textfield"></td>
									</tr>
									<tr>
							';
						if ($l & 1) {
							$output .= '
										<table class="emcclariion_luns" style="width: 500px">
								';
							}
						else {
							$output .= '
										<table class="emcclariion_luns" style="background-color: #EEEEEE; width: 494px">
								';
							}
						$output .= '
											<tr>
												<td style="width: 50px"></td>
												<td align="right"><input type="checkbox" class="checkbox" name="serviceargs[lun_warn_select]['.$l.']" '; if (isset($serviceargs['lun_warn_select'][$l])) { if ($serviceargs['lun_warn_select'][$l] == 'on') {$output .= 'checked';} } $output .= '></td>
												<td><label>Warning:</label></td>
												<td><input type="text" size="5" name="serviceargs[lun_warn_value]['.$l.']" class="textfield" value="'.$serviceargs['lun_warn_value'][$l].'"></td>
												<td></td>
												<td align="right"><input type="checkbox" class="checkbox" name="serviceargs[lun_crit_select]['.$l.']" '; if (isset($serviceargs['lun_crit_select'][$l])) { if ($serviceargs['lun_crit_select'][$l] == 'on') {$output .= 'checked';} } $output .= '></td>
												<td><label>Critical:</label></td>
												<td><input type="text" size="5" name="serviceargs[lun_crit_value]['.$l.']" class="textfield" value="'.$serviceargs['lun_crit_value'][$l].'"></td>
												<td></td>
											</tr>
										</table>
										
									</tr>
							';
						} /* End for ($l = 0; $l < $luns_counter; $l++) { */
					$output.='
							</table>
							<input type="hidden" name="emcclariion-luns-counter" value="'.$luns_counter.'">
						</div> <!-- This is the end of the div for width -->
						';
					} /* End if ($luns_counter != '') { */
			$output.='
			</div> <!-- End div emcclariion_lun_results -->
			
			
			<div class="sectionTitle">RAID Groups</div>
			Checks the status of a specific RAID Group and reports the State, ID, RAID Group Type, Logical Size, Free Space, Percentage Defragmentation Complete and Percentage Expansion Complete.<br><br>
			
			Warning and/or critical values are optional however critical must be a smaller value than warning. For example warn when free space is 50% of RAID Group and critical when free space is 30% of RAID Group.<br><br>
			
			This will generate performance data for graphing purposes.<br><br>

			Click the "Get RAID Groups" button to populate the screen with a list of the RAID Groups on the EMC CLARiiON. The more RAID Groups there are on the CLARiiON, the longer it will take for the results to display below. <b>NOTE:</b> the monitoring username and password must be correctly entered on the previous step.<br><br>
			
			<input type="button" id="id-emcclariion_get_raid_groups" onclick="emcclariion_get_raid_groups()" value="Get RAID Groups">
			
			<br><br>
			
			<div id="emcclariion_raid_group_results"> 
				<!-- RAID Group results will go here -->
			
			';
				if ($raid_groups_counter != '') {
					$output.='
						<div style="width: 500px">
							<div style="width: 50px; float: left; font-weight: bold; text-align: center">
								Select
							</div>
							<div style="width: 450px; float: right; font-weight: bold; text-align: center">
								Define LUN Parameters
							</div>
							<br><br>
						';
					for ($rg = 0; $rg < $raid_groups_counter; $rg++) {
						if ($rg & 1) {
							$output.='
								<table class="emcclariion_raid_groups" style="width: 494px">
								';
							}
						else {
							$output .= '
								<table class="emcclariion_raid_groups" style="background-color: #EEEEEE; width: 494px">
								';
							}	
						$output .= '
									<tr>
										<td rowspan="2" style="vertical-align: middle; text-align: center; width: 46px">'.$rg.'<br><input type="checkbox" class="checkbox" name="serviceargs[raid_group_select]['.$rg.']" '; if (isset($serviceargs['raid_group_select'][$rg])) { if ($serviceargs['raid_group_select'][$rg] == 'on') {$output .= 'checked';} } $output .= '></td>
										<td><label>ID:</label></td>
										<td>'.$serviceargs['raid_group_id'][$rg].'</td>
										<input type="hidden" name="serviceargs[raid_group_id]['.$rg.']" value="'.$serviceargs['raid_group_id'][$rg].'">
										<td><label>Type:</label></td>
										<td>'.$serviceargs['raid_group_type'][$rg].'</td>
										<input type="hidden" name="serviceargs[raid_group_type]['.$rg.']" value="'.$serviceargs['raid_group_type'][$rg].'">
										<td><label>Size:</label></td>
										<td>'.$serviceargs['raid_group_size'][$rg].'</td>
										<input type="hidden" name="serviceargs[raid_group_size]['.$rg.']" value="'.$serviceargs['raid_group_size'][$rg].'">
										<td rowspan="2" style="width: 80px; text-align: center"><label>Monitoring<br>via</label></td>
										<td rowspan="2" style="width: 60px">
							';
						if ($spaselect == true){
							$output .= '
											<label>SPA:</label><input type="checkbox" class="checkbox" name="serviceargs[raid_group_select_spa]['.$rg.']" '; if (isset($serviceargs['raid_group_select_spa'][$rg])) { if ($serviceargs['raid_group_select_spa'][$rg] == 'on') {$output .= 'checked';} } $output .= '>
							';
							}
						if ($spbselect == true){
							$output .= '
											<label>SPB:</label><input type="checkbox" class="checkbox" name="serviceargs[raid_group_select_spb]['.$rg.']" '; if (isset($serviceargs['raid_group_select_spb'][$rg])) { if ($serviceargs['raid_group_select_spb'][$rg] == 'on') {$output .= 'checked';} } $output .= '>
							';
							}
						$output.='	
										</td>
									</tr>
									<tr>
										<td><label>Name:</label></td>
										<td colspan="5"><input type="text" size="35" name="serviceargs[raid_group_name]['.$rg.']" value="'.$serviceargs['raid_group_name'][$rg].'" class="textfield"></td>
									</tr>
									<tr>
							';
						if ($rg & 1) {
							$output .= '
										<table class="emcclariion_raid_groups" style="width: 500px">
								';
							}
						else {
							$output .= '
										<table class="emcclariion_raid_groups" style="background-color: #EEEEEE; width: 494px">
								';
							}
						$output .= '
											<tr>
												<td style="width: 50px"></td>
												<td align="right"><input type="checkbox" class="checkbox" name="serviceargs[raid_group_warn_select]['.$rg.']" '; if (isset($serviceargs['raid_group_warn_select'][$rg])) { if ($serviceargs['raid_group_warn_select'][$rg] == 'on') {$output .= 'checked';} } $output .= '></td>
												<td><label>Warning:</label></td>
												<td><input type="text" size="5" name="serviceargs[raid_group_warn_value]['.$rg.']" class="textfield" value="'.$serviceargs['raid_group_warn_value'][$rg].'"></td>
												<td></td>
												<td align="right"><input type="checkbox" class="checkbox" name="serviceargs[raid_group_crit_select]['.$rg.']" '; if (isset($serviceargs['raid_group_crit_select'][$rg])) { if ($serviceargs['raid_group_crit_select'][$rg] == 'on') {$output .= 'checked';} } $output .= '></td>
												<td><label>Critical:</label></td>
												<td><input type="text" size="5" name="serviceargs[raid_group_crit_value]['.$rg.']" class="textfield" value="'.$serviceargs['raid_group_crit_value'][$rg].'"></td>
												<td></td>
											</tr>
										</table>
									</tr>
							';
						} /* End for ($rg = 0; $rg < $raid_groups_counter; $rg++) { */
					$output.='
							</table>
							<input type="hidden" name="emcclariion-raid-groups-counter" value="'.$raid_groups_counter.'">
						</div> <!-- This is the end of the div for width -->
						';
					} /* End if ($raid_groups_counter != '') { */
			$output.='
			</div> <!-- End div emcclariion_raid_group_results -->
			
			<br><br>
			
			</div> <!-- This is the end of the div for width -->
			';
			/* The quote and semicolon ends HTML for CONFIGWIZARD_MODE_GETSTAGE2HTML */ 
			/* $output will be passed back to XI framework and rendered to browser */
			/* The next line ends CONFIGWIZARD_MODE_GETSTAGE2HTML */
			break;

		/* Form validation for CONFIGWIZARD_MODE_GETSTAGE2HTML */ 
		case CONFIGWIZARD_MODE_VALIDATESTAGE2DATA:
			/* This defines $back variable, used for determining if the Back button */
			/* was clicked when the user was on CONFIGWIZARD_MODE_GETSTAGE4HTML */
			$back = htmlentities(grab_array_var($_POST,'backButton',false),ENT_QUOTES); 	
			
			/* If the user came back from CONFIGWIZARD_MODE_GETSTAGE3HTML then we don't need to revalidate and check for errors */
			if ($back) break;	
			
			/* Get variables that were passed to us */
			$tab_selected = grab_array_var($inargs,'emcclariion-tab-selected','');
			
			/* There are different values based on which tab was selected */
			switch($tab_selected){
				case 'emcclariion-new':
					$sanname = grab_array_var($inargs,'sanname','');
					$spaaddress = grab_array_var($inargs,'spaaddress','');
					$spbaddress = grab_array_var($inargs,'spbaddress','');
					break; /* End case 'emcclariion-new': */
				
				case 'emcclariion-existing':
					$spahostname = grab_array_var($inargs,'spahostname','');
					$spbhostname = grab_array_var($inargs,'spbhostname','');
					break; /* End case 'emcclariion-existing': */
				} /* End switch($tab_selected){ */
			
			$spaselect = grab_array_var($inargs,'spaselect','');
			$spbselect = grab_array_var($inargs,'spbselect','');
			$monitoring_username = grab_array_var($inargs,'monitoring_username','');
			$monitoring_password = grab_array_var($inargs,'monitoring_password','');
			$serviceargs = grab_array_var($inargs,'serviceargs','');
			$luns_counter = grab_array_var($inargs,'emcclariion-luns-counter','');
			$raid_groups_counter = grab_array_var($inargs,'emcclariion-raid-groups-counter','');
			
			// check for errors
			$errors = 0;
			$errmsg = array();
			
			if (grab_array_var($inargs,'spa_monitoring_sp_busy_select') != ''){
				$spa_monitoring_sp_busy_warn_final = 1;
				$spa_monitoring_sp_busy_crit_final = 1;
				if (grab_array_var($inargs,'spa_monitoring_sp_busy_select') == 'on') {
					if (grab_array_var($inargs,'spa_monitoring_sp_busy_warn_select') != '') {
						if (grab_array_var($inargs,'spa_monitoring_sp_busy_warn_select') == 'on') {
							if (grab_array_var($inargs,'spa_monitoring_sp_busy_warn_value') == '') {
								$errmsg[$errors++] = 'Please provide a Warning value for SPA Storage Processors Percentage Busy';
								$spa_monitoring_sp_busy_warn_final = 2;
							}
							else if (preg_match('/[^0-9]/',grab_array_var($inargs,'spa_monitoring_sp_busy_warn_value'))) {
								$errmsg[$errors++] = 'SPA Storage Processors Percentage Busy Warning value can only be a number';
								$spa_monitoring_sp_busy_warn_final = 2;
							}
							else {
								$spa_monitoring_sp_busy_warn_final = 3;
							}
						}
					}					
					if (grab_array_var($inargs,'spa_monitoring_sp_busy_crit_select') != '') {
						if (grab_array_var($inargs,'spa_monitoring_sp_busy_crit_select') == 'on') {
							if (grab_array_var($inargs,'spa_monitoring_sp_busy_crit_value') == '') {
								$errmsg[$errors++] = 'Please provide a Critical value for SPA Storage Processors Percentage Busy';
								$spa_monitoring_sp_busy_crit_final = 2;
							}
							else if (preg_match('/[^0-9]/',grab_array_var($inargs,'spa_monitoring_sp_busy_crit_value'))) {
								$errmsg[$errors++] = 'SPA Storage Processors Percentage Busy Critical value can only be a number';
								$spa_monitoring_sp_busy_crit_final = 2;
							}
							else {
								$spa_monitoring_sp_busy_crit_final = 3;
							}
						}
					}
					if ($spa_monitoring_sp_busy_warn_final == 3 && $spa_monitoring_sp_busy_crit_final == 3) {
						if (grab_array_var($inargs,'spa_monitoring_sp_busy_warn_value') > grab_array_var($inargs,'spa_monitoring_sp_busy_crit_value')) {
							$errmsg[$errors++] = 'The SPA Storage Processors Percentage Busy Critical value must be a larger value than the SPA Storage Processors Percentage Busy Warning value';
						}
					}
				}
			}
	
			if (grab_array_var($inargs,'spb_monitoring_sp_busy_select') != ''){
				$spb_monitoring_sp_busy_warn_final = 1;
				$spb_monitoring_sp_busy_crit_final = 1;
				if (grab_array_var($inargs,'spb_monitoring_sp_busy_select') == 'on') {
					if (grab_array_var($inargs,'spb_monitoring_sp_busy_warn_select') != '') {
						if (grab_array_var($inargs,'spb_monitoring_sp_busy_warn_select') == 'on') {
							if (grab_array_var($inargs,'spb_monitoring_sp_busy_warn_value') == '') {
								$errmsg[$errors++] = 'Please provide a Warning value for SPB Storage Processors Percentage Busy';
								$spb_monitoring_sp_busy_warn_final = 2;
							}
							else if (preg_match('/[^0-9]/',grab_array_var($inargs,'spb_monitoring_sp_busy_warn_value'))) {
								$errmsg[$errors++] = 'SPB Storage Processors Percentage Busy Warning value can only be a number';
								$spb_monitoring_sp_busy_warn_final = 2;
							}
							else {
								$spb_monitoring_sp_busy_warn_final = 3;
							}
						}
					}					
					if (grab_array_var($inargs,'spb_monitoring_sp_busy_crit_select') != '') {
						if (grab_array_var($inargs,'spb_monitoring_sp_busy_crit_select') == 'on') {
							if (grab_array_var($inargs,'spb_monitoring_sp_busy_crit_value') == '') {
								$errmsg[$errors++] = 'Please provide a Critical value for SPB Storage Processors Percentage Busy';
								$spb_monitoring_sp_busy_crit_final = 2;
							}
							else if (preg_match('/[^0-9]/',grab_array_var($inargs,'spb_monitoring_sp_busy_crit_value'))) {
								$errmsg[$errors++] = 'SPB Storage Processors Percentage Busy Critical value can only be a number';
								$spb_monitoring_sp_busy_crit_final = 2;
							}
							else {
								$spb_monitoring_sp_busy_crit_final = 3;
							}
						}
					}
					if ($spb_monitoring_sp_busy_warn_final == 3 && $spb_monitoring_sp_busy_crit_final == 3) {
						if (grab_array_var($inargs,'spb_monitoring_sp_busy_warn_value') > grab_array_var($inargs,'spb_monitoring_sp_busy_crit_value')) {
							$errmsg[$errors++] = 'The SPB Storage Processors Percentage Busy Critical value must be a larger value than the SPB Storage Processors Percentage Busy Warning value';
						}
					}
				}
			}
			
			for ($v = 0; $v < 9; $v++) {
				if (isset($serviceargs['client_select'][$v])) {
					if (have_value($serviceargs['client_name'][$v]) == false) {
						$errmsg[$errors++] = 'No Name specified for Client HBA '.$v;
						}
					else if (preg_match('/[^0-9a-zA-Z\ \.\:\_\-\[\]]/',$serviceargs['client_name'][$v])) {
						$errmsg[$errors++] = 'Client HBA '.$v.' Name contains invalid characters.';
						}
					if (!isset($serviceargs['client_select_spa'][$v])) {
						if (!isset($serviceargs['client_select_spb'][$v])) {
							$errmsg[$errors++] = 'You need to select SPA, SPB or both for Client HBA '.$v;
							}
						}
					if (have_value($serviceargs['client_number_paths'][$v]) == false) {
						$errmsg[$errors++] = 'No Paths specified for Client HBA '.$v;
						}
					} /* End if (isset($serviceargs['client_select'][$v])) { */
				} /* End for($v = 0; $v < 9; $v++){ */
			
			
			if ($luns_counter != '') {
				for ($l = 0; $l < $luns_counter; $l++) {
					$lun_warn_final = 0;
					$lun_crit_final = 0;
					if (isset($serviceargs['lun_select'][$l])) {
						if (have_value($serviceargs['lun_name'][$l]) == false) {
							$errmsg[$errors++] = 'No Name specified for LUN '.$l;
							}
						if (preg_match('/[^0-9a-zA-Z\ \.\:\_\-\[\]]/',$serviceargs['lun_name'][$l])) {
							$errmsg[$errors++] = 'LUN Name '.$l.' contains invalid characters.';
							}	
						if (!isset($serviceargs['lun_select_spa'][$l])) {
							if (!isset($serviceargs['lun_select_spb'][$l])) {
								$errmsg[$errors++] = 'You need to select SPA, SPB or both for LUN '.$l;
								}
							}
						if (isset($serviceargs['lun_warn_select'][$l])) {
							if ($serviceargs['lun_warn_select'][$l] == 'on') {
								if ($serviceargs['lun_warn_value'][$l] == '') {
									$errmsg[$errors++] = 'Please provide a Warning value for LUN '.$l;
									$lun_warn_final = 2;
									}
								else if (preg_match('/[^0-9]/',$serviceargs['lun_warn_value'][$l])) {
									$errmsg[$errors++] = 'LUN '.$l.' Warning value can only be a number';
									$lun_warn_final = 2;
									}
								else {
									$lun_warn_final = 3;
									}
								}
							} /* End if (isset($serviceargs['lun_warn_select'][$l])) { */
						if (isset($serviceargs['lun_crit_select'][$l])) {
							if ($serviceargs['lun_crit_select'][$l] == 'on') {
								if ($serviceargs['lun_crit_value'][$l] == '') {
									$errmsg[$errors++] = 'Please provide a Critical value for LUN '.$l;
									$lun_crit_final = 2;
									}
								else if (preg_match('/[^0-9]/',$serviceargs['lun_crit_value'][$l])) {
									$errmsg[$errors++] = 'LUN '.$l.' Critical value can only be a number';
									$lun_crit_final = 2;
									}
								else {
									$lun_crit_final = 3;
									}
								}
							} /* End if (isset($serviceargs['lun_crit_select'][$l])) { */
						if (isset($lun_warn_final) && isset($lun_crit_final)) {
							if ($lun_warn_final == 3 && $lun_crit_final == 3) {
								if ($serviceargs['lun_warn_value'][$l] < $serviceargs['lun_crit_value'][$l]) {
									$errmsg[$errors++] = 'LUN '.$l.' Critical value must be a smaller value than the Warning value';
									}
								}
							} /* End if (isset($lun_warn_final) && isset($lun_crit_final)) { */
						} /* End if (isset($serviceargs['lun_select'][$l])) { */
					} /* End for ($l = 0; $l < $luns_counter; $l++) { */
				} /* End if ($luns_counter != '') { */
			
			
			if ($raid_groups_counter != '') {
				for ($rg = 0; $rg < $raid_groups_counter; $rg++) {
					$raid_group_warn_final = 0;
					$raid_group_crit_final = 0;
					if (isset($serviceargs['raid_group_select'][$rg])) {
						if (have_value($serviceargs['raid_group_name'][$rg]) == false) {
							$errmsg[$errors++] = 'No Name specified for RAID Group '.$rg;
							}
						if (preg_match('/[^0-9a-zA-Z\ \.\:\_\-\[\]]/',$serviceargs['raid_group_name'][$rg])) {
							$errmsg[$errors++] = 'RAID Group Name '.$rg.' contains invalid characters.';
							}	
						if (!isset($serviceargs['raid_group_select_spa'][$rg])) {
							if (!isset($serviceargs['raid_group_select_spb'][$rg])) {
								$errmsg[$errors++] = 'You need to select SPA, SPB or both for RAID Group '.$rg;
								}
							}
						if (isset($serviceargs['raid_group_warn_select'][$rg])) {
							if ($serviceargs['raid_group_warn_select'][$rg] == 'on') {
								if ($serviceargs['raid_group_warn_value'][$rg] == '') {
									$errmsg[$errors++] = 'Please provide a Warning value for RAID Group '.$rg;
									$raid_group_warn_final = 2;
									}
								else if (preg_match('/[^0-9]/',$serviceargs['raid_group_warn_value'][$rg])) {
									$errmsg[$errors++] = 'RAID Group '.$rg.' Warning value can only be a number';
									$raid_group_warn_final = 2;
									}
								else {
									$raid_group_warn_final = 3;
									}
								}
							} /* End if (isset($serviceargs['raid_group_warn_select'][$rg])) { */
						if (isset($serviceargs['raid_group_crit_select'][$rg])) {
							if ($serviceargs['raid_group_crit_select'][$rg] == 'on') {
								if ($serviceargs['raid_group_crit_value'][$rg] == '') {
									$errmsg[$errors++] = 'Please provide a Critical value for RAID Group '.$rg;
									$raid_group_crit_final = 2;
									}
								else if (preg_match('/[^0-9]/',$serviceargs['raid_group_crit_value'][$rg])) {
									$errmsg[$errors++] = 'RAID Group '.$rg.' Critical value can only be a number';
									$raid_group_crit_final = 2;
									}
								else {
									$raid_group_crit_final = 3;
									}
								}
							} /* End if (isset($serviceargs['raid_group_crit_select'][$rg])) { */
						if (isset($raid_group_warn_final) && isset($raid_group_crit_final)) {
							if ($raid_group_warn_final == 3 && $raid_group_crit_final == 3) {
								if ($serviceargs['raid_group_warn_value'][$rg] < $serviceargs['raid_group_crit_value'][$rg]) {
									$errmsg[$errors++] = 'RAID Group '.$rg.' Critical value must be a smaller value than the Warning value';
									}
								}
							} /* End if (isset($raid_group_warn_final) && isset($raid_group_crit_final)) { */
						} /* End if (isset($serviceargs['raid_group_select'][$rg])) { */
					} /* End for ($rg = 0; $rg < $raid_groups_counter; $rg++) { */
				} /* End if ($raid_groups_counter != '') { */
			
			
			/* Check to see if the $errors array contains errors */
			if ($errors>0){
				$outargs[CONFIGWIZARD_ERROR_MESSAGES] = $errmsg;
				$result = 1;
				}
			
			/* The next line ends CONFIGWIZARD_MODE_VALIDATESTAGE2DATA */
			break;

		
		case CONFIGWIZARD_MODE_GETSTAGE3HTML:
			/* This defines $back variable, used for determining if the Back button */
			/* was clicked when the user was on CONFIGWIZARD_MODE_GETSTAGE4HTML */
			$back = htmlentities(grab_array_var($_POST,'backButton',false),ENT_QUOTES); 		
			
			/* The following THREE lines can be enabled for debugging purposes */
			//print_r('<br />post CONFIGWIZARD_MODE_GETSTAGE3HTML<br />'); 
			//print_r($_POST); 
			//print_r('<br /><br />'); 
			
			/* The following THREE lines can be enabled for debugging purposes */
			//print_r('<br />session CONFIGWIZARD_MODE_GETSTAGE3HTML<br />'); 
			//print_r($_SESSION[$wizard_name]); 
			//print_r('<br /><br />'); 
			
			/* Check to see if we are coming back from CONFIGWIZARD_MODE_GETSTAGE4HTML OR continuing from CONFIGWIZARD_MODE_GETSTAGE2HTML */
			if (!$back) {
				/* Continuing from CONFIGWIZARD_MODE_GETSTAGE2HTML */
				/* The following line can be enabled for debugging purposes */
				//print_r('Continuing from CONFIGWIZARD_MODE_GETSTAGE2HTML <br />'); 
				
				/* grab array variables from CONFIGWIZARD_MODE_GETSTAGE2HTML */
				$tab_selected = grab_array_var($inargs,'tab_selected','');
			
				/* There are different values based on which tab was selected */
				switch($tab_selected){
					case 'emcclariion-new':
						$sanname = grab_array_var($inargs,'sanname','');
						$spaaddress = grab_array_var($inargs,'spaaddress','');
						$spbaddress = grab_array_var($inargs,'spbaddress','');
						break; /* End case 'emcclariion-new': */
					
					case 'emcclariion-existing':
						$spahostname = grab_array_var($inargs,'spahostname','');
						$spbhostname = grab_array_var($inargs,'spbhostname','');
						break; /* End case 'emcclariion-existing': */
					} /* End switch($tab_selected){ */
				
				$spa_monitoring_spa = grab_array_var($inargs,'spa_monitoring_spa','');
				$spa_monitoring_spb = grab_array_var($inargs,'spa_monitoring_spb','');
				$spb_monitoring_spa = grab_array_var($inargs,'spb_monitoring_spa','');
				$spb_monitoring_spb = grab_array_var($inargs,'spb_monitoring_spb','');
				$spa_monitoring_information = grab_array_var($inargs,'spa_monitoring_information','');
				$spb_monitoring_information = grab_array_var($inargs,'spb_monitoring_information','');
				$spa_monitoring_sp_busy_select = grab_array_var($inargs,'spa_monitoring_sp_busy_select','');
				$spa_monitoring_sp_busy_warn_select = grab_array_var($inargs,'spa_monitoring_sp_busy_warn_select','');
				$spa_monitoring_sp_busy_warn_value = grab_array_var($inargs,'spa_monitoring_sp_busy_warn_value','');
				$spa_monitoring_sp_busy_crit_select = grab_array_var($inargs,'spa_monitoring_sp_busy_crit_select','');
				$spa_monitoring_sp_busy_crit_value = grab_array_var($inargs,'spa_monitoring_sp_busy_crit_value','');
				$spb_monitoring_sp_busy_select = grab_array_var($inargs,'spb_monitoring_sp_busy_select','');
				$spb_monitoring_sp_busy_warn_select = grab_array_var($inargs,'spb_monitoring_sp_busy_warn_select','');
				$spb_monitoring_sp_busy_warn_value = grab_array_var($inargs,'spb_monitoring_sp_busy_warn_value','');
				$spb_monitoring_sp_busy_crit_select = grab_array_var($inargs,'spb_monitoring_sp_busy_crit_select','');
				$spb_monitoring_sp_busy_crit_value = grab_array_var($inargs,'spb_monitoring_sp_busy_crit_value','');
				$spa_monitoring_disks = grab_array_var($inargs,'spa_monitoring_disks','');
				$spb_monitoring_disks = grab_array_var($inargs,'spb_monitoring_disks','');
				$spa_monitoring_cache = grab_array_var($inargs,'spa_monitoring_cache','');
				$spb_monitoring_cache = grab_array_var($inargs,'spb_monitoring_cache','');
				$spa_monitoring_faults = grab_array_var($inargs,'spa_monitoring_faults','');
				$spb_monitoring_faults = grab_array_var($inargs,'spb_monitoring_faults','');
				$spa_monitoring_pdp = grab_array_var($inargs,'spa_monitoring_pdp','');
				$spb_monitoring_pdp = grab_array_var($inargs,'spb_monitoring_pdp','');
				$spa_monitoring_portstate_spa = grab_array_var($inargs,'spa_monitoring_portstate_spa','');
				$spa_monitoring_portstate_spb = grab_array_var($inargs,'spa_monitoring_portstate_spb','');
				$spb_monitoring_portstate_spa = grab_array_var($inargs,'spb_monitoring_portstate_spa','');
				$spb_monitoring_portstate_spb = grab_array_var($inargs,'spb_monitoring_portstate_spb','');
				$serviceargs = grab_array_var($inargs,'serviceargs','');
				$luns_counter = grab_array_var($inargs,'emcclariion-luns-counter','');
				$raid_groups_counter = grab_array_var($inargs,'emcclariion-raid-groups-counter','');
			
				/* We will save these to the session variable array for later use */
				$_SESSION[$wizard_name]['spa_monitoring_spa'] = $spa_monitoring_spa;
				$_SESSION[$wizard_name]['spa_monitoring_spb'] = $spa_monitoring_spb;
				$_SESSION[$wizard_name]['spb_monitoring_spa'] = $spb_monitoring_spa;
				$_SESSION[$wizard_name]['spb_monitoring_spb'] = $spb_monitoring_spb;
				$_SESSION[$wizard_name]['spa_monitoring_information'] = $spa_monitoring_information;
				$_SESSION[$wizard_name]['spb_monitoring_information'] = $spb_monitoring_information;
				$_SESSION[$wizard_name]['spa_monitoring_sp_busy_select'] = $spa_monitoring_sp_busy_select;
				$_SESSION[$wizard_name]['spa_monitoring_sp_busy_warn_select'] = $spa_monitoring_sp_busy_warn_select;
				$_SESSION[$wizard_name]['spa_monitoring_sp_busy_warn_value'] = $spa_monitoring_sp_busy_warn_value;
				$_SESSION[$wizard_name]['spa_monitoring_sp_busy_crit_select'] = $spa_monitoring_sp_busy_crit_select;
				$_SESSION[$wizard_name]['spa_monitoring_sp_busy_crit_value'] = $spa_monitoring_sp_busy_crit_value;
				$_SESSION[$wizard_name]['spb_monitoring_sp_busy_select'] = $spb_monitoring_sp_busy_select;
				$_SESSION[$wizard_name]['spb_monitoring_sp_busy_warn_select'] = $spb_monitoring_sp_busy_warn_select;
				$_SESSION[$wizard_name]['spb_monitoring_sp_busy_warn_value'] = $spb_monitoring_sp_busy_warn_value;
				$_SESSION[$wizard_name]['spb_monitoring_sp_busy_crit_select'] = $spb_monitoring_sp_busy_crit_select;
				$_SESSION[$wizard_name]['spb_monitoring_sp_busy_crit_value'] = $spb_monitoring_sp_busy_crit_value;
				$_SESSION[$wizard_name]['spa_monitoring_disks'] = $spa_monitoring_disks;
				$_SESSION[$wizard_name]['spb_monitoring_disks'] = $spb_monitoring_disks;
				$_SESSION[$wizard_name]['spa_monitoring_cache'] = $spa_monitoring_cache;
				$_SESSION[$wizard_name]['spb_monitoring_cache'] = $spb_monitoring_cache;
				$_SESSION[$wizard_name]['spa_monitoring_faults'] = $spa_monitoring_faults;
				$_SESSION[$wizard_name]['spb_monitoring_faults'] = $spb_monitoring_faults;
				$_SESSION[$wizard_name]['spa_monitoring_pdp'] = $spa_monitoring_pdp;
				$_SESSION[$wizard_name]['spb_monitoring_pdp'] = $spb_monitoring_pdp;
				$_SESSION[$wizard_name]['spa_monitoring_portstate_spa'] = $spa_monitoring_portstate_spa;
				$_SESSION[$wizard_name]['spa_monitoring_portstate_spb'] = $spa_monitoring_portstate_spb;
				$_SESSION[$wizard_name]['spb_monitoring_portstate_spa'] = $spb_monitoring_portstate_spa;
				$_SESSION[$wizard_name]['spb_monitoring_portstate_spb'] = $spb_monitoring_portstate_spb;
				$_SESSION[$wizard_name]['serviceargs'] = $serviceargs;
				$_SESSION[$wizard_name]['luns_counter'] = $luns_counter;
				$_SESSION[$wizard_name]['raid_groups_counter'] = $raid_groups_counter;
			} /* End if (!$back) { */
			
			/* The following THREE lines can be enabled for debugging purposes */
			//print_r('<br />_SESSION[emcclariion]<br />'); 
			//print_r($_SESSION[$wizard_name]); 
			//print_r('<br />'); 
			
			/* Now we are creating the HTML for CONFIGWIZARD_MODE_GETSTAGE3HTML */ 
			$output = '
			';
			/* The quote and semicolon ends HTML for CONFIGWIZARD_MODE_GETSTAGE3HTML */ 
			/* $output will be passed back to XI framework and rendered to browser */
			/* The next line ends CONFIGWIZARD_MODE_GETSTAGE3HTML */
			break;
			
			
		case CONFIGWIZARD_MODE_VALIDATESTAGE3DATA:
			/* No validation necessary for this stage */
			/* The next line ends CONFIGWIZARD_MODE_VALIDATESTAGE3DATA */
			break;
		
	/* This is the CONFIGWIZARD_MODE_GETSTAGE3OPTS stage */
	/* I have intentionally disabled the whole stage but have left the code here for documentation purposes */
	//	case CONFIGWIZARD_MODE_GETSTAGE3OPTS:
	//		/* Use this to hard code the Monitoring Settings options */
	//		/* The below options are currently the only supported options to hard code */
	//		$outargs[CONFIGWIZARD_OVERRIDE_OPTIONS] = array(
	//			'max_check_attempts' 	=> 15,
	//			'check_interval'        => 15,
	//			'retry_interval'        => 15,
	//			);
	//			
	//		/* Use this to hide the Monitoring Settings options */
	//		$result = CONFIGWIZARD_HIDE_OPTIONS;
	//		
	//		/* Now we are creating the HTML for CONFIGWIZARD_MODE_GETSTAGE3OPTS that will appear on CONFIGWIZARD_MODE_GETSTAGE3HTML */ 
	//		$output = '
	//		<p>
	//		<strong>Note:</strong> Manually overriding wizard options for the Monitoring Settings.
	//		</p>
	//		';
	//		/* The quote and semicolon ends HTML for CONFIGWIZARD_MODE_GETSTAGE3OPTS */ 
	//		/* $output will be passed back to XI framework and rendered to browser */
	//		/* The next line ends CONFIGWIZARD_MODE_GETSTAGE3OPTS */
	//		break;
		
		
	/* This is the CONFIGWIZARD_MODE_GETSTAGE4OPTS stage */
	/* I have intentionally disabled the whole stage but have left the code here for documentation purposes */
	//	case CONFIGWIZARD_MODE_GETSTAGE4OPTS:
	//		/* Use this to hard code the Notification Settings options */
	//		/* The below options are currently the only supported options to hard code */
	//		$outargs[CONFIGWIZARD_OVERRIDE_OPTIONS] = array(
	//		   'notification_delay'		=> 15,
	//		   'notification_interval'	=> 15,						
	//			);
	//		
	//		/* Use this to hide the different Notification Settings options */
	//		/* The below options are currently the only supported options to hide */
	//		/* NOTE: If the TARGETS option is hidden, the user running the wizard will be set as the contact TARGET */
	//		$outargs[CONFIGWIZARD_HIDDEN_OPTIONS] = array(
	//			CONFIGWIZARD_HIDE_NOTIFICATION_OPTIONS,
	//			CONFIGWIZARD_HIDE_NOTIFICATION_DELAY,
	//			CONFIGWIZARD_HIDE_NOTIFICATION_INTERVAL,
	//			CONFIGWIZARD_HIDE_NOTIFICATION_TARGETS, 
	//			);
	//		$result = CONFIGWIZARD_HIDE_OPTIONS;
	//		
	//		/* Now we are creating the HTML for CONFIGWIZARD_MODE_GETSTAGE4OPTS that will appear on CONFIGWIZARD_MODE_GETSTAGE3HTML */ 
	//		$output = '
	//		<p>
	//		<strong>Note: </strong>Manually overriding wizard options for Notification Settings.
	//		</p>
	//		';
	//		/* The quote and semicolon ends HTML for CONFIGWIZARD_MODE_GETSTAGE4OPTS */ 
	//		/* $output will be passed back to XI framework and rendered to browser */
	//		/* The next line ends CONFIGWIZARD_MODE_GETSTAGE4OPTS */
	//		break;			
		
	
		case CONFIGWIZARD_MODE_GETFINALSTAGEHTML:
			/* Now we are creating the HTML for CONFIGWIZARD_MODE_GETFINALSTAGEHTML */ 
			$output = '
			<p>
				Just one more button click :o)
				<br>
				<br>
				<br>
				Discount Offer:  Get a <b>10%</b> discount on your Nagios XI license when purchased through <a href="http://www.nagios.com/nagiosxi10?ref=box293" target="_blank"><b>this link</b></a>.<br><br><br>
			</p>
			';
			/* The quote and semicolon ends HTML for CONFIGWIZARD_MODE_GETFINALSTAGEHTML */ 
			/* $output will be passed back to XI framework and rendered to browser */
			/* The next line ends CONFIGWIZARD_MODE_GETFINALSTAGEHTML */
			break;
		
		
		/* This stage commits the wizard data into objects definitions to be imported */
		case CONFIGWIZARD_MODE_GETOBJECTS:
			/* The following THREE lines can be enabled for debugging purposes */
			//print_r('<br />_SESSION[emcclariion]<br />'); 
			//print_r($_SESSION[$wizard_name]); 
			//print_r('<br />'); 
			
			/* Get the session data to turn into object configs */
			$tab_selected = $_SESSION[$wizard_name]['tab_selected'];
			$spaselect = $_SESSION[$wizard_name]['spaselect'];
			$spbselect = $_SESSION[$wizard_name]['spbselect'];
			$monitoring_username = $_SESSION[$wizard_name]['monitoring_username'];
			$monitoring_password = $_SESSION[$wizard_name]['monitoring_password'];
			$serviceargs = $_SESSION[$wizard_name]['serviceargs'];
			$luns_counter = $_SESSION[$wizard_name]['luns_counter'];
			$raid_groups_counter = $_SESSION[$wizard_name]['raid_groups_counter'];
			
			/* Initialize objects array, this will contain the objects that we will add */
			$objs = array();
			
			/* Define the host names and create the host objects */
			/* There are different values based on which tab was selected */
			switch($tab_selected){
				case 'emcclariion-new':
					$sanname = $_SESSION[$wizard_name]['sanname'];
					$spaaddress = $_SESSION[$wizard_name]['spaaddress'];
					$spbaddress = $_SESSION[$wizard_name]['spbaddress'];
					if ($spaselect == true){
						$sannamespa = $sanname . ' SPA';
						if(!host_exists($sannamespa)) {
							$objs[] = array(
								'type' => OBJECTTYPE_HOST,
								'use' => 'xiwizard_genericnetdevice_host',
								'host_name' => $sannamespa,
								'address' => $spaaddress,
								'icon_image' => 'emc1.png',
								'statusmap_image' => 'emc1.png',
								'_xiwizard' => $wizard_name,
								);
							}
						} /* End if ($spaselect == true){ */
					if ($spbselect == true){
						$sannamespb = $sanname . ' SPB';
						if(!host_exists($sannamespb)) {
							$objs[] = array(
								'type' => OBJECTTYPE_HOST,
								'use' => 'xiwizard_genericnetdevice_host',
								'host_name' => $sannamespb,
								'address' => $spbaddress,
								'icon_image' => 'emc1.png',
								'statusmap_image' => 'emc1.png',
								'_xiwizard' => $wizard_name,
								);
							}
						} /* End if ($spbselect == true){ */		
					break; /* End case 'emcclariion-new': */
				
				case 'emcclariion-existing':
					/* Obviously the host objects would already exist so we just need to define some variables */
					$sannamespa = $_SESSION[$wizard_name]['spahostname'];
					$sannamespb = $_SESSION[$wizard_name]['spbhostname'];
					break; /* End case 'emcclariion-existing': */
				
				} /* End switch($tab_selected){ */

				
			/* Configure the services we will monitor */
			if ($_SESSION[$wizard_name]['spa_monitoring_spa'] == 'on') {
				$objs[] = array(
					'type' => OBJECTTYPE_SERVICE,
					'host_name' => $sannamespa,
					'service_description' => 'EMC CLARiiON - SPA Status via SPA',
					'check_command' => 'check_emc_clariion!$HOSTADDRESS$!-u '.$monitoring_username.'!-p '.$monitoring_password.'!-t sp!--sp A',
					'icon_image' => 'emc1.png',
					'_xiwizard' => $wizard_name,
					);
				}
					
			if ($_SESSION[$wizard_name]['spa_monitoring_spb'] == 'on') {
				$objs[] = array(
					'type' => OBJECTTYPE_SERVICE,
					'host_name' => $sannamespa,
					'service_description' => 'EMC CLARiiON - SPB Status via SPA',
					'check_command' => 'check_emc_clariion!$HOSTADDRESS$!-u '.$monitoring_username.'!-p '.$monitoring_password.'!-t sp!--sp B',
					'icon_image' => 'emc1.png',
					'_xiwizard' => $wizard_name,
					);
				}

			if ($_SESSION[$wizard_name]['spb_monitoring_spa'] == 'on') {
				$objs[] = array(
					'type' => OBJECTTYPE_SERVICE,
					'host_name' => $sannamespb,
					'service_description' => 'EMC CLARiiON - SPA Status via SPB',
					'check_command' => 'check_emc_clariion!$HOSTADDRESS$!-u '.$monitoring_username.'!-p '.$monitoring_password.'!-t sp!--sp A',
					'icon_image' => 'emc1.png',
					'_xiwizard' => $wizard_name,
					);
				}
			
			if ($_SESSION[$wizard_name]['spb_monitoring_spb'] == 'on') {
				$objs[] = array(
					'type' => OBJECTTYPE_SERVICE,
					'host_name' => $sannamespb,
					'service_description' => 'EMC CLARiiON - SPB Status via SPB',
					'check_command' => 'check_emc_clariion!$HOSTADDRESS$!-u '.$monitoring_username.'!-p '.$monitoring_password.'!-t sp!--sp B',
					'icon_image' => 'emc1.png',
					'_xiwizard' => $wizard_name,
					);
				}
			
			if ($_SESSION[$wizard_name]['spa_monitoring_information'] == 'on') {
				$objs[] = array(
					'type' => OBJECTTYPE_SERVICE,
					'host_name' => $sannamespa,
					'service_description' => 'EMC CLARiiON - SPA Information',
					'check_command' => 'check_emc_clariion!$HOSTADDRESS$!-u '.$monitoring_username.'!-p '.$monitoring_password.'!-t sp_info',
					'icon_image' => 'emc1.png',
					'_xiwizard' => $wizard_name,
					);
				}
			
			if ($_SESSION[$wizard_name]['spb_monitoring_information'] == 'on') {
				$objs[] = array(
					'type' => OBJECTTYPE_SERVICE,
					'host_name' => $sannamespb,
					'service_description' => 'EMC CLARiiON - SPB Information',
					'check_command' => 'check_emc_clariion!$HOSTADDRESS$!-u '.$monitoring_username.'!-p '.$monitoring_password.'!-t sp_info',
					'icon_image' => 'emc1.png',
					'_xiwizard' => $wizard_name,
					);
				}
			
			if ($_SESSION[$wizard_name]['spa_monitoring_disks'] == 'on') {
				$objs[] = array(
					'type' => OBJECTTYPE_SERVICE,
					'host_name' => $sannamespa,
					'service_description' => 'EMC CLARiiON - Status of All Disks via SPA',
					'check_command' => 'check_emc_clariion!$HOSTADDRESS$!-u '.$monitoring_username.'!-p '.$monitoring_password.'!-t disk',
					'icon_image' => 'emc1.png',
					'_xiwizard' => $wizard_name,
					);
				}
			
			if ($_SESSION[$wizard_name]['spb_monitoring_disks'] == 'on') {
				$objs[] = array(
					'type' => OBJECTTYPE_SERVICE,
					'host_name' => $sannamespb,
					'service_description' => 'EMC CLARiiON - Status of All Disks via SPB',
					'check_command' => 'check_emc_clariion!$HOSTADDRESS$!-u '.$monitoring_username.'!-p '.$monitoring_password.'!-t disk',
					'icon_image' => 'emc1.png',
					'_xiwizard' => $wizard_name,
					);
				}
		
			if ($_SESSION[$wizard_name]['spa_monitoring_cache'] == 'on') {
				$objs[] = array(
					'type' => OBJECTTYPE_SERVICE,
					'host_name' => $sannamespa,
					'service_description' => 'EMC CLARiiON - Status of Cache via SPA',
					'check_command' => 'check_emc_clariion!$HOSTADDRESS$!-u '.$monitoring_username.'!-p '.$monitoring_password.'!-t cache',
					'icon_image' => 'emc1.png',
					'_xiwizard' => $wizard_name,
					);
				}
			
			if ($_SESSION[$wizard_name]['spb_monitoring_cache'] == 'on') {
				$objs[] = array(
					'type' => OBJECTTYPE_SERVICE,
					'host_name' => $sannamespb,
					'service_description' => 'EMC CLARiiON - Status of Cache via SPB',
					'check_command' => 'check_emc_clariion!$HOSTADDRESS$!-u '.$monitoring_username.'!-p '.$monitoring_password.'!-t cache',
					'icon_image' => 'emc1.png',
					'_xiwizard' => $wizard_name,
					);
				}
			
			if ($_SESSION[$wizard_name]['spa_monitoring_faults'] == 'on') {
				$objs[] = array(
					'type' => OBJECTTYPE_SERVICE,
					'host_name' => $sannamespa,
					'service_description' => 'EMC CLARiiON - Status of Any Faults via SPA',
					'check_command' => 'check_emc_clariion!$HOSTADDRESS$!-u '.$monitoring_username.'!-p '.$monitoring_password.'!-t faults',
					'icon_image' => 'emc1.png',
					'_xiwizard' => $wizard_name,
					);
				}
				
			if ($_SESSION[$wizard_name]['spb_monitoring_faults'] == 'on') {
				$objs[] = array(
					'type' => OBJECTTYPE_SERVICE,
					'host_name' => $sannamespb,
					'service_description' => 'EMC CLARiiON - Status of Any Faults via SPB',
					'check_command' => 'check_emc_clariion!$HOSTADDRESS$!-u '.$monitoring_username.'!-p '.$monitoring_password.'!-t faults',
					'icon_image' => 'emc1.png',
					'_xiwizard' => $wizard_name,
					);
				}
				
			if ($_SESSION[$wizard_name]['spa_monitoring_pdp'] == 'on') {
				$objs[] = array(
					'type' => OBJECTTYPE_SERVICE,
					'host_name' => $sannamespa,
					'service_description' => 'EMC CLARiiON - SPA Percentage Dirty Pages in Cache',
					'check_command' => 'check_emc_clariion!$HOSTADDRESS$!-u '.$monitoring_username.'!-p '.$monitoring_password.'!-t cache_pdp',
					'icon_image' => 'emc1.png',
					'_xiwizard' => $wizard_name,
					);
				}
		
			if ($_SESSION[$wizard_name]['spb_monitoring_pdp'] == 'on') {
				$objs[] = array(
					'type' => OBJECTTYPE_SERVICE,
					'host_name' => $sannamespb,
					'service_description' => 'EMC CLARiiON - SPB Percentage Dirty Pages in Cache',
					'check_command' => 'check_emc_clariion!$HOSTADDRESS$!-u '.$monitoring_username.'!-p '.$monitoring_password.'!-t cache_pdp',
					'icon_image' => 'emc1.png',
					'_xiwizard' => $wizard_name,
					);
				}

			if ($_SESSION[$wizard_name]['spa_monitoring_portstate_spa'] == 'on') {
				$objs[] = array(
					'type' => OBJECTTYPE_SERVICE,
					'host_name' => $sannamespa,
					'service_description' => 'EMC CLARiiON - SPA Port State via SPA',
					'check_command' => 'check_emc_clariion!$HOSTADDRESS$!-u '.$monitoring_username.'!-p '.$monitoring_password.'!-t portstate!--sp A',
					'icon_image' => 'emc1.png',
					'_xiwizard' => $wizard_name,
					);
				}
				
			if ($_SESSION[$wizard_name]['spa_monitoring_portstate_spb'] == 'on') {
				$objs[] = array(
					'type' => OBJECTTYPE_SERVICE,
					'host_name' => $sannamespa,
					'service_description' => 'EMC CLARiiON - SPB Port State via SPA',
					'check_command' => 'check_emc_clariion!$HOSTADDRESS$!-u '.$monitoring_username.'!-p '.$monitoring_password.'!-t portstate!--sp B',
					'icon_image' => 'emc1.png',
					'_xiwizard' => $wizard_name,
					);
				}
			
			if ($_SESSION[$wizard_name]['spb_monitoring_portstate_spa'] == 'on') {
				$objs[] = array(
					'type' => OBJECTTYPE_SERVICE,
					'host_name' => $sannamespb,
					'service_description' => 'EMC CLARiiON - SPA Port State via SPB',
					'check_command' => 'check_emc_clariion!$HOSTADDRESS$!-u '.$monitoring_username.'!-p '.$monitoring_password.'!-t portstate!--sp A',
					'icon_image' => 'emc1.png',
					'_xiwizard' => $wizard_name,
					);
				}
			
			if ($_SESSION[$wizard_name]['spb_monitoring_portstate_spb'] == 'on') {
				$objs[] = array(
					'type' => OBJECTTYPE_SERVICE,
					'host_name' => $sannamespb,
					'service_description' => 'EMC CLARiiON - SPB Port State via SPB',
					'check_command' => 'check_emc_clariion!$HOSTADDRESS$!-u '.$monitoring_username.'!-p '.$monitoring_password.'!-t portstate!--sp B',
					'icon_image' => 'emc1.png',
					'_xiwizard' => $wizard_name,
					);
				}
			
			if ($_SESSION[$wizard_name]['spa_monitoring_sp_busy_select'] == 'on') {
				$spa_monitoring_sp_busy_command = '';
				if ($_SESSION[$wizard_name]['spa_monitoring_sp_busy_warn_select'] == 'on') {
					if ($_SESSION[$wizard_name]['spa_monitoring_sp_busy_crit_select'] == 'on') {
						$spa_monitoring_sp_busy_command = '--warn '.$_SESSION[$wizard_name]['spa_monitoring_sp_busy_warn_value'].'!--crit '.$_SESSION[$wizard_name]['spa_monitoring_sp_busy_crit_value'].'';
						}
					else { 
						$spa_monitoring_sp_busy_command = '--warn '.$_SESSION[$wizard_name]['spa_monitoring_sp_busy_warn_value'].'';
						}
					}
				else if ($_SESSION[$wizard_name]['spa_monitoring_sp_busy_crit_select'] == 'on') {
					$spa_monitoring_sp_busy_command = '--crit '.$_SESSION[$wizard_name]['spa_monitoring_sp_busy_crit_value'].'';
					}
				$objs[] = array(
					'type' => OBJECTTYPE_SERVICE,
					'host_name' => $sannamespa,
					'service_description' => 'EMC CLARiiON - SPA Percentage Busy',							
					'use' => 'xiwizard_generic_service',
					'check_command' => 'check_emc_clariion!$HOSTADDRESS$!-u '.$monitoring_username.'!-p '.$monitoring_password.'!-t sp_cbt_busy!--sp A!'.$spa_monitoring_sp_busy_command.'',
					'_xiwizard' => $wizard_name,
					);
				}
		
			if ($_SESSION[$wizard_name]['spb_monitoring_sp_busy_select'] == 'on') {
				$spb_monitoring_sp_busy_command = '';
				if ($_SESSION[$wizard_name]['spb_monitoring_sp_busy_warn_select'] == 'on') {
					if ($_SESSION[$wizard_name]['spb_monitoring_sp_busy_crit_select'] == 'on') {
						$spb_monitoring_sp_busy_command = '--warn '.$_SESSION[$wizard_name]['spb_monitoring_sp_busy_warn_value'].'!--crit '.$_SESSION[$wizard_name]['spb_monitoring_sp_busy_crit_value'].'';
						}
					else { 
						$spb_monitoring_sp_busy_command = '--warn '.$_SESSION[$wizard_name]['spb_monitoring_sp_busy_warn_value'].'';
						}
					}
				else if ($_SESSION[$wizard_name]['spb_monitoring_sp_busy_crit_value'] == 'on') {
					$spb_monitoring_sp_busy_command = '--crit '.$_SESSION[$wizard_name]['spb_monitoring_sp_busy_crit_value'].'';
					}
				$objs[] = array(
					'type' => OBJECTTYPE_SERVICE,
					'host_name' => $sannamespb,
					'service_description' => 'EMC CLARiiON - SPB Percentage Busy',							
					'use' => 'xiwizard_generic_service',
					'check_command' => 'check_emc_clariion!$HOSTADDRESS$!-u '.$monitoring_username.'!-p '.$monitoring_password.'!-t sp_cbt_busy!--sp B!'.$spb_monitoring_sp_busy_command.'',
					'_xiwizard' => $wizard_name,
					);
				}
		
			/* Client HBA */
			for($u=0;$u<9;$u++){
				if (isset($serviceargs['client_select'][$u])){
					if (isset($serviceargs['client_select_spa'][$u])) {
						$objs[] = array(
							'type' => OBJECTTYPE_SERVICE,
							'host_name' => $sannamespa,
							'service_description' => 'EMC CLARiiON - '.$serviceargs['client_name'][$u].' HBA State via SPA',
							'check_command' => 'check_emc_clariion!$HOSTADDRESS$!-u '.$monitoring_username.'!-p '.$monitoring_password.'!-t hbastate!--node '.$serviceargs['client_name'][$u].'!--paths '.$serviceargs['client_number_paths'][$u].'',
							'icon_image' => 'emc1.png',
							'_xiwizard' => $wizard_name,
							);
						}
					if (isset($serviceargs['client_select_spb'][$u])) {
						$objs[] = array(
							'type' => OBJECTTYPE_SERVICE,
							'host_name' => $sannamespb,
							'service_description' => 'EMC CLARiiON - '.$serviceargs['client_name'][$u].' HBA State via SPB',
							'check_command' => 'check_emc_clariion!$HOSTADDRESS$!-u '.$monitoring_username.'!-p '.$monitoring_password.'!-t hbastate!--node '.$serviceargs['client_name'][$u].'!--paths '.$serviceargs['client_number_paths'][$u].'',
							'icon_image' => 'emc1.png',
							'_xiwizard' => $wizard_name,
							);
						}
					}
				} /* End for($u=0;$u<9;$u++){ */
			
			
			/* LUNs */
			if ($luns_counter != '') {
				for ($l = 0; $l < $luns_counter; $l++) {
					if (isset($serviceargs['lun_select'][$l])) {
						
						if (isset($serviceargs['lun_select_spa'][$l])) {
							$spa_lun_command = '';
								if (isset($serviceargs['lun_warn_select'][$l])) {	
									if ($serviceargs['lun_warn_select'][$l] == 'on') {
										if (isset($serviceargs['lun_crit_select'][$l])) {
											if ($serviceargs['lun_crit_select'][$l] == 'on') {
												$spa_lun_command = '--warn '.$serviceargs['lun_warn_value'][$l].'!--crit '.$serviceargs['lun_crit_value'][$l].'';
												}
											}
										else { 
											$spa_lun_command = '--warn '.$serviceargs['lun_warn_value'][$l].'';
											}
										}
									}
							else if (isset($serviceargs['lun_crit_select'][$l])) {
								if ($serviceargs['lun_crit_select'][$l] == 'on') {
									$spa_lun_command = '--crit '.$serviceargs['lun_crit_value'][$l].'';
									}
								}
							$objs[] = array(
								'type' => OBJECTTYPE_SERVICE,
								'host_name' => $sannamespa,
								'service_description' => 'EMC CLARiiON - LUN '.$serviceargs['lun_name'][$l].' Status via SPA',
								'check_command' => 'check_emc_clariion!$HOSTADDRESS$!-u '.$monitoring_username.'!-p '.$monitoring_password.'!-t lun!--lun_id '.$serviceargs['lun_id'][$l].'!'.$spa_lun_command.'',
								'icon_image' => 'emc1.png',
								'_xiwizard' => $wizard_name,
								);
							} /* End if (isset($serviceargs['lun_select_spa'][$l])) { */
						
						if (isset($serviceargs['lun_select_spb'][$l])) {
							$spb_lun_command = '';
							if (isset($serviceargs['lun_warn_select'][$l])) {
								if ($serviceargs['lun_warn_select'][$l] == 'on') {
									if (isset($serviceargs['lun_crit_select'][$l])) {
										if ($serviceargs['lun_crit_select'][$l] == 'on') {
											$spb_lun_command = '--warn '.$serviceargs['lun_warn_value'][$l].'!--crit '.$serviceargs['lun_crit_value'][$l].'';
											}
										}
									else { 
										$spb_lun_command = '--warn '.$serviceargs['lun_warn_value'][$l].'';
										}
									}
								}
							else if (isset($serviceargs['lun_crit_select'][$l])) {
								if ($serviceargs['lun_crit_select'][$l] == 'on') {
									$spb_lun_command = '--crit '.$serviceargs['lun_crit_value'][$l].'';
									}
								}
							$objs[] = array(
								'type' => OBJECTTYPE_SERVICE,
								'host_name' => $sannamespb,
								'service_description' => 'EMC CLARiiON - LUN '.$serviceargs['lun_name'][$l].' Status via SPB',
								'check_command' => 'check_emc_clariion!$HOSTADDRESS$!-u '.$monitoring_username.'!-p '.$monitoring_password.'!-t lun!--lun_id '.$serviceargs['lun_id'][$l].'!'.$spb_lun_command.'',
								'icon_image' => 'emc1.png',
								'_xiwizard' => $wizard_name,
								);
							} /* End if (isset($serviceargs['lun_select_spb'][$l])) { */
						
						} /* End if (isset($serviceargs['lun_select'][$l])) { */
					} /* End for ($l = 0; $l < $luns_counter; $l++) { */
				} /* End if ($luns_counter != '') { */
			
			/* RAID Groups */
			if ($raid_groups_counter != '') {
				for ($rg = 0; $rg < $raid_groups_counter; $rg++) {
					if (isset($serviceargs['raid_group_select'][$rg])) {
						
						if (isset($serviceargs['raid_group_select_spa'][$rg])) {
							$spa_raid_group_command = '';
							if (isset($serviceargs['raid_group_warn_select'][$rg])) {
								if ($serviceargs['raid_group_warn_select'][$rg] == 'on') {
									if (isset($serviceargs['raid_group_crit_select'][$rg])) {
										if ($serviceargs['raid_group_crit_select'][$rg] == 'on') {
											$spa_raid_group_command = '--warn '.$serviceargs['raid_group_warn_value'][$rg].'!--crit '.$serviceargs['raid_group_crit_value'][$rg].'';
											}
										}
									else { 
										$spa_raid_group_command = '--warn '.$serviceargs['raid_group_warn_value'][$rg].'';
										}
									}
								}
							else if (isset($serviceargs['raid_group_crit_select'][$rg])) {
								if ($serviceargs['raid_group_crit_select'][$rg] == 'on') {
									$spa_raid_group_command = '--crit '.$serviceargs['raid_group_crit_value'][$rg].'';
									}
								}
							$objs[] = array(
								'type' => OBJECTTYPE_SERVICE,
								'host_name' => $sannamespa,
								'service_description' => 'EMC CLARiiON - RAID Group '.$serviceargs['raid_group_name'][$rg].' Status via SPA',
								'check_command' => 'check_emc_clariion!$HOSTADDRESS$!-u '.$monitoring_username.'!-p '.$monitoring_password.'!-t raid_group!--raid_group_id '.$serviceargs['raid_group_id'][$rg].'!'.$spa_raid_group_command.'',
								'icon_image' => 'emc1.png',
								'_xiwizard' => $wizard_name,
								);
							} /* End if (isset($serviceargs['raid_group_select_spa'][$rg])) { */
						
						if (isset($serviceargs['raid_group_select_spb'][$rg])) {
							$spb_raid_group_command = '';
							if (isset($serviceargs['raid_group_warn_select'][$rg])) {
								if ($serviceargs['raid_group_warn_select'][$rg] == 'on') {
									if (isset($serviceargs['raid_group_crit_select'][$rg])) {
										if ($serviceargs['raid_group_crit_select'][$rg] == 'on') {
											$spb_raid_group_command = '--warn '.$serviceargs['raid_group_warn_value'][$rg].'!--crit '.$serviceargs['raid_group_crit_value'][$rg].'';
											}
										}
									else { 
										$spb_raid_group_command = '--warn '.$serviceargs['raid_group_warn_value'][$rg].'';
										}
									}
								}
							else if (isset($serviceargs['raid_group_crit_select'][$rg])) {
								if ($serviceargs['raid_group_crit_select'][$rg] == 'on') {
									$spb_raid_group_command = '--crit '.$serviceargs['raid_group_crit_value'][$rg].'';
									}
								}
							$objs[] = array(
								'type' => OBJECTTYPE_SERVICE,
								'host_name' => $sannamespb,
								'service_description' => 'EMC CLARiiON - RAID Group '.$serviceargs['raid_group_name'][$rg].' Status via SPB',
								'check_command' => 'check_emc_clariion!$HOSTADDRESS$!-u '.$monitoring_username.'!-p '.$monitoring_password.'!-t raid_group!--raid_group_id '.$serviceargs['raid_group_id'][$rg].'!'.$spb_raid_group_command.'',
								'icon_image' => 'emc1.png',
								'_xiwizard' => $wizard_name,
								);
							} /* End if (isset($serviceargs['raid_group_select_spb'][$rg])) { */
						
						} /* End if (isset($serviceargs['raid_group_select'][$rg])) { */
					} /* End for ($rg = 0; $rg < $raid_groups_counter; $rg++) { */
				} /* End if ($raid_groups_counter != '') { */
			
			
			/* The following three lines can be enabled for debugging purposes */
			//print_r('<br />Objects Array:<br />');
			//print_r($objs);
			//print_r('<br />');
			
			/* Return the object definitions to the wizard */
			$outargs[CONFIGWIZARD_NAGIOS_OBJECTS] = $objs;
			
			/* clear the session variables for this wizard run */
			unset ($_SESSION[$wizard_name]); 
			
			/* The next line ends CONFIGWIZARD_MODE_GETOBJECTS */
			break;
			
		default:
			break;			
		}
		
	return $output;
	}
?>