<?php
// emcclariion_get_luns WIZARD
//
// Copyright 2013-03-09 Troy Lea aka Box293
//  

require_once(dirname(__FILE__).'/../../common.inc.php');

// initialization stuff
pre_init();
// start session
init_session();
// grab GET or POST variables 
grab_request_vars();
// check prereqs
check_prereqs();
// check authentication
check_authentication(false);

// Get all the arguments passed to us from the JavaScript function emcclariion_test_account()
$emcclariion_get_luns_username = urldecode(grab_request_var('monitoring_username',false));
$emcclariion_get_luns_password = urldecode(grab_request_var('monitoring_password',false));
$emcclariion_get_luns_spa_select = urldecode(grab_request_var('spa_select',false));
$emcclariion_get_luns_spb_select = urldecode(grab_request_var('spb_select',false));
$emcclariion_get_luns_spa_address = urldecode(grab_request_var('spa_address',false));
$emcclariion_get_luns_spb_address = urldecode(grab_request_var('spb_address',false));
if ($emcclariion_get_luns_spa_address != '') {
	$emcclariion_get_luns_final_address = $emcclariion_get_luns_spa_address;
	}
else {
	$emcclariion_get_luns_final_address = $emcclariion_get_luns_spb_address;
	}

// Now run the command to test the account details
$emcclariion_get_luns_command_to_execute = '/opt/Navisphere/bin/naviseccli -user \''.$emcclariion_get_luns_username.'\' -password \''.$emcclariion_get_luns_password.'\' -Scope 0 -h \''.$emcclariion_get_luns_final_address.'\' getlun -type -capacity -name 2>&1';
$emcclariion_get_luns_result_data = array();
exec($emcclariion_get_luns_command_to_execute, $emcclariion_get_luns_result_data);

// Let's check to see the command executed correctly
$emcclariion_get_luns_bad_result = 0;
$emcclariion_get_luns_bad_result_suggestion = '';
foreach($emcclariion_get_luns_result_data as $test_result) {
	if (strstr($test_result, 'Authentication failed')) {
		$emcclariion_get_luns_bad_result = 1;
		$emcclariion_get_luns_bad_result_suggestion = 'Perhaps the Monitoring Username OR Password are incorrect.';
		}
	
	if (strstr($test_result, 'Could not connect to the specified host')) {
		$emcclariion_get_luns_bad_result = 1;
		$emcclariion_get_luns_bad_result_suggestion = 'Perhaps the SAN is not contactable or the wrong address was supplied.';
		}
	
	if (strstr($test_result, 'No such file or directory')) {
		$emcclariion_get_luns_bad_result = 1;
		$emcclariion_get_luns_bad_result_suggestion = 'Perhaps the EMC Linux Navisphere Server Software is not installed on your ESXi host.';
		}
	}

// Produce Output
$emcclariion_get_luns_output = '';

if ($emcclariion_get_luns_bad_result == 1) {
	$emcclariion_get_luns_output = '
		<br>
		There was a problem!
		<br><br>
		'.$emcclariion_get_luns_bad_result_suggestion.'
		<br><br>
		The returned result was:
		<br><br>
		<table>
		';
		foreach($emcclariion_get_luns_result_data as $td) {
			$convert = htmlentities($td);
			$emcclariion_get_luns_output .= '<tr><td>'.$convert.'</td></tr>';
			}
		$emcclariion_get_luns_output.='
		</table>
		<br>
		';
	} /* End if ($emcclariion_get_luns_bad_result == 1) { */
else {
	$emcclariion_get_luns_counter = 0;
	$emcclariion_get_luns_output .= '
		<div style="width: 500px">
			<div style="width: 50px; float: left; font-weight: bold; text-align: center">
				Select
			</div>
			<div style="width: 450px; float: right; font-weight: bold; text-align: center">
				Define LUN Parameters
			</div>
			<br><br>
		';
	foreach($emcclariion_get_luns_result_data as $td) {
		$convert = htmlentities($td);
		
		if (preg_match('/LOGICAL UNIT NUMBER/', $convert)) {
			$convert_split = preg_split('/LOGICAL UNIT NUMBER/', $convert);
			$convert_split_no_pre_or_post_whitespace = trim($convert_split[1], ' \t');
			if ($emcclariion_get_luns_counter & 1) {
				$emcclariion_get_luns_output .= '
					<table class="emcclariion_luns" style="width: 494px">
					';
				}
			else {
				$emcclariion_get_luns_output .= '
					<table class="emcclariion_luns" style="background-color: #EEEEEE; width: 494px">
					';
				}
			$emcclariion_get_luns_output .= '
						<tr>
							<td rowspan="2" style="vertical-align: middle; text-align: center; width: 46px">'.$emcclariion_get_luns_counter.'<br><input type="checkbox" class="checkbox" name="serviceargs[lun_select]['.$emcclariion_get_luns_counter.']"></td>
							<td><label>ID:</label></td>
							<td>'.$convert_split_no_pre_or_post_whitespace.'</td>
							<input type="hidden" name="serviceargs[lun_id]['.$emcclariion_get_luns_counter.']" value="'.$convert_split_no_pre_or_post_whitespace.'">
				';
			}
		
		if (preg_match('/RAID Type:/', $convert)) {
			$convert_split = preg_split('/RAID Type:/', $convert);
			$convert_split_no_pre_or_post_whitespace = trim($convert_split[1], ' \t');
			$emcclariion_get_luns_output .= '
							<td><label>Type:</label></td>
							<td>'.$convert_split_no_pre_or_post_whitespace.'</td>
							<input type="hidden" name="serviceargs[lun_type]['.$emcclariion_get_luns_counter.']" value="'.$convert_split_no_pre_or_post_whitespace.'">
				';	
			}
		
		if (preg_match('/LUN Capacity\(Megabytes\):/', $convert)) {
			$convert_split = preg_split('/LUN Capacity\(Megabytes\):/', $convert);
			$convert_split_no_pre_or_post_whitespace = trim($convert_split[1], ' \t');
			$emcclariion_get_luns_output .= '
							<td><label>Size:</label></td>
							<td>'.emcclariion_get_luns_size_format($convert_split_no_pre_or_post_whitespace*1048576).'</td>
							<input type="hidden" name="serviceargs[lun_size]['.$emcclariion_get_luns_counter.']" value="'.emcclariion_get_luns_size_format($convert_split_no_pre_or_post_whitespace*1048576).'">
							<td rowspan="2" style="width: 80px; text-align: center"><label>Monitoring<br>via</label></td>
							<td rowspan="2" style="width: 60px">
				';
			if ($emcclariion_get_luns_spa_select == true){
				$emcclariion_get_luns_output .= '
								<label>SPA:</label><input type="checkbox" class="checkbox" name="serviceargs[lun_select_spa]['.$emcclariion_get_luns_counter.']">
				';
				}
			if ($emcclariion_get_luns_spb_select == true){
				$emcclariion_get_luns_output .= '
								<label>SPB:</label><input type="checkbox" class="checkbox" name="serviceargs[lun_select_spb]['.$emcclariion_get_luns_counter.']">
				';
				}
			$emcclariion_get_luns_output.='	
							</td>
						</tr>
				';
			}
		
		if (preg_match('/Name/', $convert)) {
			$convert_split = preg_split('/Name/', $convert);
			$convert_split_no_pre_or_post_whitespace = trim($convert_split[1], ' \t');
			$emcclariion_get_luns_output .= '
						<tr>
							<td><label>Name:</label></td>
							<td colspan="5"><input type="text" size="35" name="serviceargs[lun_name]['.$emcclariion_get_luns_counter.']" value="'.$convert_split_no_pre_or_post_whitespace.'" class="textfield"></td>
						</tr>
						<tr>
				';	
			if ($emcclariion_get_luns_counter & 1) {
				$emcclariion_get_luns_output .= '
							<table class="emcclariion_luns" style="width: 500px">
					';
				}
			else {
				$emcclariion_get_luns_output .= '
							<table class="emcclariion_luns" style="background-color: #EEEEEE; width: 494px">
					';
				}
			$emcclariion_get_luns_output .= '
								<tr>
									<td style="width: 50px"></td>
									<td align="right"><input type="checkbox" class="checkbox" name="serviceargs[lun_warn_select]['.$emcclariion_get_luns_counter.']"></td>
									<td><label>Warning:</label></td>
									<td><input type="text" size="5" name="serviceargs[lun_warn_value]['.$emcclariion_get_luns_counter.']" class="textfield"></td>
									<td></td>
									<td align="right"><input type="checkbox" class="checkbox" name="serviceargs[lun_crit_select]['.$emcclariion_get_luns_counter.']"></td>
									<td><label>Critical:</label></td>
									<td><input type="text" size="5" name="serviceargs[lun_crit_value]['.$emcclariion_get_luns_counter.']" class="textfield"></td>
									<td></td>
								</tr>
							</table>
							
						</tr>
				';	
			$emcclariion_get_luns_counter++;	
			}
		
		} /* End foreach($emcclariion_get_luns_result_data as $td) { */
	$emcclariion_get_luns_output .= '
					</table>
		';
	
	} /* End else { */

if ($emcclariion_get_luns_bad_result == 0) {	
	$emcclariion_get_luns_output .= '
		<input type="hidden" name="emcclariion-luns-counter" value="'.$emcclariion_get_luns_counter.'">
		';
	}

$emcclariion_get_luns_output .= '
	</div> <!-- This is the end of the div for width -->
	';


// Display the Output
print $emcclariion_get_luns_output;


function emcclariion_get_luns_size_format($size) {
	if ($size < (1024)) {
		return sprintf("%.2fB",$size);
		}
	if ($size < (1024*1024)) {
		return sprintf("%.2fKB",$size / (1024));
		}
	if ($size < (1024*1024*1024)) {
		return sprintf("%.2fMB",$size / (1024*1024));
		}
	if ($size < (1024*1024*1024*1024)) {
		return sprintf("%.2fGB",$size / (1024*1024*1024));
		}
	if ($size < (1024*1024*1024*1024*1024)) {
		return sprintf("%.2fTB",$size / (1024*1024*1024*1024));
		}
	if ($size < (1024*1024*1024*1024*1024*1024)) {
		return sprintf("%.2fPB",$size / (1024*1024*1024*1024*1024));
		}
	if ($size < (1024*1024*1024*1024*1024*1024*1024)) {
		return sprintf("%.2fEB",$size / (1024*1024*1024*1024*1024*1024));
		}
	} /* End function emcclariion_get_luns_size_format($size) { */


?>