<?php
// emcclariion_get_raid_groups WIZARD
//
// Copyright 2013-03-09 Troy Lea aka Box293
//  

require_once(dirname(__FILE__).'/../../common.inc.php');

// initialization stuff
pre_init();
// start session
init_session();
// grab GET or POST variables 
grab_request_vars();
// check prereqs
check_prereqs();
// check authentication
check_authentication(false);

// Get all the arguments passed to us from the JavaScript function emcclariion_test_account()
$emcclariion_get_raid_groups_username = urldecode(grab_request_var('monitoring_username',false));
$emcclariion_get_raid_groups_password = urldecode(grab_request_var('monitoring_password',false));
$emcclariion_get_raid_groups_spa_select = urldecode(grab_request_var('spa_select',false));
$emcclariion_get_raid_groups_spb_select = urldecode(grab_request_var('spb_select',false));
$emcclariion_get_raid_groups_spa_address = urldecode(grab_request_var('spa_address',false));
$emcclariion_get_raid_groups_spb_address = urldecode(grab_request_var('spb_address',false));
if ($emcclariion_get_raid_groups_spa_address != '') {
	$emcclariion_get_raid_groups_final_address = $emcclariion_get_raid_groups_spa_address;
	}
else {
	$emcclariion_get_raid_groups_final_address = $emcclariion_get_raid_groups_spb_address;
	}

// Now run the command to test the account details
$emcclariion_get_raid_groups_command_to_execute = '/opt/Navisphere/bin/naviseccli -user \''.$emcclariion_get_raid_groups_username.'\' -password \''.$emcclariion_get_raid_groups_password.'\' -Scope 0 -h \''.$emcclariion_get_raid_groups_final_address.'\' getrg -type -tcap 2>&1';
$emcclariion_get_raid_groups_result_data = array();
exec($emcclariion_get_raid_groups_command_to_execute, $emcclariion_get_raid_groups_result_data);

// Let's check to see the command executed correctly
$emcclariion_get_raid_groups_bad_result = 0;
$emcclariion_get_raid_groups_bad_result_suggestion = '';
foreach($emcclariion_get_raid_groups_result_data as $test_result) {
	if (strstr($test_result, 'Authentication failed')) {
		$emcclariion_get_raid_groups_bad_result = 1;
		$emcclariion_get_raid_groups_bad_result_suggestion = 'Perhaps the Monitoring Username OR Password are incorrect.';
		}
	
	if (strstr($test_result, 'Could not connect to the specified host')) {
		$emcclariion_get_raid_groups_bad_result = 1;
		$emcclariion_get_raid_groups_bad_result_suggestion = 'Perhaps the SAN is not contactable or the wrong address was supplied.';
		}
	
	if (strstr($test_result, 'No such file or directory')) {
		$emcclariion_get_raid_groups_bad_result = 1;
		$emcclariion_get_raid_groups_bad_result_suggestion = 'Perhaps the EMC Linux Navisphere Server Software is not installed on your ESXi host.';
		}
	}

// Produce Output
$emcclariion_get_raid_groups_output = '';

if ($emcclariion_get_raid_groups_bad_result == 1) {
	$emcclariion_get_raid_groups_output = '
		<br>
		There was a problem!
		<br><br>
		'.$emcclariion_get_raid_groups_bad_result_suggestion.'
		<br><br>
		The returned result was:
		<br><br>
		<table>
		';
		foreach($emcclariion_get_raid_groups_result_data as $td) {
			$convert = htmlentities($td);
			$emcclariion_get_raid_groups_output .= '<tr><td>'.$convert.'</td></tr>';
			}
		$emcclariion_get_raid_groups_output.='
		</table>
		<br>
		';
	} /* End if ($emcclariion_get_raid_groups_bad_result == 1) { */
else {
	$emcclariion_get_raid_groups_counter = 0;
	$emcclariion_get_raid_groups_output .= '
		<div style="width: 500px">
			<div style="width: 50px; float: left; font-weight: bold; text-align: center">
				Select
			</div>
			<div style="width: 450px; float: right; font-weight: bold; text-align: center">
				Define RAID Group Parameters
			</div>
			<br><br>
		';
	foreach($emcclariion_get_raid_groups_result_data as $td) {
		$convert = htmlentities($td);
		
		if (preg_match('/RaidGroup ID:/', $convert)) {
			$convert_split = preg_split('/RaidGroup ID:/', $convert);
			$convert_split_no_pre_or_post_whitespace = trim($convert_split[1], ' \t');
			$emcclariion_get_raid_group_id = $convert_split_no_pre_or_post_whitespace;
			if ($emcclariion_get_raid_groups_counter & 1) {
				$emcclariion_get_raid_groups_output .= '
					<table class="emcclariion_raid_groups" style="width: 494px">
					';
				}
			else {
				$emcclariion_get_raid_groups_output .= '
					<table class="emcclariion_raid_groups" style="background-color: #EEEEEE; width: 494px">
					';
				}
			$emcclariion_get_raid_groups_output .= '
						<tr>
							<td rowspan="2" style="vertical-align: middle; text-align: center; width: 46px">'.$emcclariion_get_raid_groups_counter.'<br><input type="checkbox" class="checkbox" name="serviceargs[raid_group_select]['.$emcclariion_get_raid_groups_counter.']"></td>
							<td><label>ID:</label></td>
							<td style="width: 25px">'.$emcclariion_get_raid_group_id.'</td>
							<input type="hidden" name="serviceargs[raid_group_id]['.$emcclariion_get_raid_groups_counter.']" value="'.$emcclariion_get_raid_group_id.'">
				';
			}
		
		if (preg_match('/RaidGroup Type:/', $convert)) {
			$convert_split = preg_split('/RaidGroup Type:/', $convert);
			$convert_split_no_pre_or_post_whitespace = trim($convert_split[1], ' \t');
			$convert_split_final = emcclariion_get_raid_type($convert_split_no_pre_or_post_whitespace);
			$emcclariion_get_raid_groups_output .= '
							<td><label>Type:</label></td>
							<td>'.$convert_split_final.'</td>
							<input type="hidden" name="serviceargs[raid_group_type]['.$emcclariion_get_raid_groups_counter.']" value="'.$convert_split_final.'">
				';
			}
		
		if (preg_match('/Logical Capacity \(Blocks\):/', $convert)) {
			$convert_split = preg_split('/Logical Capacity \(Blocks\):/', $convert);
			$convert_split_no_pre_or_post_whitespace = trim($convert_split[1], ' \t');
			$emcclariion_get_raid_groups_output .= '
							<td><label>Size:</label></td>
							<td colspan="2">'.emcclariion_get_raid_groups_size_format($convert_split_no_pre_or_post_whitespace*512).'</td>
							<input type="hidden" name="serviceargs[raid_group_size]['.$emcclariion_get_raid_groups_counter.']" value="'.emcclariion_get_raid_groups_size_format($convert_split_no_pre_or_post_whitespace*512).'">
							<td rowspan="2" style="width: 80px; text-align: center"><label>Monitoring<br>via</label></td>
							<td rowspan="2" style="width: 60px">
				';
			if ($emcclariion_get_raid_groups_spa_select == true){
				$emcclariion_get_raid_groups_output .= '
				<label>SPA:</label><input type="checkbox" class="checkbox" name="serviceargs[raid_group_select_spa]['.$emcclariion_get_raid_groups_counter.']">
				';
				}
			if ($emcclariion_get_raid_groups_spb_select == true){
				$emcclariion_get_raid_groups_output .= '
				<label>SPB:</label><input type="checkbox" class="checkbox" name="serviceargs[raid_group_select_spb]['.$emcclariion_get_raid_groups_counter.']">
				';
				}
			$emcclariion_get_raid_groups_output.='	
							</td>
						</tr>
						<tr>
							<td><label>Name:</label></td>
							<td colspan="6"><input type="text" size="40" name="serviceargs[raid_group_name]['.$emcclariion_get_raid_groups_counter.']" value="RAID Group '.$emcclariion_get_raid_group_id.'" class="textfield"></td>
						</tr>
						<tr>
				';
			if ($emcclariion_get_raid_groups_counter & 1) {
				$emcclariion_get_raid_groups_output .= '
							<table class="emcclariion_raid_groups" style="width: 494px">
					';
				}
			else {
				$emcclariion_get_raid_groups_output .= '
							<table class="emcclariion_raid_groups" style="background-color: #EEEEEE; width: 494px">
					';
				}
			$emcclariion_get_raid_groups_output .= '
								<tr>
									<td style="width: 50px"></td>
									<td align="right"><input type="checkbox" class="checkbox" name="serviceargs[raid_group_warn_select]['.$emcclariion_get_raid_groups_counter.']"></td>
									<td><label>Warning:</label></td>
									<td><input type="text" size="5" name="serviceargs[raid_group_warn_value]['.$emcclariion_get_raid_groups_counter.']" class="textfield"></td>
									<td></td>
									<td align="right"><input type="checkbox" class="checkbox" name="serviceargs[raid_group_crit_select]['.$emcclariion_get_raid_groups_counter.']"></td>
									<td><label>Critical:</label></td>
									<td><input type="text" size="5" name="serviceargs[raid_group_crit_value]['.$emcclariion_get_raid_groups_counter.']" class="textfield"></td>
									<td></td>
								</tr>
							</table>
					
						</tr>
				';
			$emcclariion_get_raid_groups_counter++;	
			}
		
		} /* End foreach($emcclariion_get_raid_groups_result_data as $td) { */
	$emcclariion_get_raid_groups_output .= '
					</table>
		';
	} /* End else { */

if ($emcclariion_get_raid_groups_bad_result == 0) {	
	$emcclariion_get_raid_groups_output .= '
		<input type="hidden" name="emcclariion-raid-groups-counter" value="'.$emcclariion_get_raid_groups_counter.'">
		';
	}
	
$emcclariion_get_raid_groups_output .= '
	</div> <!-- This is the end of the div for width -->
	';


// Display the Output
print $emcclariion_get_raid_groups_output;


function emcclariion_get_raid_groups_size_format($size) {
	if ($size < (1024)) {
		return sprintf("%.2fB",$size);
		}
	if ($size < (1024*1024)) {
		return sprintf("%.2fKB",$size / (1024));
		}
	if ($size < (1024*1024*1024)) {
		return sprintf("%.2fMB",$size / (1024*1024));
		}
	if ($size < (1024*1024*1024*1024)) {
		return sprintf("%.2fGB",$size / (1024*1024*1024));
		}
	if ($size < (1024*1024*1024*1024*1024)) {
		return sprintf("%.2fTB",$size / (1024*1024*1024*1024));
		}
	if ($size < (1024*1024*1024*1024*1024*1024)) {
		return sprintf("%.2fPB",$size / (1024*1024*1024*1024*1024));
		}
	if ($size < (1024*1024*1024*1024*1024*1024*1024)) {
		return sprintf("%.2fEB",$size / (1024*1024*1024*1024*1024*1024));
		}
	} /* End function emcclariion_get_raid_groups_size_format($size) { */


function emcclariion_get_raid_type($raid_group_raid_type) {
	if ($raid_group_raid_type == 'r0') {
		return 'RAID 0';
		}
	if ($raid_group_raid_type == 'r1') {
		return 'RAID 1';
		}
	if ($raid_group_raid_type == 'r3') {
		return 'RAID 3';
		}
	if ($raid_group_raid_type == 'r5') {
		return 'RAID 5';
		}
	if ($raid_group_raid_type == 'r6') {
		return 'RAID 6';
		}
	if ($raid_group_raid_type == 'r1_0') {
		return 'RAID 1/0';
		}
	if ($raid_group_raid_type == 'id') {
		return 'Individual Disk';
		}
	if ($raid_group_raid_type == 'hot_spare') {
		return 'Hot Spare';
		}
	} /* End function emcclariion_get_raid_type($raid_group_raid_type) { */
	
	
?>