<?php
// emcclariion_test_monitoring_account WIZARD
//
// Copyright 2013-03-09 Troy Lea aka Box293
//  

require_once(dirname(__FILE__).'/../../common.inc.php');

// initialization stuff
pre_init();
// start session
init_session();
// grab GET or POST variables 
grab_request_vars();
// check prereqs
check_prereqs();
// check authentication
check_authentication(false);

	
// Get all the arguments passed to us from the JavaScript function emcclariion_test_account()
$emcclariion_test_monitoring_account_username = urldecode(grab_request_var('monitoring_username',false));
$emcclariion_test_monitoring_account_password = urldecode(grab_request_var('monitoring_password',false));
$emcclariion_test_monitoring_account_spa_address = urldecode(grab_request_var('spa_address',false));
$emcclariion_test_monitoring_account_spb_address = urldecode(grab_request_var('spb_address',false));
if ($emcclariion_test_monitoring_account_spa_address != '') {
	$emcclariion_test_monitoring_account_final_address = $emcclariion_test_monitoring_account_spa_address;
	}
else {
	$emcclariion_test_monitoring_account_final_address = $emcclariion_test_monitoring_account_spb_address;
	}

// Now run the command to test the account details
$emcclariion_test_monitoring_account_command_to_execute = '/opt/Navisphere/bin/naviseccli -user \''.$emcclariion_test_monitoring_account_username.'\' -password \''.$emcclariion_test_monitoring_account_password.'\' -Scope 0 -h \''.$emcclariion_test_monitoring_account_final_address.'\' getsp 2>&1';
$emcclariion_test_monitoring_account_result_data = array();
exec($emcclariion_test_monitoring_account_command_to_execute, $emcclariion_test_monitoring_account_result_data);

// Let's check to see the command executed correctly
$emcclariion_test_monitoring_account_bad_result = 0;
$emcclariion_test_monitoring_account_bad_result_suggestion = '';
foreach($emcclariion_test_monitoring_account_result_data as $test_result) {
	if (strstr($test_result, 'Authentication failed')) {
		$emcclariion_test_monitoring_account_bad_result = 1;
		$emcclariion_test_monitoring_account_bad_result_suggestion = 'Perhaps the Monitoring Username OR Password are incorrect.';
		}
	
	if (strstr($test_result, 'Could not connect to the specified host')) {
		$emcclariion_test_monitoring_account_bad_result = 1;
		$emcclariion_test_monitoring_account_bad_result_suggestion = 'Perhaps the SAN is not contactable or the wrong address was supplied.';
		}
	
	if (strstr($test_result, 'No such file or directory')) {
		$emcclariion_test_monitoring_account_bad_result = 1;
		$emcclariion_test_monitoring_account_bad_result_suggestion = 'Perhaps the EMC Linux Navisphere Server Software is not installed on your ESXi host.';
		}
	}

// Produce Output
if ($emcclariion_test_monitoring_account_bad_result == 1) {

	$emcclariion_test_monitoring_account_output = '
		<br>
		There was a problem!
		<br><br>
		'.$emcclariion_test_monitoring_account_bad_result_suggestion.'
		<br><br>
		The returned result was:
		<br><br>
		<table>
		';
		foreach($emcclariion_test_monitoring_account_result_data as $td) {
			$convert = htmlentities($td);
			$emcclariion_test_monitoring_account_output .= '<tr><td>'.$convert.'</td></tr>';
			}
		$emcclariion_test_monitoring_account_output.='
		</table>
		<br>
		';
	}
else {
	$emcclariion_test_monitoring_account_output = '
		<br>
		The account details CORRECTLY connected to the EMC CLARiiON.
		';
	}


// Display the Output
print $emcclariion_test_monitoring_account_output;



?>