/*
 * Decompiled with CFR 0.152.
 */
package com.servprise.nagios;

import com.servprise.webreboot.WebReboot;
import com.servprise.webreboot.WebRebootException;
import java.util.Iterator;
import java.util.List;

public class Nagios {
    private static final String GET_WEBREBOOT_PORT_CMD = "get_webreboot_port";
    private static final String GET_HOSTS_CMD = "get_hosts";
    private static final String POWER_OFF_CMD = "power_off_host";
    private static final String POWER_ON_CMD = "power_on_host";
    private static final String REBOOT_HOST_CMD = "reboot_host";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) {
        String webRebootHostname = args[0];
        String username = args[1];
        String password = args[2];
        String scheme = args[3];
        String port = args[4];
        String command = args[5];
        String commandArgument = args.length == 7 ? args[6] : null;
        boolean inDebugMode = false;
        String debugProperty = System.getProperty("debug");
        if (null != debugProperty) {
            inDebugMode = true;
        }
        if (inDebugMode) {
            System.out.println("WebReboot hostname: " + webRebootHostname);
            System.out.println("Username: " + username);
            System.out.println("Password: " + password);
            System.out.println("Scheme: " + scheme);
            System.out.println("Port: " + port);
            System.out.println("Command: " + command);
            System.out.println("Command argument: " + commandArgument);
        }
        WebReboot wr = new WebReboot();
        try {
            wr.connect(webRebootHostname, port, scheme);
        }
        catch (WebRebootException e) {
            System.out.println("Could not connect to WebReboot 3.0:" + e.getMessage());
            System.exit(-1);
        }
        if (wr.isInUse()) {
            System.out.println("Could not connect to WebReboot 3.0: Someone already logged in.");
            System.exit(-1);
        }
        int status = 0;
        try {
            wr.login(username, password);
            if (GET_WEBREBOOT_PORT_CMD.equals(command)) {
                String serverID = commandArgument;
                System.out.print(wr.getServerName(serverID));
            } else if (GET_HOSTS_CMD.equals(command)) {
                StringBuffer output = new StringBuffer();
                List serverIDs = wr.getServerIDs(wr.getUserID());
                Iterator it = serverIDs.iterator();
                while (it.hasNext()) {
                    String serverID = (String)it.next();
                    String serverName = wr.getServerName(serverID);
                    output.append(serverID).append(",").append(serverName);
                    if (!it.hasNext()) continue;
                    output.append("\n");
                }
                System.out.print(output);
            } else {
                String hostname = commandArgument;
                String serverID = Nagios.getServerID(wr, hostname);
                if (REBOOT_HOST_CMD.equals(command)) {
                    if (wr.isPlainRebootable(serverID)) {
                        wr.plainReboot(serverID);
                    } else {
                        wr.powerReboot(serverID);
                    }
                } else if (POWER_OFF_CMD.equals(command)) {
                    if (!wr.isPowerRebootable(serverID)) throw new UnsupportedOperationException("Hostname " + hostname + " is not configured for power reboot for user " + username + ".");
                    wr.powerOff(serverID);
                } else if (POWER_ON_CMD.equals(command)) {
                    if (!wr.isPowerRebootable(serverID)) throw new UnsupportedOperationException("Hostname " + hostname + " is not configured for power reboot for user " + username + ".");
                    wr.powerOn(serverID);
                } else {
                    System.out.println("Problem interacting with WebReboot 3.0: Unsupported command: " + command);
                    status = -1;
                }
            }
        }
        catch (Exception e) {
            System.out.println("Problem interacting with WebReboot 3.0: " + e.getMessage());
            status = -1;
        }
        finally {
            wr.logout();
        }
        System.exit(status);
    }

    private static String getServerID(WebReboot wr, String hostname) {
        String ret = null;
        List serverIDs = wr.getServerIDs(wr.getUserID());
        for (String serverID : serverIDs) {
            String serverName = wr.getServerName(serverID);
            if (!serverName.equals(hostname)) continue;
            if (null == ret) {
                ret = serverID;
                continue;
            }
            throw new IllegalStateException("Hostname " + hostname + " is used by multiple ports.");
        }
        if (null == ret) {
            throw new IllegalStateException("Hostname " + hostname + " not found on WebReboot 3.0.");
        }
        return ret;
    }
}

