/*
 * Decompiled with CFR 0.152.
 */
package com.servprise.webreboot;

import com.servprise.webreboot.Command;
import com.servprise.webreboot.User;
import com.servprise.webreboot.WebReboot;
import com.servprise.webreboot.WebRebootConnection;

class CommandFactory {
    private static final int MAX_SERVERNAME_LENGTH = 16;
    private final String session;
    private final WebReboot webreboot;

    public CommandFactory(String string, WebReboot webReboot) {
        this.session = string;
        this.webreboot = webReboot;
    }

    public Command login(User user) {
        return new Command("main.spi?io7=0&com={l" + user.getNormalizedUsername() + user.getMaskedPassword(User.USE_MASK) + this.session + "}&io7=1", 0);
    }

    public Command logout() {
        return new Command("main.spi?io7=0&com={o" + this.session + "}&io7=1", 4);
    }

    public Command modifyUser(User user, int n) {
        return new Command("main.spi?io7=0&com={u" + this.session + n + user.getNormalizedUsername() + user.getMaskedPassword(User.SET_MASK) + "}&io7=1", 7);
    }

    public Command plainReboot(int n) {
        return new Command("main.spi?io7=0&com={r" + this.session + n + "}&io7=1", 1);
    }

    public Command powerReboot(int n) {
        return new Command("main.spi?io7=0&com={c" + this.session + n + "}&io7=1", 9);
    }

    public Command powerOff(int n) {
        return new Command("main.spi?io7=0&com={b" + this.session + n + "}&io7=1", 9);
    }

    public Command powerOn(int n) {
        return new Command("main.spi?io7=0&com={f" + this.session + n + "}&io7=1", 9);
    }

    public Command renameServer(int n, String string) {
        StringBuffer stringBuffer;
        String string2 = "main.spi?io7=0&com={n" + this.session;
        if (n % 2 == 0) {
            stringBuffer = new StringBuffer(string2 + n + WebRebootConnection.normalizeText(string, 32));
            stringBuffer.append(WebRebootConnection.normalizeText(this.webreboot.getServerName(WebReboot.SERVER_IDS[n + 1]), 32)).append("}&io7=1");
        } else {
            stringBuffer = new StringBuffer(string2 + (n - 1) + WebRebootConnection.normalizeText(this.webreboot.getServerName(WebReboot.SERVER_IDS[n - 1]), 32));
            stringBuffer.append(WebRebootConnection.normalizeText(string, 32)).append("}&io7=1");
        }
        return new Command(stringBuffer.toString(), 2);
    }

    public Command updateRebootTypes(String string) {
        return new Command("main.spi?io7=0&com={t" + this.session + string + "}&io7=1", 2);
    }

    public Command changeIP(int[] nArray) {
        return new Command("main.spi?io7=0&com={i" + this.session + WebRebootConnection.generateHexStringRepresentation(nArray) + "}&io7=1", 5);
    }

    public Command removeUser(int n) {
        return new Command("main.spi?io7=0&com={d" + this.session + n + "}&io7=1", 8);
    }

    public Command addUser(User user, int n) {
        return new Command("main.spi?io7=0&com={a" + this.session + n + user.getNormalizedUsername() + user.getMaskedPassword(User.SET_MASK) + "%" + user.getPermsString() + "}&io7=1", 6);
    }

    public Command changePermissions(User user, int n) {
        return new Command("main.spi?io7=0&com={p" + this.session + n + "%" + user.getPermsString() + "}&io7=1", 7);
    }
}

