/*
 * Decompiled with CFR 0.152.
 */
package com.servprise.webreboot;

import com.servprise.webreboot.WebRebootConnection;
import com.servprise.webreboot.WebRebootException;
import java.io.UnsupportedEncodingException;

class User {
    private final String username;
    private String password;
    private final int perms;
    private static final int USER_LENGTH = 16;
    private static final int PASSWORD_LENGTH = 16;
    public static final int[] SET_MASK = new int[]{199, 249, 146, 121, 80, 208, 31, 97, 57, 65, 233, 13, 221, 44, 159, 89, 213, 101, 138, 229, 191, 211, 236, 201, 115, 196, 84, 77, 167, 148, 214, 248};
    public static final int[] USE_MASK = new int[]{151, 218, 172, 27, 72, 174, 247, 226, 189, 123, 181, 213, 73, 243, 177, 92, 90, 161, 179, 173, 198, 199, 182, 101, 251, 138, 80, 73, 1, 184, 81, 159};

    public User(String string, String string2) {
        this(string, string2, 0);
    }

    public User(String string, String string2, int n) {
        this.username = string;
        this.password = string2;
        this.perms = n;
    }

    public String getMaskedPassword(int[] nArray) {
        try {
            int n;
            int[] nArray2 = new int[32];
            byte[] byArray = this.password.getBytes("UTF-8");
            for (n = 0; n < nArray2.length; ++n) {
                nArray2[n] = n < byArray.length ? byArray[n] : 32;
            }
            for (n = 0; n < nArray2.length; n += 2) {
                int n2 = nArray2[n + 1];
                nArray2[n + 1] = nArray2[n];
                nArray2[n] = n2;
            }
            for (n = 0; n < nArray2.length; ++n) {
                int n3 = n;
                nArray2[n3] = nArray2[n3] ^ nArray[n];
            }
            return WebRebootConnection.generateHexStringRepresentation(nArray2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new WebRebootException("System does not support UTF-8 encoding.", unsupportedEncodingException);
        }
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getNormalizedUsername() {
        return WebRebootConnection.normalizeText(this.username, 32);
    }

    public String getUsername() {
        return this.username;
    }

    public String getPermsString() {
        String string = Integer.toHexString(this.perms);
        if (string.length() == 1) {
            string = "0" + string;
        }
        return string;
    }

    public static User createUser(String string, int n) {
        if (!string.equals("                                ")) {
            return new User(string.trim(), null, n);
        }
        return null;
    }

    public int getPerms() {
        return this.perms;
    }
}

