/*
 * Decompiled with CFR 0.152.
 */
package com.servprise.webreboot;

import com.servprise.webreboot.Command;
import com.servprise.webreboot.CommandFactory;
import com.servprise.webreboot.CommandProcessor;
import com.servprise.webreboot.User;
import com.servprise.webreboot.WebRebootConnection;
import com.servprise.webreboot.WebRebootException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class WebReboot {
    static final String[] SERVER_IDS = new String[]{"srv0", "srv1", "srv2", "srv3", "srv4", "srv5", "srv6", "srv7"};
    private static final String[] USER_IDS = new String[]{"user0", "user1", "user2", "user3", "user4", "user5", "user6", "user7", "user8"};
    private WebRebootConnection conn;
    private CommandFactory factory;

    WebRebootConnection getConnection() {
        if (null == this.conn) {
            throw new WebRebootException("Must be connected to the WebReboot to perform operation.");
        }
        return this.conn;
    }

    private CommandFactory getFactory() {
        if (null == this.factory) {
            throw new WebRebootException("Must be connected to the WebReboot to perform operation.");
        }
        return this.factory;
    }

    private void sendCommand(Command command) {
        CommandProcessor commandProcessor = new CommandProcessor(this, command);
        commandProcessor.process();
    }

    private void checkPermissions() {
        if (!this.isAdmin()) {
            throw new WebRebootException("Logged on user does not have permission to complete this operation.");
        }
    }

    private void checkValidServerID(String string) {
        if (!this.getServerIDs(this.getUserID()).contains(string)) {
            throw new WebRebootException("The supplied ID is not valid: ", string);
        }
    }

    private void checkValidUserID(String string) {
        if (this.getUserID().equals(string)) {
            return;
        }
        if (!this.isAdmin()) {
            throw new WebRebootException("The supplied ID is not valid: ", string);
        }
        if (!this.getUserIDs().contains(string)) {
            throw new WebRebootException("The supplied ID is not valid: ", string);
        }
    }

    private void checkLoggedIn() {
        if (!this.isLoggedIn()) {
            throw new WebRebootException("Must be logged into the WebReboot to perform operation.");
        }
    }

    public void connect(String string, String string2, String string3) {
        this.disconnect();
        this.conn = new WebRebootConnection(string, string2, string3);
        this.factory = new CommandFactory(this.getConnection().getSession(), this);
    }

    void disconnect() {
        this.conn = null;
        this.factory = null;
    }

    public boolean isLoggedIn() {
        return this.getConnection().isLoggedIn();
    }

    public boolean isInUse() {
        return this.getConnection().isInUse();
    }

    public boolean isAdmin() {
        this.checkLoggedIn();
        return this.getConnection().getUserSlot() == 0;
    }

    boolean isConnected() {
        return this.conn != null;
    }

    public void login(String string, String string2) {
        User user = new User(string, string2);
        Command command = this.getFactory().login(user);
        this.sendCommand(command);
    }

    public void logout() {
        if (this.isLoggedIn()) {
            Command command = this.getFactory().logout();
            this.sendCommand(command);
        }
    }

    public List getServerIDs(String string) {
        this.checkLoggedIn();
        this.checkValidUserID(string);
        User user = this.getUser(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < SERVER_IDS.length; ++i) {
            String string2 = SERVER_IDS[i];
            if ((user.getPerms() & 1 << i) == 0) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public List getUserIDs() {
        this.checkLoggedIn();
        this.checkPermissions();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 1; i < USER_IDS.length; ++i) {
            byte by;
            String string = this.getConnection().getParameter(USER_IDS[i]);
            String string2 = string.substring(0, string.length() - 3);
            if (null == User.createUser(string2, by = Integer.valueOf(string.substring(string.length() - 3, string.length())).byteValue())) continue;
            arrayList.add(USER_IDS[i]);
        }
        return arrayList;
    }

    public boolean isPlainRebootable(String string) {
        this.checkLoggedIn();
        this.checkValidServerID(string);
        int n = Arrays.asList(SERVER_IDS).indexOf(string);
        String string2 = this.getConnection().getParameter("rebtype");
        return string2.charAt(n) == 'r' || string2.charAt(n) == 'b';
    }

    public void setPlainRebootable(String string) {
        this.checkLoggedIn();
        this.checkPermissions();
        this.checkValidServerID(string);
        int n = Arrays.asList(SERVER_IDS).indexOf(string);
        String string2 = this.getConnection().getParameter("rebtype");
        String string3 = string2.substring(0, n) + "r" + string2.substring(n + 1, string2.length());
        Command command = this.getFactory().updateRebootTypes(string3);
        this.sendCommand(command);
    }

    public void setPowerRebootable(String string) {
        this.checkLoggedIn();
        this.checkPermissions();
        this.checkValidServerID(string);
        int n = Arrays.asList(SERVER_IDS).indexOf(string);
        String string2 = this.getConnection().getParameter("rebtype");
        String string3 = string2.substring(0, n) + "p" + string2.substring(n + 1, string2.length());
        Command command = this.getFactory().updateRebootTypes(string3);
        this.sendCommand(command);
    }

    public void setPlainAndPowerRebootable(String string) {
        this.checkLoggedIn();
        this.checkPermissions();
        this.checkValidServerID(string);
        if (this.getProcessedVersion().compareTo(WebRebootConnection.WEBREBOOT_3_0_VERSION) < 0) {
            throw new WebRebootException("The called method is invalid for your version of the WebReboot: ", this.getVersion());
        }
        int n = Arrays.asList(SERVER_IDS).indexOf(string);
        String string2 = this.getConnection().getParameter("rebtype");
        String string3 = string2.substring(0, n) + "b" + string2.substring(n + 1, string2.length());
        Command command = this.getFactory().updateRebootTypes(string3);
        this.sendCommand(command);
    }

    public boolean isPowerRebootable(String string) {
        this.checkLoggedIn();
        this.checkValidServerID(string);
        int n = Arrays.asList(SERVER_IDS).indexOf(string);
        String string2 = this.getConnection().getParameter("rebtype");
        return string2.charAt(n) == 'p' || string2.charAt(n) == 'b';
    }

    public String getServerName(String string) {
        this.checkLoggedIn();
        this.checkValidServerID(string);
        String string2 = this.getConnection().getParameter(string);
        if (null != string2) {
            string2 = string2.trim();
            return string2;
        }
        return null;
    }

    public String getUserName(String string) {
        this.checkLoggedIn();
        this.checkValidUserID(string);
        User user = this.getUser(string);
        if (null == user) {
            return null;
        }
        return user.getUsername();
    }

    public void changePassword(String string, String string2) {
        this.checkLoggedIn();
        this.checkValidUserID(string);
        int n = Arrays.asList(USER_IDS).indexOf(string);
        User user = this.getUser(string);
        user.setPassword(string2);
        Command command = this.getFactory().modifyUser(user, n);
        this.sendCommand(command);
    }

    public void reboot(String string) {
        this.checkLoggedIn();
        this.checkValidServerID(string);
        if (this.getProcessedVersion().compareTo(WebRebootConnection.WEBREBOOT_3_0_VERSION) >= 0 && !this.isPlainRebootable(string)) {
            throw new WebRebootException("The server specified by the supplied ID does not support a plain reboot: ", string);
        }
        int n = Arrays.asList(SERVER_IDS).indexOf(string);
        Command command = this.getFactory().plainReboot(n);
        this.sendCommand(command);
    }

    public void plainReboot(String string) {
        this.checkLoggedIn();
        this.checkValidServerID(string);
        if (!this.isPlainRebootable(string)) {
            throw new WebRebootException("The server specified by the supplied ID does not support a plain reboot: ", string);
        }
        if (this.getProcessedVersion().compareTo(WebRebootConnection.WEBREBOOT_3_0_VERSION) < 0) {
            this.reboot(string);
            return;
        }
        int n = Arrays.asList(SERVER_IDS).indexOf(string);
        Command command = this.getFactory().plainReboot(n);
        this.sendCommand(command);
    }

    public void powerReboot(String string) {
        this.checkLoggedIn();
        this.checkValidServerID(string);
        if (!this.isPowerRebootable(string)) {
            throw new WebRebootException("The server specified by the supplied ID does not support a power reboot: ", string);
        }
        if (this.getProcessedVersion().compareTo(WebRebootConnection.WEBREBOOT_3_0_VERSION) < 0) {
            this.reboot(string);
            return;
        }
        int n = Arrays.asList(SERVER_IDS).indexOf(string);
        Command command = this.getFactory().powerReboot(n);
        this.sendCommand(command);
    }

    public void togglePower(String string) {
        this.powerOff(string);
    }

    public void powerOff(String string) {
        this.checkLoggedIn();
        this.checkValidServerID(string);
        int n = Arrays.asList(SERVER_IDS).indexOf(string);
        Command command = this.getFactory().powerOff(n);
        this.sendCommand(command);
    }

    public void powerOn(String string) {
        this.checkLoggedIn();
        this.checkValidServerID(string);
        if (this.getProcessedVersion().compareTo(WebRebootConnection.WEBREBOOT_3_1_VERSION) < 0) {
            this.togglePower(string);
        } else {
            int n = Arrays.asList(SERVER_IDS).indexOf(string);
            Command command = this.getFactory().powerOn(n);
            this.sendCommand(command);
        }
    }

    public void renameServer(String string, String string2) {
        this.checkLoggedIn();
        this.checkPermissions();
        this.checkValidServerID(string);
        int n = Arrays.asList(SERVER_IDS).indexOf(string);
        Command command = this.getFactory().renameServer(n, string2);
        this.sendCommand(command);
    }

    public void renameUser(String string, String string2, String string3) {
        this.checkLoggedIn();
        this.checkPermissions();
        this.checkValidUserID(string);
        int n = Arrays.asList(USER_IDS).indexOf(string);
        User user = new User(string2, string3);
        Command command = this.getFactory().modifyUser(user, n);
        this.sendCommand(command);
    }

    public void changeIP(String string) {
        this.checkLoggedIn();
        this.checkPermissions();
        String[] stringArray = string.split("\\.");
        int[] nArray = new int[4];
        for (int i = 0; i < 4; ++i) {
            nArray[i] = Integer.parseInt(stringArray[i]);
        }
        Command command = this.getFactory().changeIP(nArray);
        this.sendCommand(command);
    }

    public String addUser(String string, String string2, List list) {
        this.checkLoggedIn();
        this.checkPermissions();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.checkValidServerID((String)iterator.next());
        }
        int n = 0;
        for (int i = 0; i < SERVER_IDS.length; ++i) {
            if (!list.contains(SERVER_IDS[i])) continue;
            n |= 1 << i;
        }
        User user = User.createUser(string, n);
        user.setPassword(string2);
        int n2 = -1;
        for (int i = 0; i < USER_IDS.length; ++i) {
            if (null != this.getUser(USER_IDS[i])) continue;
            n2 = i;
            break;
        }
        Command command = this.getFactory().addUser(user, n2);
        this.sendCommand(command);
        return USER_IDS[n2];
    }

    public void removeUser(String string) {
        this.checkLoggedIn();
        this.checkPermissions();
        this.checkValidUserID(string);
        int n = Arrays.asList(USER_IDS).indexOf(string);
        Command command = this.getFactory().removeUser(n);
        this.sendCommand(command);
    }

    public void changePermissions(String string, List list) {
        this.checkLoggedIn();
        this.checkPermissions();
        this.checkValidUserID(string);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.checkValidServerID((String)iterator.next());
        }
        int n = Arrays.asList(USER_IDS).indexOf(string);
        int n2 = 0;
        for (int i = 0; i < SERVER_IDS.length; ++i) {
            if (!list.contains(SERVER_IDS[i])) continue;
            n2 |= 1 << i;
        }
        User user = User.createUser(USER_IDS[n], n2);
        Command command = this.getFactory().changePermissions(user, n);
        this.sendCommand(command);
    }

    public String getUserID() {
        this.checkLoggedIn();
        return USER_IDS[this.getConnection().getUserSlot()];
    }

    private User getUser(String string) {
        int n = Arrays.asList(USER_IDS).indexOf(string);
        String string2 = this.getConnection().getParameter(USER_IDS[n]);
        String string3 = string2.substring(0, string2.length() - 3);
        byte by = Integer.valueOf(string2.substring(string2.length() - 3, string2.length())).byteValue();
        return User.createUser(string3, by);
    }

    private BigDecimal getProcessedVersion() {
        return new BigDecimal(this.getVersion());
    }

    public String getVersion() {
        return this.conn.getVersion();
    }
}

